/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.notification;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import android.util.Log;
import io.rong.imlib.common.Res;
import io.rong.imlib.notification.RongNotificationContact;
import io.rong.imlib.notification.RongNotificationMessage;
import io.rong.imlib.push.PushContext;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class RongNotificationManager
extends ContextWrapper {
    private static final String TAG = "RongNotificationManager";
    private final int NEW_NOTIFICATION_LEVEL = 16;
    private final int notificationId = 0;
    private ArrayList<RongNotificationContact> contactList = new ArrayList();
    private static RongNotificationManager sS;

    private RongNotificationManager(Context context) {
        super(context);
    }

    public static void init(Context context) {
        if (sS == null) {
            sS = new RongNotificationManager(context);
        }
    }

    public static RongNotificationManager getInstance() {
        return sS;
    }

    public void receiveNewNotificationMsg(RongNotificationMessage msg) {
        Log.i((String)TAG, (String)("ReceiveNewNotificationMsg:" + msg.getUserId() + "|" + msg.getUserName()));
        this.storeMsgToCache(msg);
        this.sendNotification(msg);
    }

    public void removeNotificationMsgFromCache() {
        Log.i((String)TAG, (String)"RemoveNotificationMsgFromCache");
        this.contactList.clear();
        NotificationManager nm = (NotificationManager)this.getSystemService("notification");
        nm.cancel(0);
    }

    public void storeMsgToCache(RongNotificationMessage msg) {
        Log.i((String)TAG, (String)("storeMsgToCache. size is " + this.contactList.size()));
        if (this.contactList.size() == 0) {
            RongNotificationContact contact = null;
            if (ConversationType.PRIVATE.getValue() == Integer.parseInt(msg.getMsgChannelType()) || ConversationType.CUSTOMER_SERVICE.getValue() == Integer.parseInt(msg.getMsgChannelType())) {
                contact = new RongNotificationContact(msg.getUserId(), msg.getUserName());
            } else {
                Log.i((String)TAG, (String)("storeToCache. Id is" + msg.getMsgChannelId() + "name is:" + msg.getMsgChannelName()));
                contact = new RongNotificationContact(msg.getMsgChannelId(), msg.getMsgChannelName());
            }
            RongNotificationContact rongNotificationContact = contact;
            rongNotificationContact.getClass();
            RongNotificationContact.NotificationMsg newMsg = rongNotificationContact.new RongNotificationContact.NotificationMsg(msg.getMsgTitle(), msg.getMsgContent(), msg.getMsgChannelId(), msg.getMsgChannelName(), msg.getMsgChannelType());
            contact.AddToMessageList(newMsg);
            this.contactList.add(contact);
        } else {
            for (RongNotificationContact contact : this.contactList) {
                String targetId = "";
                targetId = ConversationType.PRIVATE.getValue() == Integer.parseInt(msg.getMsgChannelType()) || ConversationType.CUSTOMER_SERVICE.getValue() == Integer.parseInt(msg.getMsgChannelType()) ? msg.getUserId() : msg.getMsgChannelId();
                if (!contact.getContactId().equals(targetId)) continue;
                RongNotificationContact rongNotificationContact = contact;
                rongNotificationContact.getClass();
                RongNotificationContact.NotificationMsg newMsg = rongNotificationContact.new RongNotificationContact.NotificationMsg(msg.getMsgTitle(), msg.getMsgContent(), msg.getMsgChannelId(), msg.getMsgChannelName(), msg.getMsgChannelType());
                Log.i((String)TAG, (String)"old contact.new msg");
                contact.AddToMessageList(newMsg);
                return;
            }
            Object contact = null;
            contact = ConversationType.PRIVATE.getValue() == Integer.parseInt(msg.getMsgChannelType()) || ConversationType.CUSTOMER_SERVICE.getValue() == Integer.parseInt(msg.getMsgChannelType()) ? new RongNotificationContact(msg.getUserId(), msg.getUserName()) : new RongNotificationContact(msg.getMsgChannelId(), msg.getMsgChannelName());
            Object object = contact;
            object.getClass();
            RongNotificationContact.NotificationMsg newMsg = (RongNotificationContact)object.new RongNotificationContact.NotificationMsg(msg.getMsgTitle(), msg.getMsgContent(), msg.getMsgChannelId(), msg.getMsgChannelName(), msg.getMsgChannelType());
            ((RongNotificationContact)contact).AddToMessageList(newMsg);
            Log.i((String)TAG, (String)"Add new contact");
            this.contactList.add((RongNotificationContact)contact);
        }
    }

    public void sendNotification(RongNotificationMessage msg) {
        Notification notification;
        RongNotificationManager context = RongNotificationManager.getInstance();
        String tickerText = this.getString(Res.getInstance((Context)this).string("rc_notification_ticker_text"));
        Bitmap appIcon = this.getAppIcon((Context)context);
        PendingIntent pendingIntent = this.buildPendingIntent((Context)context, msg);
        String title = this.getNotificationTitle((Context)context);
        String content = this.getNotificationContent((Context)context);
        Log.i((String)TAG, (String)("send. title:" + title));
        Log.i((String)TAG, (String)("android.os.Build.VERSION.SDK_INT is" + Build.VERSION.SDK_INT));
        if (Build.VERSION.SDK_INT < 16) {
            notification = new Notification(this.getApplicationInfo().icon, (CharSequence)tickerText, System.currentTimeMillis());
            notification.setLatestEventInfo((Context)context, (CharSequence)title, (CharSequence)content, pendingIntent);
            notification.flags = 16;
            notification.defaults = 1;
        } else {
            notification = new Notification.Builder((Context)context).setLargeIcon(appIcon).setSmallIcon(Res.getInstance((Context)this).drawable("rc_ic_notice")).setTicker((CharSequence)tickerText).setContentTitle((CharSequence)title).setContentText((CharSequence)content).setContentIntent(pendingIntent).setAutoCancel(true).setDefaults(-1).build();
        }
        NotificationManager nm = (NotificationManager)this.getSystemService("notification");
        nm.notify(0, notification);
    }

    private String getNotificationTitle(Context context) {
        String title;
        if (this.contactList.size() == 1) {
            title = this.contactList.get(0).getUserName();
        } else {
            ApplicationInfo appinfo;
            PackageManager PkgMng = context.getPackageManager();
            try {
                appinfo = PkgMng.getApplicationInfo(context.getPackageName(), 0);
            }
            catch (PackageManager.NameNotFoundException e) {
                throw new IllegalArgumentException("the app info can't be null!");
            }
            title = (String)context.getPackageManager().getApplicationLabel(appinfo);
        }
        return title;
    }

    private String getNotificationContent(Context context) {
        String content;
        String notification_send = (String)context.getResources().getText(Res.getInstance(context).string("rc_notification_send"));
        String notification_nMsg = (String)context.getResources().getText(Res.getInstance(context).string("rc_notification_msg"));
        String notification_nContact = (String)context.getResources().getText(Res.getInstance(context).string("rc_notification_contact"));
        if (this.contactList.size() == 1) {
            int index = 0;
            RongNotificationContact contact = this.contactList.get(index);
            int nMsg = contact.getMessageList().size();
            content = nMsg == 1 ? contact.getMessageList().get(index).getMsgContent() : notification_send + nMsg + notification_nMsg;
        } else {
            int count = 0;
            for (RongNotificationContact c : this.contactList) {
                count += c.getMessageList().size();
            }
            content = this.contactList.size() + notification_nContact + notification_send + count + notification_nMsg;
        }
        return content;
    }

    private String getCurrentFormatTime() {
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        return sdf.format(new Date());
    }

    private Bitmap getAppIcon(Context context) {
        Drawable appIconDrawable = context.getApplicationInfo().loadIcon(context.getPackageManager());
        BitmapDrawable tempIcon = (BitmapDrawable)appIconDrawable;
        Bitmap appIcon = tempIcon.getBitmap();
        return appIcon;
    }

    private PendingIntent buildPendingIntent(Context context, RongNotificationMessage msg) {
        Uri uri;
        Intent intent = new Intent();
        intent.setAction("android.intent.action.VIEW");
        if (this.contactList.size() == 1) {
            String channelType = msg.getMsgChannelType();
            String conversationType = ConversationType.setValue(Integer.parseInt(channelType)).toString().toLowerCase();
            uri = ConversationType.PRIVATE.getName().equals(conversationType) || ConversationType.CUSTOMER_SERVICE.getName().equals(conversationType) ? Uri.parse((String)("rong://" + context.getPackageName())).buildUpon().appendPath("conversation").appendPath(conversationType).appendQueryParameter("targetId", msg.getUserId()).appendQueryParameter("title", msg.getUserName()).build() : Uri.parse((String)("rong://" + context.getPackageName())).buildUpon().appendPath("conversation").appendPath(conversationType).appendQueryParameter("targetId", msg.getMsgChannelId()).appendQueryParameter("title", msg.getMsgChannelName()).build();
        } else {
            uri = Uri.parse((String)("rong://" + context.getPackageName())).buildUpon().appendPath("conversationlist").build();
        }
        intent.setData(uri);
        intent.putExtra("appId", (Parcelable)PushContext.getInstance().getCurrentVersion());
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)context, (int)0, (Intent)intent, (int)0x8000000);
        return pendingIntent;
    }

    static enum ConversationType {
        PRIVATE(1, "private"),
        DISCUSSION(2, "discussion"),
        GROUP(3, "group"),
        CHATROOM(4, "chatroom"),
        CUSTOMER_SERVICE(5, "customer_service"),
        SYSTEM(6, "system");

        int value = 1;
        String name = "";

        private ConversationType(int value, String name) {
            this.value = value;
            this.name = name;
        }

        int getValue() {
            return this.value;
        }

        String getName() {
            return this.name;
        }

        static ConversationType setValue(int code) {
            for (ConversationType c : ConversationType.values()) {
                if (code != c.getValue()) continue;
                return c;
            }
            return PRIVATE;
        }
    }
}

