/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.model;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Parcel;
import android.os.Parcelable;
import io.rong.database.Version;
import me.add1.common.ParcelUtils;

public class AppVersion
extends Version
implements Parcelable {
    public static final Parcelable.Creator<AppVersion> CREATOR = new Parcelable.Creator<AppVersion>(){

        public AppVersion createFromParcel(Parcel source) {
            return new AppVersion(source);
        }

        public AppVersion[] newArray(int size) {
            return new AppVersion[size];
        }
    };

    public AppVersion(Context context) throws PackageManager.NameNotFoundException {
        ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
        if (applicationInfo.metaData == null || applicationInfo.metaData.getString("RONG_CLOUD_APP_KEY") == null) {
            throw new RuntimeException("RONG_CLOUD_APP_KEY metadata was null. please set at manifest.");
        }
        this.setAppKey(applicationInfo.metaData.getString("RONG_CLOUD_APP_KEY"));
        this.setAppId(context.getPackageName());
        this.setAppVersionCode(this.getVersionCode(context));
        this.setSDKVersionCode(10343);
        this.setPushVersionCode(2);
    }

    public AppVersion(Version version) {
        this.setAppKey(version.getAppKey());
        this.setAppId(version.getAppId());
        this.setAppVersionCode(version.getAppVersionCode());
        this.setSDKVersionCode(version.getSDKVersionCode());
        this.setPushVersionCode(version.getPushVersionCode());
    }

    private int getVersionCode(Context context) {
        PackageInfo pi = null;
        try {
            pi = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e1) {
            e1.printStackTrace();
        }
        if (pi == null) {
            return 0;
        }
        return pi.versionCode;
    }

    public AppVersion(Parcel in) {
        this.setAppId(ParcelUtils.readFromParcel(in));
        this.setAppKey(ParcelUtils.readFromParcel(in));
        this.setAppVersionCode(ParcelUtils.readIntFromParcel(in));
        this.setSDKVersionCode(ParcelUtils.readIntFromParcel(in));
        this.setPushVersionCode(ParcelUtils.readIntFromParcel(in));
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        ParcelUtils.writeToParcel(dest, this.getAppId());
        ParcelUtils.writeToParcel(dest, this.getAppKey());
        ParcelUtils.writeToParcel(dest, this.getAppVersionCode());
        ParcelUtils.writeToParcel(dest, this.getSDKVersionCode());
        ParcelUtils.writeToParcel(dest, this.getPushVersionCode());
    }
}

