/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib;

import android.content.Context;
import android.os.PowerManager;

class RongWakeLock {
    PowerManager.WakeLock mLock;
    Context mContext;

    RongWakeLock(Context context) {
        this.mContext = context;
    }

    protected void acquireWakeLock(int timeout) {
        this.acquireWakeLock(timeout, 1);
    }

    protected void acquireWakeLock(int timeout, int level) {
        if (this.mLock == null) {
            PowerManager pm = (PowerManager)this.mContext.getSystemService("power");
            this.mLock = pm.newWakeLock(level, this.getClass().getCanonicalName());
            if (timeout <= 0) {
                this.mLock.acquire();
            } else {
                this.mLock.acquire((long)timeout);
            }
        }
    }

    protected void acquireWakeLock() {
        this.acquireWakeLock(0);
    }

    protected void releaseWakeLock() {
        if (this.mLock != null && this.mLock.isHeld()) {
            this.mLock.release();
            this.mLock = null;
        }
    }
}

