/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.os.IBinder;
import io.rong.imlib.NativeObject;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.RongReceiver;
import io.rong.imlib.WakeLockUtils;

public class RongService
extends IntentService {
    static final String ACTION_HEARTBEAT = "HEARTBEAT";
    static final String ACTION_HANDLER_REMOTE = "HANDLER_REMOTE";
    static final String ACTION_CONNECTION = "CONNECTION";
    static final String ACTION_DISCONNECTION = "DISCONNECTION";

    public RongService() {
        super("RongService");
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    protected void onHandleIntent(final Intent intent) {
        if (RongIMClient.getLastNativeInstance() == null) {
            return;
        }
        if (intent == null || intent.getAction() == null) {
            return;
        }
        if (intent.getAction().equals(this.getPackageName() + "." + ACTION_HEARTBEAT)) {
            RongIMClient.getLastNativeInstance().EnvironmentChangeNotify(105, null, 0, new NativeObject.EnvironmentChangeNotifyListener(){

                @Override
                public void Complete(int type, String desc) {
                    RongReceiver.completeWakefulIntent((Intent)intent);
                }
            });
            WakeLockUtils.startNextHeartbeat((Context)this);
        } else if (intent.getAction().equals(this.getPackageName() + "." + ACTION_HANDLER_REMOTE)) {
            RongIMClient.getLastNativeInstance().SetWakeupQueryListener(new NativeObject.WakeupQueryListener(){

                @Override
                public void QueryWakeup(int type) {
                }

                @Override
                public void ReleaseWakup() {
                    RongReceiver.completeWakefulIntent((Intent)intent);
                }
            });
        } else if (intent.getAction().equals(this.getPackageName() + "." + ACTION_CONNECTION)) {
            int type = intent.getIntExtra("conn_type", 0);
            RongIMClient.getLastClientInstance().reconnect(new RongIMClient.ConnectCallback(){

                @Override
                public void onSuccess(String userId) {
                    WakeLockUtils.startNextHeartbeat((Context)RongService.this);
                    RongReceiver.completeWakefulIntent((Intent)intent);
                }

                @Override
                public void onError(RongIMClient.ConnectCallback.ErrorCode errorCode) {
                    RongReceiver.completeWakefulIntent((Intent)intent);
                }
            });
        } else if (intent.getAction().equals(ACTION_DISCONNECTION)) {
            byte[] data = new byte[]{0};
            RongIMClient.getLastNativeInstance().EnvironmentChangeNotify(101, data, data.length, new NativeObject.EnvironmentChangeNotifyListener(){

                @Override
                public void Complete(int type, String desc) {
                    RongReceiver.completeWakefulIntent((Intent)intent);
                }
            });
        }
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        if (RongIMClient.getLastNativeInstance() == null) {
            return super.onStartCommand(intent, flags, startId);
        }
        if (intent == null || intent.getAction() == null) {
            return super.onStartCommand(intent, flags, startId);
        }
        return super.onStartCommand(intent, flags, startId);
    }
}

