/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib;

import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Parcelable;
import android.support.v4.content.WakefulBroadcastReceiver;
import android.util.Log;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.RongService;
import io.rong.imlib.WakeLockUtils;

public final class RongReceiver
extends WakefulBroadcastReceiver {
    public void onReceive(Context context, Intent intent) {
        Parcelable parcelableExtra;
        Log.d((String)((Object)((Object)this)).getClass().getCanonicalName(), (String)intent.toString());
        if (intent.getAction().equals(context.getPackageName() + "." + "HEARTBEAT")) {
            Intent heartbeatIntent = new Intent(context, RongService.class);
            heartbeatIntent.setAction(context.getPackageName() + "." + "HEARTBEAT");
            RongReceiver.startWakefulService((Context)context, (Intent)heartbeatIntent);
        } else if (intent.getAction().equals(context.getPackageName() + "." + "HANDLER_REMOTE")) {
            Intent handlerRemote = new Intent(context, RongService.class);
            handlerRemote.setAction(context.getPackageName() + "." + "HANDLER_REMOTE");
            RongReceiver.startWakefulService((Context)context, (Intent)handlerRemote);
        } else if (intent.getAction().equals("android.net.conn.CONNECTIVITY_CHANGE") && null != (parcelableExtra = intent.getParcelableExtra("networkInfo"))) {
            NetworkInfo networkInfo = (NetworkInfo)parcelableExtra;
            NetworkInfo.State state = networkInfo.getState();
            ConnectivityManager currentState = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo activeInfo = null;
            if (currentState != null && currentState.getActiveNetworkInfo() != null) {
                activeInfo = currentState.getActiveNetworkInfo();
                if (activeInfo != null) {
                    Log.d((String)"RongReceiver", (String)(intent.getAction() + ":" + state + "~" + networkInfo.getTypeName() + "**" + activeInfo.getTypeName() + "~" + activeInfo.getState()));
                } else {
                    Log.d((String)"RongReceiver", (String)(intent.getAction() + ":" + state + "~" + networkInfo.getTypeName()));
                }
            } else {
                Log.d((String)"RongReceiver", (String)(intent.getAction() + ":" + state + "~" + networkInfo.getTypeName()));
            }
            if (RongIMClient.getLastClientInstance() == null || RongIMClient.getCurrentConnStatus() == RongIMClient.ConnectionStatusListener.ConnectionStatus.KICKED_OFFLINE_BY_OTHER_CLIENT) {
                return;
            }
            if (state == NetworkInfo.State.CONNECTED && (activeInfo == null || networkInfo.getType() == activeInfo.getType())) {
                int type = 0;
                if (networkInfo.getType() == 0) {
                    type = 0;
                } else if (networkInfo.getType() == 1) {
                    type = 1;
                }
                Intent connectionIntent = new Intent(context, RongService.class);
                connectionIntent.setAction(context.getPackageName() + "." + "CONNECTION");
                connectionIntent.putExtra("conn_type", type);
                RongReceiver.startWakefulService((Context)context, (Intent)connectionIntent);
            } else if (state == NetworkInfo.State.DISCONNECTED && (activeInfo == null || networkInfo.getType() == activeInfo.getType() && activeInfo.getState() == NetworkInfo.State.DISCONNECTED)) {
                if (RongIMClient.getConnectionStatusListener() != null) {
                    RongIMClient.getConnectionStatusListener().onChanged(RongIMClient.ConnectionStatusListener.ConnectionStatus.NETWORK_UNAVAILABLE);
                }
                Intent connectionIntent = new Intent(context, RongService.class);
                connectionIntent.setAction(context.getPackageName() + "." + "DISCONNECTION");
                RongReceiver.startWakefulService((Context)context, (Intent)connectionIntent);
                WakeLockUtils.cancelHeartbeat(context);
            }
        }
    }
}

