/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.graphics.Bitmap;
import android.net.ConnectivityManager;
import android.os.Build;
import android.os.Environment;
import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import io.rong.imlib.AnnotationNotFoundException;
import io.rong.imlib.MessageTag;
import io.rong.imlib.NativeObject;
import io.rong.imlib.RongReceiver;
import io.rong.imlib.RongWakeLock;
import io.rong.imlib.WakeLockUtils;
import io.rong.imlib.common.RLog;
import io.rong.imlib.common.RongVersionDatabase;
import io.rong.imlib.common.Utils;
import io.rong.imlib.model.AppVersion;
import io.rong.imlib.notification.RongNotificationManager;
import io.rong.imlib.notification.RongNotificationMessage;
import io.rong.imlib.push.PushContext;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class RongIMClient {
    private static final String TAG = "RongIMClient";
    private static RongIMClient client = null;
    private static String resourcePath;
    private static Context sContext;
    private static RongWakeLock mWakeLock;
    private static NativeObject nativeObj;
    private String token;
    private String currentUserId;
    private UserInfo mUserInfo = null;
    private static PushMessageBehaviorListener mPushMessageBehaviorListener;
    private static HashMap<String, Constructor<? extends MessageContent>> constructorMap;
    private static HashMap<String, Constructor<? extends MessageTag.MessageHandler>> messageHandlerMap;
    private static ConnectionStatusListener mListener;
    private static ConnectionStatusListener.ConnectionStatus currentConnStatus;
    private static RongReceiver mReceiver;
    private static OnReceiveMessageListener mOnReceiveMessageListener;

    private int saveMessage(ConversationType conversationType, String targetId, MessageContent content, String senderUserId) {
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId) || content == null || TextUtils.isEmpty((CharSequence)senderUserId)) {
            throw new IllegalArgumentException();
        }
        MessageTag msgTag = content.getClass().getAnnotation(MessageTag.class);
        if (msgTag == null) {
            throw new RuntimeException("\u81ea\u5b9a\u4e49\u6d88\u606f\u6ca1\u6709\u52a0\u6ce8\u89e3\u4fe1\u606f\u3002");
        }
        if ((msgTag.flag() & 1) == 1) {
            byte[] contentByte = content.encode();
            return nativeObj.SaveMessage(targetId, conversationType.getValue(), msgTag.value(), senderUserId, contentByte, content.getPushContent() == null ? null : content.getPushContent().getBytes());
        }
        return 0;
    }

    void sendMessage(final Message message, MessageTag.MessageHandler handler, final SendMessageCallback callback) {
        MessageTag msgTag = message.getContent().getClass().getAnnotation(MessageTag.class);
        if (msgTag == null) {
            throw new RuntimeException("\u81ea\u5b9a\u4e49\u6d88\u606f\u6ca1\u6709\u52a0\u6ce8\u89e3\u4fe1\u606f\u3002");
        }
        byte[] data = null;
        if (handler.encodeMessage(message, message.getContent())) {
            data = message.getContent().encode();
            nativeObj.SetMessageContent(message.getMessageId(), data);
        } else {
            data = message.getContent().encode();
        }
        nativeObj.SendMessage(message.getTargetId(), message.getConversationType().getValue(), 3, msgTag.value(), data, message.content.getPushContent() == null ? null : message.content.getPushContent().getBytes(), message.getMessageId(), new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code) {
                if (callback == null) {
                    return;
                }
                if (code == 0) {
                    callback.onSuccess(message.getMessageId());
                } else {
                    if (code == 3001) {
                        currentConnStatus = ConnectionStatusListener.ConnectionStatus.NETWORK_UNAVAILABLE;
                        if (mListener != null) {
                            mListener.onChanged(currentConnStatus);
                        }
                    }
                    callback.onError(message.getMessageId(), SendMessageCallback.ErrorCode.setValue(code));
                }
            }
        });
        Log.d((String)"MESSAGE_SEND", (String)"SENDED");
    }

    private RongIMClient() {
    }

    private static MessageContent getMessageContent(String objectName, byte[] content) {
        Constructor<? extends MessageContent> constructor = constructorMap.get(objectName);
        Object result = null;
        if (constructor == null) {
            return new UnknowMessage(content);
        }
        try {
            return constructor.newInstance(new Object[]{content});
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    private boolean filterNatiMessageve(Message message) {
        MessageContent content = message.getContent();
        if (content instanceof DiscussionNotificationMessage) {
            nativeObj.GetDiscussionInfo(message.getTargetId(), true, new NativeObject.DiscussionInfoListener(){

                @Override
                public void onReceived(NativeObject.DiscussionInfo info) {
                }

                @Override
                public void OnError(int status) {
                }
            });
            return true;
        }
        return false;
    }

    private static final String createPath(File file, String appKey) {
        File baseDirectory = new File(file, "RongCloud/" + appKey);
        if (!baseDirectory.exists()) {
            baseDirectory.mkdirs();
        }
        return baseDirectory.getPath();
    }

    private static final void regConnectChangeReceiver(Context context) {
        if (mReceiver == null) {
            mReceiver = new RongReceiver();
            IntentFilter filter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
            IntentFilter heartFilter = new IntentFilter(context.getPackageName() + "." + "HEARTBEAT");
            IntentFilter remoteFilter = new IntentFilter(context.getPackageName() + "." + "HANDLER_REMOTE");
            IntentFilter connectFilter = new IntentFilter(context.getPackageName() + "." + "CONNECTION");
            IntentFilter disconnectFilter = new IntentFilter(context.getPackageName() + "." + "DISCONNECTION");
            context.registerReceiver((BroadcastReceiver)mReceiver, filter);
            context.registerReceiver((BroadcastReceiver)mReceiver, heartFilter);
            context.registerReceiver((BroadcastReceiver)mReceiver, remoteFilter);
            context.registerReceiver((BroadcastReceiver)mReceiver, connectFilter);
            context.registerReceiver((BroadcastReceiver)mReceiver, disconnectFilter);
        }
    }

    protected static NativeObject getLastNativeInstance() {
        if (client == null) {
            return null;
        }
        return nativeObj;
    }

    protected static RongIMClient getLastClientInstance() {
        return client;
    }

    protected static ConnectionStatusListener getConnectionStatusListener() {
        return mListener;
    }

    protected static ConnectionStatusListener.ConnectionStatus getCurrentConnStatus() {
        return currentConnStatus;
    }

    public static void setOptions(Options options) {
    }

    public static boolean init(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("Context\u6216AppKey\u5f02\u5e38");
        }
        sContext = context.getApplicationContext();
        RongNotificationManager.init(context);
        RongVersionDatabase.init(context);
        if (PushContext.getInstance() == null) {
            PushContext.init(context);
        }
        File root = null;
        if (Environment.getExternalStorageState().equals("mounted")) {
            root = context.getExternalFilesDir("RongCloud");
        }
        if (root == null) {
            root = new File(context.getFilesDir(), "RongCloud");
        }
        if (!root.exists() && !root.mkdirs()) {
            return false;
        }
        resourcePath = root.getPath();
        String deviceId = Utils.getDeviceId(context);
        nativeObj = new NativeObject();
        try {
            int result;
            AppVersion version = new AppVersion(context);
            if (TextUtils.isEmpty((CharSequence)version.getAppKey())) {
                RLog.e(context, "Rong_init", "Undefined \"RongCloud\" meta-data in AndroidManifest");
            }
            if ((result = nativeObj.InitClient(version.getAppKey(), context.getPackageName(), deviceId, root.getPath(), context.getFilesDir().getPath())) == 0) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        Log.d((String)TAG, (String)(resourcePath + "||" + context.getFilesDir().getPath()));
        mWakeLock = new RongWakeLock(context);
        nativeObj.SetWakeupQueryListener(new NativeObject.WakeupQueryListener(){

            @Override
            public void QueryWakeup(int type) {
                mWakeLock.acquireWakeLock();
            }

            @Override
            public void ReleaseWakup() {
                mWakeLock.releaseWakeLock();
            }
        });
        try {
            try {
                RongIMClient.registerMessageType(Class.forName("io.rong.message.TextMessage"));
                RongIMClient.registerMessageType(Class.forName("io.rong.message.VoiceMessage"));
                RongIMClient.registerMessageType(Class.forName("io.rong.message.ImageMessage"));
                RongIMClient.registerMessageType(Class.forName("io.rong.message.LocationMessage"));
                RongIMClient.registerMessageType(Class.forName("io.rong.message.CommandNotificationMessage"));
                RongIMClient.registerMessageType(Class.forName("io.rong.message.ContactNotificationMessage"));
                RongIMClient.registerMessageType(Class.forName("io.rong.message.GroupNotificationMessage"));
                RongIMClient.registerMessageType(Class.forName("io.rong.message.ProfileNotificationMessage"));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            RongIMClient.registerMessageType(DiscussionNotificationMessage.class);
        }
        catch (AnnotationNotFoundException e) {
            e.printStackTrace();
        }
        if (mListener != null) {
            RongIMClient.setConnectionStatusListener(mListener);
        } else {
            RongIMClient.setConnectionStatusListener(null);
        }
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        String network = "no";
        if (connectivityManager.getActiveNetworkInfo() != null) {
            network = connectivityManager.getActiveNetworkInfo().getTypeName();
        }
        nativeObj.SetDeviceInfo(Build.MANUFACTURER, Build.MODEL, String.valueOf(Build.VERSION.SDK_INT), network, telephonyManager.getNetworkOperator());
        return true;
    }

    public static void registerMessageType(Class<? extends MessageContent> type) throws AnnotationNotFoundException {
        if (nativeObj == null) {
            throw new RuntimeException("RongIMClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (type == null) {
            throw new IllegalArgumentException("MessageContent \u4e3a\u7a7a\uff01");
        }
        MessageTag tag = type.getAnnotation(MessageTag.class);
        if (tag != null) {
            String objName = tag.value();
            int flag = tag.flag();
            try {
                Constructor<? extends MessageContent> constructor = type.getDeclaredConstructor(byte[].class);
                Constructor<? extends MessageTag.MessageHandler> handlerConstructor = tag.messageHandler().getConstructor(Context.class);
                constructorMap.put(objName, constructor);
                messageHandlerMap.put(objName, handlerConstructor);
                nativeObj.RegisterMessageType(objName, flag);
            }
            catch (NoSuchMethodException e) {
                throw new AnnotationNotFoundException();
            }
        } else {
            throw new AnnotationNotFoundException();
        }
    }

    public static RongIMClient connect(String token, final ConnectCallback callback) throws Exception {
        if (nativeObj == null) {
            throw new RuntimeException("RongIMClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (resourcePath == null) {
            throw new IllegalArgumentException("AppKey\u6216\u8d44\u6e90\u8def\u5f84\u5f02\u5e38\u3002");
        }
        if (client == null) {
            client = new RongIMClient();
        }
        if (token == null) {
            throw new IllegalArgumentException("Token\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (currentConnStatus == ConnectionStatusListener.ConnectionStatus.CONNECTING) {
            return client;
        }
        RongIMClient.client.token = token;
        currentConnStatus = ConnectionStatusListener.ConnectionStatus.CONNECTING;
        Log.d((String)TAG, (String)"connect");
        nativeObj.Connect(token, new NativeObject.ConnectAckCallback(){

            @Override
            public void operationComplete(int status, String userId) {
                if (status == 0) {
                    RongIMClient.regConnectChangeReceiver(sContext);
                    WakeLockUtils.startNextHeartbeat(sContext);
                    client.currentUserId = userId;
                    client.mUserInfo = new UserInfo(userId, null, null);
                    client.getUserInfo(userId, new GetUserInfoCallback(){

                        @Override
                        public void onSuccess(UserInfo user) {
                            client.mUserInfo.setName(user.getName());
                            client.mUserInfo.setPortraitUri(user.getPortraitUri());
                        }

                        @Override
                        public void onError(GetUserInfoCallback.ErrorCode errorCode) {
                        }
                    });
                    if (callback != null) {
                        callback.onSuccess(userId);
                    }
                    currentConnStatus = ConnectionStatusListener.ConnectionStatus.CONNECTED;
                } else {
                    if (callback != null) {
                        callback.onError(ConnectCallback.ErrorCode.setValue(status));
                    }
                    currentConnStatus = ConnectionStatusListener.ConnectionStatus.NETWORK_UNAVAILABLE;
                }
            }
        });
        client.setOnReceiveMessageListener(null);
        return client;
    }

    public void reconnect(final ConnectCallback callback) {
        if (nativeObj == null) {
            throw new RuntimeException("RongIMClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (this.token != null && currentConnStatus != ConnectionStatusListener.ConnectionStatus.CONNECTED && currentConnStatus != ConnectionStatusListener.ConnectionStatus.CONNECTING) {
            Log.d((String)TAG, (String)("reconnect:" + (Object)((Object)currentConnStatus)));
            nativeObj.Connect(this.token, new NativeObject.ConnectAckCallback(){

                @Override
                public void operationComplete(int status, String userId) {
                    if (status == 0) {
                        client.currentUserId = userId;
                        if (callback != null) {
                            callback.onSuccess(userId);
                        }
                        currentConnStatus = ConnectionStatusListener.ConnectionStatus.setValue(status);
                        if (mListener != null) {
                            mListener.onChanged(ConnectionStatusListener.ConnectionStatus.setValue(status));
                        }
                    } else {
                        if (callback != null) {
                            callback.onError(ConnectCallback.ErrorCode.setValue(status));
                        }
                        currentConnStatus = ConnectionStatusListener.ConnectionStatus.setValue(status);
                    }
                }
            });
        }
    }

    public void disconnect() {
        this.disconnect(true);
    }

    public void disconnect(boolean isReceivePush) {
        if (nativeObj == null) {
            throw new RuntimeException("RongIMClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        nativeObj.SetMessageListener(null);
        nativeObj.Disconnect(isReceivePush ? 2 : 4);
        currentConnStatus = ConnectionStatusListener.ConnectionStatus.DISCONNECTED;
    }

    public List<Conversation> getConversationList() {
        int[] conversationTypes = new int[]{ConversationType.PRIVATE.getValue(), ConversationType.DISCUSSION.getValue(), ConversationType.GROUP.getValue(), ConversationType.SYSTEM.getValue()};
        if (nativeObj == null) {
            throw new RuntimeException("RongIMClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        return this.getConversationList(conversationTypes);
    }

    public List<Conversation> getGroupConversationList() {
        int[] conversationTypes = new int[]{ConversationType.GROUP.getValue()};
        if (nativeObj == null) {
            throw new RuntimeException("RongIMClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        return this.getConversationList(conversationTypes);
    }

    private List<Conversation> getConversationList(int[] conversationTypeValues) {
        byte[] bytes = nativeObj.GetConversationList(conversationTypeValues);
        String jsonResult = null;
        try {
            jsonResult = new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        ArrayList<Conversation> list = new ArrayList<Conversation>();
        if (!TextUtils.isEmpty((CharSequence)jsonResult)) {
            try {
                JSONObject jo = new JSONObject(jsonResult);
                JSONArray jsonArray = (JSONArray)jo.get("result");
                for (int i = 0; i < jsonArray.length(); ++i) {
                    JSONObject o = (JSONObject)jsonArray.get(i);
                    Conversation msg = new Conversation(o);
                    list.add(msg);
                }
            }
            catch (JSONException e) {
                Log.d((String)"jsonerror", (String)e.getMessage());
            }
        }
        return list;
    }

    public Conversation getConversation(ConversationType conversationType, String targetId) {
        if (nativeObj == null) {
            throw new RuntimeException("RongIMClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId)) {
            throw new IllegalArgumentException("ConversationType \u548c TargetId \u53c2\u6570\u5f02\u5e38");
        }
        byte[] bytes = nativeObj.GetConversation(targetId, conversationType.getValue());
        String jsonResult = null;
        try {
            jsonResult = new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        Conversation conversation = null;
        if (!TextUtils.isEmpty((CharSequence)jsonResult)) {
            try {
                JSONObject jo = new JSONObject(jsonResult);
                JSONArray jsonArray = (JSONArray)jo.get("result");
                int i = 0;
                if (i < jsonArray.length()) {
                    JSONObject o = (JSONObject)jsonArray.get(i);
                    conversation = new Conversation(o);
                }
            }
            catch (JSONException e) {
                Log.d((String)"jsonerror", (String)e.getMessage());
            }
        }
        return conversation;
    }

    public boolean removeConversation(ConversationType conversationType, String targetId) {
        if (nativeObj == null) {
            throw new RuntimeException("RongIMClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId) || TextUtils.isEmpty((CharSequence)targetId.trim())) {
            throw new IllegalArgumentException();
        }
        targetId = targetId.trim();
        return nativeObj.RemoveConversation(conversationType.getValue(), targetId);
    }

    public boolean setConversationToTop(ConversationType conversationType, String targetId, boolean isTop) {
        if (nativeObj == null) {
            throw new RuntimeException("RongIMClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId)) {
            throw new IllegalArgumentException();
        }
        return nativeObj.SetIsTop(conversationType.getValue(), targetId, isTop);
    }

    public int getTotalUnreadCount() {
        if (nativeObj == null) {
            throw new RuntimeException("RongIMClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        return nativeObj.GetTotalUnreadCount();
    }

    public int getUnreadCount(ConversationType conversationType, String targetId) {
        if (nativeObj == null) {
            throw new RuntimeException("RongIMClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (TextUtils.isEmpty((CharSequence)targetId) || conversationType == null) {
            throw new IllegalArgumentException();
        }
        return nativeObj.GetUnreadCount(targetId, conversationType.getValue());
    }

    public int getUnreadCount(ConversationType ... conversationTypes) {
        if (nativeObj == null) {
            throw new RuntimeException("RongIMClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationTypes == null || conversationTypes.length == 0) {
            new IllegalAccessException("ConversationTypes \u53c2\u6570\u5f02\u5e38\u3002");
        }
        int[] conversationTypeValues = new int[conversationTypes.length];
        int i = 0;
        for (ConversationType conversationType : conversationTypes) {
            conversationTypeValues[i] = conversationType.getValue();
            ++i;
        }
        return nativeObj.GetCateUnreadCount(conversationTypeValues);
    }

    public List<Message> getLatestMessages(ConversationType conversationType, String targetId, int count) {
        if (nativeObj == null) {
            throw new RuntimeException("RongIMClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId)) {
            new IllegalAccessException("ConversationTypes \u6216 targetId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        targetId = targetId.trim();
        return this.getHistoryMessages(conversationType, targetId, -1, count);
    }

    public List<Message> getHistoryMessages(ConversationType conversationType, String targetId, int oldestMessageId, int count) {
        if (nativeObj == null) {
            throw new RuntimeException("RongIMClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId)) {
            new IllegalAccessException("ConversationTypes \u6216 targetId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        targetId = targetId.trim();
        byte[] bytes = nativeObj.GetPagedMessage(targetId, conversationType.getValue(), oldestMessageId, count);
        ArrayList<Message> list = new ArrayList<Message>();
        String jsonResult = null;
        try {
            jsonResult = new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        if (!TextUtils.isEmpty((CharSequence)jsonResult)) {
            try {
                JSONObject jo = new JSONObject(jsonResult);
                JSONArray jsonArray = (JSONArray)jo.get("result");
                for (int i = 0; i < jsonArray.length(); ++i) {
                    JSONObject o = (JSONObject)jsonArray.get(i);
                    NativeObject.Message nativeMsg = new NativeObject.Message(o);
                    Message msg = new Message(nativeMsg);
                    list.add(msg);
                }
            }
            catch (JSONException e) {
                Log.d((String)"jsonerror", (String)e.getMessage());
            }
        }
        return list;
    }

    public List<Message> getHistoryMessages(ConversationType conversationType, String targetId, String objectName, int oldestMessageId, int count) {
        if (nativeObj == null) {
            throw new RuntimeException("RongIMClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId) || TextUtils.isEmpty((CharSequence)objectName)) {
            new IllegalAccessException("\u53c2\u6570\u5f02\u5e38\u3002");
        }
        targetId = targetId.trim();
        byte[] bytes = nativeObj.GetHistoryMessages(targetId, conversationType.getValue(), objectName, oldestMessageId, count);
        ArrayList<Message> list = new ArrayList<Message>();
        String jsonResult = null;
        try {
            jsonResult = new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        if (!TextUtils.isEmpty((CharSequence)jsonResult)) {
            try {
                JSONObject jo = new JSONObject(jsonResult);
                JSONArray jsonArray = (JSONArray)jo.get("result");
                for (int i = 0; i < jsonArray.length(); ++i) {
                    JSONObject o = (JSONObject)jsonArray.get(i);
                    NativeObject.Message nativeMsg = new NativeObject.Message(o);
                    Message msg = new Message(nativeMsg);
                    list.add(msg);
                }
            }
            catch (JSONException e) {
                Log.d((String)"jsonerror", (String)e.getMessage());
            }
        }
        return list;
    }

    public boolean deleteMessages(int[] messageIds) {
        if (nativeObj == null) {
            throw new RuntimeException("RongIMClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (messageIds == null || messageIds.length == 0) {
            throw new IllegalArgumentException("MessageIds \u53c2\u6570\u5f02\u5e38\u3002");
        }
        return nativeObj.DeleteMessages(messageIds);
    }

    public boolean clearMessages(ConversationType conversationType, String targetId) {
        if (nativeObj == null) {
            throw new RuntimeException("RongIMClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId)) {
            throw new IllegalArgumentException("\u53c2\u6570\u5f02\u5e38\u3002");
        }
        return nativeObj.ClearMessages(conversationType.getValue(), targetId);
    }

    public boolean clearMessagesUnreadStatus(ConversationType conversationType, String targetId) {
        if (nativeObj == null) {
            throw new RuntimeException("RongIMClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId)) {
            throw new IllegalArgumentException("\u53c2\u6570\u5f02\u5e38\u3002");
        }
        return nativeObj.ClearUnread(conversationType.getValue(), targetId);
    }

    public boolean setMessageExtra(int messageId, String value) {
        if (nativeObj == null) {
            throw new RuntimeException("RongIMClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (messageId == 0) {
            throw new IllegalArgumentException("\u53c2\u6570\u5f02\u5e38\u3002");
        }
        return nativeObj.SetMessageExtra(messageId, value);
    }

    public boolean setMessageReceivedStatus(int messageId, ReceivedStatus receivedStatus) {
        if (nativeObj == null) {
            throw new RuntimeException("RongIMClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (receivedStatus == null || messageId == 0) {
            throw new IllegalArgumentException("\u53c2\u6570\u5f02\u5e38\u3002");
        }
        return nativeObj.SetReadStatus(messageId, receivedStatus.getFlag());
    }

    public boolean setMessageSentStatus(int messageId, SentStatus sentStatus) {
        if (nativeObj == null) {
            throw new RuntimeException("RongIMClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (sentStatus == null || messageId == 0) {
            throw new IllegalArgumentException("\u53c2\u6570\u5f02\u5e38\u3002");
        }
        return nativeObj.SetSendStatus(messageId, sentStatus.getValue());
    }

    public String getTextMessageDraft(ConversationType conversationType, String targetId) {
        if (nativeObj == null) {
            throw new RuntimeException("RongIMClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId)) {
            throw new IllegalArgumentException("\u53c2\u6570\u5f02\u5e38\u3002");
        }
        return nativeObj.GetTextMessageDraft(conversationType.getValue(), targetId);
    }

    public boolean saveTextMessageDraft(ConversationType conversationType, String targetId, String content) {
        if (nativeObj == null) {
            throw new RuntimeException("RongIMClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId)) {
            throw new IllegalArgumentException("\u53c2\u6570\u5f02\u5e38\u3002");
        }
        return nativeObj.SetTextMessageDraft(conversationType.getValue(), targetId, content);
    }

    public boolean clearTextMessageDraft(ConversationType conversationType, String targetId) {
        if (nativeObj == null) {
            throw new RuntimeException("RongIMClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId)) {
            throw new IllegalArgumentException("\u53c2\u6570\u5f02\u5e38\u3002");
        }
        return this.saveTextMessageDraft(conversationType, targetId, "");
    }

    public void getDiscussion(String discussionId, final GetDiscussionCallback callback) {
        if (nativeObj == null) {
            throw new RuntimeException("RongIMClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (TextUtils.isEmpty((CharSequence)discussionId)) {
            throw new IllegalArgumentException("\u53c2\u6570\u5f02\u5e38\u3002");
        }
        nativeObj.GetDiscussionInfo(discussionId, false, new NativeObject.DiscussionInfoListener(){

            @Override
            public void onReceived(NativeObject.DiscussionInfo info) {
                Log.d((String)"MessageLogic", (String)("getDiscussion--GetDiscussionInfo--onReceived:" + info.getDiscussionName()));
                if (callback != null) {
                    callback.onSuccess(new Discussion(info));
                }
            }

            @Override
            public void OnError(int status) {
                if (callback != null) {
                    callback.onError(GetDiscussionCallback.ErrorCode.setValue(status));
                }
            }
        });
    }

    public void setDiscussionName(String discussionId, String name, final OperationCallback callback) {
        if (nativeObj == null) {
            throw new RuntimeException("RongIMClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (TextUtils.isEmpty((CharSequence)discussionId) || TextUtils.isEmpty((CharSequence)discussionId.trim()) || TextUtils.isEmpty((CharSequence)name) || TextUtils.isEmpty((CharSequence)name.trim())) {
            throw new IllegalArgumentException("\u53c2\u6570\u5f02\u5e38\u3002");
        }
        nativeObj.RenameDiscussion(discussionId, name, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code) {
                if (callback == null) {
                    return;
                }
                if (code == 0) {
                    callback.onSuccess();
                } else {
                    callback.onError(OperationCallback.ErrorCode.setValue(code));
                }
            }
        });
    }

    public void createDiscussion(String name, List<String> userIdList, final CreateDiscussionCallback callback) {
        String userId;
        if (nativeObj == null) {
            throw new RuntimeException("RongIMClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (TextUtils.isEmpty((CharSequence)name) || userIdList == null || userIdList.size() == 0) {
            throw new IllegalArgumentException("\u53c2\u6570\u5f02\u5e38\u3002");
        }
        if (this.getCurrentUserInfo() != null && !TextUtils.isEmpty((CharSequence)(userId = this.getCurrentUserInfo().getUserId())) && userIdList.contains(userId)) {
            userIdList.remove(userId);
        }
        String[] ids = new String[userIdList.size()];
        userIdList.toArray(ids);
        nativeObj.CreateInviteDiscussion(name, ids, new NativeObject.CreateDiscussionCallback(){

            @Override
            public void OnError(int errorCode) {
                if (callback != null) {
                    callback.onError(CreateDiscussionCallback.ErrorCode.setValue(errorCode));
                }
            }

            @Override
            public void OnSuccess(String discussionId) {
                if (callback != null) {
                    callback.onSuccess(discussionId);
                }
            }
        });
    }

    public void addMemberToDiscussion(String discussionId, List<String> userIdList, final OperationCallback callback) {
        if (nativeObj == null) {
            throw new RuntimeException("RongIMClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (TextUtils.isEmpty((CharSequence)discussionId) || userIdList == null || userIdList.size() == 0) {
            throw new IllegalArgumentException("\u53c2\u6570\u5f02\u5e38\u3002");
        }
        if (userIdList != null && userIdList.size() > 0) {
            String[] ids = new String[userIdList.size()];
            userIdList.toArray(ids);
            nativeObj.InviteMemberToDiscussion(discussionId, ids, new NativeObject.PublishAckListener(){

                @Override
                public void operationComplete(int code) {
                    if (callback == null) {
                        return;
                    }
                    if (code == 0) {
                        callback.onSuccess();
                    } else {
                        callback.onError(OperationCallback.ErrorCode.setValue(code));
                    }
                }
            });
        }
    }

    public void removeMemberFromDiscussion(String discussionId, String userId, final OperationCallback callback) {
        if (nativeObj == null) {
            throw new RuntimeException("RongIMClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (TextUtils.isEmpty((CharSequence)discussionId) || TextUtils.isEmpty((CharSequence)userId)) {
            throw new IllegalArgumentException("\u53c2\u6570\u5f02\u5e38\u3002");
        }
        nativeObj.RemoveMemberFromDiscussion(discussionId, userId, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code) {
                if (callback == null) {
                    return;
                }
                if (code == 0) {
                    callback.onSuccess();
                } else {
                    callback.onError(OperationCallback.ErrorCode.setValue(code));
                }
            }
        });
    }

    public void quitDiscussion(String discussionId, final OperationCallback callback) {
        if (nativeObj == null) {
            throw new RuntimeException("RongIMClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (TextUtils.isEmpty((CharSequence)discussionId)) {
            throw new IllegalArgumentException("\u53c2\u6570\u5f02\u5e38\u3002");
        }
        nativeObj.QuitDiscussion(discussionId, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code) {
                if (callback == null) {
                    return;
                }
                if (code == 0) {
                    callback.onSuccess();
                } else {
                    callback.onError(OperationCallback.ErrorCode.setValue(code));
                }
            }
        });
    }

    public Message insertMessage(ConversationType conversationType, String targetId, String senderUserId, MessageContent content) {
        if (nativeObj == null) {
            throw new RuntimeException("RongIMClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId) || content == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u5f02\u5e38\u3002");
        }
        MessageTag msgTag = content.getClass().getAnnotation(MessageTag.class);
        if (msgTag == null) {
            throw new RuntimeException("\u81ea\u5b9a\u4e49\u6d88\u606f\u6ca1\u6709\u52a0\u6ce8\u89e3\u4fe1\u606f\u3002");
        }
        Message msg = new Message();
        msg.setConversationType(conversationType);
        msg.setTargetId(targetId);
        msg.setMessageDirection(this.currentUserId.equals(senderUserId) ? MessageDirection.SEND : MessageDirection.RECEIVE);
        msg.setSenderUserId(senderUserId);
        msg.setSentStatus(this.currentUserId.equals(senderUserId) ? SentStatus.SENT : SentStatus.RECEIVED);
        msg.setReceivedTime(System.currentTimeMillis());
        msg.setSentTime(System.currentTimeMillis());
        msg.setObjectName(msgTag.value());
        msg.setContent(content);
        Constructor<? extends MessageTag.MessageHandler> constructor = messageHandlerMap.get(msgTag.value());
        try {
            if (constructor == null) {
                Log.e((String)TAG, (String)"\u8be5\u6d88\u606f\u672a\u6ce8\u518c\uff0c\u8bf7\u8c03\u7528registerMessageType\u65b9\u6cd5\u6ce8\u518c\u3002");
            } else {
                MessageTag.MessageHandler handler = constructor.newInstance(sContext);
                int msgId = this.saveMessage(conversationType, targetId, content, this.currentUserId);
                msg.setMessageId(msgId);
                msg.setReceivedStatus(new ReceivedStatus(0, msgId));
                msg.setSenderUserId(this.currentUserId);
                handler.encodeMessage(msg, content);
                byte[] data = msg.getContent().encode();
                nativeObj.SetMessageContent(msg.getMessageId(), data);
                this.setMessageSentStatus(msgId, this.currentUserId.equals(senderUserId) ? SentStatus.SENT : SentStatus.RECEIVED);
            }
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        if (mOnReceiveMessageListener != null) {
            mOnReceiveMessageListener.onReceived(msg, 0);
        }
        return msg;
    }

    public Message sendMessage(ConversationType conversationType, String targetId, MessageContent content, SendMessageCallback callback) {
        if (nativeObj == null) {
            throw new RuntimeException("RongIMClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId) || content == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u5f02\u5e38\u3002");
        }
        MessageTag msgTag = content.getClass().getAnnotation(MessageTag.class);
        if (msgTag == null) {
            throw new RuntimeException("\u81ea\u5b9a\u4e49\u6d88\u606f\u6ca1\u6709\u52a0\u6ce8\u89e3\u4fe1\u606f\u3002");
        }
        Message msg = new Message();
        msg.setConversationType(conversationType);
        msg.setTargetId(targetId);
        msg.setMessageDirection(MessageDirection.SEND);
        msg.setSenderUserId(this.currentUserId);
        msg.setSentStatus(SentStatus.SENDING);
        msg.setSentTime(System.currentTimeMillis());
        msg.setObjectName(msgTag.value());
        msg.setContent(content);
        Constructor<? extends MessageTag.MessageHandler> constructor = messageHandlerMap.get(msgTag.value());
        try {
            MessageTag.MessageHandler handler = constructor.newInstance(sContext);
            if (msgTag.flag() != 0) {
                int msgId = this.saveMessage(conversationType, targetId, content, this.currentUserId);
                msg.setMessageId(msgId);
                msg.setSenderUserId(this.currentUserId);
                handler.encodeMessage(msg, content);
            }
            handler.handlersendMessage(this, msg, msg.getContent(), callback);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        Log.d((String)"MESSAGE_SEND", (String)"OBTAIN");
        return msg;
    }

    public Message sendNotification(ConversationType conversationType, String targetId, NotificationMessage content, final SendMessageCallback callback) {
        if (nativeObj == null) {
            throw new RuntimeException("RongIMClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId) || content == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u5f02\u5e38\u3002");
        }
        MessageTag msgTag = content.getClass().getAnnotation(MessageTag.class);
        if (msgTag == null) {
            throw new RuntimeException("\u81ea\u5b9a\u4e49\u6d88\u606f\u6ca1\u6709\u52a0\u6ce8\u89e3\u4fe1\u606f\u3002");
        }
        final Message msg = new Message();
        msg.setConversationType(conversationType);
        msg.setTargetId(targetId);
        msg.setMessageDirection(MessageDirection.SEND);
        msg.setSenderUserId(this.currentUserId);
        msg.setSentStatus(SentStatus.SENDING);
        msg.setSentTime(System.currentTimeMillis());
        msg.setObjectName(msgTag.value());
        msg.setContent(content);
        byte[] msgContent = content.encode();
        int msgId = this.saveMessage(conversationType, targetId, content, this.currentUserId);
        msg.setMessageId(msgId);
        nativeObj.SendMessage(targetId, msg.getConversationType().getValue(), 3, msgTag.value(), msgContent, null, msgId, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code) {
                if (callback == null) {
                    return;
                }
                if (code == 0) {
                    callback.onSuccess(msg.getMessageId());
                } else {
                    callback.onError(msg.getMessageId(), SendMessageCallback.ErrorCode.setValue(code));
                }
            }
        });
        return msg;
    }

    public Message sendStatus(ConversationType conversationType, String targetId, StatusMessage content, final SendMessageCallback callback) {
        if (nativeObj == null) {
            throw new RuntimeException("RongIMClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId) || content == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u5f02\u5e38\u3002");
        }
        MessageTag msgTag = content.getClass().getAnnotation(MessageTag.class);
        if (msgTag == null) {
            throw new RuntimeException("\u81ea\u5b9a\u4e49\u6d88\u606f\u6ca1\u6709\u52a0\u6ce8\u89e3\u4fe1\u606f\u3002");
        }
        final Message msg = new Message();
        msg.setConversationType(conversationType);
        msg.setTargetId(targetId);
        msg.setMessageDirection(MessageDirection.SEND);
        msg.setSenderUserId(this.currentUserId);
        msg.setSentStatus(SentStatus.SENDING);
        msg.setSentTime(System.currentTimeMillis());
        msg.setObjectName(msgTag.value());
        msg.setContent(content);
        byte[] msgContent = content.encode();
        int msgId = this.saveMessage(conversationType, targetId, content, this.currentUserId);
        msg.setMessageId(msgId);
        nativeObj.SendMessage(targetId, msg.getConversationType().getValue(), 1, msgTag.value(), msgContent, null, msgId, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code) {
                if (callback == null) {
                    return;
                }
                if (code == 0) {
                    callback.onSuccess(msg.getMessageId());
                } else {
                    callback.onError(msg.getMessageId(), SendMessageCallback.ErrorCode.setValue(code));
                }
            }
        });
        return msg;
    }

    public void uploadMedia(ConversationType conversationType, String targetId, InputStream stream, final UploadMediaCallback callback) {
        if (nativeObj == null) {
            throw new RuntimeException("RongIMClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationType == null || targetId == null || stream == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u5f02\u5e38\u3002");
        }
        byte[] bytes = null;
        try {
            int count = 0;
            while (count == 0) {
                count = stream.available();
            }
            bytes = new byte[count];
            stream.read(bytes);
        }
        catch (Exception e) {
            throw new IllegalArgumentException();
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {}
        }
        nativeObj.SendFileWithUrl(targetId, conversationType.getValue(), 1, bytes, bytes.length, new NativeObject.ProgressCallback(){

            @Override
            public void OnProgress(int progress) {
                if (callback != null) {
                    callback.onProgress(progress);
                }
            }

            @Override
            public void OnError(int errorCode, String description) {
                if (callback != null) {
                    callback.onError(UploadMediaCallback.ErrorCode.setValue(errorCode));
                }
            }

            @Override
            public void OnComplete(String result) {
                if (callback != null) {
                    callback.onSuccess(result);
                }
            }
        });
    }

    public void downloadMedia(ConversationType conversationType, String targetId, MediaType mediaType, String imageUrl, final DownloadMediaCallback callback) {
        if (nativeObj == null) {
            throw new RuntimeException("RongIMClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId) || mediaType == null || TextUtils.isEmpty((CharSequence)imageUrl)) {
            throw new IllegalArgumentException("\u53c2\u6570\u5f02\u5e38\u3002");
        }
        nativeObj.DownFileWithUrl(targetId, conversationType.getValue(), mediaType.getValue(), imageUrl, new NativeObject.ProgressCallback(){

            @Override
            public void OnProgress(int progress) {
                if (callback != null) {
                    callback.onProgress(progress);
                }
            }

            @Override
            public void OnError(int errorCode, String description) {
                if (callback != null) {
                    callback.onError(DownloadMediaCallback.ErrorCode.setValue(errorCode));
                }
            }

            @Override
            public void OnComplete(String result) {
                if (callback != null) {
                    callback.onSuccess(result);
                }
            }
        });
    }

    private void clearCachedResources(OperationCallback callback) {
    }

    public void getConversationNotificationStatus(ConversationType conversationType, String targetId, final GetConversationNotificationStatusCallback callback) {
        if (nativeObj == null) {
            throw new RuntimeException("RongIMClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId) || callback == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u5f02\u5e38\u3002");
        }
        nativeObj.GetBlockPush(targetId, conversationType.getValue(), false, new NativeObject.BizAckListener(){

            @Override
            public void operationComplete(int opStatus, int status) {
                if (callback == null) {
                    return;
                }
                if (opStatus == 0) {
                    callback.onSuccess(status == 100 ? ConversationNotificationStatus.DO_NOT_DISTURB : ConversationNotificationStatus.NOTIFY);
                } else {
                    callback.onError(GetConversationNotificationStatusCallback.ErrorCode.setValue(opStatus));
                }
            }
        });
    }

    public void setConversationNotificationStatus(ConversationType conversationType, String targetId, ConversationNotificationStatus notificationStatus, final SetConversationNotificationStatusCallback callback) {
        if (nativeObj == null) {
            throw new RuntimeException("RongIMClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationType == null || notificationStatus == null || TextUtils.isEmpty((CharSequence)targetId) || callback == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u5f02\u5e38\u3002");
        }
        nativeObj.SetBlockPush(targetId, conversationType.getValue(), notificationStatus == ConversationNotificationStatus.DO_NOT_DISTURB, new NativeObject.BizAckListener(){

            @Override
            public void operationComplete(int opStatus, int status) {
                if (callback == null) {
                    return;
                }
                if (opStatus == 0) {
                    callback.onSuccess(status == 100 ? ConversationNotificationStatus.DO_NOT_DISTURB : ConversationNotificationStatus.NOTIFY);
                } else {
                    Log.d((String)RongIMClient.TAG, (String)("setConversationNotificationStatus---operationComplete---" + opStatus));
                    callback.onError(SetConversationNotificationStatusCallback.ErrorCode.setValue(status));
                }
            }
        });
    }

    public void setDiscussionInviteStatus(String targetId, DiscussionInviteStatus status, final SetDiscussionInviteStatusCallback callback) {
        if (nativeObj == null) {
            throw new RuntimeException("RongIMClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (TextUtils.isEmpty((CharSequence)targetId)) {
            throw new IllegalArgumentException("\u53c2\u6570\u5f02\u5e38\u3002");
        }
        nativeObj.SetInviteStatus(targetId, status.getValue(), new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int statusCode) {
                if (callback == null) {
                    return;
                }
                if (statusCode == 0) {
                    callback.onSuccess();
                } else {
                    callback.onError(SetDiscussionInviteStatusCallback.ErrorCode.setValue(statusCode));
                }
            }
        });
    }

    public void syncGroup(List<Group> groups, final OperationCallback callback) {
        if (nativeObj == null) {
            throw new RuntimeException("RongIMClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (groups == null || groups.size() == 0) {
            throw new IllegalArgumentException("\u53c2\u6570\u5f02\u5e38\u3002");
        }
        String[] ids = new String[groups.size()];
        String[] names = new String[groups.size()];
        int i = 0;
        for (Group item : groups) {
            ids[i] = item.getId();
            names[i++] = item.getName();
        }
        nativeObj.SyncGroups(ids, names, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code) {
                if (callback == null) {
                    return;
                }
                if (code == 0) {
                    callback.onSuccess();
                } else {
                    callback.onError(OperationCallback.ErrorCode.setValue(code));
                }
            }
        });
    }

    public void joinGroup(String groupId, String groupName, final OperationCallback callback) {
        if (nativeObj == null) {
            throw new RuntimeException("RongIMClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (groupId == null || groupName == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u5f02\u5e38\u3002");
        }
        nativeObj.JoinGroup(groupId, groupName, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code) {
                if (callback == null) {
                    return;
                }
                if (code == 0) {
                    callback.onSuccess();
                } else {
                    callback.onError(OperationCallback.ErrorCode.setValue(code));
                }
            }
        });
    }

    public void quitGroup(String groupId, final OperationCallback callback) {
        if (nativeObj == null) {
            throw new RuntimeException("RongIMClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (groupId == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u5f02\u5e38\u3002");
        }
        nativeObj.QuitGroup(groupId, "", new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code) {
                if (callback == null) {
                    return;
                }
                if (code == 0) {
                    callback.onSuccess();
                } else {
                    callback.onError(OperationCallback.ErrorCode.setValue(code));
                }
            }
        });
    }

    public void getUserInfo(String userId, final GetUserInfoCallback callback) {
        if (nativeObj == null) {
            throw new RuntimeException("RongIMClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (userId == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u5f02\u5e38\u3002");
        }
        nativeObj.GetUserInfo(userId, new NativeObject.UserInfoOutputListener(){

            @Override
            public void onReceiveUserInfo(String userId, byte[] userName, String userPortrait) {
                UserInfo info = new UserInfo(userId, userName == null ? null : new String(userName), userPortrait);
                if (callback != null) {
                    callback.onSuccess(info);
                }
            }

            @Override
            public void OnError(int status) {
                if (callback != null) {
                    callback.onError(GetUserInfoCallback.ErrorCode.setValue(status));
                }
            }
        });
    }

    public UserInfo getCurrentUserInfo() {
        if (nativeObj == null) {
            throw new RuntimeException("RongIMClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        return this.mUserInfo;
    }

    private void addUserInfoToCache(UserInfo userInfo) {
    }

    public void setOnReceiveMessageListener(OnReceiveMessageListener listener) {
        if (nativeObj == null) {
            throw new RuntimeException("RongIMClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        mOnReceiveMessageListener = listener;
        nativeObj.SetMessageListener(new NativeObject.ReceiveMessageListener(){

            @Override
            public void onReceived(NativeObject.Message nativeMessage, int left) {
                final Message message = new Message(nativeMessage);
                if (message.getContent() instanceof UnknowMessage) {
                    return;
                }
                Log.d((String)"RongIMClinet", (String)"------setOnReceiveMessageListener--------onReceived-------");
                if (message.getContent() instanceof DiscussionNotificationMessage) {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            nativeObj.GetDiscussionInfo(message.targetId, true, new NativeObject.DiscussionInfoListener(){

                                @Override
                                public void onReceived(NativeObject.DiscussionInfo info) {
                                    Log.d((String)"RongIMClinet", (String)("getDiscussion--setOnReceiveMessageListener--onReceived:" + info.getDiscussionName()));
                                }

                                @Override
                                public void OnError(int status) {
                                    Log.d((String)"RongIMClinet", (String)("-------OnError----status:" + status));
                                }
                            });
                        }
                    }).start();
                }
                if (mOnReceiveMessageListener != null) {
                    mOnReceiveMessageListener.onReceived(message, left);
                }
            }
        });
    }

    public static void setConnectionStatusListener(ConnectionStatusListener listener) {
        mListener = listener;
        nativeObj.SetExceptionListener(new NativeObject.ExceptionListener(){

            @Override
            public void onError(int status, String desc) {
                switch (status) {
                    case 100: {
                        status = ConnectionStatusListener.ConnectionStatus.NETWORK_UNAVAILABLE.code;
                        break;
                    }
                    case 1001: {
                        status = ConnectionStatusListener.ConnectionStatus.KICKED_OFFLINE_BY_OTHER_CLIENT.code;
                        break;
                    }
                    case 3001: {
                        status = ConnectionStatusListener.ConnectionStatus.NETWORK_UNAVAILABLE.code;
                        break;
                    }
                    case 3006: {
                        status = ConnectionStatusListener.ConnectionStatus.NETWORK_UNAVAILABLE.code;
                        break;
                    }
                    case 10004: {
                        status = ConnectionStatusListener.ConnectionStatus.CONNECTED.code;
                    }
                }
                Log.d((String)"ConnectionStatus", (String)("value:" + status));
                currentConnStatus = ConnectionStatusListener.ConnectionStatus.setValue(status);
                if (mListener != null) {
                    mListener.onChanged(ConnectionStatusListener.ConnectionStatus.setValue(status));
                }
            }
        });
    }

    public long getDeltaTime() {
        return nativeObj.GetDeltaTime();
    }

    public void joinChatRoom(String id2, int defMessageCount, final OperationCallback callback) {
        if (nativeObj == null) {
            throw new RuntimeException("RongIMClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (TextUtils.isEmpty((CharSequence)id2) || defMessageCount < 0) {
            throw new IllegalArgumentException("\u53c2\u6570\u5f02\u5e38\u3002");
        }
        nativeObj.JoinChatRoom(id2, ConversationType.CHATROOM.getValue(), defMessageCount, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code) {
                if (code == 0) {
                    if (callback != null) {
                        callback.onSuccess();
                    }
                } else if (callback != null) {
                    callback.onError(OperationCallback.ErrorCode.setValue(code));
                }
            }
        });
    }

    public void quitChatRoom(String id2, final OperationCallback callback) {
        if (nativeObj == null) {
            throw new RuntimeException("RongIMClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (TextUtils.isEmpty((CharSequence)id2)) {
            throw new IllegalArgumentException("\u53c2\u6570\u5f02\u5e38\u3002");
        }
        nativeObj.QuitChatRoom(id2, ConversationType.CHATROOM.getValue(), new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code) {
                if (code == 0) {
                    if (callback != null) {
                        callback.onSuccess();
                    }
                } else if (callback != null) {
                    callback.onError(OperationCallback.ErrorCode.setValue(code));
                }
            }
        });
        this.clearMessages(ConversationType.CHATROOM, id2);
    }

    public boolean clearConversations(ConversationType ... conversationTypes) {
        if (nativeObj == null) {
            throw new RuntimeException("RongIMClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationTypes == null || conversationTypes.length == 0) {
            new IllegalAccessException("ConversationTypes \u53c2\u6570\u5f02\u5e38\u3002");
        }
        int[] conversationTypeValues = new int[conversationTypes.length];
        int i = 0;
        for (ConversationType conversationType : conversationTypes) {
            conversationTypeValues[i] = conversationType.getValue();
            ++i;
        }
        return nativeObj.ClearConversations(conversationTypeValues);
    }

    public void addToBlacklist(String userId, final AddToBlackCallback callback) {
        if (nativeObj == null) {
            throw new RuntimeException("RongIMClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (TextUtils.isEmpty((CharSequence)userId) || callback == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u5f02\u5e38\u3002");
        }
        nativeObj.AddToBlacklist(userId, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code) {
                if (code == 0) {
                    callback.onSuccess();
                } else {
                    callback.onError(AddToBlackCallback.ErrorCode.setValue(code));
                }
            }
        });
    }

    public void removeFromBlacklist(String userId, final RemoveFromBlacklistCallback callback) {
        if (nativeObj == null) {
            throw new RuntimeException("RongIMClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (TextUtils.isEmpty((CharSequence)userId) || callback == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u5f02\u5e38\u3002");
        }
        nativeObj.RemoveFromBlacklist(userId, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code) {
                if (code == 0) {
                    callback.onSuccess();
                } else {
                    callback.onError(RemoveFromBlacklistCallback.ErrorCode.setValue(code));
                }
            }
        });
    }

    public void getBlacklistStatus(String userId, final GetUserBlacklistCallback callback) {
        if (nativeObj == null) {
            throw new RuntimeException("RongIMClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (TextUtils.isEmpty((CharSequence)userId) || callback == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u5f02\u5e38\u3002");
        }
        nativeObj.GetBlacklistStatus(userId, new NativeObject.BizAckListener(){

            @Override
            public void operationComplete(int opStatus, int status) {
                if (opStatus == 0) {
                    if (status == 0) {
                        callback.onSuccess(BlacklistStatus.EXIT_BLACK_LIST);
                    } else if (status == 101) {
                        callback.onSuccess(BlacklistStatus.NOT_EXIT_BLACK_LIST);
                    }
                } else {
                    callback.onError(GetUserBlacklistCallback.ErrorCode.setValue(opStatus));
                }
            }
        });
    }

    public void getBlacklist(final GetBlacklistCallback callback) {
        if (nativeObj == null) {
            throw new RuntimeException("RongIMClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (callback == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u5f02\u5e38\u3002");
        }
        nativeObj.GetBlacklist(new NativeObject.SetBlacklistListener(){

            @Override
            public void OnSuccess(String userIds) {
                if (!TextUtils.isEmpty((CharSequence)userIds)) {
                    if (callback != null) {
                        callback.onSuccess(userIds.split("\n"));
                    }
                } else if (callback != null) {
                    callback.onSuccess(null);
                }
            }

            @Override
            public void OnError(int errorCode) {
                if (callback != null) {
                    callback.onError(GetBlacklistCallback.ErrorCode.setValue(errorCode));
                }
            }
        });
    }

    private static PushMessageBehaviorListener getPushMessageBehaviorListener() {
        return mPushMessageBehaviorListener;
    }

    private static void setPushMessageBehaviorListener(PushMessageBehaviorListener listener) {
        mPushMessageBehaviorListener = listener;
    }

    public static void clearNotifications() {
        RongNotificationManager.getInstance().removeNotificationMsgFromCache();
    }

    static {
        sContext = null;
        constructorMap = new HashMap();
        messageHandlerMap = new HashMap();
        currentConnStatus = ConnectionStatusListener.ConnectionStatus.DISCONNECTED;
    }

    private static interface PushMessageBehaviorListener {
        public boolean onPushMessageArrive(RongNotificationMessage var1);
    }

    public static interface GetBlacklistCallback {
        public void onSuccess(String[] var1);

        public void onError(ErrorCode var1);

        public static enum ErrorCode {
            UNKNOWN(-1, "Unknown error."),
            TIMEOUT(3001, "Server is timed out.");

            private int code;
            private String msg;

            private ErrorCode(int code, String msg) {
                this.code = code;
                this.msg = msg;
            }

            public int getValue() {
                return this.code;
            }

            public String getMessage() {
                return this.msg;
            }

            public static ErrorCode setValue(int code) {
                for (ErrorCode c : ErrorCode.values()) {
                    if (code != c.getValue()) continue;
                    return c;
                }
                Log.d((String)RongIMClient.TAG, (String)("GetBlacklistCallback---ErrorCode---code:" + code));
                return UNKNOWN;
            }
        }
    }

    public static interface GetUserBlacklistCallback {
        public void onSuccess(BlacklistStatus var1);

        public void onError(ErrorCode var1);

        public static enum ErrorCode {
            UNKNOWN(-1, "Unknown error."),
            TIMEOUT(3001, "Server is timed out.");

            private int code;
            private String msg;

            private ErrorCode(int code, String msg) {
                this.code = code;
                this.msg = msg;
            }

            public int getValue() {
                return this.code;
            }

            public String getMessage() {
                return this.msg;
            }

            public static ErrorCode setValue(int code) {
                for (ErrorCode c : ErrorCode.values()) {
                    if (code != c.getValue()) continue;
                    return c;
                }
                Log.d((String)RongIMClient.TAG, (String)("GetUserBlacklistCallback---ErrorCode---code:" + code));
                return UNKNOWN;
            }
        }
    }

    public static interface RemoveFromBlacklistCallback {
        public void onSuccess();

        public void onError(ErrorCode var1);

        public static enum ErrorCode {
            UNKNOWN(-1, "Unknown error."),
            TIMEOUT(3001, "Server is timed out.");

            private int code;
            private String msg;

            private ErrorCode(int code, String msg) {
                this.code = code;
                this.msg = msg;
            }

            public int getValue() {
                return this.code;
            }

            public String getMessage() {
                return this.msg;
            }

            public static ErrorCode setValue(int code) {
                for (ErrorCode c : ErrorCode.values()) {
                    if (code != c.getValue()) continue;
                    return c;
                }
                Log.d((String)RongIMClient.TAG, (String)("RemoveFromBlacklistCallback---ErrorCode---code:" + code));
                return UNKNOWN;
            }
        }
    }

    public static interface AddToBlackCallback {
        public void onSuccess();

        public void onError(ErrorCode var1);

        public static enum ErrorCode {
            UNKNOWN(-1, "Unknown error."),
            TIMEOUT(3001, "Server is timed out.");

            private int code;
            private String msg;

            private ErrorCode(int code, String msg) {
                this.code = code;
                this.msg = msg;
            }

            public int getValue() {
                return this.code;
            }

            public String getMessage() {
                return this.msg;
            }

            public static ErrorCode setValue(int code) {
                for (ErrorCode c : ErrorCode.values()) {
                    if (code != c.getValue()) continue;
                    return c;
                }
                Log.d((String)RongIMClient.TAG, (String)("AddToBlackCallback---ErrorCode---code:" + code));
                return UNKNOWN;
            }
        }
    }

    public static enum BlacklistStatus {
        EXIT_BLACK_LIST(0),
        NOT_EXIT_BLACK_LIST(1);

        private int value = 1;

        private BlacklistStatus(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static BlacklistStatus setValue(int code) {
            for (BlacklistStatus c : BlacklistStatus.values()) {
                if (code != c.getValue()) continue;
                return c;
            }
            return NOT_EXIT_BLACK_LIST;
        }
    }

    public static interface ConnectionStatusListener {
        public void onChanged(ConnectionStatus var1);

        public static enum ConnectionStatus {
            DISCONNECTED(-9, "Disconnected"),
            CONNECTED(0, "Connect Success."),
            CONNECTING(2, "Connecting"),
            UNKNOWN(-1, "Unknown error."),
            NETWORK_UNAVAILABLE(1, "Network is unavailable."),
            KICKED_OFFLINE_BY_OTHER_CLIENT(6, "Login on the other device, and be kicked offline."),
            LOGIN_ON_WEB(7, "Login on web client.");

            private int code;
            private String msg;

            private ConnectionStatus(int code, String msg) {
                this.code = code;
                this.msg = msg;
            }

            public int getValue() {
                return this.code;
            }

            public String getMessage() {
                return this.msg;
            }

            public static ConnectionStatus setValue(int code) {
                for (ConnectionStatus c : ConnectionStatus.values()) {
                    if (code != c.getValue()) continue;
                    return c;
                }
                Log.d((String)RongIMClient.TAG, (String)("ConnectionStatusListener---ErrorCode---code:" + code));
                return UNKNOWN;
            }
        }
    }

    public static interface OnReceiveMessageListener {
        public void onReceived(Message var1, int var2);
    }

    public static interface SetDiscussionInviteStatusCallback {
        public void onSuccess();

        public void onError(ErrorCode var1);

        public static enum ErrorCode {
            UNKNOWN(-1, "Unknown error."),
            TIMEOUT(3001, "Server is timed out.");

            private int code;
            private String msg;

            private ErrorCode(int code, String msg) {
                this.code = code;
                this.msg = msg;
            }

            public int getValue() {
                return this.code;
            }

            public String getMessage() {
                return this.msg;
            }

            public static ErrorCode setValue(int code) {
                for (ErrorCode c : ErrorCode.values()) {
                    if (code != c.getValue()) continue;
                    return c;
                }
                Log.d((String)RongIMClient.TAG, (String)("SetDiscussionInviteStatusCallback---ErrorCode---code:" + code));
                return UNKNOWN;
            }
        }
    }

    public static interface GetConversationNotificationStatusCallback {
        public void onSuccess(ConversationNotificationStatus var1);

        public void onError(ErrorCode var1);

        public static enum ErrorCode {
            UNKNOWN(-1, "Unknown error."),
            TIMEOUT(3001, "Server is timed out.");

            private int code;
            private String msg;

            private ErrorCode(int code, String msg) {
                this.code = code;
                this.msg = msg;
            }

            public int getValue() {
                return this.code;
            }

            public String getMessage() {
                return this.msg;
            }

            public static ErrorCode setValue(int code) {
                for (ErrorCode c : ErrorCode.values()) {
                    if (code != c.getValue()) continue;
                    return c;
                }
                Log.d((String)RongIMClient.TAG, (String)("GetConversationNotificationStatusCallback---ErrorCode---code:" + code));
                return UNKNOWN;
            }
        }
    }

    public static interface SetConversationNotificationStatusCallback {
        public void onSuccess(ConversationNotificationStatus var1);

        public void onError(ErrorCode var1);

        public static enum ErrorCode {
            UNKNOWN(-1, "Unknown error."),
            TIMEOUT(3001, "Server is timed out.");

            private int code;
            private String msg;

            private ErrorCode(int code, String msg) {
                this.code = code;
                this.msg = msg;
            }

            public int getValue() {
                return this.code;
            }

            public String getMessage() {
                return this.msg;
            }

            public static ErrorCode setValue(int code) {
                for (ErrorCode c : ErrorCode.values()) {
                    if (code != c.getValue()) continue;
                    return c;
                }
                Log.d((String)RongIMClient.TAG, (String)("SetConversationNotificationStatusCallback---ErrorCode---code:" + code));
                return UNKNOWN;
            }
        }
    }

    public static interface GetDiscussionCallback {
        public void onSuccess(Discussion var1);

        public void onError(ErrorCode var1);

        public static enum ErrorCode {
            UNKNOWN(-1, "Unknown error."),
            TIMEOUT(3001, "Server is timed out.");

            private int code;
            private String msg;

            private ErrorCode(int code, String msg) {
                this.code = code;
                this.msg = msg;
            }

            public int getValue() {
                return this.code;
            }

            public String getMessage() {
                return this.msg;
            }

            public static ErrorCode setValue(int code) {
                for (ErrorCode c : ErrorCode.values()) {
                    if (code != c.getValue()) continue;
                    return c;
                }
                Log.d((String)RongIMClient.TAG, (String)("GetDiscussionCallback---ErrorCode---code:" + code));
                return UNKNOWN;
            }
        }
    }

    public static interface GetUserInfoCallback {
        public void onSuccess(UserInfo var1);

        public void onError(ErrorCode var1);

        public static enum ErrorCode {
            UNKNOWN(-1, "Unknown error."),
            TIMEOUT(3001, "Server is timed out.");

            private int code;
            private String msg;

            private ErrorCode(int code, String msg) {
                this.code = code;
                this.msg = msg;
            }

            public int getValue() {
                return this.code;
            }

            public String getMessage() {
                return this.msg;
            }

            public static ErrorCode setValue(int code) {
                for (ErrorCode c : ErrorCode.values()) {
                    if (code != c.getValue()) continue;
                    return c;
                }
                Log.d((String)RongIMClient.TAG, (String)("GetUserInfoCallback---ErrorCode---code:" + code));
                return UNKNOWN;
            }
        }
    }

    public static interface DownloadMediaCallback {
        public void onProgress(int var1);

        public void onSuccess(String var1);

        public void onError(ErrorCode var1);

        public static enum ErrorCode {
            UNKNOWN(-1, "Unknown error."),
            TIMEOUT(3001, "Server is timed out.");

            private int code;
            private String msg;

            private ErrorCode(int code, String msg) {
                this.code = code;
                this.msg = msg;
            }

            public int getValue() {
                return this.code;
            }

            public String getMessage() {
                return this.msg;
            }

            public static ErrorCode setValue(int code) {
                for (ErrorCode c : ErrorCode.values()) {
                    if (code != c.getValue()) continue;
                    return c;
                }
                Log.d((String)RongIMClient.TAG, (String)("DownloadMediaCallback---ErrorCode---code:" + code));
                return UNKNOWN;
            }
        }
    }

    public static interface UploadMediaCallback {
        public void onProgress(int var1);

        public void onSuccess(String var1);

        public void onError(ErrorCode var1);

        public static enum ErrorCode {
            UNKNOWN(-1, "Unknown error."),
            TIMEOUT(3001, "Server is timed out.");

            private int code;
            private String msg;

            private ErrorCode(int code, String msg) {
                this.code = code;
                this.msg = msg;
            }

            public int getValue() {
                return this.code;
            }

            public String getMessage() {
                return this.msg;
            }

            public static ErrorCode setValue(int code) {
                for (ErrorCode c : ErrorCode.values()) {
                    if (code != c.getValue()) continue;
                    return c;
                }
                Log.d((String)RongIMClient.TAG, (String)("UploadMediaCallback---ErrorCode---code:" + code));
                return UNKNOWN;
            }
        }
    }

    public static interface CreateDiscussionCallback {
        public void onSuccess(String var1);

        public void onError(ErrorCode var1);

        public static enum ErrorCode {
            UNKNOWN(-1, "Unknown error."),
            TIMEOUT(3001, "Server is timed out.");

            private int code;
            private String msg;

            private ErrorCode(int code, String msg) {
                this.code = code;
                this.msg = msg;
            }

            public int getValue() {
                return this.code;
            }

            public String getMessage() {
                return this.msg;
            }

            public static ErrorCode setValue(int code) {
                for (ErrorCode c : ErrorCode.values()) {
                    if (code != c.getValue()) continue;
                    return c;
                }
                Log.d((String)RongIMClient.TAG, (String)("CreateDiscussionCallback---ErrorCode---code:" + code));
                return UNKNOWN;
            }
        }
    }

    public static interface SendMessageCallback {
        public void onSuccess(int var1);

        public void onError(int var1, ErrorCode var2);

        public void onProgress(int var1, int var2);

        public static enum ErrorCode {
            UNKNOWN(-1, "Unknown error."),
            HANDLER_EXP(-2, "Handler exp."),
            TIMEOUT(3001, "Server is timed out."),
            REJECTED_BY_BLACKLIST(405, "rejected by blacklist");

            private int code;
            private String msg;

            private ErrorCode(int code, String msg) {
                this.code = code;
                this.msg = msg;
            }

            public int getValue() {
                return this.code;
            }

            public String getMessage() {
                return this.msg;
            }

            public static ErrorCode setValue(int code) {
                for (ErrorCode c : ErrorCode.values()) {
                    if (code != c.getValue()) continue;
                    return c;
                }
                Log.d((String)RongIMClient.TAG, (String)("SendMessageCallback---ErrorCode---code:" + code));
                return UNKNOWN;
            }
        }
    }

    public static interface OperationCallback {
        public void onSuccess();

        public void onError(ErrorCode var1);

        public static enum ErrorCode {
            UNKNOWN(-1, "Unknown error."),
            TIMEOUT(3001, "Server is timed out.");

            private int code;
            private String msg;

            private ErrorCode(int code, String msg) {
                this.code = code;
                this.msg = msg;
            }

            public int getValue() {
                return this.code;
            }

            public String getMessage() {
                return this.msg;
            }

            public static ErrorCode setValue(int code) {
                for (ErrorCode c : ErrorCode.values()) {
                    if (code != c.getValue()) continue;
                    return c;
                }
                Log.d((String)RongIMClient.TAG, (String)("OperationCallback---ErrorCode---code:" + code));
                return UNKNOWN;
            }
        }
    }

    public static interface ConnectCallback {
        public void onSuccess(String var1);

        public void onError(ErrorCode var1);

        public static enum ErrorCode {
            UNKNOWN(-1, "Unknown error."),
            PACKAGE_BROKEN(2002, "Package is broken."),
            SERVER_UNAVAILABLE(2003, "Server is unavailable."),
            TOKEN_INCORRECT(2004, "Token is incorrect."),
            APP_KEY_UNAVAILABLE(2005, "App key is unavailable."),
            DATABASE_ERROR(2006, "Database is error"),
            TIMEOUT(5004, "Server is timed out.");

            private int code;
            private String msg;

            private ErrorCode(int code, String msg) {
                this.code = code;
                this.msg = msg;
            }

            public int getValue() {
                return this.code;
            }

            public String getMessage() {
                return this.msg;
            }

            public static ErrorCode setValue(int code) {
                if (code == 3002) {
                    code = 2004;
                }
                for (ErrorCode c : ErrorCode.values()) {
                    if (code != c.getValue()) continue;
                    return c;
                }
                Log.d((String)RongIMClient.TAG, (String)("ConnectCallback---ErrorCode---code:" + code));
                return UNKNOWN;
            }
        }
    }

    public static enum ConversationNotificationStatus {
        DO_NOT_DISTURB(0),
        NOTIFY(1);

        private int value = 1;

        private ConversationNotificationStatus(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static ConversationNotificationStatus setValue(int code) {
            for (ConversationNotificationStatus c : ConversationNotificationStatus.values()) {
                if (code != c.getValue()) continue;
                return c;
            }
            return NOTIFY;
        }
    }

    public static enum DiscussionInviteStatus {
        CLOSED(1),
        OPENED(0);

        private int value = 0;

        private DiscussionInviteStatus(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static DiscussionInviteStatus setValue(int code) {
            for (DiscussionInviteStatus c : DiscussionInviteStatus.values()) {
                if (code != c.getValue()) continue;
                return c;
            }
            return OPENED;
        }
    }

    @MessageTag(value="RC:TypNtf")
    private static class IsTypingStatusMessage
    extends StatusMessage {
        private boolean isTyping;

        private IsTypingStatusMessage() {
        }

        public boolean isTyping() {
            return this.isTyping;
        }

        public void setTyping(boolean isTyping) {
            this.isTyping = isTyping;
        }

        @Override
        public byte[] encode() {
            return new byte[0];
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
        }
    }

    private static abstract class StatusMessage
    extends MessageContent {
        private StatusMessage() {
        }
    }

    @MessageTag(value="RC:ReadNtf")
    private static class HasReadNotificationMessage
    extends NotificationMessage {
        private boolean hasRead;

        private HasReadNotificationMessage() {
        }

        public boolean hasRead() {
            return this.hasRead;
        }

        public void hasRead(boolean hasRead) {
            this.hasRead = hasRead;
        }

        @Override
        public byte[] encode() {
            return new byte[0];
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
        }
    }

    @MessageTag(value="RC:RecNtf")
    private static class HasReceivedNotificationMessage
    extends NotificationMessage {
        private boolean hasReceived;

        private HasReceivedNotificationMessage() {
        }

        public boolean isHasReceived() {
            return this.hasReceived;
        }

        public void setHasReceived(boolean hasReceived) {
            this.hasReceived = hasReceived;
        }

        @Override
        public byte[] encode() {
            return new byte[0];
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
        }
    }

    @MessageTag(value="RC:DizNtf", flag=1)
    public static class DiscussionNotificationMessage
    extends NotificationMessage {
        private int type;
        private String extension;
        private String operator;
        private boolean hasReceived;
        public static final Parcelable.Creator<DiscussionNotificationMessage> CREATOR = new Parcelable.Creator<DiscussionNotificationMessage>(){

            public DiscussionNotificationMessage createFromParcel(Parcel source) {
                return new DiscussionNotificationMessage(source);
            }

            public DiscussionNotificationMessage[] newArray(int size) {
                return new DiscussionNotificationMessage[size];
            }
        };

        public DiscussionNotificationMessage() {
        }

        public DiscussionNotificationMessage(Parcel in) {
            this.type = in.readInt();
            this.extension = in.readString();
            this.operator = in.readString();
        }

        public static DiscussionNotificationMessage obtain(int type, String extension, String operator) {
            DiscussionNotificationMessage model = new DiscussionNotificationMessage();
            model.setType(type);
            model.setExtension(extension);
            model.setOperator(operator);
            return model;
        }

        public DiscussionNotificationMessage(byte[] data) {
            String jsonStr = null;
            try {
                jsonStr = new String(data, "UTF-8");
            }
            catch (UnsupportedEncodingException e1) {
                // empty catch block
            }
            try {
                JSONObject jsonObj = new JSONObject(jsonStr);
                this.setType(jsonObj.getInt("type"));
                this.setExtension(jsonObj.getString("extension"));
                this.setOperator(jsonObj.getString("operator"));
            }
            catch (JSONException e) {
                Log.e((String)"JSONException", (String)e.getMessage());
            }
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.type);
            if (this.extension != null) {
                dest.writeString(this.extension);
            } else {
                dest.writeString("");
            }
            if (this.operator != null) {
                dest.writeString(this.operator);
            } else {
                dest.writeString("");
            }
        }

        public boolean isHasReceived() {
            return this.hasReceived;
        }

        public void setHasReceived(boolean hasReceived) {
            this.hasReceived = hasReceived;
        }

        @Override
        public byte[] encode() {
            JSONObject jsonObj = new JSONObject();
            try {
                jsonObj.put("type", this.type);
                jsonObj.put("extension", (Object)this.extension);
            }
            catch (JSONException e) {
                Log.e((String)"JSONException", (String)e.getMessage());
            }
            try {
                return jsonObj.toString().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                return null;
            }
        }

        public int getType() {
            return this.type;
        }

        public void setType(int type) {
            this.type = type;
        }

        public String getExtension() {
            return this.extension;
        }

        public void setExtension(String extension) {
            this.extension = extension;
        }

        public String getOperator() {
            return this.operator;
        }

        public void setOperator(String operator) {
            this.operator = operator;
        }
    }

    public static abstract class NotificationMessage
    extends MessageContent {
    }

    @MessageTag(value="RC:StkMsg")
    private static class StickerMessage
    extends MessageContent {
        @Override
        public byte[] encode() {
            return null;
        }

        public StickerMessage() {
        }

        public StickerMessage(byte[] data) {
        }

        public StickerMessage(String stickerCategory, String key, Bitmap stickerImage) {
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
        }
    }

    public static class UnknowMessage
    extends MessageContent {
        public UnknowMessage(byte[] bytes) {
        }

        public UnknowMessage() {
        }

        @Override
        public byte[] encode() {
            return new byte[0];
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
        }
    }

    public static abstract class MessageContent
    implements Parcelable {
        protected String pushContent;

        public String getPushContent() {
            return this.pushContent;
        }

        public void setPushContent(String pushContent) {
            this.pushContent = pushContent;
        }

        protected MessageContent() {
        }

        public MessageContent(byte[] data, Message message) {
        }

        public abstract byte[] encode();
    }

    public static class Group {
        private String id;
        private String name;
        private String portraitUri;

        public Group(String id2, String name, String portraitUri) {
            if (TextUtils.isEmpty((CharSequence)id2) || TextUtils.isEmpty((CharSequence)name)) {
                throw new RuntimeException("groupId or name is null");
            }
            this.id = id2;
            this.name = name;
            this.portraitUri = portraitUri;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id2) {
            this.id = id2;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getPortraitUri() {
            return this.portraitUri;
        }

        public void setPortraitUri(String portraitUri) {
            this.portraitUri = portraitUri;
        }
    }

    public static class Discussion {
        private String id;
        private String name;
        private String creatorId;
        private boolean isOpen = true;
        private List<String> memberIdList;

        protected Discussion(NativeObject.DiscussionInfo info) {
            this.id = info.getDiscussionId();
            this.name = info.getDiscussionName();
            this.creatorId = info.getAdminId();
            this.memberIdList = Arrays.asList(info.getUserIds().split("\n"));
            Log.d((String)"Discussion", (String)("info.getInviteStatus():" + info.getInviteStatus()));
            this.isOpen = info.getInviteStatus() != 1;
        }

        public Discussion(String id2, String name, String creatorId, boolean isOpen, List<String> memberIdList) {
            this.id = id2;
            this.name = name;
            this.creatorId = creatorId;
            this.isOpen = isOpen;
            this.memberIdList = memberIdList;
        }

        public boolean isOpen() {
            return this.isOpen;
        }

        public void setOpen(boolean isOpen) {
            this.isOpen = isOpen;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id2) {
            this.id = id2;
        }

        public String getCreatorId() {
            return this.creatorId;
        }

        public void setCreatorId(String creatorId) {
            this.creatorId = creatorId;
        }

        public List<String> getMemberIdList() {
            return this.memberIdList;
        }

        public void setMemberIdList(List<String> memberIdList) {
            this.memberIdList = memberIdList;
        }
    }

    public static class Conversation {
        private ConversationType conversationType;
        private String targetId;
        private String conversationTitle;
        private int unreadMessageCount;
        private boolean isTop;
        private ReceivedStatus receivedStatus;
        private SentStatus sentStatus;
        private long receivedTime;
        private long sentTime;
        private String objectName;
        private String senderUserId;
        private String senderUserName;
        private int latestMessageId;
        private MessageContent latestMessage;
        private String draft;
        private ConversationNotificationStatus notificationStatus;

        public Conversation() {
        }

        protected Conversation(JSONObject jsonObj) {
            this.targetId = jsonObj.optString("target_id");
            this.latestMessageId = jsonObj.optInt("last_message_id");
            this.conversationTitle = jsonObj.optString("conversation_title");
            this.unreadMessageCount = jsonObj.optInt("unread_count");
            this.conversationType = ConversationType.setValue(jsonObj.optInt("conversation_category"));
            this.senderUserId = jsonObj.optString("sender_user_id");
            this.isTop = jsonObj.optInt("is_top") == 1;
            this.objectName = jsonObj.optString("object_name");
            if (this.latestMessageId == 0 || this.latestMessageId == -1) {
                this.latestMessage = null;
            } else {
                this.latestMessage = RongIMClient.getMessageContent(this.objectName, jsonObj.optString("content").getBytes());
                Constructor constructor = (Constructor)messageHandlerMap.get(this.objectName);
                try {
                    if (constructor != null) {
                        Message message = new Message();
                        message.setMessageId(this.latestMessageId);
                        message.setSenderUserId(this.senderUserId);
                        MessageTag.MessageHandler handler = (MessageTag.MessageHandler)constructor.newInstance(sContext);
                        handler.decodeMessage(message, this.latestMessage);
                    } else {
                        Log.e((String)RongIMClient.TAG, (String)"\u8be5\u6d88\u606f\u672a\u6ce8\u518c\uff0c\u8bf7\u8c03\u7528registerMessageType\u65b9\u6cd5\u6ce8\u518c\u3002");
                    }
                }
                catch (InstantiationException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            this.receivedStatus = new ReceivedStatus(jsonObj.optInt("read_status"), this.latestMessageId);
            this.receivedTime = jsonObj.optLong("receive_time");
            this.sentTime = jsonObj.optLong("send_time");
            this.sentStatus = SentStatus.setValue(jsonObj.optInt("send_status"));
            this.senderUserId = jsonObj.optString("sender_user_id");
            this.senderUserName = jsonObj.optString("sender_user_name");
            this.draft = jsonObj.optString("draft_message");
            this.notificationStatus = jsonObj.optInt("block_push") == 100 ? ConversationNotificationStatus.DO_NOT_DISTURB : ConversationNotificationStatus.NOTIFY;
        }

        public ConversationType getConversationType() {
            return this.conversationType;
        }

        public void setConversationType(ConversationType conversationType) {
            this.conversationType = conversationType;
        }

        public String getTargetId() {
            return this.targetId;
        }

        public void setTargetId(String targetId) {
            this.targetId = targetId;
        }

        public String getConversationTitle() {
            return this.conversationTitle;
        }

        public void setConversationTitle(String conversationTitle) {
            this.conversationTitle = conversationTitle;
        }

        public int getUnreadMessageCount() {
            return this.unreadMessageCount;
        }

        public void setUnreadMessageCount(int unreadMessageCount) {
            this.unreadMessageCount = unreadMessageCount;
        }

        public boolean isTop() {
            return this.isTop;
        }

        public void setTop(boolean isTop) {
            this.isTop = isTop;
        }

        public ReceivedStatus getReceivedStatus() {
            return this.receivedStatus;
        }

        public void setReceivedStatus(ReceivedStatus receivedStatus) {
            this.receivedStatus = receivedStatus;
        }

        public SentStatus getSentStatus() {
            return this.sentStatus;
        }

        public void setSentStatus(SentStatus sentStatus) {
            this.sentStatus = sentStatus;
        }

        public long getReceivedTime() {
            return this.receivedTime;
        }

        public void setReceivedTime(long receivedTime) {
            this.receivedTime = receivedTime;
        }

        public long getSentTime() {
            return this.sentTime;
        }

        public void setSentTime(long sentTime) {
            this.sentTime = sentTime;
        }

        public String getDraft() {
            return this.draft;
        }

        public void setDraft(String draft) {
            this.draft = draft;
        }

        public String getObjectName() {
            return this.objectName;
        }

        public void setObjectName(String objectName) {
            this.objectName = objectName;
        }

        public int getLatestMessageId() {
            return this.latestMessageId;
        }

        public void setLatestMessageId(int latestMessageId) {
            this.latestMessageId = latestMessageId;
        }

        public MessageContent getLatestMessage() {
            return this.latestMessage;
        }

        public void setLatestMessage(MessageContent latestMessage) {
            this.latestMessage = latestMessage;
        }

        public String getSenderUserId() {
            return this.senderUserId;
        }

        public void setSenderUserId(String senderUserId) {
            this.senderUserId = senderUserId;
        }

        public String getSenderUserName() {
            return this.senderUserName;
        }

        public void setSenderUserName(String senderUserName) {
            this.senderUserName = senderUserName;
        }

        public ConversationNotificationStatus getNotificationStatus() {
            return this.notificationStatus;
        }

        public void setNotificationStatus(ConversationNotificationStatus notificationStatus) {
            this.notificationStatus = notificationStatus;
        }
    }

    public static class Message {
        private ConversationType conversationType;
        private String targetId;
        private int messageId;
        private MessageDirection messageDirection;
        private String senderUserId;
        private ReceivedStatus receivedStatus;
        private SentStatus sentStatus;
        private long receivedTime;
        private long sentTime;
        private String objectName;
        private MessageContent content;
        private String extra;

        public Message() {
        }

        protected Message(NativeObject.Message msg) {
            this.conversationType = ConversationType.setValue(msg.getConversationType());
            this.targetId = msg.getTargetId();
            this.messageId = msg.getMessageId();
            this.messageDirection = !msg.getMessageDirection() ? MessageDirection.SEND : MessageDirection.RECEIVE;
            this.senderUserId = msg.getSenderUserId();
            this.receivedStatus = new ReceivedStatus(msg.getReadStatus(), this.messageId);
            this.sentStatus = SentStatus.setValue(msg.getSentStatus());
            this.receivedTime = msg.getReceivedTime();
            this.sentTime = msg.getSentTime();
            this.objectName = msg.getObjectName();
            this.content = RongIMClient.getMessageContent(this.objectName, msg.getContent());
            if (this.content != null) {
                this.content.setPushContent(msg.getPushContent());
            }
            Constructor constructor = (Constructor)messageHandlerMap.get(this.objectName);
            try {
                if (constructor != null) {
                    MessageTag.MessageHandler handler = (MessageTag.MessageHandler)constructor.newInstance(sContext);
                    handler.decodeMessage(this, this.content);
                } else {
                    Log.e((String)RongIMClient.TAG, (String)"\u8be5\u6d88\u606f\u672a\u6ce8\u518c\uff0c\u8bf7\u8c03\u7528registerMessageType\u65b9\u6cd5\u6ce8\u518c\u3002");
                }
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            this.extra = msg.getExtra();
        }

        public ConversationType getConversationType() {
            return this.conversationType;
        }

        public void setConversationType(ConversationType conversationType) {
            this.conversationType = conversationType;
        }

        public String getTargetId() {
            return this.targetId;
        }

        public void setTargetId(String targetId) {
            this.targetId = targetId;
        }

        public int getMessageId() {
            return this.messageId;
        }

        public void setMessageId(int messageId) {
            this.messageId = messageId;
        }

        public MessageDirection getMessageDirection() {
            return this.messageDirection;
        }

        public void setMessageDirection(MessageDirection messageDirection) {
            this.messageDirection = messageDirection;
        }

        public ReceivedStatus getReceivedStatus() {
            return this.receivedStatus;
        }

        public void setReceivedStatus(ReceivedStatus receivedStatus) {
            this.receivedStatus = receivedStatus;
        }

        public SentStatus getSentStatus() {
            return this.sentStatus;
        }

        public void setSentStatus(SentStatus sentStatus) {
            this.sentStatus = sentStatus;
        }

        public long getReceivedTime() {
            return this.receivedTime;
        }

        public void setReceivedTime(long receivedTime) {
            this.receivedTime = receivedTime;
        }

        public long getSentTime() {
            return this.sentTime;
        }

        public void setSentTime(long sentTime) {
            this.sentTime = sentTime;
        }

        public String getObjectName() {
            return this.objectName;
        }

        public void setObjectName(String objectName) {
            this.objectName = objectName;
        }

        public MessageContent getContent() {
            return this.content;
        }

        public void setContent(MessageContent content) {
            this.content = content;
        }

        public String getExtra() {
            return this.extra;
        }

        public void setExtra(String extra) {
            this.extra = extra;
        }

        public String getSenderUserId() {
            return this.senderUserId;
        }

        public void setSenderUserId(String senderUserId) {
            this.senderUserId = senderUserId;
        }
    }

    public static class UserInfo
    implements Parcelable {
        private String userId;
        private String name;
        private String portraitUri;
        public static final Parcelable.Creator<UserInfo> CREATOR = new Parcelable.Creator<UserInfo>(){

            public UserInfo createFromParcel(Parcel source) {
                return new UserInfo(source);
            }

            public UserInfo[] newArray(int size) {
                return new UserInfo[size];
            }
        };

        public UserInfo(Parcel in) {
            this.setUserId(in.readString());
            this.setName(in.readString());
            this.setPortraitUri(in.readString());
        }

        public UserInfo(String userId, String name, String portraitUri) {
            if (TextUtils.isEmpty((CharSequence)userId)) {
                throw new NullPointerException("userId is null");
            }
            this.userId = userId;
            this.name = name;
            this.portraitUri = portraitUri;
        }

        public String getUserId() {
            if (TextUtils.isEmpty((CharSequence)this.userId)) {
                throw new NullPointerException("userId  is null");
            }
            return this.userId;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getPortraitUri() {
            return this.portraitUri;
        }

        public void setPortraitUri(String portraitUri) {
            this.portraitUri = portraitUri;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            if (this.userId != null) {
                dest.writeString(this.userId);
            } else {
                dest.writeString("");
            }
            if (this.name != null) {
                dest.writeString(this.name);
            } else {
                dest.writeString("");
            }
            if (this.portraitUri != null) {
                dest.writeString(this.portraitUri);
            } else {
                dest.writeString("");
            }
        }
    }

    public static class ReceivedStatus {
        private static final int READ = 1;
        private static final int LISTENED = 2;
        private static final int DOWNLOADED = 4;
        private int flag = 0;
        private boolean isRead = false;
        private boolean isListened = false;
        private boolean isDownload = false;
        private int messageId = 0;

        public ReceivedStatus(int flag, int messageId) {
            this.flag = flag;
            this.isRead = (flag & 1) == 1;
            this.isListened = (flag & 2) == 2;
            this.isDownload = (flag & 4) == 4;
            this.messageId = messageId;
        }

        public int getFlag() {
            return this.flag;
        }

        public boolean isRead() {
            return this.isRead;
        }

        public boolean isListened() {
            return this.isListened;
        }

        public void setListened() {
            this.flag |= 2;
            this.isListened = true;
            nativeObj.SetReadStatus(this.messageId, this.flag);
        }

        public boolean isDownload() {
            return this.isDownload;
        }

        public void setDownload() {
            this.flag |= 4;
            this.isDownload = true;
            nativeObj.SetReadStatus(this.messageId, this.flag);
        }
    }

    public static enum SentStatus {
        SENDING(10),
        FAILED(20),
        SENT(30),
        RECEIVED(40),
        READ(50),
        DESTROYED(60);

        private int value = 1;

        private SentStatus(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static SentStatus setValue(int code) {
            for (SentStatus c : SentStatus.values()) {
                if (code != c.getValue()) continue;
                return c;
            }
            return SENDING;
        }
    }

    public static enum MessageDirection {
        SEND(1),
        RECEIVE(2);

        private int value = 1;

        private MessageDirection(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static MessageDirection setValue(int code) {
            for (MessageDirection c : MessageDirection.values()) {
                if (code != c.getValue()) continue;
                return c;
            }
            return SEND;
        }
    }

    public static enum MediaType {
        IMAGE(1),
        AUDIO(2),
        VIDEO(3),
        FILE(100);

        private int value = 1;

        private MediaType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static MediaType setValue(int code) {
            for (MediaType c : MediaType.values()) {
                if (code != c.getValue()) continue;
                return c;
            }
            return IMAGE;
        }
    }

    public static enum ConversationType {
        PRIVATE(1, "private"),
        DISCUSSION(2, "discussion"),
        GROUP(3, "group"),
        CHATROOM(4, "chatroom"),
        CUSTOMER_SERVICE(5, "customer_service"),
        SYSTEM(6, "system");

        private int value = 1;
        private String name = "";

        private ConversationType(int value, String name) {
            this.value = value;
            this.name = name;
        }

        public int getValue() {
            return this.value;
        }

        public String getName() {
            return this.name;
        }

        public static ConversationType setValue(int code) {
            for (ConversationType c : ConversationType.values()) {
                if (code != c.getValue()) continue;
                return c;
            }
            return PRIVATE;
        }
    }

    public static class Options {
        private boolean enableDebug;

        public boolean isEnableDebug() {
            return this.enableDebug;
        }

        public void setEnableDebug(boolean enableDebug) {
            this.enableDebug = enableDebug;
        }
    }
}

