/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib;

import org.json.JSONObject;

class NativeObject {
    NativeObject() {
        this.setJNIEnv(this);
    }

    protected native void setJNIEnv(NativeObject var1);

    protected native int InitClient(String var1, String var2, String var3, String var4, String var5);

    protected native void RegisterMessageType(String var1, int var2);

    protected native void Connect(String var1, ConnectAckCallback var2);

    protected native void Disconnect(int var1);

    protected native void SendFileWithUrl(String var1, int var2, int var3, byte[] var4, int var5, ProgressCallback var6);

    protected native void DownFileWithUrl(String var1, int var2, int var3, String var4, ProgressCallback var5);

    protected native byte[] GetPagedMessage(String var1, int var2, int var3, int var4);

    protected native byte[] GetHistoryMessages(String var1, int var2, String var3, int var4, int var5);

    protected native boolean DeleteMessages(int[] var1);

    protected native boolean ClearMessages(int var1, String var2);

    protected native boolean ClearUnread(int var1, String var2);

    protected native boolean SetMessageExtra(int var1, String var2);

    protected native boolean RemoveConversation(int var1, String var2);

    protected native boolean SetTextMessageDraft(int var1, String var2, String var3);

    protected native boolean SetMessageContent(int var1, byte[] var2);

    protected native String GetTextMessageDraft(int var1, String var2);

    protected native byte[] GetRecentConversation();

    protected native boolean SetIsTop(int var1, String var2, boolean var3);

    protected native int GetTotalUnreadCount();

    protected native long GetDeltaTime();

    protected native void CreateInviteDiscussion(String var1, String[] var2, CreateDiscussionCallback var3);

    protected native void InviteMemberToDiscussion(String var1, String[] var2, PublishAckListener var3);

    protected native void RemoveMemberFromDiscussion(String var1, String var2, PublishAckListener var3);

    protected native void QuitDiscussion(String var1, PublishAckListener var2);

    protected native int SaveMessage(String var1, int var2, String var3, String var4, byte[] var5, byte[] var6);

    protected native void SendMessage(String var1, int var2, int var3, String var4, byte[] var5, byte[] var6, int var7, PublishAckListener var8);

    protected native void GetUserInfo(String var1, UserInfoOutputListener var2);

    protected native void SetMessageListener(ReceiveMessageListener var1);

    protected native boolean SetReadStatus(int var1, int var2);

    protected native boolean SetSendStatus(int var1, int var2);

    protected native void SetWakeupQueryListener(WakeupQueryListener var1);

    protected native void EnvironmentChangeNotify(int var1, byte[] var2, int var3, EnvironmentChangeNotifyListener var4);

    protected native void GetDiscussionInfo(String var1, boolean var2, DiscussionInfoListener var3);

    protected native void SetExceptionListener(ExceptionListener var1);

    protected native void RenameDiscussion(String var1, String var2, PublishAckListener var3);

    protected native byte[] GetConversation(String var1, int var2);

    protected native void SetBlockPush(String var1, int var2, boolean var3, BizAckListener var4);

    protected native void GetBlockPush(String var1, int var2, boolean var3, BizAckListener var4);

    protected native void SetInviteStatus(String var1, int var2, PublishAckListener var3);

    protected native int GetUnreadCount(String var1, int var2);

    protected native byte[] GetConversationList(int[] var1);

    protected native void SyncGroups(String[] var1, String[] var2, PublishAckListener var3);

    protected native void JoinGroup(String var1, String var2, PublishAckListener var3);

    protected native void QuitGroup(String var1, String var2, PublishAckListener var3);

    protected native int GetCateUnreadCount(int[] var1);

    protected native void JoinChatRoom(String var1, int var2, int var3, PublishAckListener var4);

    protected native void QuitChatRoom(String var1, int var2, PublishAckListener var3);

    protected native boolean ClearConversations(int[] var1);

    protected native void AddToBlacklist(String var1, PublishAckListener var2);

    protected native void RemoveFromBlacklist(String var1, PublishAckListener var2);

    protected native void GetBlacklistStatus(String var1, BizAckListener var2);

    protected native void GetBlacklist(SetBlacklistListener var1);

    protected native void SetDeviceInfo(String var1, String var2, String var3, String var4, String var5);

    static {
        System.loadLibrary("RongIMLib");
    }

    public static class DiscussionInfo {
        private String discussionId;
        private String discussionName;
        private String adminId;
        private String userIds;
        private int inviteStatus;

        public String getDiscussionId() {
            return this.discussionId;
        }

        public void setDiscussionId(String discussionId) {
            this.discussionId = discussionId;
        }

        public String getDiscussionName() {
            return this.discussionName;
        }

        public void setDiscussionName(byte[] data) {
            this.discussionName = new String(data);
        }

        public String getAdminId() {
            return this.adminId;
        }

        public void setAdminId(String adminId) {
            this.adminId = adminId;
        }

        public String getUserIds() {
            return this.userIds;
        }

        public void setUserIds(String userIds) {
            this.userIds = userIds;
        }

        public int getInviteStatus() {
            return this.inviteStatus;
        }

        public void setInviteStatus(int inviteStatus) {
            this.inviteStatus = inviteStatus;
        }
    }

    public static class Message {
        private int conversationType;
        private String targetId;
        private int messageId;
        private boolean messageDirection;
        private String senderUserId;
        private int readStatus;
        private int sentStatus;
        private long receivedTime;
        private long sentTime;
        private String objectName;
        private byte[] content;
        private String extra;
        private String pushContent;

        public Message(JSONObject jsonObj) {
            this.conversationType = jsonObj.optInt("conversation_category");
            this.targetId = jsonObj.optString("target_id");
            this.messageId = jsonObj.optInt("id");
            this.messageDirection = jsonObj.optBoolean("message_direction");
            this.senderUserId = jsonObj.optString("sender_user_id");
            this.readStatus = jsonObj.optInt("read_status");
            this.sentStatus = jsonObj.optInt("send_status");
            this.receivedTime = jsonObj.optLong("receive_time");
            this.sentTime = jsonObj.optLong("send_time");
            this.objectName = jsonObj.optString("object_name");
            this.content = jsonObj.optString("content").getBytes();
            this.extra = jsonObj.optString("extra");
            this.pushContent = jsonObj.optString("push");
        }

        public Message() {
        }

        public String getPushContent() {
            return this.pushContent;
        }

        public void setPushContent(String pushContent) {
            this.pushContent = pushContent;
        }

        public int getConversationType() {
            return this.conversationType;
        }

        public void setConversationType(int conversationType) {
            this.conversationType = conversationType;
        }

        public String getTargetId() {
            return this.targetId;
        }

        public void setTargetId(String targetId) {
            this.targetId = targetId;
        }

        public int getMessageId() {
            return this.messageId;
        }

        public void setMessageId(int messageId) {
            this.messageId = messageId;
        }

        public boolean getMessageDirection() {
            return this.messageDirection;
        }

        public void setMessageDirection(boolean messageDirection) {
            this.messageDirection = messageDirection;
        }

        public int getReadStatus() {
            return this.readStatus;
        }

        public void setReadStatus(int readStatus) {
            this.readStatus = readStatus;
        }

        public int getSentStatus() {
            return this.sentStatus;
        }

        public void setSentStatus(int sentStatus) {
            this.sentStatus = sentStatus;
        }

        public long getReceivedTime() {
            return this.receivedTime;
        }

        public void setReceivedTime(long receivedTime) {
            this.receivedTime = receivedTime;
        }

        public long getSentTime() {
            return this.sentTime;
        }

        public void setSentTime(long sentTime) {
            this.sentTime = sentTime;
        }

        public String getObjectName() {
            return this.objectName;
        }

        public void setObjectName(String objectName) {
            this.objectName = objectName;
        }

        public byte[] getContent() {
            return this.content;
        }

        public void setContent(byte[] content) {
            this.content = content;
        }

        public String getExtra() {
            return this.extra;
        }

        public void setExtra(String extra) {
            this.extra = extra;
        }

        public String getSenderUserId() {
            return this.senderUserId;
        }

        public void setSenderUserId(String senderUserId) {
            this.senderUserId = senderUserId;
        }
    }

    public static interface SetBlacklistListener {
        public void OnSuccess(String var1);

        public void OnError(int var1);
    }

    public static interface BizAckListener {
        public void operationComplete(int var1, int var2);
    }

    public static interface ExceptionListener {
        public void onError(int var1, String var2);
    }

    public static interface DiscussionInfoListener {
        public void onReceived(DiscussionInfo var1);

        public void OnError(int var1);
    }

    public static abstract class ReceiveMessageListener {
        public abstract void onReceived(Message var1, int var2);

        protected Message getNewMessage() {
            return new Message();
        }
    }

    public static interface EnvironmentChangeNotifyListener {
        public void Complete(int var1, String var2);
    }

    public static interface WakeupQueryListener {
        public void QueryWakeup(int var1);

        public void ReleaseWakup();
    }

    public static interface UserInfoOutputListener {
        public void onReceiveUserInfo(String var1, byte[] var2, String var3);

        public void OnError(int var1);
    }

    public static interface CreateDiscussionCallback {
        public void OnSuccess(String var1);

        public void OnError(int var1);
    }

    public static interface PublishAckListener {
        public void operationComplete(int var1);
    }

    public static interface ProgressCallback {
        public void OnProgress(int var1);

        public void OnComplete(String var1);

        public void OnError(int var1, String var2);
    }

    public static interface ConnectAckCallback {
        public void operationComplete(int var1, String var2);
    }
}

