/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib;

import android.content.Context;
import io.rong.imlib.RongIMClient;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Target(value={ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface MessageTag {
    public static final int NONE = 0;
    public static final int ISPERSISTED = 1;
    public static final int ISCOUNTED = 2;

    public String value();

    public int flag() default 0;

    public Class<? extends MessageHandler> messageHandler() default MessageHandler.NullMessageHandler.class;

    public static abstract class MessageHandler<T extends RongIMClient.MessageContent> {
        private RongIMClient client;
        private RongIMClient.Message message;
        private RongIMClient.SendMessageCallback callback;
        private Context context;

        public MessageHandler(Context context) {
            this.context = context;
        }

        void decodeMessage(RongIMClient.Message message, T messageContent) {
            this.afterDecodeMessage(message, messageContent);
        }

        boolean encodeMessage(RongIMClient.Message message, T messageContent) {
            return this.beforeEncodeMessage(message, messageContent);
        }

        protected Context getContext() {
            return this.context;
        }

        void handlersendMessage(RongIMClient client, RongIMClient.Message message, T messageContent, RongIMClient.SendMessageCallback callback) {
            this.client = client;
            this.message = message;
            this.callback = callback;
            if (!this.sendMessage(client, message, messageContent, callback)) {
                client.sendMessage(message, this, callback);
            }
        }

        public void flush() {
            if (this.client == null || this.callback == null || this.message == null) {
                throw new RuntimeException("not send yet!");
            }
            this.client.sendMessage(this.message, this, this.callback);
        }

        public abstract void afterDecodeMessage(RongIMClient.Message var1, T var2);

        public abstract boolean beforeEncodeMessage(RongIMClient.Message var1, T var2);

        public abstract boolean sendMessage(RongIMClient var1, RongIMClient.Message var2, T var3, RongIMClient.SendMessageCallback var4);

        static class NullMessageHandler
        extends MessageHandler<RongIMClient.MessageContent> {
            public NullMessageHandler(Context context) {
                super(context);
            }

            @Override
            public void afterDecodeMessage(RongIMClient.Message message, RongIMClient.MessageContent messageContent) {
            }

            @Override
            public boolean beforeEncodeMessage(RongIMClient.Message message, RongIMClient.MessageContent messageContent) {
                return false;
            }

            @Override
            public boolean sendMessage(RongIMClient client, RongIMClient.Message message, RongIMClient.MessageContent messageContent, RongIMClient.SendMessageCallback callback) {
                return false;
            }
        }
    }
}

