/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.view.gif;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.widget.ImageView;
import io.rong.imkit.view.gif.GifAction;
import io.rong.imkit.view.gif.GifDecoder;
import io.rong.imkit.view.gif.GifFrame;
import java.io.InputStream;
import java.lang.ref.WeakReference;

public class GifView
extends ImageView
implements GifAction {
    private GifDecoder mGifDecoder = null;
    private Bitmap mCurrentImage = null;
    private int mResId = -1;
    private int mShowWidth = -1;
    private Rect mRect = null;
    private final String fNameSpace = "http://schemas.android.com/apk/res/android";
    private GifImageType mAnimationType = GifImageType.SYNC_DECODER;
    private int mStatus = 0;
    Paint mPaint = new Paint();
    private final AnimationHandler mGifHandler = new AnimationHandler();
    private final Handler redrawHandler = new Handler(){

        public void handleMessage(Message msg) {
            GifView.this.invalidate();
        }
    };

    public GifView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public GifView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        String value = attrs.getAttributeValue("http://schemas.android.com/apk/res/android", "src");
        if (value == null || value.length() < 1) {
            return;
        }
        value = value.substring(1);
        this.mResId = Integer.parseInt(value);
        this.setGifImage(this.mResId);
    }

    private void setGifDecoderImage(byte[] gif) {
        this.freeDecoder(this.mGifDecoder);
        this.mGifDecoder = new GifDecoder(gif, (GifAction)this);
        this.mGifDecoder.start();
    }

    private void setGifDecoderImage(InputStream is) {
        this.freeDecoder(this.mGifDecoder);
        this.mGifDecoder = new GifDecoder(is, (GifAction)this);
        this.mAnimationType = GifImageType.SYNC_DECODER;
        this.mStatus = 0;
        this.mGifDecoder.start();
    }

    private void freeDecoder(GifDecoder gifDecoder) {
        if (gifDecoder != null) {
            gifDecoder.free();
            gifDecoder = null;
        }
    }

    public void setGifImage(byte[] gif) {
        this.setGifDecoderImage(gif);
    }

    public void setGifImage(InputStream is) {
        this.setGifDecoderImage(is);
    }

    public void setGifImage(int resId) {
        Resources r = this.getResources();
        InputStream is = r.openRawResource(resId);
        this.setGifDecoderImage(is);
    }

    protected void onDraw(Canvas canvas) {
        if (this.mGifDecoder == null) {
            return;
        }
        if (this.mCurrentImage == null) {
            this.mCurrentImage = this.mGifDecoder.getImage();
        }
        if (this.mCurrentImage == null) {
            return;
        }
        int saveCount = canvas.getSaveCount();
        canvas.save();
        canvas.translate((float)this.getPaddingLeft(), (float)this.getPaddingTop());
        this.mPaint.setAntiAlias(true);
        if (this.mShowWidth == -1) {
            canvas.drawBitmap(this.mCurrentImage, 0.0f, 0.0f, this.mPaint);
        } else {
            canvas.drawBitmap(this.mCurrentImage, null, this.mRect, this.mPaint);
        }
        canvas.restoreToCount(saveCount);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int h;
        int w;
        int pleft = this.getPaddingLeft();
        int pright = this.getPaddingRight();
        int ptop = this.getPaddingTop();
        int pbottom = this.getPaddingBottom();
        if (this.mGifDecoder == null) {
            w = 1;
            h = 1;
        } else {
            w = this.mGifDecoder.width;
            h = this.mGifDecoder.height;
        }
        w += pleft + pright;
        h += ptop + pbottom;
        w = Math.max(w, this.getSuggestedMinimumWidth());
        h = Math.max(h, this.getSuggestedMinimumHeight());
        int widthSize = GifView.resolveSize((int)w, (int)widthMeasureSpec);
        int heightSize = GifView.resolveSize((int)h, (int)heightMeasureSpec);
        this.setMeasuredDimension(widthSize, heightSize);
    }

    public void showCover() {
        int count;
        this.mAnimationType = GifImageType.COVER;
        if (this.mGifDecoder != null && (count = this.mGifDecoder.getFrameCount()) > 0) {
            Bitmap currentImage;
            this.stopAnimation();
            this.mCurrentImage = currentImage = this.mGifDecoder.getImage();
            this.invalidate();
            this.destory();
        }
    }

    public void setGifImageType(GifImageType type) {
        if (this.mGifDecoder == null) {
            this.mAnimationType = type;
        }
    }

    public void setShowDimension(int width, int height) {
        if (width > 0 && height > 0) {
            this.mShowWidth = width;
            this.mRect = new Rect();
            this.mRect.left = 0;
            this.mRect.top = 0;
            this.mRect.right = width;
            this.mRect.bottom = height;
        }
    }

    @Override
    public void parseOk(boolean parseStatus, int frameIndex) {
        if (parseStatus && this.mGifDecoder != null) {
            switch (this.mAnimationType) {
                case COVER: {
                    if (frameIndex == 1) {
                        this.mCurrentImage = this.mGifDecoder.getImage();
                        this.reDraw();
                    }
                    this.destory();
                    break;
                }
                case SYNC_DECODER: {
                    if (this.mStatus != 0) break;
                    this.mGifHandler.startAnimation(this);
                    break;
                }
            }
        }
    }

    private void reDraw() {
        if (this.redrawHandler != null) {
            Message msg = this.redrawHandler.obtainMessage();
            this.redrawHandler.sendMessage(msg);
        }
    }

    public void stopAnimation() {
        this.mGifHandler.stopAnimation(this);
    }

    public void destory() {
        this.mGifHandler.destory(this);
    }

    public void startAnimation() {
        if (this.mStatus == 2) {
            return;
        }
        if (this.mStatus == 3) {
            this.mGifHandler.startAnimation(this);
        } else if (this.mResId != -1) {
            this.setGifImage(this.mResId);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.destory();
    }

    private static class AnimationHandler
    extends Handler {
        private static final int fAnimation = 2;
        private static final int fStop = 3;
        private static final int fDestory = 4;
        private WeakReference<GifView> mGifViewReference;

        private AnimationHandler() {
        }

        public void handleMessage(Message msg) {
            int what = msg.what;
            switch (what) {
                case 2: {
                    this.executeAnimation();
                }
            }
        }

        private void executeAnimation() {
            GifView gv = (GifView)this.mGifViewReference.get();
            if (gv != null && gv.mStatus == 2) {
                gv.invalidate();
                GifFrame frame = gv.mGifDecoder.next();
                gv.mCurrentImage = frame.image;
                long sp = frame.delay;
                this.sendEmptyMessageDelayed(2, sp);
            }
        }

        public void startAnimation(GifView gifView) {
            if (gifView.mStatus != 2) {
                gifView.mStatus = 2;
                this.mGifViewReference = new WeakReference<GifView>(gifView);
                this.sendEmptyMessage(2);
            }
        }

        public void stopAnimation(GifView gifView) {
            gifView.mStatus = 3;
            this.removeMessages(2);
        }

        public void destory(GifView gifView) {
            gifView.mStatus = 4;
            gifView.mGifDecoder.free();
            if (this.mGifViewReference != null) {
                this.mGifViewReference.clear();
            }
        }
    }

    public static enum GifImageType {
        WAIT_FINISH(0),
        SYNC_DECODER(1),
        COVER(2);

        final int nativeInt;

        private GifImageType(int i) {
            this.nativeInt = i;
        }
    }
}

