/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.view.gif;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.View;
import io.rong.imkit.view.AnimationTextView;
import io.rong.imkit.view.gif.GifAction;
import io.rong.imkit.view.gif.GifDecoder;
import io.rong.imkit.view.gif.GifFrame;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.ArrayList;

public class GifDrawable
extends AnimationDrawable
implements GifAction {
    private static final String TAG = "GifDrawable";
    private int mCurrentIndex = 0;
    private GifDecoder mDecoder;
    private final ArrayList<SoftReference<AnimationTextView>> cachedAnimationViews;
    public String mFilePath;
    public String mEmotionCode;
    private boolean onStarted = false;
    private final Context mContext;
    private final Handler handler = new Handler(){

        public void handleMessage(Message msg) {
            GifFrame frame = GifDrawable.this.mDecoder.next();
            if (frame == null) {
                return;
            }
            Bitmap image = frame.image;
            BitmapDrawable drawable2 = new BitmapDrawable(GifDrawable.this.mContext.getResources(), image);
            drawable2.setFilterBitmap(true);
            GifDrawable.this.addFrame((Drawable)drawable2, frame.delay);
            GifDrawable.this.setVisible(true, false);
        }
    };

    public GifDrawable(Context context, String emotionCode, String path) {
        this.mContext = context;
        this.mFilePath = path;
        this.mEmotionCode = emotionCode;
        this.cachedAnimationViews = new ArrayList();
        try {
            InputStream is = path.contains("Emotions") ? new FileInputStream(path) : context.getAssets().open(path);
            this.mDecoder = new GifDecoder(is, (GifAction)this);
            Bitmap image = this.mDecoder.getFirstFrame().image;
            BitmapDrawable drawable2 = new BitmapDrawable(context.getResources(), image);
            this.addFrame((Drawable)drawable2, this.mDecoder.getFirstFrame().delay);
            this.freeDecoder(this.mDecoder);
            is = path.contains("Emotions") ? new FileInputStream(path) : context.getAssets().open(path);
            this.mDecoder = new GifDecoder(is, (GifAction)this);
            this.mDecoder.start();
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)("GifDrawable constructor has Exception:" + e.getMessage()));
        }
    }

    public void addAnimationView(AnimationTextView animationView) {
        try {
            for (SoftReference<AnimationTextView> reference : this.cachedAnimationViews) {
                if (reference.get() == null || !((Object)((Object)reference.get())).equals((Object)animationView)) continue;
                return;
            }
            this.cachedAnimationViews.add(new SoftReference<AnimationTextView>(animationView));
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)("addAnimationView has excetion:" + e.getMessage()));
        }
    }

    public ArrayList<SoftReference<AnimationTextView>> getAnimationView() {
        return this.cachedAnimationViews;
    }

    public void removeAnimationView(View view) {
        this.cachedAnimationViews.remove(view);
    }

    public void ChangeToNextFrame() {
        int number = this.getNumberOfFrames();
        if (this.mCurrentIndex >= number) {
            this.mCurrentIndex = 0;
        }
        this.selectDrawable(this.mCurrentIndex++);
    }

    private void freeDecoder(GifDecoder gifDecoder) {
        if (gifDecoder != null) {
            gifDecoder.free();
            gifDecoder = null;
        }
    }

    @Override
    public void parseOk(boolean parseStatus, int frameIndex) {
        if (parseStatus && frameIndex != 1 && !this.mDecoder.isGetFirst()) {
            this.handler.sendEmptyMessage(frameIndex);
        }
    }

    public boolean isOnStarted() {
        return this.onStarted;
    }

    public void setOnStarted(boolean onStarted) {
        this.onStarted = onStarted;
    }
}

