/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.view.gif;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import io.rong.imkit.Res;

public class EmotionParser {
    private int[] defaultFrameResIds;
    private String[] defaultCodeArray;
    private Context mContext;
    private static EmotionParser mInstance;
    private int size;

    private EmotionParser(Context context) {
        this.mContext = context;
        TypedArray resEmotionIds = this.mContext.getResources().obtainTypedArray(Res.getInstance(context).array("rc_emoji_array"));
        this.defaultCodeArray = this.mContext.getResources().getStringArray(Res.getInstance(context).array("rc_emoji_code"));
        float d = this.mContext.getResources().getDisplayMetrics().density;
        this.size = (int)(d * 20.0f);
        int length = this.defaultCodeArray.length;
        this.defaultFrameResIds = new int[length];
        for (int i = 0; i < length; ++i) {
            this.defaultFrameResIds[i] = resEmotionIds.getResourceId(i, 0);
        }
    }

    public static EmotionParser getInstance(Context context) {
        if (mInstance == null) {
            mInstance = new EmotionParser(context);
        }
        return mInstance;
    }

    public Drawable getSmileDrawable(String smileCode) {
        Drawable drawable2 = null;
        int resId = this.getSmileResId(smileCode);
        if (resId != 0) {
            drawable2 = this.mContext.getResources().getDrawable(resId);
            drawable2.setBounds(0, 0, this.size, this.size);
        }
        return drawable2;
    }

    private int getSmileResId(String smileCode) {
        int length = this.defaultCodeArray.length;
        for (int i = 0; i < length; ++i) {
            if (!smileCode.equals(this.defaultCodeArray[i])) continue;
            return this.defaultFrameResIds[i];
        }
        return 0;
    }

    public String getSmileCode(int resId) {
        for (int i = 0; i < this.defaultFrameResIds.length; ++i) {
            if (resId != this.defaultFrameResIds[i]) continue;
            return this.defaultCodeArray[i];
        }
        return "";
    }

    public int[] getSmileResIds() {
        int[] res = new int[this.defaultFrameResIds.length];
        System.arraycopy(this.defaultFrameResIds, 0, res, 0, this.defaultFrameResIds.length);
        return res;
    }

    public void onDestroy() {
        this.size = 0;
        this.mContext = null;
        this.defaultFrameResIds = null;
        this.defaultCodeArray = null;
    }

    public static void setEmptyInstance() {
        mInstance = null;
    }
}

