/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.view;

import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import io.rong.imkit.Res;
import io.rong.imkit.common.IVoiceHandler;
import io.rong.imkit.view.CoverFrameLayout;
import java.io.File;

public class VoiceCoverView
extends FrameLayout
implements Handler.Callback,
CoverFrameLayout.CoverHandler {
    public static final int STATUS_REC = 131072;
    public static final int STATUS_CANCEL = 131073;
    private final int MSG_SEC = 1;
    private final int MSG_CANCEL = 2;
    private final int MSG_SAMPLING = 3;
    private final int MSG_READY = 4;
    private ImageView mIcon;
    private TextView mText;
    private TextView mMessage;
    private Handler mHandler;
    private int mStatus;
    private boolean mTrigger = false;
    private IVoiceHandler mVoiceHandler;
    long mVoiceLength;
    Uri mLastVoiceUri;

    public VoiceCoverView(Context context, AttributeSet attrs) {
        super(context, attrs);
        VoiceCoverView.inflate((Context)context, (int)Res.getInstance(context).layout("rc_voice_cover"), (ViewGroup)this);
        this.mIcon = (ImageView)this.findViewById(16908294);
        this.mText = (TextView)this.findViewById(16908308);
        this.mMessage = (TextView)this.findViewById(16908299);
        this.mHandler = new Handler((Handler.Callback)this);
    }

    public void setVoiceHandler(IVoiceHandler voiceHandler) {
        this.mVoiceHandler = voiceHandler;
    }

    @Override
    public void setStatus(int status) {
        if (this.mStatus == status) {
            return;
        }
        switch (status) {
            case 65535: {
                this.mText.setVisibility(8);
                this.setVisibility(8);
                break;
            }
            case 131071: {
                this.mHandler.sendEmptyMessageDelayed(4, 300L);
                break;
            }
            case 196607: {
                this.mHandler.removeMessages(4);
                this.mHandler.removeMessages(1);
                this.mHandler.removeMessages(2);
                this.mVoiceLength = SystemClock.elapsedRealtime() - this.mVoiceLength;
                this.mLastVoiceUri = this.mStatus == 131072 ? this.mVoiceHandler.stopRec(true) : this.mVoiceHandler.stopRec(false);
                this.mHandler.removeMessages(3);
                this.setVisibility(8);
                break;
            }
            case 131072: {
                this.mMessage.setText(Res.getInstance(this.getContext()).string("voice_dialog_collect"));
                this.mIcon.setImageResource(Res.getInstance(this.getContext()).drawable("rc_volume_zero"));
                this.mMessage.setBackgroundColor(this.getContext().getResources().getColor(17170445));
                break;
            }
            case 131073: {
                this.mMessage.setText(Res.getInstance(this.getContext()).string("voice_dialog_cancel_send"));
                this.mIcon.setImageResource(Res.getInstance(this.getContext()).drawable("rc_cancel_send_voice"));
                this.mMessage.setBackgroundColor(this.getResources().getColor(Res.getInstance(this.getContext()).color("rc_text_color_warning")));
            }
        }
        this.mStatus = status;
    }

    @Override
    public int getStatus() {
        return this.mStatus;
    }

    public Uri getLastVoiceUri() {
        return this.mLastVoiceUri;
    }

    public long getLastVoiceLength() {
        return this.mVoiceLength;
    }

    public void removeLastVoiceUri() {
        File voiceFile;
        if (this.mLastVoiceUri != null && (voiceFile = new File(this.mLastVoiceUri.getPath())).exists()) {
            voiceFile.delete();
        }
    }

    public boolean handleMessage(Message msg) {
        block0 : switch (msg.what) {
            case 1: {
                this.mText.setVisibility(0);
                this.mText.setText((CharSequence)(msg.arg1 + "s"));
                if (msg.arg1 > 0) {
                    this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(1, --msg.arg1, 0), 1000L);
                    break;
                }
                this.mHandler.sendEmptyMessage(2);
                break;
            }
            case 2: {
                this.setStatus(196607);
                break;
            }
            case 3: {
                this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(3), 150L);
                if (this.mStatus == 131073) break;
                int db = this.mVoiceHandler.getCurrentDb();
                switch (db / 5) {
                    case 0: {
                        this.mIcon.setImageResource(Res.getInstance(this.getContext()).drawable("rc_volume_zero"));
                        break block0;
                    }
                    case 1: {
                        this.mIcon.setImageResource(Res.getInstance(this.getContext()).drawable("rc_volume_one"));
                        break block0;
                    }
                    case 2: {
                        this.mIcon.setImageResource(Res.getInstance(this.getContext()).drawable("rc_volume_two"));
                        break block0;
                    }
                    case 3: {
                        this.mIcon.setImageResource(Res.getInstance(this.getContext()).drawable("rc_volume_three"));
                        break block0;
                    }
                    case 4: {
                        this.mIcon.setImageResource(Res.getInstance(this.getContext()).drawable("rc_volume_four"));
                    }
                }
                this.mIcon.setImageResource(Res.getInstance(this.getContext()).drawable("rc_volume_four"));
                break;
            }
            case 4: {
                this.setVisibility(0);
                this.mStatus = 0;
                this.mVoiceLength = SystemClock.elapsedRealtime();
                this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(1, 10, 0), 50000L);
                this.mLastVoiceUri = null;
                this.mVoiceHandler.startRec();
                this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(3), 150L);
                this.mIcon.setImageResource(Res.getInstance(this.getContext()).drawable("rc_volume_zero"));
                this.mMessage.setText(Res.getInstance(this.getContext()).string("voice_dialog_collect"));
                this.mMessage.setBackgroundColor(this.getContext().getResources().getColor(17170445));
                this.mText.setVisibility(8);
                break;
            }
        }
        return true;
    }
}

