/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import io.rong.imkit.Res;
import io.rong.imkit.view.SwitchItemView;

public class SwitchGroup
extends ViewGroup {
    private int mPinnedViewResId;
    int mOrientation;
    View mPinnedView;
    ItemHander mItemHander;
    Rect mSwitchRect;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;

    public SwitchGroup(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, Res.getInstance(context).styleables("SwitchGroup"));
        this.mPinnedViewResId = a.getResourceId(Res.getInstance(context).styleable("SwitchGroup_pinned_view"), 0);
        this.mOrientation = a.getInt(Res.getInstance(context).styleable("SwitchGroup_orientation"), 0);
        int itemResId = a.getResourceId(Res.getInstance(context).styleable("SwitchGroup_pinned_item"), 0);
        int itemArrayResId = a.getResourceId(Res.getInstance(context).styleable("SwitchGroup_pinned_item_array"), 0);
        a.recycle();
        this.mSwitchRect = new Rect();
        if (itemResId != 0 && itemArrayResId != 0) {
            String[] letters = this.getResources().getStringArray(itemArrayResId);
            int size = letters.length;
            for (int i = 0; i < size; ++i) {
                SwitchItemView switchItemView = (SwitchItemView)LayoutInflater.from((Context)this.getContext()).inflate(itemResId, null);
                switchItemView.setText(letters[i]);
                this.addView((View)switchItemView);
            }
            letters = null;
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mPinnedView == null && this.mPinnedViewResId != 0) {
            View parentView = LayoutInflater.from((Context)this.getContext()).inflate(this.mPinnedViewResId, (ViewGroup)this.getParent(), true);
            this.mPinnedView = parentView.findViewById(16908310);
        }
    }

    public ItemHander getItemHander() {
        return this.mItemHander;
    }

    public void setItemHander(ItemHander itemHander) {
        this.mItemHander = itemHander;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int cellHeight;
        int cellWidth;
        int count = this.getChildCount();
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (this.mOrientation == 0) {
            cellWidth = (width - this.getPaddingLeft() - this.getPaddingRight()) / count;
            cellHeight = height - this.getPaddingTop() - this.getPaddingBottom();
        } else {
            cellWidth = width - this.getPaddingLeft() - this.getPaddingRight();
            cellHeight = (height - this.getPaddingTop() - this.getPaddingBottom()) / count;
        }
        int childWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)cellWidth, (int)0x40000000);
        int childHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)cellHeight, (int)0x40000000);
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int newChildWidthMeasureSpec = SwitchGroup.getChildMeasureSpec((int)childWidthMeasureSpec, (int)(lp.rightMargin + lp.leftMargin), (int)(cellWidth - lp.rightMargin - lp.leftMargin));
            int newChildHeightMeasureSpec = SwitchGroup.getChildMeasureSpec((int)childHeightMeasureSpec, (int)(lp.topMargin + lp.bottomMargin), (int)(cellHeight - lp.topMargin - lp.rightMargin));
            child.measure(newChildWidthMeasureSpec, newChildHeightMeasureSpec);
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int count = this.getChildCount();
        int currentLeft = this.getPaddingLeft();
        int currentTop = this.getPaddingTop();
        int currentRight = 0;
        int currentBottom = 0;
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            int childWidth = child.getMeasuredWidth();
            int childHeight = child.getMeasuredHeight();
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            currentRight = currentLeft + lp.leftMargin + childWidth;
            currentBottom = currentTop + lp.topMargin + childHeight;
            child.layout(currentLeft + lp.leftMargin, currentTop + lp.rightMargin, currentRight, currentBottom);
            if (this.mOrientation == 0) {
                currentLeft = currentRight + lp.rightMargin;
                continue;
            }
            currentTop = currentBottom + lp.bottomMargin;
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        return true;
    }

    public boolean onTouchEvent(MotionEvent event) {
        float xf = event.getX();
        float yf = event.getY();
        float scrolledXFloat = xf + (float)this.getScrollX();
        float scrolledYFloat = yf + (float)this.getScrollY();
        Rect frame = this.mSwitchRect;
        int scrolledXInt = (int)scrolledXFloat;
        int scrolledYInt = (int)scrolledYFloat;
        int count = this.getChildCount();
        for (int i = count - 1; i >= 0; --i) {
            int visibility;
            View child = this.getChildAt(i);
            if (child.getVisibility() != 0 && child.getAnimation() == null) continue;
            if (event.getAction() == 1 || event.getAction() == 3) {
                if (child.isSelected()) {
                    child.setSelected(false);
                }
                if (this.mPinnedView == null || this.mPinnedView.getVisibility() != 0) continue;
                this.mPinnedView.setVisibility(8);
                continue;
            }
            child.getHitRect(frame);
            if (frame.contains(scrolledXInt, scrolledYInt)) {
                if (!child.isSelected()) {
                    child.setSelected(true);
                    if (child instanceof SwitchItemView) {
                        ((SwitchItemView)child).handlerPinnedView(this.mPinnedView);
                        if (this.mItemHander != null) {
                            this.mItemHander.onClick(child);
                        }
                        this.invalidate();
                    }
                }
            } else if (child.isSelected()) {
                child.setSelected(false);
            }
            if (this.mPinnedView == null || (visibility = this.mPinnedView.getVisibility()) != 8 && visibility != 4) continue;
            this.mPinnedView.setVisibility(0);
        }
        return true;
    }

    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    protected void attachViewToParent(View child, int index, ViewGroup.LayoutParams params) {
        Log.d((String)"View", (String)"attachViewToParent");
        super.attachViewToParent(child, index, params);
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
    }

    public static interface ItemHander
    extends View.OnClickListener {
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }
    }
}

