/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.view;

import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.RotateAnimation;
import android.widget.AbsListView;
import android.widget.LinearLayout;
import android.widget.ListView;
import io.rong.imkit.Res;
import io.rong.imkit.view.AnimationTextView;

public class PullDownRefreshListView
extends ListView
implements AbsListView.OnScrollListener {
    private static final String TAG = "PullDownRefreshListView";
    private static final int DONE = 0;
    private static final int RELEASE_TO_REFRESH = 1;
    private static final int PULL_TO_REFRESH = 2;
    private static final int REFRESHING = 3;
    private LayoutInflater inflater;
    private LinearLayout headView;
    private RotateAnimation animation;
    private RotateAnimation reverseAnimation;
    private boolean isRecored;
    private boolean isBack;
    private int headContentHeight;
    private int startY;
    private int mFirstVisiableItem;
    private int mVisableCount;
    private int state;
    public OnRefreshListener refreshListener;

    public PullDownRefreshListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    private void init(Context context) {
        this.inflater = LayoutInflater.from((Context)context);
        this.headView = (LinearLayout)this.inflater.inflate(Res.getInstance(context).layout("rc_pull_head"), null);
        this.measureView((View)this.headView);
        this.headContentHeight = this.headView.getMeasuredHeight();
        this.headView.getMeasuredWidth();
        this.headView.setPadding(0, -1 * this.headContentHeight, 0, 0);
        this.headView.invalidate();
        this.headView.setVisibility(8);
        this.addHeaderView((View)this.headView);
        this.setOnScrollListener(this);
        this.animation = new RotateAnimation(0.0f, -180.0f, 1, 0.5f, 1, 0.5f);
        this.animation.setInterpolator((Interpolator)new LinearInterpolator());
        this.animation.setDuration(500L);
        this.animation.setFillAfter(true);
        this.reverseAnimation = new RotateAnimation(-180.0f, 0.0f, 1, 0.5f, 1, 0.5f);
        this.reverseAnimation.setInterpolator((Interpolator)new LinearInterpolator());
        this.reverseAnimation.setDuration(500L);
        this.reverseAnimation.setFillAfter(true);
    }

    public void onScroll(AbsListView arg0, int firstVisiableItem, int arg2, int arg3) {
        this.mFirstVisiableItem = firstVisiableItem;
        this.mVisableCount = arg2;
    }

    public void onScrollStateChanged(AbsListView arg0, int arg1) {
        if (0 == arg1) {
            try {
                for (int i = 0; i <= this.mVisableCount - 1; ++i) {
                    AnimationTextView msgText;
                    View convertView;
                    View textView;
                    if (null == arg0.getChildAt(i) || !((textView = (convertView = arg0.getChildAt(i)).findViewById(Res.getInstance(this.getContext()).id("conversation_message_content_tv"))) instanceof AnimationTextView) || null == (msgText = (AnimationTextView)textView) || msgText.getGifDrawable() == null) continue;
                    if (!msgText.getGifDrawable().isOnStarted()) {
                        msgText.getGifDrawable().setOnStarted(true);
                    }
                    msgText.startGifAnimation();
                }
            }
            catch (Exception e) {
                Log.d((String)TAG, (String)(" class PullDownRefreshListView method onScrollStateChanged has exception:" + e.getMessage()));
            }
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                if (this.mFirstVisiableItem != 0 || this.isRecored) break;
                this.startY = (int)event.getY();
                this.isRecored = true;
                break;
            }
            case 1: {
                if (this.state != 3) {
                    if (this.state == 0) {
                        // empty if block
                    }
                    if (this.state == 2) {
                        this.state = 0;
                        this.changeHeaderViewByState();
                    }
                    if (this.state == 1) {
                        this.state = 3;
                        this.changeHeaderViewByState();
                        this.onRefresh();
                    }
                }
                this.isRecored = false;
                this.isBack = false;
                break;
            }
            case 2: {
                int tempY = (int)event.getY();
                if (!this.isRecored && this.mFirstVisiableItem == 0) {
                    this.isRecored = true;
                    this.startY = tempY;
                }
                if (this.state == 3 || !this.isRecored) break;
                int diffY = (tempY - this.startY) * 2 / 3;
                if (this.state == 1) {
                    if (diffY < this.headContentHeight && diffY > 0) {
                        this.state = 2;
                        this.changeHeaderViewByState();
                    } else if (diffY <= 0) {
                        this.state = 0;
                        this.changeHeaderViewByState();
                    }
                }
                if (this.state == 2) {
                    if (diffY >= this.headContentHeight) {
                        this.state = 1;
                        this.isBack = true;
                        this.changeHeaderViewByState();
                    } else if (diffY <= 0) {
                        this.state = 0;
                        this.changeHeaderViewByState();
                    }
                }
                if (this.state == 0 && diffY > 0) {
                    this.state = 2;
                    this.changeHeaderViewByState();
                }
                if (this.state == 2) {
                    this.headView.setPadding(0, -1 * this.headContentHeight + diffY, 0, 0);
                    this.headView.invalidate();
                }
                if (this.state != 1) break;
                this.headView.setPadding(0, diffY - this.headContentHeight, 0, 0);
                this.headView.invalidate();
            }
        }
        return super.onTouchEvent(event);
    }

    private void changeHeaderViewByState() {
        switch (this.state) {
            case 1: 
            case 2: {
                this.headView.setVisibility(8);
                break;
            }
            case 3: {
                this.headView.setPadding(0, 20, 0, 0);
                this.headView.invalidate();
                this.headView.setVisibility(0);
                break;
            }
            case 0: {
                this.headView.setPadding(0, -1 * this.headContentHeight, 0, 0);
                this.headView.invalidate();
                this.headView.setVisibility(8);
            }
        }
    }

    public void setonRefreshListener(OnRefreshListener refreshListener) {
        this.refreshListener = refreshListener;
    }

    public void onRefreshComplete() {
        this.state = 0;
        this.changeHeaderViewByState();
    }

    private void onRefresh() {
        if (this.refreshListener != null) {
            this.refreshListener.onRefresh();
        }
    }

    private void measureView(View child) {
        ViewGroup.LayoutParams p = child.getLayoutParams();
        if (p == null) {
            p = new ViewGroup.LayoutParams(-1, -2);
        }
        int childWidthSpec = ViewGroup.getChildMeasureSpec((int)0, (int)0, (int)p.width);
        int lpHeight = p.height;
        int childHeightSpec = lpHeight > 0 ? View.MeasureSpec.makeMeasureSpec((int)lpHeight, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        child.measure(childWidthSpec, childHeightSpec);
    }

    public void setSelection(int position) {
        super.setSelection(position);
    }

    public static interface OnRefreshListener {
        public void onRefresh();
    }
}

