/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ListAdapter;
import android.widget.ListView;
import io.rong.imkit.Res;
import io.rong.imkit.view.PinnedHeaderAdapter;

public class PinnedHeaderListView
extends ListView {
    private static final int MAX_ALPHA = 255;
    private PinnedHeaderAdapter<?> mAdapter;
    private View mHeaderView;
    private boolean mHeaderViewVisible;
    private int mHeaderViewWidth;
    private int mHeaderViewHeight;
    private View mListHeaderView;

    public PinnedHeaderListView(Context context) {
        super(context);
    }

    public PinnedHeaderListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public PinnedHeaderListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, Res.getInstance(context).styleables("PullLayout"));
        a.recycle();
    }

    public void setPinnedHeaderView(View view) {
        this.mHeaderView = view;
    }

    public void setAdapter(ListAdapter adapter) {
        if (!(adapter instanceof PinnedHeaderAdapter)) {
            throw new RuntimeException("Adapter not instance of PinnedHeader");
        }
        super.setAdapter(adapter);
        this.mAdapter = (PinnedHeaderAdapter)adapter;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.mHeaderView != null) {
            this.measureChild(this.mHeaderView, widthMeasureSpec, heightMeasureSpec);
            this.mHeaderViewWidth = this.mHeaderView.getMeasuredWidth();
            this.mHeaderViewHeight = this.mHeaderView.getMeasuredHeight();
        }
    }

    public void addHeaderView(View v, Object data, boolean isSelectable) {
        super.addHeaderView(v, data, isSelectable);
        this.mListHeaderView = v;
    }

    public void addHeaderView(View v) {
        super.addHeaderView(v);
        this.mListHeaderView = v;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (this.mHeaderView != null) {
            this.mHeaderView.layout(0, 0, this.mHeaderViewWidth, this.mHeaderViewHeight);
            this.configureHeaderView(this.getFirstVisiblePosition());
        }
    }

    public void configureHeaderView(int position) {
        if (this.mHeaderView == null || this.mAdapter == null) {
            return;
        }
        if (this.mListHeaderView != null) {
            position -= this.getHeaderViewsCount();
        }
        int state = this.mAdapter.getPinnedHeaderState(position);
        switch (state) {
            case 0: {
                this.mHeaderViewVisible = false;
                break;
            }
            case 1: {
                this.mAdapter.configurePinnedHeader(this.mHeaderView, position, 255);
                if (this.mHeaderView.getTop() != 0) {
                    this.mHeaderView.layout(0, 0, this.mHeaderViewWidth, this.mHeaderViewHeight);
                }
                this.mHeaderViewVisible = true;
                break;
            }
            case 2: {
                int alpha;
                int y;
                View firstView = this.getChildAt(0);
                if (firstView == null) break;
                int bottom = firstView.getBottom();
                int itemHeight = firstView.getHeight();
                int headerHeight = this.mHeaderView.getHeight();
                if (bottom < headerHeight) {
                    y = bottom - headerHeight;
                    alpha = 255 * (headerHeight + y) / headerHeight;
                } else {
                    y = 0;
                    alpha = 255;
                }
                this.mAdapter.configurePinnedHeader(this.mHeaderView, position, alpha);
                if (this.mHeaderView.getTop() != y) {
                    this.mHeaderView.layout(0, y, this.mHeaderViewWidth, this.mHeaderViewHeight + y);
                }
                this.mHeaderViewVisible = true;
                break;
            }
        }
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.mHeaderViewVisible) {
            this.drawChild(canvas, this.mHeaderView, this.getDrawingTime());
        }
    }
}

