/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.view;

import android.content.Context;
import android.view.View;
import android.widget.AbsListView;
import android.widget.SectionIndexer;
import io.rong.imkit.view.CompositeAdapter;
import io.rong.imkit.view.PinnedHeaderListView;
import java.util.Collection;
import java.util.List;

public abstract class PinnedHeaderAdapter<T>
extends CompositeAdapter<T> {
    public static final int PINNED_HEADER_GONE = 0;
    public static final int PINNED_HEADER_VISIBLE = 1;
    public static final int PINNED_HEADER_PUSHED_UP = 2;
    private SectionIndexer mIndexer;

    public PinnedHeaderAdapter(Context context) {
        super(context);
    }

    public PinnedHeaderAdapter(Context context, Collection<List<T>> collection) {
        super(context);
        this.changeIndexer(collection);
    }

    public void updateCollection(Collection<List<T>> collection) {
        this.clearPartitions();
        this.changeIndexer(collection);
    }

    private void changeIndexer(Collection<List<T>> collection) {
        int size = collection.size();
        for (List<T> data : collection) {
            this.addPartition(new CompositeAdapter.Partition<T>(false, true, data), size);
        }
    }

    protected abstract SectionIndexer updateIndexer(CompositeAdapter.Partition<T>[] var1);

    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        if (view instanceof PinnedHeaderListView) {
            ((PinnedHeaderListView)view).configureHeaderView(firstVisibleItem);
        }
    }

    public void onScrollStateChanged(AbsListView view, int scrollState) {
    }

    public int getPinnedHeaderState(int position) {
        int nextSectionPosition;
        if (this.mIndexer == null) {
            return 0;
        }
        if (position < 0) {
            return 0;
        }
        int section = this.mIndexer.getSectionForPosition(position);
        if ((nextSectionPosition = this.mIndexer.getPositionForSection(++section)) != -1 && position == nextSectionPosition - 1) {
            return 2;
        }
        return 1;
    }

    public int getSectionForPosition(int position) {
        return this.mIndexer.getSectionForPosition(position);
    }

    public int getPositionForSection(int section) {
        return this.mIndexer.getPositionForSection(section);
    }

    @Override
    public void notifyDataSetChanged() {
        if (this.getPartitions() != null) {
            this.mIndexer = this.updateIndexer(this.getPartitions());
        }
        super.notifyDataSetChanged();
    }

    public SectionIndexer getSectionIndexer() {
        return this.mIndexer;
    }

    public void notifyDataSetInvalidated() {
        if (this.getPartitions() != null) {
            this.mIndexer = this.updateIndexer(this.getPartitions());
        }
        super.notifyDataSetInvalidated();
    }

    public abstract void configurePinnedHeader(View var1, int var2, int var3);
}

