/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.view;

import android.content.Context;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import io.rong.imkit.Res;
import io.rong.imkit.view.BaseFrameLayout;
import io.rong.imkit.view.MentionsEditText;

public class MessageBar
extends BaseFrameLayout
implements View.OnClickListener {
    public static int MESSAGE_BAR_STATE_TEXT = 1;
    public static int MESSAGE_BAR_STATE_VOICE = 2;
    private ImageView mChangeImageView;
    private MentionsEditText mMessageEditText;
    private ImageView mAddImageView;
    private Button mSendButton;
    private Button mVoiceButton;
    private ImageView mExpressionImageView;
    private LinearLayout mEditLayout;
    private MessageBarListener mMessageBarListener;
    private int mCurrentState = MESSAGE_BAR_STATE_TEXT;

    public MessageBar(Context context) {
        super(context);
        this.initView();
    }

    public MessageBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public MessageBar(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView();
    }

    public void initView() {
        LayoutInflater.from((Context)this.getContext()).inflate(Res.getInstance(this.getContext()).layout("rc_view_message_bar"), (ViewGroup)this);
        this.mChangeImageView = (ImageView)this.getView((View)this, "conversation_message_bar_change_iv");
        this.mMessageEditText = (MentionsEditText)((Object)this.getView((View)this, "conversation_message_bar_edit"));
        this.mAddImageView = (ImageView)this.getView((View)this, "conversation_message_bar_add_iv");
        this.mSendButton = (Button)this.getView((View)this, "conversation_message_bar_send_btn");
        this.mVoiceButton = (Button)this.getView((View)this, "conversation_message_bar_voice_btn");
        this.mExpressionImageView = (ImageView)this.getView((View)this, "conversation_message_expression");
        this.mEditLayout = (LinearLayout)this.getView((View)this, "conversation_message_edit_layout");
        this.mMessageEditText.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                if (s.toString().trim().length() > 0) {
                    MessageBar.this.mSendButton.setVisibility(0);
                    MessageBar.this.mAddImageView.setVisibility(8);
                } else {
                    MessageBar.this.mSendButton.setVisibility(8);
                    MessageBar.this.mAddImageView.setVisibility(0);
                }
            }
        });
        this.mMessageEditText.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                if (MessageBar.this.mMessageBarListener != null) {
                    MessageBar.this.mMessageBarListener.onEditTextClick();
                }
            }
        });
        this.mAddImageView.setOnClickListener((View.OnClickListener)this);
        this.mSendButton.setOnClickListener((View.OnClickListener)this);
        this.mExpressionImageView.setOnClickListener((View.OnClickListener)this);
        this.mChangeImageView.setOnClickListener((View.OnClickListener)this);
        this.mMessageEditText.setOnClickListener(this);
    }

    public void onClick(View v) {
        if (this.mMessageBarListener == null) {
            return;
        }
        if (v == this.mChangeImageView) {
            Log.d((String)"onclick->", (String)("conversation_message_bar_change_iv 1:text 2:voice ->\uff1a" + this.mCurrentState));
            if (this.mCurrentState == MESSAGE_BAR_STATE_TEXT) {
                this.mEditLayout.setVisibility(8);
                this.mVoiceButton.setVisibility(0);
                this.mChangeImageView.setImageDrawable(this.getContext().getResources().getDrawable(Res.getInstance(this.getContext()).drawable("rc_message_bar_keyboard")));
                this.mCurrentState = MESSAGE_BAR_STATE_VOICE;
                this.mMessageBarListener.onChangeIVClick(this.mCurrentState);
                this.mAddImageView.setVisibility(0);
                this.mSendButton.setVisibility(8);
            } else if (this.mCurrentState == MESSAGE_BAR_STATE_VOICE) {
                this.mEditLayout.setVisibility(0);
                this.mVoiceButton.setVisibility(8);
                this.mChangeImageView.setImageDrawable(this.getContext().getResources().getDrawable(Res.getInstance(this.getContext()).drawable("rc_message_bar_vioce_icon")));
                this.mCurrentState = MESSAGE_BAR_STATE_TEXT;
                if (this.mMessageEditText.getText().toString().trim().length() > 0) {
                    this.mAddImageView.setVisibility(8);
                    this.mSendButton.setVisibility(0);
                    this.mMessageBarListener.onChangeIVClick(MESSAGE_BAR_STATE_VOICE);
                } else {
                    this.mMessageBarListener.onChangeIVClick(this.mCurrentState);
                }
            }
        } else if (v == this.mAddImageView) {
            this.mMessageBarListener.onAddIVClick();
            this.mEditLayout.setVisibility(0);
            this.mVoiceButton.setVisibility(8);
            if (this.mMessageEditText.getText().toString().trim().length() > 0) {
                this.mAddImageView.setVisibility(8);
                this.mSendButton.setVisibility(0);
            }
        } else if (v == this.mSendButton) {
            this.mMessageBarListener.onSendBtnClick();
        } else if (v == this.mExpressionImageView) {
            this.mMessageBarListener.onExpressionClick();
        } else if (v == this.mMessageEditText) {
            this.mMessageBarListener.onEditTextClick();
        }
    }

    public void setMessageBarListener(MessageBarListener mMessageBarListener) {
        this.mMessageBarListener = mMessageBarListener;
    }

    public ImageView getChangeImageView() {
        return this.mChangeImageView;
    }

    public MentionsEditText getMessageEditText() {
        return this.mMessageEditText;
    }

    public ImageView getAddImageView() {
        return this.mAddImageView;
    }

    public Button getSendButton() {
        return this.mSendButton;
    }

    public ImageView getExpressionImageView() {
        return this.mExpressionImageView;
    }

    public static interface MessageBarListener {
        public void onChangeIVClick(int var1);

        public void onAddIVClick();

        public void onSendBtnClick();

        public void onExpressionClick();

        public void onEditTextClick();
    }
}

