/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.view;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.style.ImageSpan;
import android.util.AttributeSet;
import android.widget.EditText;

public class MentionsEditText
extends EditText {
    public MentionsEditText(Context context) {
        super(context);
    }

    public MentionsEditText(Context context, AttributeSet attrs) {
        super(context, attrs, 16842862);
    }

    public MentionsEditText(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    private Object getNowSpan() {
        int flag = this.getSelectionEnd();
        Object[] spans = this.getEditableText().getSpans(0, flag, Object.class);
        if (spans != null && spans.length > 0) {
            Object span = spans[spans.length - 1];
            if (this.getEditableText().getSpanEnd(span) >= flag) {
                return span;
            }
        }
        return null;
    }

    public String getRealString() {
        String text = null;
        text = this.getEditableText().toString();
        return text;
    }

    public void clearStr() {
        this.setText(null);
    }

    public int insertText(String text) {
        int index = this.getSelectionEnd();
        if (index < 0 || index >= this.getEditableText().length()) {
            this.append(text);
        } else {
            this.getEditableText().insert(index, (CharSequence)text);
        }
        return index;
    }

    public void insertImage(String text, Drawable drawable2) {
        int start = this.insertText(text);
        if (drawable2 != null) {
            this.getEditableText().setSpan((Object)new ImageSpan(drawable2, 0), start, start + text.length(), 33);
        }
    }

    public void deleteChar() {
        if (this.getEditableText().length() > 0) {
            Object nowSpan = this.getNowSpan();
            if (nowSpan != null) {
                if (nowSpan instanceof ImageSpan) {
                    int start = this.getEditableText().getSpanStart(nowSpan);
                    int end = this.getEditableText().getSpanEnd(nowSpan);
                    this.getEditableText().removeSpan(nowSpan);
                    this.getEditableText().delete(start, end);
                } else {
                    this.getEditableText().delete(this.getSelectionEnd() - 1, this.getSelectionEnd());
                }
            } else {
                this.getEditableText().delete(this.getSelectionEnd() - 1, this.getSelectionEnd());
            }
        }
    }

    public class MentionsText {
        private CharSequence text;

        public CharSequence getText() {
            return this.text;
        }

        public void setText(CharSequence text) {
            this.text = text;
        }

        public int length() {
            if (this.text != null) {
                return this.text.length();
            }
            return 0;
        }
    }
}

