/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.view;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import io.rong.imkit.Res;
import io.rong.imkit.view.CirclePageIndicator;
import io.rong.imkit.view.EmotionAdapter;
import io.rong.imkit.view.gif.EmotionParser;

public class EmotionView
extends FrameLayout
implements EmotionAdapter.OnEmotionItemClickListener {
    private ViewPager mPager;
    private EmotionAdapter mAdapter;
    private EmotionAdapter.OnEmotionItemClickListener mListener;
    private Context mContext;
    private CirclePageIndicator mIndicator;

    public EmotionView(Context context) {
        super(context);
        this.mContext = context;
        this.initView();
        this.initData();
    }

    public EmotionView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.initView();
        this.initData();
    }

    private void initView() {
        View view = LayoutInflater.from((Context)this.mContext).inflate(Res.getInstance(this.getContext()).layout("rc_view_emotion"), (ViewGroup)this);
        this.mPager = (ViewPager)view.findViewById(Res.getInstance(this.getContext()).id("viewpager"));
        this.mIndicator = (CirclePageIndicator)view.findViewById(Res.getInstance(this.getContext()).id("radio_group"));
    }

    private void initData() {
        this.mAdapter = new EmotionAdapter(this.mContext, this.mPager);
        this.mAdapter.setOnEmotionItemClickListener(this);
        this.mPager.setAdapter((PagerAdapter)this.mAdapter);
        this.mPager.setCurrentItem(0);
        this.mIndicator.setViewPager(this.mPager);
        this.mIndicator.setFillColor(-1);
        this.mIndicator.setPageColor(-8092540);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
    }

    @Override
    public void onEmotionClick(Drawable drawable2, String code, int flag) {
        if (this.mListener != null) {
            this.mListener.onEmotionClick(drawable2, code, flag);
        }
    }

    public void setOnEmotionItemClickListener(EmotionAdapter.OnEmotionItemClickListener listener) {
        this.mListener = listener;
    }

    protected void onDetachedFromWindow() {
        EmotionParser.getInstance(this.getContext()).onDestroy();
        EmotionParser.setEmptyInstance();
        super.onDetachedFromWindow();
    }
}

