/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.view;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import android.widget.GridView;
import android.widget.ImageView;
import android.widget.ListAdapter;
import io.rong.imkit.Res;
import io.rong.imkit.view.gif.EmotionParser;

public class EmotionAdapter
extends PagerAdapter
implements View.OnClickListener {
    Drawable[] mDrawableArray;
    int[] mDrawableResId;
    int[][] mDrawablePageId;
    Context mContext;
    private static int ROW_COUNT = 3;
    private static int COLUMN_COUNT = 7;
    private static int P_COUNT = ROW_COUNT * COLUMN_COUNT - 1;
    public static final int FLAG_DELETE = -1;
    public static final int FLAG_PNG = 0;
    private int rate = 0;
    private int item_length = 0;
    private int grid_height = 0;
    int mCount;
    ViewHolder mViewHolder;
    OnEmotionItemClickListener mListener;
    ViewPager mViewPager;

    public EmotionAdapter(Context context, ViewPager viewPager) {
        this.mViewPager = viewPager;
        this.mContext = context;
        this.initData();
    }

    private void initData() {
        this.mDrawableResId = EmotionParser.getInstance(this.mContext).getSmileResIds();
        this.mCount = this.mDrawableResId.length % P_COUNT > 0 ? this.mDrawableResId.length / P_COUNT + 1 : this.mDrawableResId.length / P_COUNT;
        this.mDrawablePageId = new int[this.mCount][ROW_COUNT * COLUMN_COUNT];
        for (int i = 0; i < this.mCount; ++i) {
            for (int j = 0; j < P_COUNT && i * P_COUNT + j < this.mDrawableResId.length; ++j) {
                this.mDrawablePageId[i][j] = this.mDrawableResId[i * P_COUNT + j];
            }
        }
        DisplayMetrics dm = this.mContext.getResources().getDisplayMetrics();
        this.rate = dm.widthPixels / (COLUMN_COUNT * 10 + 3);
        this.item_length = this.rate * 9;
        this.grid_height = this.item_length * ROW_COUNT + this.rate * 6;
        Log.d((String)"rate", (String)("--------------------" + this.rate));
    }

    public int getMaxHeight() {
        return this.grid_height;
    }

    public int getCount() {
        return this.mCount;
    }

    public boolean isViewFromObject(View arg0, Object arg1) {
        ViewHolder holder = (ViewHolder)arg1;
        return arg0 == holder.gridView;
    }

    public Object instantiateItem(ViewGroup container, int position) {
        GridView gridView = null;
        EmotionListAdapter adapter = null;
        ViewHolder holder = null;
        if (this.mViewHolder != null) {
            gridView = this.mViewHolder.gridView;
            adapter = this.mViewHolder.adapter;
            holder = this.mViewHolder;
            this.mViewHolder = null;
        } else {
            gridView = (GridView)LayoutInflater.from((Context)this.mContext).inflate(Res.getInstance(this.mContext).layout("rc_emotion"), null);
            gridView.setScrollContainer(false);
            gridView.setPadding(this.rate * 2, this.rate * 2, this.rate * 2, this.rate * 2);
            gridView.setHorizontalSpacing(this.rate);
            float scale = this.mContext.getResources().getDisplayMetrics().density;
            if ((double)scale <= 1.5) {
                Log.d((String)"scale---", (String)("-----<=1.5---scale:" + scale));
                gridView.setVerticalSpacing(38);
                gridView.setMinimumHeight(272);
            } else {
                Log.d((String)"scale---", (String)("--->1.5-----scale:" + scale));
                gridView.setVerticalSpacing(58);
                gridView.setMinimumHeight(406);
            }
            adapter = new EmotionListAdapter();
            holder = new ViewHolder();
            holder.gridView = gridView;
            holder.adapter = adapter;
            holder.gridView.setNumColumns(COLUMN_COUNT);
        }
        adapter.setData(this.mDrawablePageId[position]);
        gridView.setAdapter((ListAdapter)adapter);
        container.addView((View)gridView);
        return holder;
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        this.mViewHolder = (ViewHolder)object;
        container.removeView((View)this.mViewHolder.gridView);
    }

    public void setOnEmotionItemClickListener(OnEmotionItemClickListener listener) {
        this.mListener = listener;
    }

    public void onClick(View v) {
        if (this.mListener != null) {
            int resId = (Integer)v.getTag();
            if (resId == -1) {
                this.mListener.onEmotionClick(null, "", -1);
            } else if (resId != 0) {
                this.mListener.onEmotionClick(null, EmotionParser.getInstance(this.mContext).getSmileCode(resId), 0);
            }
        }
    }

    private int pxTodip(Context context, float pxValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        Log.d((String)"pxTodip", (String)("-------scale-----" + scale + ":--" + (int)(pxValue / scale + 0.5f)));
        return (int)(pxValue / scale + 0.5f);
    }

    public static interface OnEmotionItemClickListener {
        public void onEmotionClick(Drawable var1, String var2, int var3);
    }

    class EmotionListAdapter
    extends BaseAdapter {
        int[] resIds;

        public void setData(int[] resIds) {
            this.resIds = resIds;
            this.notifyDataSetChanged();
        }

        public int getCount() {
            if (this.resIds != null) {
                return this.resIds.length;
            }
            return 0;
        }

        public Object getItem(int position) {
            return this.resIds[position];
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            ImageView img = (ImageView)LayoutInflater.from((Context)EmotionAdapter.this.mContext).inflate(Res.getInstance(EmotionAdapter.this.mContext).layout("rc_item_emotion"), null);
            img.setLayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams(EmotionAdapter.this.item_length, EmotionAdapter.this.item_length));
            img.setPadding(EmotionAdapter.this.rate, EmotionAdapter.this.rate, EmotionAdapter.this.rate, EmotionAdapter.this.rate);
            img.setTag((Object)this.resIds[position]);
            img.setVisibility(4);
            img.setOnClickListener((View.OnClickListener)EmotionAdapter.this);
            if (this.resIds[position] != 0) {
                img.setImageResource(this.resIds[position]);
                img.setVisibility(0);
            } else if (position == this.resIds.length - 1) {
                img.setTag((Object)-1);
                img.setImageResource(Res.getInstance(EmotionAdapter.this.mContext).drawable("rc_ic_delete"));
                img.setVisibility(0);
            }
            return img;
        }
    }

    class ViewHolder {
        GridView gridView;
        EmotionListAdapter adapter;

        ViewHolder() {
        }
    }
}

