/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.FrameLayout;
import io.rong.imkit.Res;

public class CoverFrameLayout
extends FrameLayout {
    CoverHandler mCoverHandler;
    View mTriggerView;
    int mCoverViewResId;
    int mTriggerViewResId;
    int mTriggerLimit;
    float mTriggerCenterX = 0.0f;
    float mTriggerCenterY = 0.0f;
    OnTriggeredTouchListener mTriggeredTouchListener;
    boolean mHasTrigger;

    public CoverFrameLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, Res.getInstance(this.getContext()).styleables("CoverFrameLayout"));
        this.mCoverViewResId = a.getResourceId(Res.getInstance(this.getContext()).styleable("CoverFrameLayout_coverView"), 0);
        this.mTriggerViewResId = a.getResourceId(Res.getInstance(this.getContext()).styleable("CoverFrameLayout_triggerView"), 0);
        this.mTriggerLimit = a.getInt(Res.getInstance(this.getContext()).styleable("CoverFrameLayout_triggerLimit"), 200);
        if (this.mCoverViewResId == 0 || this.mTriggerViewResId == 0) {
            throw new RuntimeException("CoverView or TriggerView not define");
        }
    }

    protected void onAttachedToWindow() {
        View view = this.findViewById(this.mCoverViewResId);
        if (!(view instanceof CoverHandler)) {
            throw new RuntimeException("CoverView not impl CoverHandler");
        }
        this.mCoverHandler = (CoverHandler)view;
        this.mCoverHandler.setStatus(65535);
        this.mTriggerView = this.findViewById(this.mTriggerViewResId);
        this.mTriggerView.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                return true;
            }
        });
        Rect rect = new Rect();
        this.mTriggerView.getHitRect(rect);
        this.mTriggerCenterX = rect.centerX();
        this.mTriggerCenterY = rect.centerY();
        super.onAttachedToWindow();
    }

    public boolean onTouchEvent(MotionEvent ev) {
        MotionEvent event;
        if (ev.getAction() == 0) {
            this.mCoverHandler.setStatus(65535);
        }
        if ((ev.getAction() == 3 || ev.getAction() == 1) && this.mHasTrigger) {
            event = MotionEvent.obtain((long)ev.getDownTime(), (long)ev.getEventTime(), (int)ev.getAction(), (float)this.mTriggerCenterX, (float)this.mTriggerCenterY, (int)ev.getMetaState());
            this.mTriggerView.dispatchTouchEvent(ev);
            this.mHasTrigger = false;
            this.mCoverHandler.setStatus(196607);
            if (this.mTriggeredTouchListener != null) {
                this.mTriggeredTouchListener.OnTriggeredTouchEvent(event, this);
            }
        }
        if (this.mHasTrigger) {
            event = MotionEvent.obtain((long)ev.getDownTime(), (long)ev.getEventTime(), (int)ev.getAction(), (float)this.mTriggerCenterX, (float)this.mTriggerCenterY, (int)ev.getMetaState());
            this.mTriggerView.dispatchTouchEvent(event);
            if (this.mTriggeredTouchListener != null && ev.getEventTime() - ev.getDownTime() > (long)this.mTriggerLimit) {
                this.mTriggeredTouchListener.OnTriggeredTouchEvent(ev, this);
            }
            if ((this.mCoverHandler.getStatus() & 0xFFFF0000) == 0) {
                this.mCoverHandler.setStatus(131071);
            }
        }
        return true;
    }

    public CoverHandler getCoverHandler() {
        return this.mCoverHandler;
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        return super.dispatchTouchEvent(ev);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (this.mTriggerView.getVisibility() != 0) {
            return super.onInterceptTouchEvent(ev);
        }
        if (ev.getAction() == 0) {
            Rect rect = new Rect();
            int offsetX = 0;
            int offsetY = 0;
            View tempView = this.mTriggerView;
            while (tempView.getParent() != this && tempView.getParent() instanceof View) {
                tempView = (View)tempView.getParent();
                offsetY += tempView.getTop();
                offsetX += tempView.getLeft();
            }
            this.mTriggerView.getHitRect(rect);
            this.mHasTrigger = rect.contains((int)ev.getX() - offsetX, (int)ev.getY() - offsetY);
        }
        if (this.mHasTrigger) {
            return true;
        }
        return super.onInterceptTouchEvent(ev);
    }

    public void setOnTriggeredTouchListener(OnTriggeredTouchListener listener) {
        this.mTriggeredTouchListener = listener;
    }

    static interface CoverHandler {
        public static final int STATUS_NORMAL = 65535;
        public static final int STATUS_OPEN = 131071;
        public static final int STATUS_CLOSE = 196607;
        public static final int STATUS_MASK = -65536;

        public void setStatus(int var1);

        public int getStatus();
    }

    public static interface OnTriggeredTouchListener {
        public void OnTriggeredTouchEvent(MotionEvent var1, CoverFrameLayout var2);
    }
}

