/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.view;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import io.rong.imkit.RCloudContext;
import io.rong.imkit.Res;
import io.rong.imkit.view.BaseFrameLayout;
import io.rong.imkit.view.EmotionAdapter;
import io.rong.imkit.view.EmotionView;
import io.rong.imkit.view.MentionsEditText;
import io.rong.imkit.view.MessageBar;
import io.rong.imkit.view.RichIconTextView;
import io.rong.imkit.view.gif.EmotionParser;

public class ConversationMessageBar
extends BaseFrameLayout
implements MessageBar.MessageBarListener,
EmotionAdapter.OnEmotionItemClickListener,
View.OnClickListener {
    private LinearLayout mExpressionLayout;
    private RelativeLayout mRichTextLayout;
    private MessageBar messageBar;
    private EmotionView mEmotionView;
    private RichIconTextView mImageRichIconTextView;
    private RichIconTextView mCameraRichIconTextView;
    private RichIconTextView mVOIPRichIconTextView;
    private RichIconTextView mLocationIconTextView;
    private int mCurrentState = MessageBar.MESSAGE_BAR_STATE_TEXT;
    private ConversationMessageBarListener conversationMessageBarLinstener;
    private OnRichIconTextViewClickListener mOnRichIconTextViewClickListener;

    public ConversationMessageBar(Context context) {
        super(context);
        this.initView();
    }

    public ConversationMessageBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public ConversationMessageBar(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView();
    }

    private void initView() {
        LayoutInflater.from((Context)this.getContext()).inflate(Res.getInstance(this.mContext).layout("rc_conversation_message_bar"), (ViewGroup)this);
        this.messageBar = (MessageBar)((Object)this.getView((View)this, "conversation_message_bar_message_bar"));
        this.mExpressionLayout = (LinearLayout)this.getView((View)this, "conversation_message_bar_expression_layout");
        this.mRichTextLayout = (RelativeLayout)this.getView((View)this, "conversation_message_bar_rich_text_layout");
        this.mEmotionView = (EmotionView)this.getView((View)this, "conversation_message_bar_emotion_view");
        this.mEmotionView.setOnEmotionItemClickListener(this);
        this.messageBar.setMessageBarListener(this);
        this.mImageRichIconTextView = (RichIconTextView)((Object)this.getView((View)this, "imagetRichIcon"));
        this.mCameraRichIconTextView = (RichIconTextView)((Object)this.getView((View)this, "camertRichIcon"));
        this.mVOIPRichIconTextView = (RichIconTextView)((Object)this.getView((View)this, "voipRichIcon"));
        this.mLocationIconTextView = (RichIconTextView)((Object)this.getView((View)this, "locationRichIcon"));
        if (RCloudContext.getInstance() != null) {
            if (RCloudContext.getInstance().getLocationProvider() == null) {
                this.mLocationIconTextView.setVisibility(8);
            } else {
                this.mLocationIconTextView.setVisibility(0);
            }
        }
        ImageView imageView = this.mImageRichIconTextView.getIconView();
        imageView.setBackgroundResource(Res.getInstance(this.getContext()).drawable("rc_ic_pic"));
        this.mImageRichIconTextView.getNameView().setText(this.getResourceStringID("rich_icon_image_txt"));
        ImageView cameraView = this.mCameraRichIconTextView.getIconView();
        cameraView.setBackgroundResource(Res.getInstance(this.getContext()).drawable("rc_ic_camera"));
        this.mCameraRichIconTextView.getNameView().setText(this.getResourceStringID("rich_icon_take_photo_txt"));
        ImageView voipView = this.mVOIPRichIconTextView.getIconView();
        voipView.setBackgroundResource(Res.getInstance(this.getContext()).drawable("rc_ic_phone"));
        this.mVOIPRichIconTextView.getNameView().setText(this.getResourceStringID("rich_icon_phone_txt"));
        ImageView locationView = this.mLocationIconTextView.getIconView();
        locationView.setBackgroundResource(Res.getInstance(this.getContext()).drawable("rc_ic_location"));
        this.mLocationIconTextView.getNameView().setText(this.getResourceStringID("rich_icon_location_txt"));
        this.mImageRichIconTextView.setOnClickListener(this);
        this.mCameraRichIconTextView.setOnClickListener(this);
        this.mVOIPRichIconTextView.setOnClickListener(this);
        this.mLocationIconTextView.setOnClickListener(this);
    }

    @Override
    public void onChangeIVClick(int state) {
        if (this.conversationMessageBarLinstener == null) {
            return;
        }
        this.mCurrentState = state;
        if (state == MessageBar.MESSAGE_BAR_STATE_TEXT) {
            if (this.mExpressionLayout.getVisibility() == 0 || this.mRichTextLayout.getVisibility() == 0) {
                this.toggleInputMethod(false, this.messageBar.getMessageEditText());
            } else {
                this.mExpressionLayout.setVisibility(8);
                this.mRichTextLayout.setVisibility(8);
                this.toggleInputMethod(true, this.messageBar.getMessageEditText());
            }
        } else if (state == MessageBar.MESSAGE_BAR_STATE_VOICE) {
            this.toggleInputMethod(false, this.messageBar.getMessageEditText());
            this.mExpressionLayout.setVisibility(8);
            this.mRichTextLayout.setVisibility(8);
        }
        this.messageBar.getExpressionImageView().setBackgroundDrawable(this.getContext().getResources().getDrawable(Res.getInstance(this.getContext()).drawable("rc_smiley_selector")));
    }

    private final void toggleInputMethod(boolean isOpen, EditText editText) {
        if (isOpen) {
            this.conversationMessageBarLinstener.toggleInputMethod(isOpen, (View)editText);
            editText.requestFocus();
        } else {
            this.conversationMessageBarLinstener.toggleInputMethod(isOpen, (View)editText);
        }
    }

    @Override
    public void onAddIVClick() {
        this.mExpressionLayout.setVisibility(8);
        if (this.mRichTextLayout.getVisibility() == 0) {
            this.toggleInputMethod(true, this.messageBar.getMessageEditText());
            this.mRichTextLayout.setVisibility(8);
        } else {
            this.toggleInputMethod(false, this.messageBar.getMessageEditText());
            this.getHandler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    ConversationMessageBar.this.mRichTextLayout.setVisibility(0);
                    if (ConversationMessageBar.this.mOnRichIconTextViewClickListener != null) {
                        ConversationMessageBar.this.mOnRichIconTextViewClickListener.isVisibility();
                    }
                }
            }, 500L);
        }
        this.messageBar.getExpressionImageView().setBackgroundDrawable(this.getContext().getResources().getDrawable(Res.getInstance(this.getContext()).drawable("rc_smiley_selector")));
    }

    public void setExpressionImageViewDefault() {
        this.messageBar.getExpressionImageView().setBackgroundDrawable(this.getContext().getResources().getDrawable(Res.getInstance(this.getContext()).drawable("rc_smiley_selector")));
    }

    @Override
    public void onSendBtnClick() {
        String message = this.getMessageEditString();
        this.conversationMessageBarLinstener.sendMessage(message);
        this.messageBar.getMessageEditText().clearStr();
    }

    @Override
    public void onExpressionClick() {
        this.mRichTextLayout.setVisibility(8);
        if (this.mExpressionLayout.getVisibility() == 8) {
            this.toggleInputMethod(false, this.messageBar.getMessageEditText());
            this.getHandler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    ConversationMessageBar.this.mExpressionLayout.setVisibility(0);
                    if (ConversationMessageBar.this.mOnRichIconTextViewClickListener != null) {
                        ConversationMessageBar.this.mOnRichIconTextViewClickListener.isVisibility();
                    }
                }
            }, 500L);
            this.messageBar.getExpressionImageView().setBackgroundDrawable(this.getContext().getResources().getDrawable(Res.getInstance(this.getContext()).drawable("rc_smiley_hover")));
        } else {
            this.mExpressionLayout.setVisibility(8);
            this.toggleInputMethod(true, this.messageBar.getMessageEditText());
            this.messageBar.getExpressionImageView().setBackgroundDrawable(this.getContext().getResources().getDrawable(Res.getInstance(this.getContext()).drawable("rc_smiley_selector")));
        }
    }

    public String getMessageEditString() {
        return this.messageBar.getMessageEditText().getRealString();
    }

    @Override
    public void onEditTextClick() {
        this.mExpressionLayout.setVisibility(8);
        this.mRichTextLayout.setVisibility(8);
        this.messageBar.getExpressionImageView().setBackgroundDrawable(this.getContext().getResources().getDrawable(Res.getInstance(this.getContext()).drawable("rc_smiley_selector")));
        if (this.mOnRichIconTextViewClickListener != null) {
            this.mOnRichIconTextViewClickListener.isVisibility();
        }
    }

    public void setHiddenRichAndExpressionView() {
        this.mExpressionLayout.setVisibility(8);
        this.mRichTextLayout.setVisibility(8);
    }

    public boolean isShowRichOrExpressionView() {
        return this.mExpressionLayout.getVisibility() == 0 || this.mRichTextLayout.getVisibility() == 0;
    }

    @Override
    public void onEmotionClick(Drawable drawable2, String code, int flag) {
        MentionsEditText mentionsEditText = this.messageBar.getMessageEditText();
        if (flag == -1) {
            mentionsEditText.deleteChar();
        } else if (flag == 0) {
            Drawable d = EmotionParser.getInstance(this.getContext()).getSmileDrawable(code);
            mentionsEditText.insertImage(code, d);
        }
    }

    public void setConversationMessageBarListener(ConversationMessageBarListener conversationMessageBarListener) {
        this.conversationMessageBarLinstener = conversationMessageBarListener;
    }

    private final int getResourceColorID(String resId) {
        return this.getContext().getResources().getColor(Res.getInstance(this.getContext()).color(resId));
    }

    private final int getResourceStringID(String resId) {
        return Res.getInstance(this.mContext).string(resId);
    }

    public void onClick(View v) {
        if (v != null && this.mOnRichIconTextViewClickListener != null) {
            if (v == this.mImageRichIconTextView) {
                this.mOnRichIconTextViewClickListener.onImageRichTextClick();
            } else if (v == this.mCameraRichIconTextView) {
                this.mOnRichIconTextViewClickListener.onCameraRichTextClick();
            } else if (v == this.mVOIPRichIconTextView) {
                this.mOnRichIconTextViewClickListener.onVoipRichTextClick();
            } else if (v == this.mLocationIconTextView) {
                this.mOnRichIconTextViewClickListener.onLocationRichTextClick();
            }
        }
    }

    public void setOnRichIconTextViewClickListener(OnRichIconTextViewClickListener onRichIconTextViewClickListener) {
        this.mOnRichIconTextViewClickListener = onRichIconTextViewClickListener;
    }

    public void setRichOrExpressionViewVisibility() {
        this.mRichTextLayout.setVisibility(8);
        this.mExpressionLayout.setVisibility(8);
    }

    public void setMessageEditText(CharSequence msg) {
        this.messageBar.getMessageEditText().setText("");
        this.messageBar.getMessageEditText().append(msg);
    }

    public MessageBar getMessageBar() {
        return this.messageBar;
    }

    public RichIconTextView getVOIPRichIconTextView() {
        return this.mVOIPRichIconTextView;
    }

    public void setVOIPRichIconTextView(RichIconTextView mVOIPRichIconTextView) {
        this.mVOIPRichIconTextView = mVOIPRichIconTextView;
    }

    public static interface OnRichIconTextViewClickListener {
        public void onImageRichTextClick();

        public void onCameraRichTextClick();

        public void onLocationRichTextClick();

        public void onVoipRichTextClick();

        public void onAddRichTextClick();

        public void isVisibility();
    }

    public static interface ConversationMessageBarListener {
        public void toggleInputMethod(boolean var1, View var2);

        public void sendMessage(String var1);
    }
}

