/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.view;

import android.content.Context;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import io.rong.imkit.adapter.BaseAdapter;
import java.util.List;

public abstract class CompositeAdapter<T>
extends BaseAdapter<T> {
    private static final int ITEM_VIEW_BASE_TYPE = 1;
    private static final String fTag = "CompositeAdapter";
    private Partition<T>[] mPartitions;
    private int mSize = 0;
    private int mCount = 0;
    private boolean mCacheValid = true;
    private boolean mNotificationsEnabled = true;
    private boolean mNotificationNeeded;

    public CompositeAdapter(Context context) {
        super(context);
        this.mContext = context;
    }

    @Override
    public Context getContext() {
        return this.mContext;
    }

    public void addPartition(boolean showIfEmpty, boolean hasHeader, List<T> list, int size) {
        this.addPartition(new Partition<T>(showIfEmpty, hasHeader, list), size);
    }

    public void addPartition(Partition<T> partition, int size) {
        if (this.mPartitions == null || this.mPartitions.length != size) {
            Log.v((String)fTag, (String)("create Partition -------------- mPartitions = " + this.mPartitions));
            this.mPartitions = new Partition[size];
            this.mSize = 0;
        }
        this.mPartitions[this.mSize++] = partition;
        this.invalidate();
        this.notifyDataSetChanged();
    }

    protected Partition<T>[] getPartitions() {
        return this.mPartitions;
    }

    public void removePartition(int partitionIndex) {
        System.arraycopy(this.mPartitions, partitionIndex + 1, this.mPartitions, partitionIndex, this.mSize - partitionIndex - 1);
        --this.mSize;
        this.invalidate();
        this.notifyDataSetChanged();
    }

    public void clearPartitions() {
        if (this.mSize == 0) {
            return;
        }
        for (int i = 0; i < this.mSize; ++i) {
            List list = this.mPartitions[i].list;
            if (list == null) continue;
            list.clear();
            list = null;
            this.mPartitions[i].list = null;
        }
        this.mSize = 0;
        this.invalidate();
        this.notifyDataSetChanged();
    }

    public void setHasHeader(int partitionIndex, boolean flag) {
        this.mPartitions[partitionIndex].hasHeader = flag;
        this.invalidate();
    }

    public void setShowIfEmpty(int partitionIndex, boolean flag) {
        this.mPartitions[partitionIndex].showIfEmpty = flag;
        this.invalidate();
    }

    public Partition<T> getPartition(int partitionIndex) {
        if (partitionIndex >= this.mSize) {
            throw new ArrayIndexOutOfBoundsException(partitionIndex);
        }
        return this.mPartitions[partitionIndex];
    }

    protected void invalidate() {
        this.mCacheValid = false;
    }

    public int getPartitionCount() {
        return this.mSize;
    }

    protected void ensureCacheValid() {
        if (this.mCacheValid) {
            return;
        }
        this.mCount = 0;
        for (int i = 0; i < this.mSize; ++i) {
            int count;
            int n = count = this.mPartitions[i].list != null ? this.mPartitions[i].list.size() : 0;
            if (!this.mPartitions[i].hasHeader || count != 0 || this.mPartitions[i].showIfEmpty) {
                // empty if block
            }
            this.mPartitions[i].count = ++count;
            this.mCount += count;
        }
        this.mCacheValid = true;
    }

    public boolean hasHeader(int partition) {
        return this.mPartitions[partition].hasHeader;
    }

    @Override
    public int getCount() {
        this.ensureCacheValid();
        return this.mCount;
    }

    public List<T> getData(int partition) {
        return this.mPartitions[partition].list;
    }

    public void changeCursor(int partition, List<T> data) {
        this.mPartitions[partition].list = data;
        this.invalidate();
        this.notifyDataSetChanged();
    }

    public boolean isPartitionEmpty(int partition) {
        return this.mPartitions[partition].list == null || this.mPartitions[partition].list.size() == 0;
    }

    public int getPartitionForPosition(int position) {
        this.ensureCacheValid();
        int start = 0;
        for (int i = 0; i < this.mSize; ++i) {
            int end = start + this.mPartitions[i].count;
            if (position >= start && position < end) {
                return i;
            }
            start = end;
        }
        return -1;
    }

    public int getOffsetInPartition(int position) {
        this.ensureCacheValid();
        int start = 0;
        for (int i = 0; i < this.mSize; ++i) {
            int end = start + this.mPartitions[i].count;
            if (position >= start && position < end) {
                int offset = position - start;
                if (this.mPartitions[i].hasHeader) {
                    --offset;
                }
                return offset;
            }
            start = end;
        }
        return -1;
    }

    public int getPositionForPartition(int partition) {
        this.ensureCacheValid();
        int position = 0;
        for (int i = 0; i < partition; ++i) {
            position += this.mPartitions[i].count;
        }
        return position;
    }

    public int getViewTypeCount() {
        return this.getItemViewTypeCount() + 1;
    }

    public int getItemViewTypeCount() {
        return 2;
    }

    protected int getItemViewType(int partition, int position) {
        return 1;
    }

    public int getItemViewType(int position) {
        this.ensureCacheValid();
        int start = 0;
        for (int i = 0; i < this.mSize; ++i) {
            int end = start + this.mPartitions[i].count;
            if (position >= start && position < end) {
                int offset = position - start;
                if (this.mPartitions[i].hasHeader && offset == 0) {
                    return 2;
                }
                return this.getItemViewType(i, position);
            }
            start = end;
        }
        throw new ArrayIndexOutOfBoundsException(position);
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        this.ensureCacheValid();
        int start = 0;
        for (int i = 0; i < this.mSize; ++i) {
            int end = start + this.mPartitions[i].count;
            if (position >= start && position < end) {
                View view;
                int offset = position - start;
                if (this.mPartitions[i].hasHeader) {
                    --offset;
                }
                if ((view = offset == -1 ? this.getHeaderView(i, this.mPartitions[i].list, convertView, parent) : this.getView(i, this.mPartitions[i].list, offset, convertView, parent)) == null) {
                    throw new NullPointerException("View should not be null, partition: " + i + " position: " + offset);
                }
                return view;
            }
            start = end;
        }
        throw new ArrayIndexOutOfBoundsException(position);
    }

    protected View getHeaderView(int partition, List<T> data, View convertView, ViewGroup parent) {
        View view = convertView != null ? convertView : this.newHeaderView(this.mContext, partition, data, parent);
        this.bindHeaderView(view, partition, data);
        return view;
    }

    protected View newHeaderView(Context context, int partition, List<T> data, ViewGroup parent) {
        return null;
    }

    protected void bindHeaderView(View view, int partition, List<T> data) {
    }

    protected View getView(int partition, List<T> data, int position, View convertView, ViewGroup parent) {
        View view = convertView != null ? convertView : this.newView(this.mContext, partition, data, position, parent);
        this.bindView(view, partition, data, position);
        return view;
    }

    protected abstract View newView(Context var1, int var2, List<T> var3, int var4, ViewGroup var5);

    protected abstract void bindView(View var1, int var2, List<T> var3, int var4);

    @Override
    public T getItem(int position) {
        this.ensureCacheValid();
        int start = 0;
        for (int i = 0; i < this.mSize; ++i) {
            int end = start + this.mPartitions[i].count;
            if (position >= start && position < end) {
                int offset = position - start;
                if (this.mPartitions[i].hasHeader) {
                    --offset;
                }
                if (offset == -1) {
                    return null;
                }
                return this.mPartitions[i].list.get(offset);
            }
            start = end;
        }
        return null;
    }

    @Override
    public long getItemId(int position) {
        this.ensureCacheValid();
        int start = 0;
        for (int i = 0; i < this.mSize; ++i) {
            int end = start + this.mPartitions[i].count;
            if (position >= start && position < end) {
                int offset = position - start;
                if (this.mPartitions[i].hasHeader) {
                    --offset;
                }
                if (offset == -1) {
                    return 0L;
                }
                if (this.mPartitions[i].idColumnIndex == -1) {
                    return 0L;
                }
                if (this.mPartitions[i].list == null || this.mPartitions[i].list.size() <= 0) {
                    return 0L;
                }
                return position;
            }
            start = end;
        }
        return 0L;
    }

    public boolean areAllItemsEnabled() {
        for (int i = 0; i < this.mSize; ++i) {
            if (!this.mPartitions[i].hasHeader) continue;
            return false;
        }
        return true;
    }

    public boolean isEnabled(int position) {
        this.ensureCacheValid();
        int start = 0;
        for (int i = 0; i < this.mSize; ++i) {
            int end = start + this.mPartitions[i].count;
            if (position >= start && position < end) {
                int offset = position - start;
                if (this.mPartitions[i].hasHeader && offset == 0) {
                    return false;
                }
                return this.isEnabled(i, offset);
            }
            start = end;
        }
        return false;
    }

    protected boolean isEnabled(int partition, int position) {
        return true;
    }

    public void setNotificationsEnabled(boolean flag) {
        this.mNotificationsEnabled = flag;
        if (flag && this.mNotificationNeeded) {
            this.notifyDataSetChanged();
        }
    }

    public void notifyDataSetChanged() {
        if (this.mNotificationsEnabled) {
            this.mNotificationNeeded = false;
            super.notifyDataSetChanged();
        } else {
            this.mNotificationNeeded = true;
        }
    }

    public static class Partition<T> {
        boolean showIfEmpty;
        boolean hasHeader;
        List<T> list;
        int idColumnIndex;
        int count;

        public Partition(boolean showIfEmpty, boolean hasHeader, List<T> list) {
            this.showIfEmpty = showIfEmpty;
            this.hasHeader = hasHeader;
            this.list = list;
        }

        public boolean getShowIfEmpty() {
            return this.showIfEmpty;
        }

        public boolean getHasHeader() {
            return this.hasHeader;
        }

        public List<T> getList() {
            return this.list;
        }
    }
}

