/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.view;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.view.ViewConfigurationCompat;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import io.rong.imkit.Res;
import io.rong.imkit.view.PageIndicator;

public class CirclePageIndicator
extends View
implements PageIndicator {
    private static final int INVALID_POINTER = -1;
    private float mRadius;
    private final Paint mPaintPageFill = new Paint(1);
    private final Paint mPaintStroke = new Paint(1);
    private final Paint mPaintFill = new Paint(1);
    private ViewPager mViewPager;
    private ViewPager.OnPageChangeListener mListener;
    private int mCurrentPage;
    private int mSnapPage;
    private float mPageOffset;
    private int mScrollState;
    private int mOrientation;
    private boolean mCentered;
    private boolean mSnap;
    private int mTouchSlop;
    private float mLastMotionX = -1.0f;
    private int mActivePointerId = -1;
    private boolean mIsDragging;

    public CirclePageIndicator(Context context) {
        this(context, null);
    }

    public CirclePageIndicator(Context context, AttributeSet attrs) {
        this(context, attrs, Res.getInstance(context).attr("vpiCirclePageIndicatorStyle"));
    }

    public CirclePageIndicator(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        if (this.isInEditMode()) {
            return;
        }
        Resources res = this.getResources();
        int defaultPageColor = res.getColor(Res.getInstance(this.getContext()).color("default_circle_indicator_page_color"));
        int defaultFillColor = res.getColor(Res.getInstance(this.getContext()).color("default_circle_indicator_fill_color"));
        int defaultOrientation = res.getInteger(Res.getInstance(this.getContext()).integer("default_circle_indicator_orientation"));
        int defaultStrokeColor = res.getColor(Res.getInstance(this.getContext()).color("default_circle_indicator_stroke_color"));
        float defaultStrokeWidth = res.getDimension(Res.getInstance(this.getContext()).dimen("default_circle_indicator_stroke_width"));
        float defaultRadius = res.getDimension(Res.getInstance(this.getContext()).dimen("default_circle_indicator_radius"));
        boolean defaultCentered = res.getBoolean(Res.getInstance(this.getContext()).bool("default_circle_indicator_centered"));
        boolean defaultSnap = res.getBoolean(Res.getInstance(this.getContext()).bool("default_circle_indicator_snap"));
        TypedArray a = context.obtainStyledAttributes(attrs, Res.getInstance(this.getContext()).styleables("CirclePageIndicator"), defStyle, 0);
        this.mCentered = a.getBoolean(Res.getInstance(this.getContext()).styleable("CirclePageIndicator_centered_"), defaultCentered);
        this.mOrientation = a.getInt(Res.getInstance(this.getContext()).styleable("CirclePageIndicator_android_orientation"), defaultOrientation);
        this.mPaintPageFill.setStyle(Paint.Style.FILL);
        this.mPaintPageFill.setColor(a.getColor(Res.getInstance(this.getContext()).styleable("CirclePageIndicator_pageColor"), defaultPageColor));
        this.mPaintStroke.setStyle(Paint.Style.STROKE);
        this.mPaintStroke.setColor(a.getColor(Res.getInstance(this.getContext()).styleable("CirclePageIndicator_strokeColor"), defaultStrokeColor));
        this.mPaintStroke.setStrokeWidth(a.getDimension(Res.getInstance(this.getContext()).styleable("CirclePageIndicator_strokeWidth_"), defaultStrokeWidth));
        this.mPaintFill.setStyle(Paint.Style.FILL);
        this.mPaintFill.setColor(a.getColor(Res.getInstance(this.getContext()).styleable("CirclePageIndicator_fillColor"), defaultFillColor));
        this.mRadius = a.getDimension(Res.getInstance(this.getContext()).styleable("CirclePageIndicator_radius_"), defaultRadius);
        this.mSnap = a.getBoolean(Res.getInstance(this.getContext()).styleable("CirclePageIndicator_snap"), defaultSnap);
        Drawable background = a.getDrawable(Res.getInstance(this.getContext()).styleable("CirclePageIndicator_android_background"));
        if (background != null) {
            this.setBackgroundDrawable(background);
        }
        a.recycle();
        ViewConfiguration configuration = ViewConfiguration.get((Context)context);
        this.mTouchSlop = ViewConfigurationCompat.getScaledPagingTouchSlop((ViewConfiguration)configuration);
    }

    public void setCentered(boolean centered) {
        this.mCentered = centered;
        this.invalidate();
    }

    public boolean isCentered() {
        return this.mCentered;
    }

    public void setPageColor(int pageColor) {
        this.mPaintPageFill.setColor(pageColor);
        this.invalidate();
    }

    public int getPageColor() {
        return this.mPaintPageFill.getColor();
    }

    public void setFillColor(int fillColor) {
        this.mPaintFill.setColor(fillColor);
        this.invalidate();
    }

    public int getFillColor() {
        return this.mPaintFill.getColor();
    }

    public void setOrientation(int orientation) {
        switch (orientation) {
            case 0: 
            case 1: {
                this.mOrientation = orientation;
                this.requestLayout();
                break;
            }
            default: {
                throw new IllegalArgumentException("Orientation must be either HORIZONTAL or VERTICAL.");
            }
        }
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    public void setStrokeColor(int strokeColor) {
        this.mPaintStroke.setColor(strokeColor);
        this.invalidate();
    }

    public int getStrokeColor() {
        return this.mPaintStroke.getColor();
    }

    public void setStrokeWidth(float strokeWidth) {
        this.mPaintStroke.setStrokeWidth(strokeWidth);
        this.invalidate();
    }

    public float getStrokeWidth() {
        return this.mPaintStroke.getStrokeWidth();
    }

    public void setRadius(float radius) {
        this.mRadius = radius;
        this.invalidate();
    }

    public float getRadius() {
        return this.mRadius;
    }

    public void setSnap(boolean snap) {
        this.mSnap = snap;
        this.invalidate();
    }

    public boolean isSnap() {
        return this.mSnap;
    }

    protected void onDraw(Canvas canvas) {
        float dY;
        float dX;
        int shortPaddingBefore;
        int longPaddingAfter;
        int longPaddingBefore;
        int longSize;
        super.onDraw(canvas);
        if (this.mViewPager == null) {
            return;
        }
        int count = this.mViewPager.getAdapter().getCount();
        if (count == 0) {
            return;
        }
        if (this.mCurrentPage >= count) {
            this.setCurrentItem(count - 1);
            return;
        }
        if (this.mOrientation == 0) {
            longSize = this.getWidth();
            longPaddingBefore = this.getPaddingLeft();
            longPaddingAfter = this.getPaddingRight();
            shortPaddingBefore = this.getPaddingTop();
        } else {
            longSize = this.getHeight();
            longPaddingBefore = this.getPaddingTop();
            longPaddingAfter = this.getPaddingBottom();
            shortPaddingBefore = this.getPaddingLeft();
        }
        float threeRadius = this.mRadius * 3.0f;
        float shortOffset = (float)shortPaddingBefore + this.mRadius;
        float longOffset = (float)longPaddingBefore + this.mRadius;
        if (this.mCentered) {
            longOffset += (float)(longSize - longPaddingBefore - longPaddingAfter) / 2.0f - (float)count * threeRadius / 2.0f;
        }
        float pageFillRadius = this.mRadius;
        if (this.mPaintStroke.getStrokeWidth() > 0.0f) {
            pageFillRadius -= this.mPaintStroke.getStrokeWidth() / 2.0f;
        }
        for (int iLoop = 0; iLoop < count; ++iLoop) {
            float drawLong = longOffset + (float)iLoop * threeRadius;
            if (this.mOrientation == 0) {
                dX = drawLong;
                dY = shortOffset;
            } else {
                dX = shortOffset;
                dY = drawLong;
            }
            if (this.mPaintPageFill.getAlpha() > 0) {
                canvas.drawCircle(dX, dY, pageFillRadius, this.mPaintPageFill);
            }
            if (pageFillRadius == this.mRadius) continue;
            canvas.drawCircle(dX, dY, this.mRadius, this.mPaintStroke);
        }
        float cx = (float)(this.mSnap ? this.mSnapPage : this.mCurrentPage) * threeRadius;
        if (!this.mSnap) {
            cx += this.mPageOffset * threeRadius;
        }
        if (this.mOrientation == 0) {
            dX = longOffset + cx;
            dY = shortOffset;
        } else {
            dX = shortOffset;
            dY = longOffset + cx;
        }
        canvas.drawCircle(dX, dY, this.mRadius, this.mPaintFill);
    }

    public boolean onTouchEvent(MotionEvent ev) {
        return true;
    }

    @Override
    public void setViewPager(ViewPager view) {
        if (this.mViewPager == view) {
            return;
        }
        if (this.mViewPager != null) {
            this.mViewPager.setOnPageChangeListener(null);
        }
        if (view.getAdapter() == null) {
            throw new IllegalStateException("ViewPager does not have adapter instance.");
        }
        this.mViewPager = view;
        this.mViewPager.setOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        this.invalidate();
    }

    @Override
    public void setViewPager(ViewPager view, int initialPosition) {
        this.setViewPager(view);
        this.setCurrentItem(initialPosition);
    }

    @Override
    public void setCurrentItem(int item) {
        if (this.mViewPager == null) {
            throw new IllegalStateException("ViewPager has not been bound.");
        }
        this.mViewPager.setCurrentItem(item);
        this.mCurrentPage = item;
        this.invalidate();
    }

    @Override
    public void notifyDataSetChanged() {
        this.invalidate();
    }

    public void onPageScrollStateChanged(int state) {
        this.mScrollState = state;
        if (this.mListener != null) {
            this.mListener.onPageScrollStateChanged(state);
        }
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        this.mCurrentPage = position;
        this.mPageOffset = positionOffset;
        this.invalidate();
        if (this.mListener != null) {
            this.mListener.onPageScrolled(position, positionOffset, positionOffsetPixels);
        }
    }

    public void onPageSelected(int position) {
        if (this.mSnap || this.mScrollState == 0) {
            this.mCurrentPage = position;
            this.mSnapPage = position;
            this.invalidate();
        }
        if (this.mListener != null) {
            this.mListener.onPageSelected(position);
        }
    }

    @Override
    public void setOnPageChangeListener(ViewPager.OnPageChangeListener listener) {
        this.mListener = listener;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mOrientation == 0) {
            this.setMeasuredDimension(this.measureLong(widthMeasureSpec), this.measureShort(heightMeasureSpec));
        } else {
            this.setMeasuredDimension(this.measureShort(widthMeasureSpec), this.measureLong(heightMeasureSpec));
        }
    }

    private int measureLong(int measureSpec) {
        int result;
        int specMode = View.MeasureSpec.getMode((int)measureSpec);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        if (specMode == 0x40000000 || this.mViewPager == null) {
            result = specSize;
        } else {
            int count = this.mViewPager.getAdapter().getCount();
            result = (int)((float)(this.getPaddingLeft() + this.getPaddingRight()) + (float)(count * 2) * this.mRadius + (float)(count - 1) * this.mRadius + 1.0f);
            if (specMode == Integer.MIN_VALUE) {
                result = Math.min(result, specSize);
            }
        }
        return result;
    }

    private int measureShort(int measureSpec) {
        int result;
        int specMode = View.MeasureSpec.getMode((int)measureSpec);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        if (specMode == 0x40000000) {
            result = specSize;
        } else {
            result = (int)(2.0f * this.mRadius + (float)this.getPaddingTop() + (float)this.getPaddingBottom() + 1.0f);
            if (specMode == Integer.MIN_VALUE) {
                result = Math.min(result, specSize);
            }
        }
        return result;
    }

    public void onRestoreInstanceState(Parcelable state) {
        SavedState savedState = (SavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.mCurrentPage = savedState.currentPage;
        this.mSnapPage = savedState.currentPage;
        this.requestLayout();
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState savedState = new SavedState(superState);
        savedState.currentPage = this.mCurrentPage;
        return savedState;
    }

    static class SavedState
    extends View.BaseSavedState {
        int currentPage;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.currentPage = in.readInt();
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.currentPage);
        }
    }
}

