/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Parcelable;
import android.util.AttributeSet;
import com.sea_monster.core.common.BackgroundThread;
import com.sea_monster.core.resource.ResourceManager;
import com.sea_monster.core.resource.model.CompressedResource;
import com.sea_monster.core.resource.model.Resource;
import io.rong.imkit.Res;
import io.rong.imkit.view.CircleBitmapDrawable;
import io.rong.imlib.RongIMClient;
import io.rong.message.ImageMessage;
import io.rong.message.LocationMessage;
import java.lang.ref.WeakReference;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import uk.co.senab.bitmapcache.CacheableImageView;

public class AsyncImageView
extends CacheableImageView
implements Observer {
    static final ExecutorService mMultiThreadExecutor;
    static final boolean DEBUG = true;
    static final String TAG = "AsyncImageView";
    Resource mResource;
    Future<?> mCurrentRunnable;
    Drawable mDefaultDrawable;
    Runnable mAttachedRunnable;
    static final int STATUS_DISPLAY = 1;
    static final int STATUS_EMPTY = 0;
    boolean isAttached;
    private boolean isCircle;
    private int status;

    @Override
    public void update(Observable observable, Object data) {
        Resource resource;
        if (this.mResource instanceof Resource) {
            Resource resource2 = (Resource)data;
            if (data.equals(resource2) || data.equals(resource2.getOrientaion())) {
                this.post(new Runnable(){

                    @Override
                    public void run() {
                        AsyncImageView.this.refreshResouce();
                    }
                });
            }
        } else if (this.mResource instanceof CompressedResource && (data.equals(resource = ((CompressedResource)data).getOriResource()) || data.equals(resource.getOrientaion()))) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    AsyncImageView.this.refreshResouce();
                }
            });
        }
    }

    public AsyncImageView(Context context) {
        super(context);
    }

    public AsyncImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, Res.getInstance(context).styleables(TAG));
        int resId = a.getResourceId(Res.getInstance(context).styleable("AsyncImageView_defDrawable"), 0);
        int shape = a.getInt(Res.getInstance(context).styleable("AsyncImageView_shape"), 0);
        boolean bl = this.isCircle = shape == 1;
        if (resId != 0) {
            this.mDefaultDrawable = this.getResources().getDrawable(resId);
        }
        a.recycle();
    }

    public Resource getResource() {
        return this.mResource;
    }

    public void setDefaultDrawable(Drawable defaultDrawable) {
        if (defaultDrawable == null) {
            this.mDefaultDrawable = null;
            return;
        }
        this.mDefaultDrawable = this.isCircle && defaultDrawable instanceof BitmapDrawable ? new CircleBitmapDrawable(this.getResources(), ((BitmapDrawable)defaultDrawable).getBitmap()) : defaultDrawable;
    }

    @Override
    public void setImageDrawable(Drawable drawable2) {
        if (this.isCircle && drawable2 instanceof BitmapDrawable) {
            super.setImageDrawable(new CircleBitmapDrawable(this.getResources(), ((BitmapDrawable)drawable2).getBitmap()));
        } else {
            super.setImageDrawable(drawable2);
        }
    }

    public void setResource(RongIMClient.Message message) {
        if (message == null || message.getContent() == null) {
            this.clean();
            return;
        }
        if (message.getContent() instanceof ImageMessage && ((ImageMessage)message.getContent()).getThumUri() != null) {
            Uri uri = AsyncImageView.obtainThumImageUri(this.getContext(), message);
            this.setResource(new Resource(uri));
        } else if (message.getContent() instanceof LocationMessage && ((LocationMessage)message.getContent()).getImgUri() != null) {
            Uri uri = AsyncImageView.obtainLocationUri(this.getContext(), message);
            this.setResource(new Resource(uri));
        }
    }

    private static Uri obtainThumImageUri(Context context, RongIMClient.Message message) {
        Uri uri = Uri.parse((String)("rong://" + context.getPackageName())).buildUpon().appendPath("image").appendPath("thum").appendPath(String.valueOf(message.getMessageId())).appendPath(message.getSenderUserId()).build();
        return uri;
    }

    private static Uri obtainLocationUri(Context context, RongIMClient.Message message) {
        Uri uri = Uri.parse((String)("rong://" + context.getPackageName())).buildUpon().appendPath("location").appendPath(String.valueOf(message.getMessageId())).appendPath(message.getSenderUserId()).build();
        return uri;
    }

    public void clean() {
        this.mResource = null;
        this.status = 0;
        this.setImageDrawable(this.mDefaultDrawable);
    }

    public void setResource(Resource resource) {
        Resource previous = this.getResource();
        this.mResource = resource;
        if (this.mResource == null) {
            this.status = 0;
            this.setImageDrawable(this.mDefaultDrawable);
            return;
        }
        if (!this.mResource.equals(previous)) {
            this.status = 0;
        }
        if (this.status == 0) {
            this.mAttachedRunnable = null;
            this.cancelRequest();
            if (this.mResource != null && this.mResource.getUri() != null && ResourceManager.getInstance().containsInMemoryCache(this.mResource)) {
                BitmapDrawable drawable2 = ResourceManager.getInstance().getDrawableCache(this.mResource);
                if (drawable2 != null && drawable2.getBitmap() != null) {
                    if (this.isCircle) {
                        this.setImageDrawable(new CircleBitmapDrawable(this.getResources(), drawable2.getBitmap()));
                    } else {
                        this.setImageDrawable((Drawable)drawable2);
                        this.invalidate();
                    }
                    this.status = 1;
                } else {
                    this.setImageDrawable(this.mDefaultDrawable);
                }
            } else {
                this.mCurrentRunnable = mMultiThreadExecutor.submit(new PhotoLoadRunnable(this, ResourceManager.getInstance(), this.mResource));
            }
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        ResourceManager.getInstance().deleteObserver(this);
        this.cancelRequest();
        super.onDetachedFromWindow();
        this.isAttached = false;
        this.mAttachedRunnable = null;
    }

    protected Parcelable onSaveInstanceState() {
        return super.onSaveInstanceState();
    }

    protected void onAttachedToWindow() {
        ResourceManager.getInstance().addObserver(this);
        super.onAttachedToWindow();
        this.isAttached = true;
        if (this.mAttachedRunnable != null) {
            this.mAttachedRunnable.run();
            this.mAttachedRunnable = null;
        }
    }

    public void cancelRequest() {
        if (null != this.mCurrentRunnable) {
            this.mCurrentRunnable.cancel(true);
            this.mCurrentRunnable = null;
        }
    }

    public void refreshResouce() {
        this.setResource(this.mResource);
    }

    static {
        int coreNum = Math.round(Runtime.getRuntime().availableProcessors());
        int threadNum = 1;
        switch (coreNum) {
            case 1: {
                threadNum = coreNum;
                break;
            }
            case 2: {
                threadNum = coreNum;
                break;
            }
            default: {
                threadNum = 3;
            }
        }
        mMultiThreadExecutor = Executors.newFixedThreadPool(threadNum, new PhotoThreadFactory());
    }

    static final class PhotoLoadRunnable
    extends BackgroundThread {
        private final WeakReference<AsyncImageView> mImageView;
        private final ResourceManager mManager;
        private final Resource mResource;

        public PhotoLoadRunnable(AsyncImageView imageView, ResourceManager manager, Resource resource) {
            this.mImageView = new WeakReference<AsyncImageView>(imageView);
            this.mManager = manager;
            this.mResource = resource;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void runImpl() {
            final AsyncImageView imageView = (AsyncImageView)this.mImageView.get();
            if (null == imageView) {
                return;
            }
            BitmapDrawable diskDrawable = null;
            Resource resource = this.mResource;
            synchronized (resource) {
                diskDrawable = this.mManager.getDrawable(this.mResource);
            }
            if (diskDrawable != null && diskDrawable.getBitmap() != null) {
                BitmapDrawable drawable2;
                if (imageView.status == 0 && imageView.getResource().equals(this.mResource)) {
                    drawable2 = diskDrawable;
                    imageView.post(new Runnable(){

                        @Override
                        public void run() {
                            if (imageView.getResource() == null || !imageView.getResource().equals(PhotoLoadRunnable.this.mResource)) {
                                return;
                            }
                            if (imageView.isCircle) {
                                imageView.setImageDrawable(new CircleBitmapDrawable(imageView.getResources(), drawable2.getBitmap()));
                            } else {
                                imageView.setImageDrawable((Drawable)drawable2);
                            }
                            imageView.status = 1;
                        }
                    });
                } else {
                    drawable2 = diskDrawable;
                    imageView.mAttachedRunnable = new Runnable(){

                        @Override
                        public void run() {
                            if (imageView.getResource() == null || !imageView.getResource().equals(PhotoLoadRunnable.this.mResource)) {
                                return;
                            }
                            if (imageView.isCircle) {
                                imageView.setImageDrawable(new CircleBitmapDrawable(imageView.getResources(), drawable2.getBitmap()));
                            } else {
                                imageView.setImageDrawable((Drawable)drawable2);
                            }
                            imageView.status = 1;
                        }
                    };
                }
            } else if (imageView.isAttached) {
                imageView.post(new Runnable(){

                    @Override
                    public void run() {
                        imageView.setImageDrawable(imageView.mDefaultDrawable);
                    }
                });
            } else {
                imageView.mAttachedRunnable = new Runnable(){

                    @Override
                    public void run() {
                        imageView.setImageDrawable(imageView.mDefaultDrawable);
                    }
                };
            }
        }
    }

    static final class PhotoThreadFactory
    implements ThreadFactory {
        private final String mThreadName;

        public PhotoThreadFactory(String threadName) {
            this.mThreadName = threadName;
        }

        public PhotoThreadFactory() {
            this("Photo");
        }

        @Override
        public Thread newThread(Runnable r) {
            if (null != this.mThreadName) {
                return new Thread(r, this.mThreadName);
            }
            return new Thread(r);
        }
    }
}

