/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.view;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.widget.TextView;
import io.rong.imkit.view.gif.GifDrawable;
import java.lang.ref.SoftReference;

public class AnimationTextView
extends TextView {
    private static final String TAG = "AnimationTextView";
    private GifDrawable mDrawable;
    private static AnimationHandler mHandler;

    public AnimationTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public AnimationTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public AnimationTextView(Context context) {
        super(context);
    }

    protected boolean verifyDrawable(Drawable who) {
        return this.mDrawable == who;
    }

    public void startGifAnimation() {
        this.setNextFrame();
    }

    private void setNextFrame() {
        if (null == this.mDrawable || !this.mDrawable.isOnStarted() || this.mDrawable.getAnimationView().size() <= 0) {
            return;
        }
        if (null == mHandler) {
            mHandler = new AnimationHandler();
        }
        Message message = mHandler.obtainMessage();
        message.what = this.mDrawable.hashCode();
        AnimationHolder holder = new AnimationHolder();
        holder.textView = this;
        holder.gifDrawable = this.mDrawable;
        message.obj = holder;
        mHandler.sendMessageAtTime(message, SystemClock.uptimeMillis() + (long)this.mDrawable.getDuration(0));
    }

    public GifDrawable getGifDrawable() {
        return this.mDrawable;
    }

    public void seGifDrawable(GifDrawable gifDrawable) {
        this.mDrawable = gifDrawable;
    }

    private class AnimationHolder {
        AnimationTextView textView;
        GifDrawable gifDrawable;

        private AnimationHolder() {
        }
    }

    public static class AnimationHandler
    extends Handler {
        public void handleMessage(Message msg) {
            AnimationHolder holder = (AnimationHolder)msg.obj;
            this.removeMessages(holder.gifDrawable.hashCode());
            holder.gifDrawable.ChangeToNextFrame();
            for (SoftReference<AnimationTextView> reference : holder.gifDrawable.getAnimationView()) {
                if (null == reference.get()) continue;
                reference.get().invalidateDrawable((Drawable)holder.gifDrawable);
            }
            holder.textView.setNextFrame();
        }
    }
}

