/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import io.rong.imkit.Res;
import java.util.ArrayList;
import java.util.List;

public class ActionBar
extends RelativeLayout {
    private List<View> mAddView;
    private ImageView mBackView;
    private ImageView mLogoView;
    private TextView mTitleView;
    private TextView mNewMessageView;
    private ViewGroup mTitleLayout;
    int mLastAddId;
    List<View> mAddChilds = new ArrayList<View>();

    public ActionBar(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView(context);
        this.mAddView = new ArrayList<View>();
    }

    public ActionBar(Context context) {
        super(context);
        this.initView(context);
        this.mAddView = new ArrayList<View>();
    }

    public ActionBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
        this.mAddView = new ArrayList<View>();
    }

    private void initView(Context context) {
        LayoutInflater.from((Context)context).inflate(Res.getInstance(this.getContext()).layout("rc_action_bar"), (ViewGroup)this);
        this.mBackView = (ImageView)this.findViewById(Res.getInstance(this.getContext()).id("rc_back"));
        this.mLogoView = (ImageView)this.findViewById(Res.getInstance(this.getContext()).id("rc_logo"));
        this.mTitleView = (TextView)this.findViewById(Res.getInstance(this.getContext()).id("rc_title"));
        this.mNewMessageView = (TextView)this.findViewById(Res.getInstance(this.getContext()).id("rc_new"));
        this.mTitleLayout = (ViewGroup)this.findViewById(Res.getInstance(this.getContext()).id("rc_title_layout"));
    }

    public void recycle() {
        if (this.mAddView != null) {
            for (View view : this.mAddView) {
                this.removeView(view);
            }
        }
        this.mLastAddId = 0;
        this.mAddView.clear();
    }

    public void addView(View child) {
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)child.getLayoutParams();
        params.addRule(15);
        params.addRule(11);
        super.addView(child);
    }

    public TextView getTitleTextView() {
        return this.mTitleView;
    }

    public TextView getNewMessageView() {
        return this.mNewMessageView;
    }

    public ImageView getLogoView() {
        return this.mLogoView;
    }

    public ImageView getBackView() {
        return this.mBackView;
    }

    public void setOnBackClick(View.OnClickListener listener) {
        this.mBackView.setOnClickListener(listener);
        this.mTitleLayout.setOnClickListener(listener);
    }
}

