/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.utils;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.drawable.Drawable;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.media.ExifInterface;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Process;
import android.os.Vibrator;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.text.style.ImageSpan;
import android.text.style.URLSpan;
import android.util.Base64;
import android.util.Log;
import io.rong.imkit.RCloudContext;
import io.rong.imkit.Res;
import io.rong.imkit.common.RongConst;
import io.rong.imkit.model.HighLightFlag;
import io.rong.imkit.model.HightLightContent;
import io.rong.imkit.utils.FileUtil;
import io.rong.imkit.view.MentionsIntentSpan;
import io.rong.imkit.view.gif.EmotionParser;
import io.rong.imlib.RongIMClient;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.security.Key;
import java.security.SecureRandom;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;

@SuppressLint(value={"SimpleDateFormat"})
public class Util {
    private static final String TAG = "Util";
    private static final char SPLIT = ',';
    private static final SimpleDateFormat timeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    static HashMap<Integer, String> codeHashMap = null;

    public static Location getLat(Context context, LocationListener listener) {
        LocationManager locMan = (LocationManager)context.getSystemService("location");
        Location location = locMan.getLastKnownLocation("gps");
        if (location == null) {
            location = locMan.getLastKnownLocation("network");
        }
        return location;
    }

    public static SpannableStringBuilder highLight(HightLightContent content) {
        if (content == null || content.getContent() == null || content.getContent().length() == 0) {
            return new SpannableStringBuilder();
        }
        SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder((CharSequence)content.getContent());
        if (content.getFlags() != null) {
            for (HighLightFlag item : content.getFlags()) {
                if (item.getTitle().startsWith("[")) {
                    Drawable drawable2 = EmotionParser.getInstance((Context)RCloudContext.getInstance()).getSmileDrawable(item.getTitle());
                    if (drawable2 == null) continue;
                    if (1 == content.getTypeFlag()) {
                        spannableStringBuilder.setSpan((Object)new ImageSpan(drawable2, 0), item.getStart(), item.getEnd(), 33);
                        continue;
                    }
                    spannableStringBuilder.setSpan((Object)new ImageSpan(drawable2, 1), item.getStart(), item.getEnd(), 33);
                    continue;
                }
                spannableStringBuilder.setSpan((Object)new ForegroundColorSpan(-1164226), item.getStart(), item.getEnd(), 34);
            }
        }
        return spannableStringBuilder;
    }

    public static SpannableStringBuilder highLightLink(HightLightContent content) {
        if (content == null || content.getContent() == null || content.getContent().length() == 0) {
            return new SpannableStringBuilder();
        }
        SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder((CharSequence)content.getContent());
        if (content.getFlags() != null) {
            for (HighLightFlag item : content.getFlags()) {
                String url;
                if (item.getTitle().startsWith("@")) {
                    spannableStringBuilder.setSpan((Object)new MentionsIntentSpan(item.getUrl().replace(RongConst.API.HOST, "").trim()), item.getStart(), item.getEnd(), 34);
                    continue;
                }
                if (item.getTitle().startsWith("#")) {
                    url = Util.getUrlWithAuth(item.getUrl(), (Context)RCloudContext.getInstance());
                    if (TextUtils.isEmpty((CharSequence)url)) {
                        spannableStringBuilder.setSpan((Object)new ForegroundColorSpan(-1164226), item.getStart(), item.getEnd(), 34);
                        continue;
                    }
                    spannableStringBuilder.setSpan((Object)new URLSpan(url), item.getStart(), item.getEnd(), 34);
                    continue;
                }
                if (item.getUrl().startsWith("http://") || item.getUrl().startsWith("www.")) {
                    url = null;
                    url = item.getUrl().startsWith("www.") ? "http://" + item.getUrl() : item.getUrl();
                    if (TextUtils.isEmpty((CharSequence)url)) {
                        spannableStringBuilder.setSpan((Object)new ForegroundColorSpan(-1164226), item.getStart(), item.getEnd(), 34);
                        continue;
                    }
                    spannableStringBuilder.setSpan((Object)new URLSpan(url), item.getStart(), item.getEnd(), 34);
                    continue;
                }
                if (item.getTitle().startsWith("[")) {
                    Drawable drawable2 = EmotionParser.getInstance((Context)RCloudContext.getInstance()).getSmileDrawable(item.getTitle());
                    if (drawable2 == null) continue;
                    if (1 == content.getTypeFlag()) {
                        spannableStringBuilder.setSpan((Object)new ImageSpan(drawable2, 1), item.getStart(), item.getEnd(), 33);
                        continue;
                    }
                    spannableStringBuilder.setSpan((Object)new ImageSpan(drawable2, 0), item.getStart(), item.getEnd(), 33);
                    continue;
                }
                spannableStringBuilder.setSpan((Object)new ForegroundColorSpan(-1164226), item.getStart(), item.getEnd(), 34);
            }
        }
        return spannableStringBuilder;
    }

    public static String getUrlWithAuth(String url, Context context) {
        if (url == null || url.length() == 0) {
            return null;
        }
        URI uri = URI.create(url);
        if (uri == null || uri.getHost() == null) {
            return null;
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isGIFImage(String filePath) {
        byte[] imageHearByte = new byte[28];
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(filePath);
            ((InputStream)inputStream).read(imageHearByte, 0, 28);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        String picType = Util.bytesToHexString(imageHearByte);
        return picType.startsWith("47494638");
    }

    public static boolean isGIFImage(InputStream inputStream) {
        if (inputStream == null) {
            return false;
        }
        byte[] imageHearByte = new byte[28];
        try {
            inputStream.read(imageHearByte, 0, 28);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        String picType = Util.bytesToHexString(imageHearByte);
        return picType.startsWith("47494638");
    }

    public static boolean isGIFImage(byte[] imgData) {
        if (imgData == null || imgData.length == 0) {
            return false;
        }
        byte[] imageHearByte = new byte[28];
        System.arraycopy(imgData, 0, imageHearByte, 0, 28);
        String picType = Util.bytesToHexString(imageHearByte);
        return picType.startsWith("47494638");
    }

    public static String bytesToHexString(byte[] bytes) {
        if (bytes == null || bytes.length <= 0) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            int intValue = bytes[i] & 0xFF;
            String hexValue = Integer.toHexString(intValue);
            if (hexValue.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hexValue);
        }
        return stringBuilder.toString().toUpperCase();
    }

    public static void shake(long milliseconds, Context context) {
        Vibrator vVi = (Vibrator)context.getSystemService("vibrator");
        vVi.vibrate(milliseconds);
        vVi.vibrate(new long[]{200L, 200L, 1000L}, -1);
    }

    public static int calculateLength(String arg) {
        if (arg == null || "".equals(arg)) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < arg.length(); ++i) {
            if (Util.isChinese(arg.charAt(i))) {
                count += 2;
                continue;
            }
            ++count;
        }
        return count;
    }

    public static String getTwentyCharNickName(String arg) {
        if (!TextUtils.isEmpty((CharSequence)arg) && Util.calculateLength(arg) > 20) {
            int length = 0;
            for (int i = 0; i < arg.length(); ++i) {
                length = Util.isChinese(arg.charAt(i)) ? (length += 2) : ++length;
                if (length == 20) {
                    return arg.substring(0, i + 1);
                }
                if (length < 21) continue;
                return arg.substring(0, i);
            }
        }
        return arg;
    }

    public static boolean isChinese(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION;
    }

    public static boolean isChinese(String arg) {
        Pattern pattern = Pattern.compile("[\\u4e00-\\u9fa5]");
        Matcher matcher = pattern.matcher(arg);
        return matcher.find();
    }

    public static int getNetWorkType(Context context) {
        try {
            NetworkInfo networkInfo;
            ConnectivityManager connManager = (ConnectivityManager)context.getSystemService("connectivity");
            if (connManager != null && (networkInfo = connManager.getActiveNetworkInfo()) != null) {
                return networkInfo.getType();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    public static byte[] desEncrypt(byte[] datasource, String key) {
        try {
            SecureRandom random = new SecureRandom();
            DESKeySpec desKey = new DESKeySpec(key.getBytes());
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
            SecretKey securekey = keyFactory.generateSecret(desKey);
            Cipher cipher = Cipher.getInstance("DES");
            cipher.init(1, (Key)securekey, random);
            return Base64.encode((byte[])cipher.doFinal(datasource), (int)0);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] desDecrypt(byte[] datasource, String key) {
        try {
            byte[] base64Data = Base64.decode((byte[])datasource, (int)0);
            SecureRandom random = new SecureRandom();
            DESKeySpec desKey = new DESKeySpec(key.getBytes());
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
            SecretKey securekey = keyFactory.generateSecret(desKey);
            Cipher cipher = Cipher.getInstance("DES");
            cipher.init(2, (Key)securekey, random);
            return cipher.doFinal(base64Data);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> String listToString(List<T> list, char split) {
        StringBuilder buffer = new StringBuilder();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            buffer.append(list.get(i));
            buffer.append(split);
        }
        buffer.deleteCharAt(buffer.length() - 1);
        return buffer.toString();
    }

    public static <T> String listToString(List<T> list) {
        return Util.listToString(list, ',');
    }

    public static int strLength(String value) {
        if (TextUtils.isEmpty((CharSequence)value)) {
            return 0;
        }
        int valueLength = 0;
        String chinese = "[\u0391-\uffe5]";
        for (int i = 0; i < value.length(); ++i) {
            String temp = value.substring(i, i + 1);
            if (temp.matches(chinese)) {
                valueLength += 2;
                continue;
            }
            ++valueLength;
        }
        return valueLength;
    }

    public static String getCrrentDateTime() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(new Date());
    }

    public static String getImageKeyFileName(String imageKey) {
        String fileName = null;
        if (!TextUtils.isEmpty((CharSequence)imageKey) && imageKey.lastIndexOf("/") != -1) {
            fileName = imageKey.substring(imageKey.lastIndexOf("/") + 1);
        }
        return fileName;
    }

    public static void saveDataToDir(File file, byte[] data) throws IOException {
        FileOutputStream stream = new FileOutputStream(file);
        stream.write(data);
        stream.flush();
        stream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getByteFromUri(Context context, Uri uri) {
        InputStream input = null;
        try {
            input = context.getContentResolver().openInputStream(uri);
            int count = 0;
            while (count == 0 && (count = input.available()) != 0) {
            }
            byte[] bytes = new byte[count];
            input.read(bytes);
            byte[] byArray = bytes;
            return byArray;
        }
        catch (Exception e) {
            Log.d((String)"getByteFromUri", (String)e.getMessage(), (Throwable)e);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    Log.d((String)"getByteFromUri", (String)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap getResizedBitmap(Context context, Uri uri, int quality, int widthLimit, int heightLimit) {
        BitmapFactory.Options opt = Util.decodeBitmapOptionsInfo(context, uri);
        int outSize = opt.outWidth > opt.outHeight ? opt.outWidth : opt.outHeight;
        int s = 1;
        while (outSize / s > widthLimit) {
            ++s;
        }
        Log.d((String)TAG, (String)String.format("OUTPUT: x:%1$s  y:%2$s", String.valueOf(opt.outWidth / s), String.valueOf(opt.outHeight / s)));
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inSampleSize = s;
        options.inPreferredConfig = Bitmap.Config.ARGB_8888;
        options.inJustDecodeBounds = false;
        InputStream input = null;
        try {
            input = context.getContentResolver().openInputStream(uri);
            Bitmap b = BitmapFactory.decodeStream((InputStream)input, null, (BitmapFactory.Options)options);
            String path = uri.getPath();
            if (!TextUtils.isEmpty((CharSequence)path)) {
                b = Util.rotateBitMap(path, b);
            }
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            b.compress(Bitmap.CompressFormat.PNG, quality, (OutputStream)os);
            Bitmap bitmap = b;
            return bitmap;
        }
        catch (Exception e) {
            if (input == null) {
                input = FileUtil.getFileInputStream(uri.getPath());
            }
            Bitmap b = BitmapFactory.decodeStream((InputStream)input, null, (BitmapFactory.Options)options);
            String path = uri.getPath();
            if (!TextUtils.isEmpty((CharSequence)path)) {
                b = Util.rotateBitMap(path, b);
            }
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            b.compress(Bitmap.CompressFormat.PNG, quality, (OutputStream)os);
            Bitmap bitmap = b;
            return bitmap;
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getResizedImageData(Context context, Uri uri, int quality, int widthLimit, int heightLimit) {
        BitmapFactory.Options opt = Util.decodeBitmapOptionsInfo(context, uri);
        int outSize = opt.outWidth > opt.outHeight ? opt.outWidth : opt.outHeight;
        int s = 1;
        while (outSize / s > widthLimit) {
            ++s;
        }
        Log.d((String)TAG, (String)String.format("OUTPUT: x:%1$s  y:%2$s", String.valueOf(opt.outWidth / s), String.valueOf(opt.outHeight / s)));
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inSampleSize = s;
        options.inPreferredConfig = Bitmap.Config.ARGB_8888;
        options.inJustDecodeBounds = false;
        InputStream input = null;
        try {
            input = context.getContentResolver().openInputStream(uri);
            Bitmap b = BitmapFactory.decodeStream((InputStream)input, null, (BitmapFactory.Options)options);
            String path = uri.getPath();
            if (!TextUtils.isEmpty((CharSequence)path)) {
                b = Util.rotateBitMap(path, b);
            }
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            b.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)os);
            b.recycle();
            byte[] byArray = os.toByteArray();
            return byArray;
        }
        catch (FileNotFoundException e) {
            if (input == null) {
                input = FileUtil.getFileInputStream(uri.getPath());
            }
            Bitmap b = BitmapFactory.decodeStream((InputStream)input, null, (BitmapFactory.Options)options);
            String path = uri.getPath();
            if (!TextUtils.isEmpty((CharSequence)path)) {
                b = Util.rotateBitMap(path, b);
            }
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            b.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)os);
            b.recycle();
            byte[] byArray = os.toByteArray();
            return byArray;
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BitmapFactory.Options decodeBitmapOptionsInfo(Context context, Uri uri) {
        InputStream input = null;
        BitmapFactory.Options opt = new BitmapFactory.Options();
        try {
            input = context.getContentResolver().openInputStream(uri);
            opt.inJustDecodeBounds = true;
            opt.inPreferredConfig = Bitmap.Config.ARGB_8888;
            BitmapFactory.decodeStream((InputStream)input, null, (BitmapFactory.Options)opt);
            BitmapFactory.Options options = opt;
            return options;
        }
        catch (FileNotFoundException e) {
            if (input == null) {
                input = FileUtil.getFileInputStream(uri.getPath());
            }
            opt.inJustDecodeBounds = true;
            opt.inPreferredConfig = Bitmap.Config.ARGB_8888;
            BitmapFactory.decodeStream((InputStream)input, null, (BitmapFactory.Options)opt);
            BitmapFactory.Options options = opt;
            return options;
        }
        finally {
            if (null != input) {
                try {
                    input.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static Bitmap getRotateBitmap(float degrees, Bitmap bm) {
        int bmpW = bm.getWidth();
        int bmpH = bm.getHeight();
        Matrix mt = new Matrix();
        mt.setRotate(degrees);
        return Bitmap.createBitmap((Bitmap)bm, (int)0, (int)0, (int)bmpW, (int)bmpH, (Matrix)mt, (boolean)true);
    }

    private static Bitmap rotateBitMap(String srcFilePath, Bitmap bitmap) {
        ExifInterface exif = null;
        try {
            exif = new ExifInterface(srcFilePath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        float degree = 0.0f;
        if (exif != null) {
            switch (exif.getAttributeInt("Orientation", 0)) {
                case 6: {
                    degree = 90.0f;
                    break;
                }
                case 3: {
                    degree = 180.0f;
                    break;
                }
                case 8: {
                    degree = 270.0f;
                    break;
                }
            }
        }
        if (degree != 0.0f) {
            Matrix matrix = new Matrix();
            matrix.setRotate(degree, (float)bitmap.getWidth(), (float)bitmap.getHeight());
            Bitmap b2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
            if (b2 != null && bitmap != b2) {
                bitmap.recycle();
                bitmap = b2;
            }
        }
        return bitmap;
    }

    public static Date strTODate(String dateStr) {
        if (dateStr == null || dateStr.length() == 0) {
            return null;
        }
        Date date = null;
        try {
            date = timeFormat.parse(dateStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public static String dateToStr(Date date) {
        if (date == null) {
            return null;
        }
        return timeFormat.format(date);
    }

    public static int dipTopx(Context context, float dipValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dipValue * scale + 0.5f);
    }

    public static int pxTodip(Context context, float pxValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(pxValue / scale + 0.5f);
    }

    public static int dip2px(Context context, float dipValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dipValue * scale + 0.5f);
    }

    public static int px2dip(Context context, float pxValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(pxValue / scale + 0.5f);
    }

    public static Uri obtainThumImageUri(Context context, RongIMClient.Message message) {
        Uri uri = Uri.parse((String)("rong://" + context.getPackageName())).buildUpon().appendPath("image").appendPath("thum").appendPath(String.valueOf(message.getMessageId())).appendPath(message.getSenderUserId()).build();
        return uri;
    }

    public static Uri obtainVoiceUri(Context context, RongIMClient.Message message) {
        Uri uri = Uri.parse((String)("rong://" + context.getPackageName())).buildUpon().appendPath("voice").appendPath(String.valueOf(message.getMessageId())).appendPath(message.getSenderUserId()).build();
        return uri;
    }

    public static String getCurProcessName(Context context) {
        int pid = Process.myPid();
        ActivityManager mActivityManager = (ActivityManager)context.getSystemService("activity");
        for (ActivityManager.RunningAppProcessInfo appProcess : mActivityManager.getRunningAppProcesses()) {
            if (appProcess.pid != pid) continue;
            return appProcess.processName;
        }
        return null;
    }

    public static String replaceEmoji(String input) {
        Util.initCodeHashMap();
        StringBuilder result = new StringBuilder();
        int[] codePoints = Util.toCodePointArray(input);
        for (int i = 0; i < codePoints.length; ++i) {
            if (codeHashMap.containsKey(codePoints[i])) {
                String value = codeHashMap.get(codePoints[i]);
                if (value == null) continue;
                result.append(value);
                continue;
            }
            result.append(Character.toChars(codePoints[i]));
        }
        return result.toString();
    }

    static final void initCodeHashMap() {
        if (codeHashMap == null) {
            String[] intStringArray = RCloudContext.getInstance().getResources().getStringArray(Res.getInstance((Context)RCloudContext.getInstance()).array("rc_emoji_int"));
            String[] codeStringArray = RCloudContext.getInstance().getResources().getStringArray(Res.getInstance((Context)RCloudContext.getInstance()).array("rc_emoji_code"));
            int length = intStringArray.length;
            codeHashMap = new HashMap(length + 6);
            for (int i = 0; i < length; ++i) {
                codeHashMap.put(Integer.parseInt(intStringArray[i]), codeStringArray[i]);
            }
        }
    }

    public static int[] toCodePointArray(String str) {
        int cp;
        char[] ach = str.toCharArray();
        int len = ach.length;
        int[] acp = new int[Character.codePointCount(ach, 0, len)];
        int j = 0;
        for (int i = 0; i < len; i += Character.charCount(cp)) {
            cp = Character.codePointAt(ach, i);
            acp[j++] = cp;
        }
        return acp;
    }

    public static void initBroadcastPackage(String packageName) {
        if (!TextUtils.isEmpty((CharSequence)packageName)) {
            if (RongConst.BROADCAST.ACTION_BUNDLE_IO_RONG_IMKIT_CONVERSATION.indexOf(packageName) == -1) {
                RongConst.BROADCAST.ACTION_BUNDLE_IO_RONG_IMKIT_CONVERSATION = packageName + RongConst.BROADCAST.ACTION_BUNDLE_IO_RONG_IMKIT_CONVERSATION;
            }
            if (RongConst.BROADCAST.ACTION_BUNDLE_IO_RONG_IMKIT_CONVERSATION.indexOf(packageName) == -1) {
                RongConst.BROADCAST.ACTION_BUNDLE_IO_RONG_IMKIT_CONVERSATION_SETTING = packageName + RongConst.BROADCAST.ACTION_BUNDLE_IO_RONG_IMKIT_CONVERSATION_SETTING;
            }
            if (RongConst.BROADCAST.ACTION_BUNDLE_IO_RONG_IMKIT_CONVERSATION.indexOf(packageName) == -1) {
                RongConst.BROADCAST.ACTION_REMOVE_CONVERSATION_FOR_DELETE_FRIEND = packageName + RongConst.BROADCAST.ACTION_REMOVE_CONVERSATION_FOR_DELETE_FRIEND;
            }
            if (RongConst.BROADCAST.ACTION_BUNDLE_IO_RONG_IMKIT_CONVERSATION.indexOf(packageName) == -1) {
                RongConst.BROADCAST.ACTION_CLEAR_MESSAGE_FOR_CONVERSION = packageName + RongConst.BROADCAST.ACTION_CLEAR_MESSAGE_FOR_CONVERSION;
            }
            if (RongConst.BROADCAST.ACTION_P2P_MESSAGE_SEND.indexOf(packageName) == -1) {
                RongConst.BROADCAST.ACTION_P2P_MESSAGE_SEND = packageName + RongConst.BROADCAST.ACTION_P2P_MESSAGE_SEND;
            }
            if (RongConst.BROADCAST.ACTION_P2P_MESSAGE_RECEIVE.indexOf(packageName) == -1) {
                RongConst.BROADCAST.ACTION_P2P_MESSAGE_RECEIVE = packageName + RongConst.BROADCAST.ACTION_P2P_MESSAGE_RECEIVE;
            }
            if (RongConst.BROADCAST.ACTION_GROUP_MESSAGE_RECEIVE.indexOf(packageName) == -1) {
                RongConst.BROADCAST.ACTION_GROUP_MESSAGE_RECEIVE = packageName + RongConst.BROADCAST.ACTION_GROUP_MESSAGE_RECEIVE;
            }
            if (RongConst.BROADCAST.ACTION_DISCUSSION_MESSAGE_SEND.indexOf(packageName) == -1) {
                RongConst.BROADCAST.ACTION_DISCUSSION_MESSAGE_SEND = packageName + RongConst.BROADCAST.ACTION_DISCUSSION_MESSAGE_SEND;
            }
            if (RongConst.BROADCAST.ACTION_CUSTOMER_SERVICE_MESSAGE_RECEIVE.indexOf(packageName) == -1) {
                RongConst.BROADCAST.ACTION_CUSTOMER_SERVICE_MESSAGE_RECEIVE = packageName + RongConst.BROADCAST.ACTION_CUSTOMER_SERVICE_MESSAGE_RECEIVE;
            }
            if (RongConst.BROADCAST.ACTION_SYSTEM_MESSAGE_RECEIVE.indexOf(packageName) == -1) {
                RongConst.BROADCAST.ACTION_SYSTEM_MESSAGE_RECEIVE = packageName + RongConst.BROADCAST.ACTION_SYSTEM_MESSAGE_RECEIVE;
            }
            if (RongConst.BROADCAST.ACTION_DISCUSSION_MESSAGE_RECEIVE.indexOf(packageName) == -1) {
                RongConst.BROADCAST.ACTION_DISCUSSION_MESSAGE_RECEIVE = packageName + RongConst.BROADCAST.ACTION_DISCUSSION_MESSAGE_RECEIVE;
            }
            if (RongConst.BROADCAST.ACTION_DISCUSSION_CREATE.indexOf(packageName) == -1) {
                RongConst.BROADCAST.ACTION_DISCUSSION_CREATE = packageName + RongConst.BROADCAST.ACTION_DISCUSSION_CREATE;
            }
            if (RongConst.BROADCAST.ACTION_DISCUSSION_INFO_GET.indexOf(packageName) == -1) {
                RongConst.BROADCAST.ACTION_DISCUSSION_INFO_GET = packageName + RongConst.BROADCAST.ACTION_DISCUSSION_INFO_GET;
            }
            if (RongConst.BROADCAST.ACTION_DISCUSSION_QUIT.indexOf(packageName) == -1) {
                RongConst.BROADCAST.ACTION_DISCUSSION_QUIT = packageName + RongConst.BROADCAST.ACTION_DISCUSSION_QUIT;
            }
            if (RongConst.BROADCAST.ACTION_DISCUSSION_INVITE_MEMBER.indexOf(packageName) == -1) {
                RongConst.BROADCAST.ACTION_DISCUSSION_INVITE_MEMBER = packageName + RongConst.BROADCAST.ACTION_DISCUSSION_INVITE_MEMBER;
            }
            if (RongConst.BROADCAST.ACTION_DISCUSSION_UPDATE_NAME.indexOf(packageName) == -1) {
                RongConst.BROADCAST.ACTION_DISCUSSION_UPDATE_NAME = packageName + RongConst.BROADCAST.ACTION_DISCUSSION_UPDATE_NAME;
            }
            if (RongConst.BROADCAST.ACTION_MESSAGE_IMAGE_DOWNLOAD.indexOf(packageName) == -1) {
                RongConst.BROADCAST.ACTION_MESSAGE_IMAGE_DOWNLOAD = packageName + RongConst.BROADCAST.ACTION_MESSAGE_IMAGE_DOWNLOAD;
            }
            if (RongConst.BROADCAST.ACTION_CHATROOM_MESSAGE_RECEIVE.indexOf(packageName) == -1) {
                RongConst.BROADCAST.ACTION_CHATROOM_MESSAGE_RECEIVE = packageName + RongConst.BROADCAST.ACTION_CHATROOM_MESSAGE_RECEIVE;
            }
            if (RongConst.BROADCAST.ACTION_SET_DISCUSSION_INVITE_STATUS.indexOf(packageName) == -1) {
                RongConst.BROADCAST.ACTION_SET_DISCUSSION_INVITE_STATUS = packageName + RongConst.BROADCAST.ACTION_SET_DISCUSSION_INVITE_STATUS;
            }
            if (RongConst.BROADCAST.ACTION_SET_BLOCK_PUSH_STATUS.indexOf(packageName) == -1) {
                RongConst.BROADCAST.ACTION_SET_BLOCK_PUSH_STATUS = packageName + RongConst.BROADCAST.ACTION_SET_BLOCK_PUSH_STATUS;
            }
            if (RongConst.BROADCAST.ACTION_GET_BLOCK_PUSH_STATUS.indexOf(packageName) == -1) {
                RongConst.BROADCAST.ACTION_GET_BLOCK_PUSH_STATUS = packageName + RongConst.BROADCAST.ACTION_GET_BLOCK_PUSH_STATUS;
            }
            if (RongConst.BROADCAST.ACTION_RESET_DATA_FOR_CONVERSION_LIST.indexOf(packageName) == -1) {
                RongConst.BROADCAST.ACTION_RESET_DATA_FOR_CONVERSION_LIST = packageName + RongConst.BROADCAST.ACTION_RESET_DATA_FOR_CONVERSION_LIST;
            }
            if (RongConst.BROADCAST.ACTION_RESET_DATA_FOR_CONVERSION.indexOf(packageName) == -1) {
                RongConst.BROADCAST.ACTION_RESET_DATA_FOR_CONVERSION = packageName + RongConst.BROADCAST.ACTION_RESET_DATA_FOR_CONVERSION;
            }
            if (RongConst.BROADCAST.ACTION_RESET_DATA_FOR_CONVERSION_GROUP_LIST.indexOf(packageName) == -1) {
                RongConst.BROADCAST.ACTION_RESET_DATA_FOR_CONVERSION_GROUP_LIST = packageName + RongConst.BROADCAST.ACTION_RESET_DATA_FOR_CONVERSION_GROUP_LIST;
            }
        }
    }
}

