/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.utils;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class RCDateUtils {
    private static final int OTHER = 2014;
    private static final int TODAY = 6;
    private static final int YESTERDAY = 15;

    public static int judgeDate(Date date) {
        Calendar calendarToday = Calendar.getInstance();
        calendarToday.set(11, 0);
        calendarToday.set(12, 0);
        calendarToday.set(13, 0);
        calendarToday.set(14, 0);
        Calendar calendarYesterday = Calendar.getInstance();
        calendarYesterday.add(5, -1);
        calendarYesterday.set(10, 0);
        calendarYesterday.set(12, 0);
        calendarYesterday.set(13, 0);
        calendarYesterday.set(14, 0);
        Calendar calendarTarget = Calendar.getInstance();
        calendarTarget.setTime(date);
        if (calendarTarget.before(calendarYesterday)) {
            return 2014;
        }
        if (calendarTarget.before(calendarToday)) {
            return 15;
        }
        return 6;
    }

    public static String getConvastionListFromatDate(Date date) {
        if (date == null) {
            return "";
        }
        String fromatedDate = null;
        int type = RCDateUtils.judgeDate(date);
        switch (type) {
            case 6: {
                fromatedDate = RCDateUtils.fromatDate(date, "HH:mm");
                break;
            }
            case 15: {
                fromatedDate = String.format("\u6628\u5929 %1$s", RCDateUtils.fromatDate(date, "HH:mm"));
                break;
            }
            case 2014: {
                fromatedDate = RCDateUtils.fromatDate(date, "yyyy-MM-dd");
                break;
            }
        }
        return fromatedDate;
    }

    public static String getConvastionFromatDate(Date date) {
        if (date == null) {
            return "";
        }
        String fromatedDate = null;
        int type = RCDateUtils.judgeDate(date);
        switch (type) {
            case 6: {
                fromatedDate = RCDateUtils.fromatDate(date, "HH:mm");
                break;
            }
            case 15: {
                fromatedDate = String.format("\u6628\u5929 %1$s", RCDateUtils.fromatDate(date, "HH:mm"));
                break;
            }
            case 2014: {
                fromatedDate = RCDateUtils.fromatDate(date, "yyyy-MM-dd HH:mm");
                break;
            }
        }
        return fromatedDate;
    }

    public static boolean isShowChatTime(long currentTime, long preTime) {
        int typePre;
        int typeCurrent = RCDateUtils.judgeDate(new Date(currentTime));
        if (typeCurrent == (typePre = RCDateUtils.judgeDate(new Date(preTime)))) {
            return currentTime - preTime > 60000L;
        }
        return true;
    }

    public static String fromatDate(Date date, String fromat) {
        SimpleDateFormat sdf = new SimpleDateFormat(fromat);
        return sdf.format(date);
    }
}

