/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.utils;

import android.text.TextUtils;
import android.widget.Filter;
import io.rong.imkit.model.IFilterModel;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class PinyinFilterList<T extends IFilterModel>
extends Filter {
    private List<T> mOriginalDatas;
    private String mKeyIndex;
    private static final String INDEX_FORMATTER = "|%1$d:%2$s|";
    private static final String REGEX_TEMPLATE = "\\|(\\d+):([^|]*?%1$s)\\|";
    private static final String REGEX_KEY_TEMPLATE = "[^|]*?";

    public PinyinFilterList(List<T> dataList) {
        this.mOriginalDatas = dataList;
        this.refreshIndex();
    }

    private void refreshIndex() {
        StringBuilder keysBuilder = new StringBuilder();
        if (this.mOriginalDatas != null && this.mOriginalDatas.size() > 0) {
            for (int i = 0; i < this.mOriginalDatas.size(); ++i) {
                IFilterModel t = (IFilterModel)this.mOriginalDatas.get(i);
                keysBuilder.append(String.format(INDEX_FORMATTER, i, t.getFilterKey().toLowerCase()));
            }
        }
        this.mKeyIndex = keysBuilder.toString();
    }

    public List<T> getOriginalDatas() {
        return this.mOriginalDatas;
    }

    public void setOriginalDatas(List<T> mOriginalDatas) {
        this.mOriginalDatas = mOriginalDatas;
        this.refreshIndex();
    }

    protected Filter.FilterResults performFiltering(CharSequence c) {
        Filter.FilterResults results = new Filter.FilterResults();
        String constraint = c.toString().trim().toLowerCase();
        if (TextUtils.isEmpty((CharSequence)constraint)) {
            results.values = this.mOriginalDatas;
            results.count = this.mOriginalDatas.size();
            return results;
        }
        if (this.mKeyIndex == null && this.mKeyIndex.length() == 0) {
            return results;
        }
        StringBuilder keysRegexBuilder = new StringBuilder();
        for (int i = 0; i < constraint.length(); ++i) {
            keysRegexBuilder.append(constraint.charAt(i));
            keysRegexBuilder.append(REGEX_KEY_TEMPLATE);
        }
        String regexString = String.format(REGEX_TEMPLATE, keysRegexBuilder.toString());
        Pattern p = Pattern.compile(regexString);
        Matcher matcher = p.matcher(this.mKeyIndex);
        LinkedList<T> resultList = new LinkedList<T>();
        if (matcher.find()) {
            do {
                int index = Integer.valueOf(matcher.group(1));
                resultList.add(this.mOriginalDatas.get(index));
            } while (matcher.find());
        }
        results.values = resultList;
        results.count = resultList.size();
        return results;
    }
}

