/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.utils;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.List;

public class ParcelUtils {
    public static void writeStringToParcel(Parcel out, String str) {
        if (str != null) {
            out.writeInt(1);
            out.writeString(str);
        } else {
            out.writeInt(0);
        }
    }

    public static String readStringFromParcel(Parcel in) {
        int flag = in.readInt();
        if (flag == 1) {
            return in.readString();
        }
        return null;
    }

    public static <T extends Parcelable> T readFromParcel(Parcel in, Class<T> cls) {
        int flag = in.readInt();
        if (flag == 1) {
            return (T)in.readParcelable(cls.getClassLoader());
        }
        return null;
    }

    public static <T extends Parcelable> void writeToParcel(Parcel out, T model) {
        if (model != null) {
            out.writeInt(1);
            out.writeParcelable(model, 0);
        } else {
            out.writeInt(0);
        }
    }

    public static <T extends Parcelable> List<T> readListFromParcel(Parcel in, Class<T> cls) {
        int flag = in.readInt();
        if (flag == 1) {
            return in.readArrayList(cls.getClassLoader());
        }
        return null;
    }

    public static <T extends Parcelable> void writeListToParcel(Parcel out, List<T> collection) {
        if (collection != null) {
            out.writeInt(1);
            out.writeParcelableArray((Parcelable[])collection.toArray(), 0);
        } else {
            out.writeInt(0);
        }
    }

    public static void writeListStingToParcel(Parcel out, List<String> collection) {
        if (collection != null) {
            out.writeInt(1);
            out.writeStringList(collection);
        } else {
            out.writeInt(0);
        }
    }

    public static ArrayList<String> readListStingToParcel(Parcel in) {
        ArrayList<String> list = new ArrayList<String>();
        int flag = in.readInt();
        if (flag == 1) {
            in.readStringList(list);
        }
        return list;
    }
}

