/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class MultiValueMap<K, V> {
    private Map<K, List<V>> mMap;

    public MultiValueMap() {
        this(0);
    }

    public MultiValueMap(int capacity) {
        this.mMap = new ConcurrentHashMap<K, List<V>>(capacity);
    }

    public List<V> get(K key) {
        return this.mMap.get(key);
    }

    public void put(K key, V value) {
        List<V> values = this.mMap.get(key);
        if (values == null) {
            values = new ArrayList<V>();
            values.add(value);
            this.mMap.put(key, values);
        } else if (!this.containsValue(key, value)) {
            values.add(value);
        }
    }

    public void putAll(K key, ArrayList<V> values) {
        List<V> valuesMap = this.mMap.get(key);
        if (valuesMap == null) {
            valuesMap = new ArrayList<V>();
            this.mMap.put(key, valuesMap);
        }
        if (values != null) {
            for (V v : values) {
                if (this.containsValue(key, v)) continue;
                valuesMap.add(v);
            }
        }
    }

    public List<V> remove(K key) {
        List<V> values = this.mMap.get(key);
        if (values != null) {
            values.clear();
        }
        return this.mMap.remove(key);
    }

    public boolean remove(K key, V value) {
        List<V> values = this.mMap.get(key);
        if (values != null) {
            return values.remove(value);
        }
        return false;
    }

    public boolean removeValue(V value) {
        boolean isRemove = true;
        for (Map.Entry<K, List<V>> entry : this.mMap.entrySet()) {
            List<V> values = entry.getValue();
            if (values == null || values.remove(value)) continue;
            isRemove = false;
        }
        return isRemove;
    }

    public void clear() {
        for (Map.Entry<K, List<V>> entry : this.mMap.entrySet()) {
            List<V> values = entry.getValue();
            if (values == null) continue;
            values.clear();
        }
        this.mMap.clear();
    }

    public boolean containsKey(K key) {
        return this.mMap.containsKey(key);
    }

    public boolean containsValue(K key, V value) {
        List<V> values = this.mMap.get(key);
        return values != null && values.contains(value);
    }

    public boolean isEmpty() {
        return this.mMap.isEmpty();
    }

    public int size() {
        return this.mMap.size();
    }

    public Set<K> keySet() {
        return this.mMap.keySet();
    }

    public Set<Map.Entry<K, List<V>>> entrySet() {
        return this.mMap.entrySet();
    }

    public Collection<List<V>> values() {
        return this.mMap.values();
    }
}

