/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.utils;

import android.content.Context;
import android.text.SpannableStringBuilder;
import android.text.style.ForegroundColorSpan;
import android.text.style.URLSpan;
import io.rong.imkit.RCloudContext;
import io.rong.imkit.Res;
import io.rong.imkit.model.HighLightFlag;
import io.rong.imkit.model.HightLightContent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HighLightUtils {
    static HashMap<Integer, String> codeHashMap = null;

    public static HightLightContent loadHighLight(String str) {
        str = str.replaceAll("(\\\\+\")", "\"");
        HightLightContent content = new HightLightContent();
        Pattern pattern = Pattern.compile("(<a.*?href=['|\"]([^'\"$'\"]*)['|\"].*?>(.*?)</a>)|(\\[/[^\\[\\]]+?\\])");
        Matcher matcher = pattern.matcher(str);
        if (matcher.find()) {
            StringBuilder stringBuilder = new StringBuilder();
            ArrayList<HighLightFlag> flags = new ArrayList<HighLightFlag>();
            int startFlag = 0;
            int endFlag = 0;
            int matcherStart = 0;
            int matcherEnd = 0;
            stringBuilder.append(str.substring(0, matcher.start(0)));
            boolean isMatcher = false;
            if (matcher.start(0) != 0) {
                content.setTypeFlag((byte)2);
            }
            do {
                String group = matcher.group(0);
                matcherEnd = matcher.end(0);
                matcherStart = matcher.start(0);
                startFlag = stringBuilder.length();
                if (group.startsWith("[")) {
                    stringBuilder.append(matcher.group(4));
                    endFlag = startFlag + matcher.end(4) - matcher.start(4);
                    flags.add(new HighLightFlag(startFlag, endFlag, "", matcher.group(4)));
                    content.setTypeFlag((byte)1);
                } else if (group.startsWith("<")) {
                    stringBuilder.append(matcher.group(3));
                    endFlag = startFlag + matcher.end(3) - matcher.start(3);
                    flags.add(new HighLightFlag(startFlag, endFlag, matcher.group(2), matcher.group(3)));
                    content.setTypeFlag((byte)2);
                }
                isMatcher = matcher.find();
                if (isMatcher) {
                    matcherStart = matcher.start(0);
                    stringBuilder.append(str.substring(matcherEnd, matcherStart));
                    if (matcherEnd == matcherStart) continue;
                    content.setTypeFlag((byte)2);
                    continue;
                }
                stringBuilder.append(str.substring(matcherEnd));
                if (matcherEnd == str.length()) continue;
                content.setTypeFlag((byte)2);
            } while (isMatcher);
            content.setContent(stringBuilder.toString());
            content.setFlags(flags);
        } else {
            content.setContent(str);
            content.setTypeFlag((byte)0);
        }
        return content;
    }

    public static SpannableStringBuilder spannableSBInsert(SpannableStringBuilder ssb, int begin, String str) {
        if (str == null) {
            return ssb;
        }
        ssb.insert(begin, (CharSequence)str);
        ssb.setSpan((Object)new ForegroundColorSpan(-1164226), begin, str.length(), 34);
        return ssb;
    }

    public static SpannableStringBuilder spannableSBInsert(SpannableStringBuilder ssb, int begin, String str, String uri) {
        if (str == null) {
            return ssb;
        }
        ssb.insert(begin, (CharSequence)str);
        ssb.setSpan((Object)new URLSpan(uri), begin, str.length(), 34);
        ssb.setSpan((Object)new ForegroundColorSpan(-1164226), begin, str.length(), 34);
        return ssb;
    }

    public static SpannableStringBuilder loadHighLight(String str, int begin, int end) {
        SpannableStringBuilder ssb = new SpannableStringBuilder((CharSequence)str);
        ssb.setSpan((Object)new ForegroundColorSpan(-1164226), begin, end, 34);
        return ssb;
    }

    public static int[] toCodePointArray(String str) {
        int cp;
        char[] ach = str.toCharArray();
        int len = ach.length;
        int[] acp = new int[Character.codePointCount(ach, 0, len)];
        int j = 0;
        for (int i = 0; i < len; i += Character.charCount(cp)) {
            cp = Character.codePointAt(ach, i);
            acp[j++] = cp;
        }
        return acp;
    }

    public static String replaceEmoji(String input) {
        HighLightUtils.initCodeHashMap();
        StringBuilder result = new StringBuilder();
        int[] codePoints = HighLightUtils.toCodePointArray(input);
        for (int i = 0; i < codePoints.length; ++i) {
            if (codeHashMap.containsKey(codePoints[i])) {
                String value = codeHashMap.get(codePoints[i]);
                if (value == null) continue;
                result.append(value);
                continue;
            }
            result.append(Character.toChars(codePoints[i]));
        }
        return result.toString();
    }

    static final void initCodeHashMap() {
        if (codeHashMap == null) {
            String[] intStringArray = RCloudContext.getInstance().getResources().getStringArray(Res.getInstance((Context)RCloudContext.getInstance()).array("rc_emoji_int"));
            String[] codeStringArray = RCloudContext.getInstance().getResources().getStringArray(Res.getInstance((Context)RCloudContext.getInstance()).array("rc_emoji_code"));
            int length = intStringArray.length;
            codeHashMap = new HashMap(length + 6);
            for (int i = 0; i < length; ++i) {
                codeHashMap.put(Integer.parseInt(intStringArray[i]), codeStringArray[i]);
            }
        }
    }
}

