/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.utils;

import android.text.TextUtils;
import java.util.HashMap;

public class HTMLDecoder {
    private static final HashMap<String, Character> charTable = new HashMap();

    public static String decode(String s) {
        if (TextUtils.isEmpty((CharSequence)s)) {
            return "";
        }
        int maxPos = s.length();
        StringBuffer sb = new StringBuffer(maxPos);
        int curPos = 0;
        while (curPos < maxPos) {
            int tmpPos;
            char c;
            if ((c = s.charAt(curPos++)) == '&' && (tmpPos = curPos) < maxPos) {
                String t;
                char d;
                if ((d = s.charAt(tmpPos++)) == '#') {
                    if (tmpPos < maxPos) {
                        int i;
                        if ((d = s.charAt(tmpPos++)) == 'x' || d == 'X') {
                            if (tmpPos < maxPos && HTMLDecoder.isHexDigit(d = s.charAt(tmpPos++))) {
                                while (tmpPos < maxPos) {
                                    if (HTMLDecoder.isHexDigit(d = s.charAt(tmpPos++))) continue;
                                    if (d != ';') break;
                                    t = s.substring(curPos + 2, tmpPos - 1);
                                    try {
                                        i = Integer.parseInt(t, 16);
                                        if (i >= 0 && i < 65536) {
                                            c = (char)i;
                                            curPos = tmpPos;
                                        }
                                    }
                                    catch (NumberFormatException e) {}
                                    break;
                                }
                            }
                        } else if (HTMLDecoder.isDigit(d)) {
                            while (tmpPos < maxPos) {
                                if (HTMLDecoder.isDigit(d = s.charAt(tmpPos++))) continue;
                                if (d != ';') break;
                                t = s.substring(curPos + 1, tmpPos - 1);
                                try {
                                    i = Integer.parseInt(t);
                                    if (i >= 0 && i < 65536) {
                                        c = (char)i;
                                        curPos = tmpPos;
                                    }
                                }
                                catch (NumberFormatException e) {}
                                break;
                            }
                        }
                    }
                } else if (HTMLDecoder.isLetter(d)) {
                    while (tmpPos < maxPos) {
                        Character ch;
                        if (HTMLDecoder.isLetterOrDigit(d = s.charAt(tmpPos++))) continue;
                        if (d != ';' || (ch = charTable.get(t = s.substring(curPos, tmpPos - 1))) == null) break;
                        c = ch.charValue();
                        curPos = tmpPos;
                        break;
                    }
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static boolean isLetterOrDigit(char c) {
        return HTMLDecoder.isLetter(c) || HTMLDecoder.isDigit(c);
    }

    private static boolean isHexDigit(char c) {
        return HTMLDecoder.isHexLetter(c) || HTMLDecoder.isDigit(c);
    }

    private static boolean isLetter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private static boolean isHexLetter(char c) {
        return c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static String compact(String s) {
        int maxPos = s.length();
        StringBuffer sb = new StringBuffer(maxPos);
        int curPos = 0;
        while (curPos < maxPos) {
            int c;
            if (HTMLDecoder.isWhitespace((char)(c = s.charAt(curPos++)))) {
                while (curPos < maxPos && HTMLDecoder.isWhitespace(s.charAt(curPos))) {
                    ++curPos;
                }
                c = 32;
            }
            sb.append((char)c);
        }
        return sb.toString();
    }

    public static boolean isWhitespace(char ch) {
        return ch == ' ' || ch == '\r' || ch == '\n' || ch == '\t' || ch == '\f' || ch == '\u200b';
    }

    static {
        charTable.put("quot", new Character('\"'));
        charTable.put("amp", new Character('&'));
        charTable.put("apos", new Character('\''));
        charTable.put("lt", new Character('<'));
        charTable.put("gt", new Character('>'));
        charTable.put("nbsp", new Character('\u00a0'));
        charTable.put("iexcl", new Character('\u00a1'));
        charTable.put("cent", new Character('\u00a2'));
        charTable.put("pound", new Character('\u00a3'));
        charTable.put("curren", new Character('\u00a4'));
        charTable.put("yen", new Character('\u00a5'));
        charTable.put("brvbar", new Character('\u00a6'));
        charTable.put("sect", new Character('\u00a7'));
        charTable.put("uml", new Character('\u00a8'));
        charTable.put("copy", new Character('\u00a9'));
        charTable.put("ordf", new Character('\u00aa'));
        charTable.put("laquo", new Character('\u00ab'));
        charTable.put("not", new Character('\u00ac'));
        charTable.put("shy", new Character('\u00ad'));
        charTable.put("reg", new Character('\u00ae'));
        charTable.put("macr", new Character('\u00af'));
        charTable.put("deg", new Character('\u00b0'));
        charTable.put("plusmn", new Character('\u00b1'));
        charTable.put("sup2", new Character('\u00b2'));
        charTable.put("sup3", new Character('\u00b3'));
        charTable.put("acute", new Character('\u00b4'));
        charTable.put("micro", new Character('\u00b5'));
        charTable.put("para", new Character('\u00b6'));
        charTable.put("middot", new Character('\u00b7'));
        charTable.put("cedil", new Character('\u00b8'));
        charTable.put("sup1", new Character('\u00b9'));
        charTable.put("ordm", new Character('\u00ba'));
        charTable.put("raquo", new Character('\u00bb'));
        charTable.put("frac14", new Character('\u00bc'));
        charTable.put("frac12", new Character('\u00bd'));
        charTable.put("frac34", new Character('\u00be'));
        charTable.put("iquest", new Character('\u00bf'));
        charTable.put("Agrave", new Character('\u00c0'));
        charTable.put("Aacute", new Character('\u00c1'));
        charTable.put("Acirc", new Character('\u00c2'));
        charTable.put("Atilde", new Character('\u00c3'));
        charTable.put("Auml", new Character('\u00c4'));
        charTable.put("Aring", new Character('\u00c5'));
        charTable.put("AElig", new Character('\u00c6'));
        charTable.put("Ccedil", new Character('\u00c7'));
        charTable.put("Egrave", new Character('\u00c8'));
        charTable.put("Eacute", new Character('\u00c9'));
        charTable.put("Ecirc", new Character('\u00ca'));
        charTable.put("Euml", new Character('\u00cb'));
        charTable.put("Igrave", new Character('\u00cc'));
        charTable.put("Iacute", new Character('\u00cd'));
        charTable.put("Icirc", new Character('\u00ce'));
        charTable.put("Iuml", new Character('\u00cf'));
        charTable.put("ETH", new Character('\u00d0'));
        charTable.put("Ntilde", new Character('\u00d1'));
        charTable.put("Ograve", new Character('\u00d2'));
        charTable.put("Oacute", new Character('\u00d3'));
        charTable.put("Ocirc", new Character('\u00d4'));
        charTable.put("Otilde", new Character('\u00d5'));
        charTable.put("Ouml", new Character('\u00d6'));
        charTable.put("times", new Character('\u00d7'));
        charTable.put("Oslash", new Character('\u00d8'));
        charTable.put("Ugrave", new Character('\u00d9'));
        charTable.put("Uacute", new Character('\u00da'));
        charTable.put("Ucirc", new Character('\u00db'));
        charTable.put("Uuml", new Character('\u00dc'));
        charTable.put("Yacute", new Character('\u00dd'));
        charTable.put("THORN", new Character('\u00de'));
        charTable.put("szlig", new Character('\u00df'));
        charTable.put("agrave", new Character('\u00e0'));
        charTable.put("aacute", new Character('\u00e1'));
        charTable.put("acirc", new Character('\u00e2'));
        charTable.put("atilde", new Character('\u00e3'));
        charTable.put("auml", new Character('\u00e4'));
        charTable.put("aring", new Character('\u00e5'));
        charTable.put("aelig", new Character('\u00e6'));
        charTable.put("ccedil", new Character('\u00e7'));
        charTable.put("egrave", new Character('\u00e8'));
        charTable.put("eacute", new Character('\u00e9'));
        charTable.put("ecirc", new Character('\u00ea'));
        charTable.put("euml", new Character('\u00eb'));
        charTable.put("igrave", new Character('\u00ec'));
        charTable.put("iacute", new Character('\u00ed'));
        charTable.put("icirc", new Character('\u00ee'));
        charTable.put("iuml", new Character('\u00ef'));
        charTable.put("eth", new Character('\u00f0'));
        charTable.put("ntilde", new Character('\u00f1'));
        charTable.put("ograve", new Character('\u00f2'));
        charTable.put("oacute", new Character('\u00f3'));
        charTable.put("ocirc", new Character('\u00f4'));
        charTable.put("otilde", new Character('\u00f5'));
        charTable.put("ouml", new Character('\u00f6'));
        charTable.put("divide", new Character('\u00f7'));
        charTable.put("oslash", new Character('\u00f8'));
        charTable.put("ugrave", new Character('\u00f9'));
        charTable.put("uacute", new Character('\u00fa'));
        charTable.put("ucirc", new Character('\u00fb'));
        charTable.put("uuml", new Character('\u00fc'));
        charTable.put("yacute", new Character('\u00fd'));
        charTable.put("thorn", new Character('\u00fe'));
        charTable.put("yuml", new Character('\u00ff'));
        charTable.put("OElig", new Character('\u0152'));
        charTable.put("oelig", new Character('\u0153'));
        charTable.put("Scaron", new Character('\u0160'));
        charTable.put("scaron", new Character('\u0161'));
        charTable.put("Yuml", new Character('\u0178'));
        charTable.put("fnof", new Character('\u0192'));
        charTable.put("circ", new Character('\u02c6'));
        charTable.put("tilde", new Character('\u02dc'));
        charTable.put("Alpha", new Character('\u0391'));
        charTable.put("Beta", new Character('\u0392'));
        charTable.put("Gamma", new Character('\u0393'));
        charTable.put("Delta", new Character('\u0394'));
        charTable.put("Epsilon", new Character('\u0395'));
        charTable.put("Zeta", new Character('\u0396'));
        charTable.put("Eta", new Character('\u0397'));
        charTable.put("Theta", new Character('\u0398'));
        charTable.put("Iota", new Character('\u0399'));
        charTable.put("Kappa", new Character('\u039a'));
        charTable.put("Lambda", new Character('\u039b'));
        charTable.put("Mu", new Character('\u039c'));
        charTable.put("Nu", new Character('\u039d'));
        charTable.put("Xi", new Character('\u039e'));
        charTable.put("Omicron", new Character('\u039f'));
        charTable.put("Pi", new Character('\u03a0'));
        charTable.put("Rho", new Character('\u03a1'));
        charTable.put("Sigma", new Character('\u03a3'));
        charTable.put("Tau", new Character('\u03a4'));
        charTable.put("Upsilon", new Character('\u03a5'));
        charTable.put("Phi", new Character('\u03a6'));
        charTable.put("Chi", new Character('\u03a7'));
        charTable.put("Psi", new Character('\u03a8'));
        charTable.put("Omega", new Character('\u03a9'));
        charTable.put("alpha", new Character('\u03b1'));
        charTable.put("beta", new Character('\u03b2'));
        charTable.put("gamma", new Character('\u03b3'));
        charTable.put("delta", new Character('\u03b4'));
        charTable.put("epsilon", new Character('\u03b5'));
        charTable.put("zeta", new Character('\u03b6'));
        charTable.put("eta", new Character('\u03b7'));
        charTable.put("theta", new Character('\u03b8'));
        charTable.put("iota", new Character('\u03b9'));
        charTable.put("kappa", new Character('\u03ba'));
        charTable.put("lambda", new Character('\u03bb'));
        charTable.put("mu", new Character('\u03bc'));
        charTable.put("nu", new Character('\u03bd'));
        charTable.put("xi", new Character('\u03be'));
        charTable.put("omicron", new Character('\u03bf'));
        charTable.put("pi", new Character('\u03c0'));
        charTable.put("rho", new Character('\u03c1'));
        charTable.put("sigmaf", new Character('\u03c2'));
        charTable.put("sigma", new Character('\u03c3'));
        charTable.put("tau", new Character('\u03c4'));
        charTable.put("upsilon", new Character('\u03c5'));
        charTable.put("phi", new Character('\u03c6'));
        charTable.put("chi", new Character('\u03c7'));
        charTable.put("psi", new Character('\u03c8'));
        charTable.put("omega", new Character('\u03c9'));
        charTable.put("thetasym", new Character('\u03d1'));
        charTable.put("upsih", new Character('\u03d2'));
        charTable.put("piv", new Character('\u03d6'));
        charTable.put("ensp", new Character('\u2002'));
        charTable.put("emsp", new Character('\u2003'));
        charTable.put("thinsp", new Character('\u2009'));
        charTable.put("zwnj", new Character('\u200c'));
        charTable.put("zwj", new Character('\u200d'));
        charTable.put("lrm", new Character('\u200e'));
        charTable.put("rlm", new Character('\u200f'));
        charTable.put("ndash", new Character('\u2013'));
        charTable.put("mdash", new Character('\u2014'));
        charTable.put("lsquo", new Character('\u2018'));
        charTable.put("rsquo", new Character('\u2019'));
        charTable.put("sbquo", new Character('\u201a'));
        charTable.put("ldquo", new Character('\u201c'));
        charTable.put("rdquo", new Character('\u201d'));
        charTable.put("bdquo", new Character('\u201e'));
        charTable.put("dagger", new Character('\u2020'));
        charTable.put("Dagger", new Character('\u2021'));
        charTable.put("bull", new Character('\u2022'));
        charTable.put("hellip", new Character('\u2026'));
        charTable.put("permil", new Character('\u2030'));
        charTable.put("prime", new Character('\u2032'));
        charTable.put("Prime", new Character('\u2033'));
        charTable.put("lsaquo", new Character('\u2039'));
        charTable.put("rsaquo", new Character('\u203a'));
        charTable.put("oline", new Character('\u203e'));
        charTable.put("frasl", new Character('\u2044'));
        charTable.put("euro", new Character('\u20ac'));
        charTable.put("image", new Character('\u2111'));
        charTable.put("weierp", new Character('\u2118'));
        charTable.put("real", new Character('\u211c'));
        charTable.put("trade", new Character('\u2122'));
        charTable.put("alefsym", new Character('\u2135'));
        charTable.put("larr", new Character('\u2190'));
        charTable.put("uarr", new Character('\u2191'));
        charTable.put("rarr", new Character('\u2192'));
        charTable.put("darr", new Character('\u2193'));
        charTable.put("harr", new Character('\u2194'));
        charTable.put("crarr", new Character('\u21b5'));
        charTable.put("lArr", new Character('\u21d0'));
        charTable.put("uArr", new Character('\u21d1'));
        charTable.put("rArr", new Character('\u21d2'));
        charTable.put("dArr", new Character('\u21d3'));
        charTable.put("hArr", new Character('\u21d4'));
        charTable.put("forall", new Character('\u2200'));
        charTable.put("part", new Character('\u2202'));
        charTable.put("exist", new Character('\u2203'));
        charTable.put("empty", new Character('\u2205'));
        charTable.put("nabla", new Character('\u2207'));
        charTable.put("isin", new Character('\u2208'));
        charTable.put("notin", new Character('\u2209'));
        charTable.put("ni", new Character('\u220b'));
        charTable.put("prod", new Character('\u220f'));
        charTable.put("sum", new Character('\u2211'));
        charTable.put("minus", new Character('\u2212'));
        charTable.put("lowast", new Character('\u2217'));
        charTable.put("radic", new Character('\u221a'));
        charTable.put("prop", new Character('\u221d'));
        charTable.put("infin", new Character('\u221e'));
        charTable.put("ang", new Character('\u2220'));
        charTable.put("and", new Character('\u2227'));
        charTable.put("or", new Character('\u2228'));
        charTable.put("cap", new Character('\u2229'));
        charTable.put("cup", new Character('\u222a'));
        charTable.put("int", new Character('\u222b'));
        charTable.put("there4", new Character('\u2234'));
        charTable.put("sim", new Character('\u223c'));
        charTable.put("cong", new Character('\u2245'));
        charTable.put("asymp", new Character('\u2248'));
        charTable.put("ne", new Character('\u2260'));
        charTable.put("equiv", new Character('\u2261'));
        charTable.put("le", new Character('\u2264'));
        charTable.put("ge", new Character('\u2265'));
        charTable.put("sub", new Character('\u2282'));
        charTable.put("sup", new Character('\u2283'));
        charTable.put("nsub", new Character('\u2284'));
        charTable.put("sube", new Character('\u2286'));
        charTable.put("supe", new Character('\u2287'));
        charTable.put("oplus", new Character('\u2295'));
        charTable.put("otimes", new Character('\u2297'));
        charTable.put("perp", new Character('\u22a5'));
        charTable.put("sdot", new Character('\u22c5'));
        charTable.put("lceil", new Character('\u2308'));
        charTable.put("rceil", new Character('\u2309'));
        charTable.put("lfloor", new Character('\u230a'));
        charTable.put("rfloor", new Character('\u230b'));
        charTable.put("lang", new Character('\u2329'));
        charTable.put("rang", new Character('\u232a'));
        charTable.put("loz", new Character('\u25ca'));
        charTable.put("spades", new Character('\u2660'));
        charTable.put("clubs", new Character('\u2663'));
        charTable.put("hearts", new Character('\u2665'));
        charTable.put("diams", new Character('\u2666'));
    }
}

