/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.utils;

import android.net.Uri;
import android.os.Environment;
import android.util.Log;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileUtil {
    private static final String TAG = "FileUtil";
    private static final String NOMEDIA = ".nomedia";

    public static InputStream getFileInputStream(String path) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(new File(path));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return fileInputStream;
    }

    public static final String createDirectory(File storageDirectory) {
        File nomediaFile;
        if (!storageDirectory.exists()) {
            Log.d((String)TAG, (String)("Trying to create storageDirectory: " + String.valueOf(storageDirectory.mkdirs())));
            Log.d((String)TAG, (String)("Exists: " + storageDirectory + " " + String.valueOf(storageDirectory.exists())));
            Log.d((String)TAG, (String)("State: " + Environment.getExternalStorageState()));
            Log.d((String)TAG, (String)("Isdir: " + storageDirectory + " " + String.valueOf(storageDirectory.isDirectory())));
            Log.d((String)TAG, (String)("Readable: " + storageDirectory + " " + String.valueOf(storageDirectory.canRead())));
            Log.d((String)TAG, (String)("Writable: " + storageDirectory + " " + String.valueOf(storageDirectory.canWrite())));
            File tmp = storageDirectory.getParentFile();
            Log.d((String)TAG, (String)("Exists: " + tmp + " " + String.valueOf(tmp.exists())));
            Log.d((String)TAG, (String)("Isdir: " + tmp + " " + String.valueOf(tmp.isDirectory())));
            Log.d((String)TAG, (String)("Readable: " + tmp + " " + String.valueOf(tmp.canRead())));
            Log.d((String)TAG, (String)("Writable: " + tmp + " " + String.valueOf(tmp.canWrite())));
            tmp = tmp.getParentFile();
            Log.d((String)TAG, (String)("Exists: " + tmp + " " + String.valueOf(tmp.exists())));
            Log.d((String)TAG, (String)("Isdir: " + tmp + " " + String.valueOf(tmp.isDirectory())));
            Log.d((String)TAG, (String)("Readable: " + tmp + " " + String.valueOf(tmp.canRead())));
            Log.d((String)TAG, (String)("Writable: " + tmp + " " + String.valueOf(tmp.canWrite())));
        }
        if (!(nomediaFile = new File(storageDirectory, NOMEDIA)).exists()) {
            try {
                Log.d((String)TAG, (String)("Created file: " + nomediaFile + " " + String.valueOf(nomediaFile.createNewFile())));
            }
            catch (IOException e) {
                Log.d((String)TAG, (String)"Unable to create .nomedia file for some reason.", (Throwable)e);
                throw new IllegalStateException("Unable to create nomedia file.");
            }
        }
        if (!storageDirectory.isDirectory() || !nomediaFile.exists()) {
            throw new RuntimeException("Unable to create storage directory and nomedia file.");
        }
        return storageDirectory.getPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getByteFromUri(Uri uri) {
        InputStream input = FileUtil.getFileInputStream(uri.getPath());
        try {
            int count = 0;
            while (count == 0) {
                count = input.available();
            }
            byte[] bytes = new byte[count];
            input.read(bytes);
            byte[] byArray = bytes;
            return byArray;
        }
        catch (Exception e) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static void writeByte(Uri uri, byte[] data) {
        File fileFolder = new File(uri.getPath().substring(0, uri.getPath().lastIndexOf("/")));
        fileFolder.mkdirs();
        File file = new File(uri.getPath());
        try {
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
            ((OutputStream)os).write(data);
            ((OutputStream)os).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

