/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.utils;

import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.ExifInterface;
import android.media.ThumbnailUtils;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BitmapUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBase64FromBitmap(Bitmap bitmap) {
        String base64Str = null;
        ByteArrayOutputStream baos = null;
        try {
            if (bitmap != null) {
                baos = new ByteArrayOutputStream();
                bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)baos);
                byte[] bitmapBytes = baos.toByteArray();
                base64Str = Base64.encodeToString((byte[])bitmapBytes, (int)2);
                Log.d((String)"base64Str", (String)base64Str);
                baos.flush();
                baos.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (baos != null) {
                    baos.flush();
                    baos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return base64Str;
    }

    public static Bitmap getBitmapFromBase64(String base64Str) {
        if (TextUtils.isEmpty((CharSequence)base64Str)) {
            return null;
        }
        byte[] bytes = Base64.decode((String)base64Str, (int)2);
        return BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length);
    }

    public static Bitmap getFixSizeBitmap(int byteLength, Bitmap bitmap) {
        int bitmapSize = bitmap.getRowBytes() * bitmap.getHeight();
        if (bitmap == null || byteLength == 0 || bitmapSize <= byteLength) {
            return bitmap;
        }
        if (bitmap != null) {
            while (bitmap.getRowBytes() * bitmap.getHeight() > byteLength) {
                int width = bitmap.getWidth();
                int height = bitmap.getHeight();
                Log.d((String)"BasePhtotActivity---getThumbnailBitmap--", (String)("width:" + width + "----" + "height:" + height));
                bitmap = ThumbnailUtils.extractThumbnail((Bitmap)bitmap, (int)(width / 2), (int)(height / 2));
            }
        }
        return bitmap;
    }

    public static Bitmap getResizedBitmap(Context context, Uri uri, int widthLimit, int heightLimit) throws IOException {
        Bitmap bitmap;
        String path = null;
        Bitmap result = null;
        if (uri.getScheme().equals("file")) {
            path = uri.getPath();
        } else if (uri.getScheme().equals("content")) {
            Cursor cursor = context.getContentResolver().query(uri, new String[]{"_data"}, null, null, null);
            cursor.moveToFirst();
            path = cursor.getString(0);
            cursor.close();
        } else {
            return null;
        }
        ExifInterface exifInterface = new ExifInterface(path);
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
        int orientation = exifInterface.getAttributeInt("Orientation", 0);
        if (orientation == 6 || orientation == 8 || orientation == 5 || orientation == 7) {
            int tmp = widthLimit;
            widthLimit = heightLimit;
            heightLimit = tmp;
        }
        int width = options.outWidth;
        int height = options.outHeight;
        int sampleW = 1;
        int sampleH = 1;
        while (width / 2 > widthLimit) {
            width /= 2;
            sampleW <<= 1;
        }
        while (height / 2 > heightLimit) {
            height /= 2;
            sampleH <<= 1;
        }
        int sampleSize = 1;
        options = new BitmapFactory.Options();
        sampleSize = widthLimit == Integer.MAX_VALUE || heightLimit == Integer.MAX_VALUE ? Math.max(sampleW, sampleH) : Math.max(sampleW, sampleH);
        options.inSampleSize = sampleSize;
        try {
            bitmap = BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
            options.inSampleSize <<= 1;
            bitmap = BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
        }
        Matrix matrix = new Matrix();
        if (bitmap == null) {
            return result;
        }
        int w = bitmap.getWidth();
        int h = bitmap.getHeight();
        if (orientation == 6 || orientation == 8 || orientation == 5 || orientation == 7) {
            int tmp = w;
            w = h;
            h = tmp;
        }
        switch (orientation) {
            case 6: {
                matrix.setRotate(90.0f, (float)w / 2.0f, (float)h / 2.0f);
                break;
            }
            case 3: {
                matrix.setRotate(180.0f, (float)w / 2.0f, (float)h / 2.0f);
                break;
            }
            case 8: {
                matrix.setRotate(270.0f, (float)w / 2.0f, (float)h / 2.0f);
                break;
            }
            case 2: {
                matrix.preScale(-1.0f, 1.0f);
                break;
            }
            case 4: {
                matrix.preScale(1.0f, -1.0f);
                break;
            }
            case 5: {
                matrix.setRotate(90.0f, (float)w / 2.0f, (float)h / 2.0f);
                matrix.preScale(1.0f, -1.0f);
                break;
            }
            case 7: {
                matrix.setRotate(270.0f, (float)w / 2.0f, (float)h / 2.0f);
                matrix.preScale(1.0f, -1.0f);
            }
        }
        float xS = (float)widthLimit / (float)bitmap.getWidth();
        float yS = (float)heightLimit / (float)bitmap.getHeight();
        matrix.postScale(Math.min(xS, yS), Math.min(xS, yS));
        try {
            result = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
            Log.e((String)"ResourceCompressHandler", (String)("OOMHeight:" + bitmap.getHeight() + "Width:" + bitmap.getHeight() + "matrix:" + xS + " " + yS));
            return null;
        }
        return result;
    }

    public static Bitmap getResizedBitmap(Bitmap bitmap, int widthLimit, int heightLimit) {
        Bitmap result = null;
        Matrix matrix = new Matrix();
        if (bitmap == null) {
            return result;
        }
        float xS = (float)widthLimit / (float)bitmap.getWidth();
        float yS = (float)heightLimit / (float)bitmap.getHeight();
        matrix.postScale(Math.min(xS, yS), Math.min(xS, yS));
        try {
            result = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
            Log.d((String)"ResourceCompressHandler", (String)("OOMHeight:" + bitmap.getHeight() + "Width:" + bitmap.getHeight() + "matrix:" + xS + " " + yS));
            return null;
        }
        return result;
    }
}

