/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.service;

import android.app.ActivityManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Vibrator;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.util.Log;
import io.rong.imkit.RCloudContext;
import io.rong.imkit.Res;
import io.rong.imkit.RongIM;
import io.rong.imkit.broadcast.SendMessageBroadcast;
import io.rong.imkit.common.RongConst;
import io.rong.imkit.logic.ActionListener;
import io.rong.imkit.logic.MessageLogic;
import io.rong.imkit.model.UIConversation;
import io.rong.imkit.model.UIDiscussion;
import io.rong.imkit.model.UIGroup;
import io.rong.imkit.model.UIMessage;
import io.rong.imkit.model.UIUserInfo;
import io.rong.imkit.utils.HighLightUtils;
import io.rong.imkit.utils.MultiValueMap;
import io.rong.imkit.utils.Util;
import io.rong.imlib.RongIMClient;
import io.rong.message.ImageMessage;
import io.rong.message.LocationMessage;
import io.rong.message.RichContentMessage;
import io.rong.message.TextMessage;
import io.rong.message.VoiceMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class RongIMService
extends Service {
    private static final String TAG = RongIMService.class.getSimpleName();
    public static final String EXTRA_CATION_HASHCODE = "io.rong.imkit.service.RongIMService.EXTRA_ACTION_HASHCODE";
    private MultiValueMap<String, ActionListener> mResolver;
    private Handler mHandler;
    private Looper mLooper;
    private SendMessageBroadcast mSendMessageBroadcast;
    private NewMessageReminderRunnable mLastReminderRunnable;
    Handler handler = new Handler(new Handler.Callback(){

        public boolean handleMessage(Message msg) {
            UIConversation conversation = null;
            Notification notification = null;
            if (msg.obj == null) {
                return true;
            }
            if (msg.obj instanceof UIConversation) {
                conversation = (UIConversation)msg.obj;
            } else if (msg.obj instanceof Notification) {
                notification = (Notification)msg.obj;
            }
            switch (msg.what) {
                case 2014082908: {
                    RongIMService.this.handlerNotification(conversation);
                    break;
                }
                case 2014082909: {
                    RongIMService.this.handlerNotification(conversation);
                    break;
                }
                case 2014082910: {
                    RongIMService.this.getUserInfo(conversation, 201409301, 201409302);
                    break;
                }
                case 2014082911: {
                    RongIMService.this.getUserInfo(conversation, 201409301, 201409302);
                    break;
                }
                case 2014090810: {
                    RongIMService.this.getUserInfo(conversation, 201409303, 201409304);
                    break;
                }
                case 2014090811: {
                    RongIMService.this.getUserInfo(conversation, 201409303, 201409304);
                    break;
                }
                case 2014091016: {
                    RongIMService.this.showNotification(notification);
                    break;
                }
                case 201409301: {
                    RongIMService.this.handlerNotification(conversation);
                    break;
                }
                case 201409302: {
                    RongIMService.this.handlerNotification(conversation);
                    break;
                }
                case 201409303: {
                    RongIMService.this.handlerNotification(conversation);
                    break;
                }
                case 201409304: {
                    RongIMService.this.handlerNotification(conversation);
                    break;
                }
                case 5555: {
                    RongIMService.this.handlerNotification(conversation);
                    break;
                }
            }
            return false;
        }
    });
    private static final int HANDLE_GET_USER_INFO_SUCCESS = 2014082908;
    private static final int HANDLE_GET_USER_INFO_FAILURE = 2014082909;
    private static final int HANDLE_GET_DISCUSSION_INFO_SUCCESS = 2014082910;
    private static final int HANDLE_GET_DISCUSSION_INFO_FAILURE = 2014082911;
    private static final int HANDLE_GET_GROUP_INFO_SUCCESS = 2014090810;
    private static final int HANDLE_GET_GROUP_INFO_FAILURE = 2014090811;
    private static final int HANDLE_CUSTOM_SERVICE = 5555;
    private static final int HANDLER_SHOW_NOTICE = 2014091016;
    private static final int HANDLE_DISCUSSION_GET_USER_INFO_SUCCESS = 201409301;
    private static final int HANDLE_DISCUSSION_GET_USER_INFO_FAILURE = 201409302;
    private static final int HANDLE_GROUP_GET_USER_INFO_SUCCESS = 201409303;
    private static final int HANDLE_GROUP_GET_USER_INFO_FAILURE = 201409304;
    private String appName = null;

    public void onCreate() {
        super.onCreate();
        Log.d((String)"RongIMService---init---", (String)"RongIMService---init-onCreate--");
        this.mResolver = new MultiValueMap(8);
        HandlerThread handlerThread = new HandlerThread(TAG, -3);
        handlerThread.start();
        this.mLooper = handlerThread.getLooper();
        this.mHandler = new Handler(this.mLooper){

            public void handleMessage(Message msg) {
                Log.d((String)"RongIMService---handleMessage", (String)"------------>");
                if (msg.obj instanceof Intent) {
                    Intent intent = (Intent)msg.obj;
                    RongIMService.this.onHandleAction(intent);
                }
            }
        };
        Log.d((String)"RongIMService", (String)("---------getPackageName--->" + this.getPackageName()));
        if (RCloudContext.getInstance() == null) {
            this.stopSelf();
            return;
        }
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                MessageLogic.init(RongIMService.this);
                RongIMService.this.mSendMessageBroadcast = new SendMessageBroadcast();
                try {
                    IntentFilter intentFilter = new IntentFilter(RongIMService.this.getPackageName() + ".io.rong.imkitvoip.broadcast.SENDMESSAGE");
                    RongIMService.this.registerReceiver(RongIMService.this.mSendMessageBroadcast, intentFilter);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        this.mHandler.obtainMessage(0, (Object)intent).sendToTarget();
        return super.onStartCommand(intent, 1, startId);
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onHandleAction(Intent intent) {
        if (intent != null) {
            intent.setComponent(null);
            String action = intent.getAction();
            if (TextUtils.isEmpty((CharSequence)action)) {
                return;
            }
            MultiValueMap<String, ActionListener> multiValueMap = this.mResolver;
            synchronized (multiValueMap) {
                List<ActionListener> actionListeners;
                if (!TextUtils.isEmpty((CharSequence)action) && this.mResolver.containsKey(action) && (actionListeners = this.mResolver.get(action)) != null) {
                    for (int i = 0; i < actionListeners.size(); ++i) {
                        actionListeners.get(i).onHandleAction(intent);
                    }
                }
            }
        }
    }

    public void registerAction(ActionListener actionListener, List<String> actions) {
        if (actionListener != null && actions != null) {
            for (String action : actions) {
                if (action == null || this.mResolver == null || actionListener == null) continue;
                this.mResolver.put(action, actionListener);
            }
        }
    }

    public void newMessageNotifycation(final UIMessage message, final int count, final int left) {
        new Thread(){

            @Override
            public void run() {
                boolean isOnBackgroud = RongIMService.this.isAppOnBackground();
                if (message != null && message.isNotify()) {
                    if (isOnBackgroud) {
                        UIConversation conversation = new UIConversation();
                        conversation.setSenderUserId(message.getSenderUserId());
                        conversation.setConversationType(message.getConversationType());
                        conversation.setLatestMessage(message.getContent());
                        conversation.setSentTime(message.getSentTime());
                        conversation.setTargetId(message.getTargetId());
                        RongIMService.this.warpMessage(conversation);
                    } else {
                        String targetId = RCloudContext.getInstance().getCurrentTargetId();
                        if (!(message.getTargetId().equals(targetId) || left != 0 && count - 5 != left && count != left)) {
                            RongIMService.this.newMessageReminder();
                        }
                    }
                }
            }
        }.start();
    }

    private void getUserInfo(final UIConversation conversation, final int successHandle, final int failureHanle) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                RongIMService.this.getUserInfo(conversation.getSenderUserId(), new MessageLogic.GetUserInfoCallback(){

                    @Override
                    public void onSuccess(RongIMClient.UserInfo user) {
                        conversation.setUserInfo(new UIUserInfo(user));
                        RongIMService.this.handler.obtainMessage(successHandle, (Object)conversation).sendToTarget();
                    }

                    @Override
                    public void onError() {
                        RongIMService.this.handler.obtainMessage(failureHanle, (Object)conversation).sendToTarget();
                    }
                });
            }
        });
    }

    private void warpMessage(final UIConversation conversation) {
        if (conversation != null && conversation.getConversationType() != null) {
            if (RongIMClient.ConversationType.PRIVATE == conversation.getConversationType() || RongIMClient.ConversationType.SYSTEM == conversation.getConversationType()) {
                this.getUserInfo(conversation, 2014082908, 2014082909);
            } else if (RongIMClient.ConversationType.DISCUSSION == conversation.getConversationType()) {
                RCloudContext.getInstance().getRongIMClient().getDiscussion(conversation.getTargetId(), new RongIMClient.GetDiscussionCallback(){

                    @Override
                    public void onSuccess(RongIMClient.Discussion discussion) {
                        conversation.setUiDiscussion(new UIDiscussion(discussion));
                        RongIMService.this.handler.obtainMessage(2014082910, (Object)conversation).sendToTarget();
                    }

                    @Override
                    public void onError(RongIMClient.GetDiscussionCallback.ErrorCode errorCode) {
                        RongIMService.this.handler.obtainMessage(2014082911, (Object)conversation).sendToTarget();
                    }
                });
            } else if (RongIMClient.ConversationType.GROUP == conversation.getConversationType()) {
                RongIM.GetGroupInfoProvider provider = RCloudContext.getInstance().getGetGroupInfoProvider();
                if (provider != null) {
                    RongIMClient.Group group = provider.getGroupInfo(conversation.getTargetId());
                    if (group != null && !TextUtils.isEmpty((CharSequence)group.getName())) {
                        conversation.setUiGroup(new UIGroup(group));
                        this.handler.obtainMessage(2014090810, (Object)conversation).sendToTarget();
                    }
                } else {
                    this.handler.obtainMessage(2014090811, (Object)conversation).sendToTarget();
                }
            } else if (RongIMClient.ConversationType.CUSTOMER_SERVICE == conversation.getConversationType()) {
                this.handler.obtainMessage(5555, (Object)conversation).sendToTarget();
            }
        }
    }

    public boolean isAppOnBackground() {
        ActivityManager activityManager = (ActivityManager)this.getSystemService("activity");
        String appPackageName = this.getPackageName();
        List runningTaskInfos = activityManager.getRunningTasks(1);
        String topAppPackageName = ((ActivityManager.RunningTaskInfo)runningTaskInfos.get((int)0)).topActivity.getPackageName();
        return !appPackageName.equals(topAppPackageName);
    }

    private void showNotification(Notification notification) {
        NotificationManager notificationManager = (NotificationManager)this.getSystemService("notification");
        notificationManager.notify(0, notification);
        Log.d((String)"RONG_NOTICE", (String)"notificationManager");
    }

    public void handlerNotification(UIConversation conversation) {
        Notification notification;
        int newMessageCount = RCloudContext.getInstance().getNotificationNewMessageCount();
        ++newMessageCount;
        String targetId = conversation.getTargetId();
        ArrayList<String> userIdList = RCloudContext.getInstance().getNotificationUserIdList();
        if (!userIdList.contains(targetId)) {
            userIdList.add(targetId);
        }
        Uri alert = RingtoneManager.getDefaultUri((int)2);
        String contentText = "";
        String contentTitle = "";
        String name = "";
        if (conversation.getConversationType() == RongIMClient.ConversationType.GROUP) {
            if (conversation.getUiGroup() != null && TextUtils.isEmpty((CharSequence)(name = conversation.getUiGroup().getName()))) {
                name = this.getString(Res.getInstance((Context)this).string("rc_default_group_name"));
            }
        } else if (conversation.getConversationType() == RongIMClient.ConversationType.DISCUSSION) {
            if (conversation.getUiDiscussion() != null && TextUtils.isEmpty((CharSequence)(name = conversation.getUiDiscussion().getName()))) {
                name = this.getString(Res.getInstance((Context)this).string("rc_default_discussion_name"));
            }
        } else if (conversation.getConversationType() == RongIMClient.ConversationType.CUSTOMER_SERVICE) {
            name = this.getString(Res.getInstance((Context)this).string("notification_custom_service"));
        } else if (conversation.getUserInfo() != null) {
            name = conversation.getUserInfo().getName();
        }
        if (TextUtils.isEmpty((CharSequence)name)) {
            name = conversation.getTargetId();
        }
        if (newMessageCount > 1) {
            String format;
            if (userIdList.size() == 1) {
                contentTitle = name;
                format = this.getString(Res.getInstance((Context)this).string("notification_new_message_one_p"));
                contentText = String.format(format, newMessageCount);
            } else {
                if (this.appName == null) {
                    this.appName = this.getAppName();
                }
                contentTitle = this.appName;
                format = this.getString(Res.getInstance((Context)this).string("notification_new_message_mang_p"));
                contentText = String.format(format, userIdList.size(), newMessageCount);
            }
        } else {
            contentTitle = name;
            if (conversation.getLatestMessage() instanceof ImageMessage) {
                contentText = conversation.getUIImageContent((Context)this);
            } else if (conversation.getLatestMessage() instanceof VoiceMessage) {
                contentText = conversation.getUIVoiceContent((Context)this);
            } else if (conversation.getLatestMessage() instanceof TextMessage) {
                contentText = conversation.getTextMessageContentStr();
            } else if (conversation.getLatestMessage() instanceof RichContentMessage) {
                contentText = conversation.getUIImageTextContent((Context)this);
            } else if (conversation.getLatestMessage() instanceof LocationMessage) {
                contentText = conversation.getUILocationContent((Context)this);
            }
        }
        int peopleCount = userIdList.size();
        Uri uri = null;
        if (peopleCount == 1) {
            uri = Uri.parse((String)("rong://" + this.getApplicationInfo().packageName)).buildUpon().appendPath("conversation").appendPath(conversation.getConversationType().getName().toLowerCase()).appendQueryParameter("targetId", conversation.getTargetId()).appendQueryParameter("appkey", RCloudContext.getInstance().getAppKey()).build();
        } else if (peopleCount > 1) {
            uri = Uri.parse((String)("rong://" + this.getApplicationInfo().packageName)).buildUpon().appendPath("conversationlist").build();
        }
        Intent intent = new Intent("android.intent.action.VIEW", uri);
        if (peopleCount > 1) {
            intent.putExtra("appkey", RCloudContext.getInstance().getAppKey());
        }
        PendingIntent contentIntent = PendingIntent.getActivity((Context)this, (int)0, (Intent)intent, (int)0x8000000);
        if (peopleCount == 1 && (conversation.getConversationType() == RongIMClient.ConversationType.GROUP || conversation.getConversationType() == RongIMClient.ConversationType.DISCUSSION) && conversation.getUserInfo() != null) {
            contentText = conversation.getUserInfo().getName() + ":" + contentText;
        }
        SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder((CharSequence)Util.highLightLink(HighLightUtils.loadHighLight(contentText)));
        if (Build.VERSION.SDK_INT < 16) {
            notification = new Notification(this.getApplicationInfo().icon, (CharSequence)this.getString(Res.getInstance((Context)this).string("rc_notification_ticker_text")), System.currentTimeMillis());
            notification.setLatestEventInfo((Context)this, (CharSequence)contentTitle.toString(), (CharSequence)spannableStringBuilder, contentIntent);
            notification.flags = 16;
            notification.defaults = 1;
        } else {
            notification = new Notification.Builder((Context)this).setLargeIcon(this.getAppIcon((Context)this)).setSmallIcon(Res.getInstance((Context)this).drawable("rc_ic_notice")).setTicker((CharSequence)this.getString(Res.getInstance((Context)this).string("rc_notification_ticker_text"))).setContentTitle((CharSequence)contentTitle.toString()).setContentText((CharSequence)spannableStringBuilder).setContentIntent(contentIntent).setAutoCancel(true).setDefaults(-1).build();
        }
        notification.flags = 16;
        notification.defaults = 1;
        this.handler.removeMessages(2014091016);
        this.handler.sendMessageDelayed(this.handler.obtainMessage(2014091016, (Object)notification), 500L);
        RCloudContext.getInstance().setNotificationNewMessageCount(newMessageCount);
    }

    private String getAppName() {
        PackageManager packageManager = null;
        ApplicationInfo applicationInfo = null;
        try {
            packageManager = this.getApplicationContext().getPackageManager();
            applicationInfo = packageManager.getApplicationInfo(this.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            applicationInfo = null;
        }
        return (String)packageManager.getApplicationLabel(applicationInfo);
    }

    private Bitmap getAppIcon(Context context) {
        Drawable appIconDrawable = context.getApplicationInfo().loadIcon(context.getPackageManager());
        BitmapDrawable tempIcon = (BitmapDrawable)appIconDrawable;
        Bitmap appIcon = tempIcon.getBitmap();
        return appIcon;
    }

    public void onDestroy() {
        Log.d((String)TAG, (String)"--------onDestroy--------");
        if (MessageLogic.getInstance() != null) {
            MessageLogic.getInstance().destroy();
        }
        this.mLooper.quit();
        this.mResolver = null;
        try {
            if (this.mSendMessageBroadcast != null) {
                this.unregisterReceiver(this.mSendMessageBroadcast);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.onDestroy();
    }

    protected void getUserInfo(String userId, final MessageLogic.GetUserInfoCallback getUserInfoCallback) {
        if (RCloudContext.getInstance().getGetUserInfoProvider() != null) {
            RongIMClient.UserInfo userInfo = RCloudContext.getInstance().getGetUserInfoProvider().getUserInfo(userId);
            if (userInfo != null) {
                if (getUserInfoCallback != null) {
                    UIUserInfo uiUserInfo = new UIUserInfo(userInfo);
                    getUserInfoCallback.onSuccess(uiUserInfo);
                }
            } else {
                RCloudContext.getInstance().getRongIMClient().getUserInfo(userId, new RongIMClient.GetUserInfoCallback(){

                    @Override
                    public void onSuccess(RongIMClient.UserInfo user) {
                        UIUserInfo uiUserInfo = new UIUserInfo(user);
                        getUserInfoCallback.onSuccess(uiUserInfo);
                    }

                    @Override
                    public void onError(RongIMClient.GetUserInfoCallback.ErrorCode errorCode) {
                        getUserInfoCallback.onError();
                    }
                });
            }
        } else {
            RCloudContext.getInstance().getRongIMClient().getUserInfo(userId, new RongIMClient.GetUserInfoCallback(){

                @Override
                public void onSuccess(RongIMClient.UserInfo user) {
                    UIUserInfo uiUserInfo = new UIUserInfo(user);
                    getUserInfoCallback.onSuccess(uiUserInfo);
                }

                @Override
                public void onError(RongIMClient.GetUserInfoCallback.ErrorCode errorCode) {
                    getUserInfoCallback.onError();
                }
            });
        }
    }

    private synchronized void newMessageReminder() {
        if (this.mLastReminderRunnable == null) {
            this.mLastReminderRunnable = new NewMessageReminderRunnable();
            this.mHandler.post((Runnable)this.mLastReminderRunnable);
        } else {
            this.mHandler.removeCallbacks((Runnable)this.mLastReminderRunnable);
            this.mHandler.postDelayed((Runnable)new NewMessageReminderRunnable(), 500L);
        }
    }

    private void playNewMessageSound() {
        try {
            MediaPlayer mMediaPlayer = new MediaPlayer();
            Uri alert = RingtoneManager.getDefaultUri((int)2);
            mMediaPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

                public void onPrepared(MediaPlayer mp) {
                    mp.start();
                }
            });
            mMediaPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

                public void onCompletion(MediaPlayer mp) {
                    Log.d((String)"RongIMService", (String)"playNewMessageSound---onCompletion");
                    mp.reset();
                    mp.release();
                    mp = null;
                }
            });
            mMediaPlayer.setDataSource((Context)this, alert);
            mMediaPlayer.prepare();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    class NewMessageReminderRunnable
    implements Runnable {
        NewMessageReminderRunnable() {
        }

        @Override
        public void run() {
            if (RongConst.SYS.BLOCK_MESSAGE_NOTICE) {
                return;
            }
            AudioManager audioManager = (AudioManager)RongIMService.this.getSystemService("audio");
            switch (audioManager.getRingerMode()) {
                case 0: {
                    break;
                }
                case 1: {
                    Vibrator vibrator = (Vibrator)RongIMService.this.getSystemService("vibrator");
                    vibrator.vibrate(200L);
                    break;
                }
                case 2: {
                    RongIMService.this.playNewMessageSound();
                }
            }
        }
    }
}

