/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.model;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import io.rong.imkit.Res;
import io.rong.imkit.adapter.BaseViewProvider;
import io.rong.imkit.adapter.IBeanItemView;
import io.rong.imkit.adapter.ImageItemViewProvider;
import io.rong.imkit.adapter.ImageTextItemViewProvider;
import io.rong.imkit.adapter.InfoNotificationViewProvider;
import io.rong.imkit.adapter.LocationItemViewProvider;
import io.rong.imkit.adapter.NotificationViewProvider;
import io.rong.imkit.adapter.TextItemViewProvider;
import io.rong.imkit.adapter.UnknownMessageItemProvider;
import io.rong.imkit.adapter.VoiceItemViewProvider;
import io.rong.imkit.common.MessageContext;
import io.rong.imkit.model.RCloudType;
import io.rong.imkit.model.UIConversation;
import io.rong.imkit.model.UIUserInfo;
import io.rong.imkit.utils.HTMLDecoder;
import io.rong.imkit.utils.HighLightUtils;
import io.rong.imkit.utils.ParcelUtils;
import io.rong.imkit.utils.Util;
import io.rong.imlib.RongIMClient;
import io.rong.message.ImageMessage;
import io.rong.message.InformationNotificationMessage;
import io.rong.message.LocationMessage;
import io.rong.message.RichContentMessage;
import io.rong.message.TextMessage;
import io.rong.message.VoiceMessage;
import java.util.ArrayList;

public class UIMessage
extends RongIMClient.Message
implements RCloudType,
Parcelable,
IBeanItemView {
    public static final String MESSAGE_OBJ = "message_obj";
    public static final String MESSAGE_CATEGORY_TEXT = "message_category_text";
    public static final String MESSAGE_CATEGORY_IMAGE = "message_category_image";
    public static final String MESSAGE_CATEGORY_VOICE = "message_category_voice";
    public static final String MESSAGE_CATEGORY_IMAGE_TEXT = "message_category_image_text";
    public static final String MESSAGE_CATEGORY_DISCUSSION_NOTIFY = "message_category_discussion_notification";
    public static final String MESSAGE_CATEGORY_LOCATION = "message_category_location";
    public static final String MESSAGE_CATEGORY_INFO_NOTIFICATION = "message_category_info_notification";
    public static final String MESSAGE_VOICE_READED = "message_voice_readed";
    public static final String MESSAGE_VOICE_UNREAD = "message_voice_unread";
    private String messageCategory;
    private UIUserInfo userInfo;
    private ArrayList<String> portaintUrl;
    private int progressText = -1;
    private boolean isSending = false;
    private int positionInList;
    private String draft;
    private boolean isNotify;
    private UIUserInfo operator;
    private UIUserInfo operatored;
    private SpannableStringBuilder textMessageContent = null;
    public static final Parcelable.Creator<UIMessage> CREATOR = new Parcelable.Creator<UIMessage>(){

        public UIMessage createFromParcel(Parcel source) {
            return new UIMessage(source);
        }

        public UIMessage[] newArray(int size) {
            return new UIMessage[size];
        }
    };

    public String getDraft() {
        return this.draft;
    }

    public void setDraft(String draft) {
        this.draft = draft;
    }

    public int getPositionInList() {
        return this.positionInList;
    }

    public void setPositionInList(int positionInList) {
        this.positionInList = positionInList;
    }

    public UIMessage() {
    }

    public UIMessage(RongIMClient.Message message) {
        if (message != null) {
            this.setContent(message.getContent());
            this.setConversationType(message.getConversationType());
            this.setExtra(message.getExtra());
            this.setMessageDirection(message.getMessageDirection());
            this.setMessageId(message.getMessageId());
            this.setObjectName(message.getObjectName());
            this.setReceivedStatus(message.getReceivedStatus());
            this.setReceivedTime(message.getReceivedTime());
            this.setSenderUserId(message.getSenderUserId());
            this.setSentStatus(message.getSentStatus());
            this.setSentTime(message.getSentTime());
            this.setTargetId(message.getTargetId());
            if (this.getContent() instanceof TextMessage) {
                this.setMessageCategory(MESSAGE_CATEGORY_TEXT);
            } else if (this.getContent() instanceof ImageMessage) {
                this.setMessageCategory(MESSAGE_CATEGORY_IMAGE);
            } else if (this.getContent() instanceof VoiceMessage) {
                this.setMessageCategory(MESSAGE_CATEGORY_VOICE);
            } else if (this.getContent() instanceof RichContentMessage) {
                this.setMessageCategory(MESSAGE_CATEGORY_IMAGE_TEXT);
            } else if (this.getContent() instanceof RongIMClient.DiscussionNotificationMessage) {
                this.setMessageCategory(MESSAGE_CATEGORY_DISCUSSION_NOTIFY);
            } else if (this.getContent() instanceof LocationMessage) {
                this.setMessageCategory(MESSAGE_CATEGORY_LOCATION);
            } else if (this.getContent() instanceof InformationNotificationMessage) {
                this.setMessageCategory(MESSAGE_CATEGORY_INFO_NOTIFICATION);
            }
            this.setExtra(message.getExtra());
        }
    }

    public SpannableStringBuilder getTextMessageContent() {
        if (this.textMessageContent != null) {
            return this.textMessageContent;
        }
        if (this.getContent() instanceof TextMessage) {
            TextMessage textMessage = (TextMessage)this.getContent();
            if (!TextUtils.isEmpty((CharSequence)textMessage.getContent())) {
                this.textMessageContent = new SpannableStringBuilder((CharSequence)Util.highLightLink(HighLightUtils.loadHighLight(HighLightUtils.replaceEmoji(textMessage.getContent()))));
                return this.textMessageContent;
            }
            this.textMessageContent = new SpannableStringBuilder((CharSequence)"");
        }
        return new SpannableStringBuilder((CharSequence)"");
    }

    public SpannableStringBuilder getInfoMessageContent() {
        if (this.textMessageContent != null) {
            return this.textMessageContent;
        }
        if (this.getContent() instanceof InformationNotificationMessage) {
            InformationNotificationMessage textMessage = (InformationNotificationMessage)this.getContent();
            String str = HTMLDecoder.decode(HTMLDecoder.decode(textMessage.getMessage()));
            this.textMessageContent = Util.highLight(HighLightUtils.loadHighLight(HighLightUtils.replaceEmoji(str)));
            return this.textMessageContent;
        }
        return new SpannableStringBuilder((CharSequence)"");
    }

    public String getTextMessageContentStr() {
        String str = "";
        if (this.getContent() instanceof TextMessage) {
            TextMessage textMessage = (TextMessage)this.getContent();
            str = HTMLDecoder.decode(HTMLDecoder.decode(textMessage.getContent()));
        }
        return str;
    }

    public String getUIImageContent(Context context) {
        if (this.getContent() instanceof ImageMessage) {
            return context.getResources().getString(Res.getInstance(context).string("message_type_image_content"));
        }
        return "";
    }

    public String getUIVoiceContent(Context context) {
        if (this.getContent() instanceof VoiceMessage) {
            return context.getResources().getString(Res.getInstance(context).string("message_type_voice_content"));
        }
        return "";
    }

    public UIMessage(Parcel in) {
        int flag = in.readInt();
        if (flag == 1) {
            this.setConversationType(RongIMClient.ConversationType.setValue(in.readInt()));
        } else {
            this.setConversationType(null);
        }
        this.setTargetId(ParcelUtils.readStringFromParcel(in));
        this.setMessageId(in.readInt());
        flag = in.readInt();
        if (flag == 1) {
            this.setMessageDirection(RongIMClient.MessageDirection.setValue(in.readInt()));
        } else {
            this.setMessageDirection(null);
        }
        this.setSenderUserId(ParcelUtils.readStringFromParcel(in));
        flag = in.readInt();
        if (flag == 1) {
            this.setReceivedStatus(new RongIMClient.ReceivedStatus(in.readInt(), this.getMessageId()));
        } else {
            this.setReceivedStatus(new RongIMClient.ReceivedStatus(0, this.getMessageId()));
        }
        flag = in.readInt();
        if (flag == 1) {
            this.setSentStatus(RongIMClient.SentStatus.setValue(in.readInt()));
        } else {
            this.setSentStatus(null);
        }
        this.setReceivedTime(in.readLong());
        this.setSentTime(in.readLong());
        this.setObjectName(ParcelUtils.readStringFromParcel(in));
        this.setSenderUserId(ParcelUtils.readStringFromParcel(in));
        flag = in.readInt();
        if (flag == 1) {
            flag = in.readInt();
            if (flag == 100) {
                this.setContent(ParcelUtils.readFromParcel(in, TextMessage.class));
            } else if (flag == 200) {
                this.setContent(ParcelUtils.readFromParcel(in, ImageMessage.class));
            } else if (flag == 300) {
                this.setContent(ParcelUtils.readFromParcel(in, VoiceMessage.class));
            } else if (flag == 400) {
                this.setContent(ParcelUtils.readFromParcel(in, RichContentMessage.class));
            } else if (flag == 500) {
                this.setContent(ParcelUtils.readFromParcel(in, RongIMClient.DiscussionNotificationMessage.class));
            } else if (flag == 600) {
                this.setContent(ParcelUtils.readFromParcel(in, LocationMessage.class));
            } else if (flag == 700) {
                this.setContent(ParcelUtils.readFromParcel(in, InformationNotificationMessage.class));
            }
        } else {
            this.setContent(null);
        }
        this.setExtra(ParcelUtils.readStringFromParcel(in));
        this.setMessageCategory(ParcelUtils.readStringFromParcel(in));
        this.setSending(in.readInt() != 0);
        this.setDraft(ParcelUtils.readStringFromParcel(in));
        this.setNotify(in.readInt() == 1);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (this.getConversationType() != null) {
            dest.writeInt(1);
            dest.writeInt(this.getConversationType().getValue());
        } else {
            dest.writeInt(0);
        }
        ParcelUtils.writeStringToParcel(dest, this.getTargetId());
        dest.writeInt(this.getMessageId());
        if (this.getMessageDirection() != null) {
            dest.writeInt(1);
            dest.writeInt(this.getMessageDirection().getValue());
        } else {
            dest.writeInt(0);
        }
        ParcelUtils.writeStringToParcel(dest, this.getSenderUserId());
        if (this.getReceivedStatus() != null) {
            dest.writeInt(1);
            dest.writeInt(this.getReceivedStatus().getFlag());
        } else {
            dest.writeInt(0);
        }
        if (this.getSentStatus() != null) {
            dest.writeInt(1);
            dest.writeInt(this.getSentStatus().getValue());
        } else {
            dest.writeInt(0);
        }
        dest.writeLong(this.getReceivedTime());
        dest.writeLong(this.getSentTime());
        ParcelUtils.writeStringToParcel(dest, this.getObjectName());
        ParcelUtils.writeStringToParcel(dest, this.getSenderUserId());
        if (this.getContent() != null) {
            dest.writeInt(1);
            if (this.getContent() instanceof TextMessage) {
                dest.writeInt(100);
                ParcelUtils.writeToParcel(dest, (TextMessage)this.getContent());
            } else if (this.getContent() instanceof ImageMessage) {
                dest.writeInt(200);
                ParcelUtils.writeToParcel(dest, (ImageMessage)this.getContent());
            } else if (this.getContent() instanceof VoiceMessage) {
                dest.writeInt(300);
                ParcelUtils.writeToParcel(dest, (VoiceMessage)this.getContent());
            } else if (this.getContent() instanceof RichContentMessage) {
                dest.writeInt(400);
                ParcelUtils.writeToParcel(dest, (RichContentMessage)this.getContent());
            } else if (this.getContent() instanceof RongIMClient.DiscussionNotificationMessage) {
                dest.writeInt(500);
                ParcelUtils.writeToParcel(dest, (RongIMClient.DiscussionNotificationMessage)this.getContent());
            } else if (this.getContent() instanceof LocationMessage) {
                dest.writeInt(600);
                ParcelUtils.writeToParcel(dest, (LocationMessage)this.getContent());
            } else if (this.getContent() instanceof InformationNotificationMessage) {
                dest.writeInt(700);
                ParcelUtils.writeToParcel(dest, (InformationNotificationMessage)this.getContent());
            }
        } else {
            dest.writeInt(0);
        }
        ParcelUtils.writeStringToParcel(dest, this.getExtra());
        ParcelUtils.writeStringToParcel(dest, this.getMessageCategory());
        dest.writeInt(!this.isSending ? 0 : 1);
        ParcelUtils.writeStringToParcel(dest, this.getDraft());
        dest.writeInt(this.isNotify ? 1 : 0);
    }

    @Override
    public BaseViewProvider getItemViewProvider(MessageContext context) {
        BaseViewProvider itemViewProvider = null;
        itemViewProvider = this.getContent() instanceof TextMessage ? new TextItemViewProvider(context) : (this.getContent() instanceof ImageMessage ? new ImageItemViewProvider(context) : (this.getContent() instanceof VoiceMessage ? new VoiceItemViewProvider(context) : (this.getContent() instanceof RichContentMessage ? new ImageTextItemViewProvider(context) : (this.getContent() instanceof RongIMClient.DiscussionNotificationMessage ? new NotificationViewProvider(context) : (this.getContent() instanceof LocationMessage ? new LocationItemViewProvider(context) : (this.getContent() instanceof InformationNotificationMessage ? new InfoNotificationViewProvider(context) : new UnknownMessageItemProvider(context)))))));
        return itemViewProvider;
    }

    public UIConversation toConversation() {
        UIConversation uiConversation = new UIConversation();
        if (!TextUtils.isEmpty((CharSequence)this.getDraft())) {
            uiConversation.setDraft(this.getDraft());
        }
        uiConversation.setConversationType(this.getConversationType());
        uiConversation.setLatestMessageId(this.getMessageId());
        uiConversation.setLatestMessage(this.getContent());
        uiConversation.setObjectName(this.getObjectName());
        uiConversation.setReceivedTime(this.getReceivedTime());
        uiConversation.setSentTime(this.getSentTime());
        uiConversation.setSenderUserId(this.getSenderUserId());
        uiConversation.setTargetId(this.getTargetId());
        return uiConversation;
    }

    public String getMessageCategory() {
        if (TextUtils.isEmpty((CharSequence)this.messageCategory) && this.getContent() != null) {
            if (this.getContent() instanceof TextMessage) {
                this.setMessageCategory(MESSAGE_CATEGORY_TEXT);
            } else if (this.getContent() instanceof ImageMessage) {
                this.setMessageCategory(MESSAGE_CATEGORY_IMAGE);
            } else if (this.getContent() instanceof VoiceMessage) {
                this.setMessageCategory(MESSAGE_CATEGORY_VOICE);
            } else if (this.getContent() instanceof RichContentMessage) {
                this.setMessageCategory(MESSAGE_CATEGORY_IMAGE_TEXT);
            } else if (this.getContent() instanceof RongIMClient.DiscussionNotificationMessage) {
                this.setMessageCategory(MESSAGE_CATEGORY_DISCUSSION_NOTIFY);
            } else if (this.getContent() instanceof LocationMessage) {
                this.setMessageCategory(MESSAGE_CATEGORY_LOCATION);
            } else if (this.getContent() instanceof InformationNotificationMessage) {
                this.setMessageCategory(MESSAGE_CATEGORY_INFO_NOTIFICATION);
            }
        }
        return this.messageCategory;
    }

    public void setMessageCategory(String messageCategory) {
        this.messageCategory = messageCategory;
    }

    public void setTextMessageContent(SpannableStringBuilder textMessageContent) {
        this.textMessageContent = textMessageContent;
    }

    public UIUserInfo getUserInfo() {
        return this.userInfo;
    }

    public void setUserInfo(UIUserInfo userInfo) {
        this.userInfo = userInfo;
    }

    @Override
    public void setSenderUserId(String senderUserId) {
        super.setSenderUserId(senderUserId);
    }

    public ArrayList<String> getPortaintUrl() {
        return this.portaintUrl;
    }

    public void setPortaintUrl(ArrayList<String> portaintUrl) {
        this.portaintUrl = portaintUrl;
    }

    public int getProgressText() {
        return this.progressText;
    }

    public void setProgressText(int progressText) {
        this.progressText = progressText;
    }

    public boolean isSending() {
        return this.isSending;
    }

    public void setSending(boolean isSending) {
        this.isSending = isSending;
    }

    public boolean isNotify() {
        return this.isNotify;
    }

    public void setNotify(boolean isNotify) {
        this.isNotify = isNotify;
    }

    public UIUserInfo getOperatored() {
        return this.operatored;
    }

    public void setOperatored(UIUserInfo operatored) {
        this.operatored = operatored;
    }

    public UIUserInfo getOperator() {
        return this.operator;
    }

    public void setOperator(UIUserInfo operator) {
        this.operator = operator;
    }
}

