/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.model;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import io.rong.imkit.Res;
import io.rong.imkit.model.RCloudType;
import io.rong.imkit.model.UIDiscussion;
import io.rong.imkit.model.UIGroup;
import io.rong.imkit.model.UIUserInfo;
import io.rong.imkit.utils.HTMLDecoder;
import io.rong.imkit.utils.HighLightUtils;
import io.rong.imkit.utils.ParcelUtils;
import io.rong.imkit.utils.Util;
import io.rong.imlib.RongIMClient;
import io.rong.message.ImageMessage;
import io.rong.message.InformationNotificationMessage;
import io.rong.message.LocationMessage;
import io.rong.message.RichContentMessage;
import io.rong.message.TextMessage;
import io.rong.message.VoiceMessage;

public class UIConversation
extends RongIMClient.Conversation
implements Parcelable,
RCloudType {
    private UIUserInfo userInfo;
    private UIDiscussion uiDiscussion;
    private UIGroup uiGroup;
    private UIUserInfo operator;
    private UIUserInfo operatored;
    private static final int TEXT_MESSAGE = 101;
    private static final int IMAGE_MESSAGE = 102;
    private static final int VOICE_MESSAGE = 103;
    private static final int RICH_CONTENT_MESSAGE = 104;
    private static final int LOCATION_MESSAGE = 105;
    private static final int INFONOTIFICATION_MESSAGE = 106;
    public static final Parcelable.Creator<UIConversation> CREATOR = new Parcelable.Creator<UIConversation>(){

        public UIConversation createFromParcel(Parcel source) {
            return new UIConversation(source);
        }

        public UIConversation[] newArray(int size) {
            return new UIConversation[size];
        }
    };
    private SpannableStringBuilder textMessageContent = null;

    public UIConversation() {
    }

    public UIConversation(RongIMClient.Conversation conversation) {
        if (conversation != null) {
            this.setConversationTitle(conversation.getConversationTitle());
            this.setConversationType(conversation.getConversationType());
            this.setDraft(conversation.getDraft());
            this.setLatestMessageId(conversation.getLatestMessageId());
            this.setLatestMessage(conversation.getLatestMessage());
            this.setObjectName(conversation.getObjectName());
            this.setReceivedTime(conversation.getReceivedTime());
            this.setSenderUserId(conversation.getSenderUserId());
            this.setSenderUserName(conversation.getSenderUserName());
            this.setSentStatus(conversation.getSentStatus());
            this.setSentTime(conversation.getSentTime());
            this.setTargetId(conversation.getTargetId());
            this.setTop(conversation.isTop());
            this.setUnreadMessageCount(conversation.getUnreadMessageCount());
            this.setNotificationStatus(conversation.getNotificationStatus());
        }
    }

    public UIConversation(Parcel in) {
        int flag = in.readInt();
        if (flag == 1) {
            this.setConversationType(RongIMClient.ConversationType.setValue(in.readInt()));
        } else {
            this.setConversationType(null);
        }
        this.setTargetId(ParcelUtils.readStringFromParcel(in));
        this.setConversationTitle(ParcelUtils.readStringFromParcel(in));
        this.setUnreadMessageCount(in.readInt());
        this.setTop(in.readInt() == 1);
        flag = in.readInt();
        if (flag == 1) {
            this.setSentStatus(RongIMClient.SentStatus.setValue(in.readInt()));
        } else {
            this.setSentStatus(null);
        }
        this.setReceivedTime(in.readLong());
        this.setSentTime(in.readLong());
        this.setObjectName(ParcelUtils.readStringFromParcel(in));
        this.setSenderUserId(ParcelUtils.readStringFromParcel(in));
        this.setSenderUserName(ParcelUtils.readStringFromParcel(in));
        this.setLatestMessageId(in.readInt());
        flag = in.readInt();
        if (flag == 1) {
            int messageType = in.readInt();
            switch (messageType) {
                case 101: {
                    this.setLatestMessage(ParcelUtils.readFromParcel(in, TextMessage.class));
                    break;
                }
                case 102: {
                    this.setLatestMessage(ParcelUtils.readFromParcel(in, ImageMessage.class));
                    break;
                }
                case 103: {
                    this.setLatestMessage(ParcelUtils.readFromParcel(in, VoiceMessage.class));
                    break;
                }
                case 104: {
                    this.setLatestMessage(ParcelUtils.readFromParcel(in, RichContentMessage.class));
                    break;
                }
                case 105: {
                    this.setLatestMessage(ParcelUtils.readFromParcel(in, LocationMessage.class));
                    break;
                }
                case 106: {
                    this.setLatestMessage(ParcelUtils.readFromParcel(in, InformationNotificationMessage.class));
                }
            }
        } else {
            this.setLatestMessage(null);
        }
        this.setDraft(ParcelUtils.readStringFromParcel(in));
        this.setUiDiscussion(ParcelUtils.readFromParcel(in, UIDiscussion.class));
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (this.getConversationType() != null) {
            dest.writeInt(1);
            dest.writeInt(this.getConversationType().getValue());
        } else {
            dest.writeInt(0);
        }
        ParcelUtils.writeStringToParcel(dest, this.getTargetId());
        ParcelUtils.writeStringToParcel(dest, this.getConversationTitle());
        dest.writeInt(this.getUnreadMessageCount());
        dest.writeInt(this.isTop() ? 1 : 0);
        if (this.getSentStatus() != null) {
            dest.writeInt(1);
            dest.writeInt(this.getSentStatus().getValue());
        } else {
            dest.writeInt(0);
        }
        dest.writeLong(this.getReceivedTime());
        dest.writeLong(this.getSentTime());
        ParcelUtils.writeStringToParcel(dest, this.getObjectName());
        ParcelUtils.writeStringToParcel(dest, this.getSenderUserId());
        ParcelUtils.writeStringToParcel(dest, this.getSenderUserName());
        dest.writeInt(this.getLatestMessageId());
        if (this.getLatestMessage() != null) {
            dest.writeInt(1);
            if (this.getLatestMessage() instanceof TextMessage) {
                dest.writeInt(101);
            } else if (this.getLatestMessage() instanceof ImageMessage) {
                dest.writeInt(102);
            } else if (this.getLatestMessage() instanceof VoiceMessage) {
                dest.writeInt(103);
            } else if (this.getLatestMessage() instanceof RichContentMessage) {
                dest.writeInt(104);
            } else if (this.getLatestMessage() instanceof LocationMessage) {
                dest.writeInt(105);
            } else if (this.getLatestMessage() instanceof InformationNotificationMessage) {
                dest.writeInt(106);
            }
            ParcelUtils.writeToParcel(dest, this.getLatestMessage());
        } else {
            dest.writeInt(0);
        }
        ParcelUtils.writeStringToParcel(dest, this.getDraft());
        ParcelUtils.writeToParcel(dest, this.uiDiscussion);
    }

    public SpannableStringBuilder getTextMessageContent() {
        if (this.textMessageContent != null) {
            return this.textMessageContent;
        }
        if (this.getLatestMessage() instanceof TextMessage || this.getLatestMessage() instanceof InformationNotificationMessage) {
            TextMessage textMessage = (TextMessage)this.getLatestMessage();
            if (!TextUtils.isEmpty((CharSequence)textMessage.getContent())) {
                this.textMessageContent = new SpannableStringBuilder((CharSequence)Util.highLightLink(HighLightUtils.loadHighLight(HighLightUtils.replaceEmoji(textMessage.getContent()))));
                return this.textMessageContent;
            }
            this.textMessageContent = new SpannableStringBuilder((CharSequence)"");
        }
        return new SpannableStringBuilder((CharSequence)"");
    }

    public UIUserInfo getUserInfo() {
        return this.userInfo;
    }

    public void setUserInfo(UIUserInfo userInfo) {
        this.userInfo = userInfo;
    }

    public void setTextMessageContent(SpannableStringBuilder textMessageContent) {
        this.textMessageContent = textMessageContent;
    }

    public UIDiscussion getUiDiscussion() {
        return this.uiDiscussion;
    }

    public void setUiDiscussion(UIDiscussion uiDiscussion) {
        this.uiDiscussion = uiDiscussion;
        if (uiDiscussion != null) {
            this.setConversationTitle(uiDiscussion.getName());
        }
    }

    public UIGroup getUiGroup() {
        return this.uiGroup;
    }

    public void setUiGroup(UIGroup uiGroup) {
        this.uiGroup = uiGroup;
    }

    public String getTextMessageContentStr() {
        String str = "";
        if (this.getLatestMessage() instanceof TextMessage) {
            TextMessage textMessage = (TextMessage)this.getLatestMessage();
            str = HTMLDecoder.decode(HTMLDecoder.decode(textMessage.getContent()));
        }
        return str;
    }

    public String getUIImageContent(Context context) {
        if (this.getLatestMessage() instanceof ImageMessage) {
            return context.getResources().getString(Res.getInstance(context).string("message_type_image_content"));
        }
        return "";
    }

    public String getUIVoiceContent(Context context) {
        if (this.getLatestMessage() instanceof VoiceMessage) {
            return context.getResources().getString(Res.getInstance(context).string("message_type_voice_content"));
        }
        return "";
    }

    public String getUIImageTextContent(Context context) {
        if (this.getLatestMessage() instanceof RichContentMessage) {
            return context.getResources().getString(Res.getInstance(context).string("message_type_image_text_content"));
        }
        return "";
    }

    public String getUILocationContent(Context context) {
        if (this.getLatestMessage() instanceof LocationMessage) {
            return context.getResources().getString(Res.getInstance(context).string("message_type_location_content"));
        }
        return "";
    }

    public UIUserInfo getOperator() {
        return this.operator;
    }

    public void setOperator(UIUserInfo operator) {
        this.operator = operator;
    }

    public UIUserInfo getOperatored() {
        return this.operatored;
    }

    public void setOperatored(UIUserInfo operatored) {
        this.operatored = operatored;
    }
}

