/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.model;

import android.widget.SectionIndexer;
import io.rong.imkit.model.Friend;
import io.rong.imkit.view.CompositeAdapter;
import java.util.Arrays;

public class FriendSectionIndexer
implements SectionIndexer {
    private String[] mSections;
    private int[] mPositions;
    private int mCount;

    public FriendSectionIndexer(CompositeAdapter.Partition<Friend>[] data) {
        int size = 0;
        if (data == null || (size = data.length) == 0) {
            throw new NullPointerException();
        }
        this.mSections = new String[size];
        this.mPositions = new int[size];
        for (int i = 0; i < size; ++i) {
            this.mPositions[i] = -1;
        }
        int position = 0;
        for (int i = 0; i < size; ++i) {
            if (data[i] == null || data[i].getList() == null || data[i].getList().size() <= 0) continue;
            this.mSections[i] = String.valueOf(data[i].getList().get(0).getSearchKey());
            this.mPositions[i] = data[i].getHasHeader() ? position++ : position;
            position += data[i].getList().size();
        }
        this.mCount = position;
    }

    public Object[] getSections() {
        return this.mSections;
    }

    public int getPositionForSection(int section) {
        if (section < 0 || section >= this.mSections.length) {
            return -1;
        }
        return this.mPositions[section];
    }

    public int getSectionForPosition(int position) {
        if (position < 0 || position >= this.mCount) {
            return -1;
        }
        int index = Arrays.binarySearch(this.mPositions, position);
        return index >= 0 ? index : -index - 2;
    }

    public void setProfileHeader(String header) {
        if (this.mSections != null) {
            if (this.mSections.length > 0 && header.equals(this.mSections[0])) {
                return;
            }
            String[] tempSections = new String[this.mSections.length + 1];
            int[] tempPositions = new int[this.mPositions.length + 1];
            tempSections[0] = header;
            tempPositions[0] = 0;
            for (int i = 1; i <= this.mPositions.length; ++i) {
                tempSections[i] = this.mSections[i - 1];
                tempPositions[i] = this.mPositions[i - 1] + 1;
            }
            this.mSections = tempSections;
            this.mPositions = tempPositions;
            ++this.mCount;
        }
    }
}

