/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.model;

import android.text.TextUtils;
import com.sea_monster.core.resource.model.Resource;
import io.rong.imkit.libs.pinyin.PinyinHelper;
import io.rong.imkit.model.IFilterModel;
import io.rong.imkit.model.IFriend;
import io.rong.imkit.model.RCloudType;

public class Friend
implements IFriend,
RCloudType,
Comparable<Friend>,
IFilterModel {
    private String userId;
    private String nickname;
    private String nicknamePinyin;
    private String portrait;
    private char searchKey;
    private Resource portraitResource;
    private boolean isCall = false;
    private boolean isAdd = false;
    private boolean isSub = false;
    private boolean isDel = false;
    private boolean isSelected = false;

    @Override
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    @Override
    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
        this.createSeachKey(nickname);
    }

    private final void createSeachKey(String nickname) {
        if (TextUtils.isEmpty((CharSequence)nickname)) {
            return;
        }
        this.nicknamePinyin = PinyinHelper.getInstance().getPinyins(nickname, "");
        if (this.nicknamePinyin != null && this.nicknamePinyin.length() > 0) {
            int key = this.nicknamePinyin.charAt(0);
            if (key < 65 || key > 90) {
                key = key >= 97 && key <= 122 ? (int)((char)(key - 32)) : 35;
            }
            this.searchKey = (char)key;
        } else {
            this.searchKey = (char)35;
        }
    }

    @Override
    public String getNicknamePinyin() {
        return this.nicknamePinyin;
    }

    public void setNicknamePinyin(String nicknamePinyin) {
        this.nicknamePinyin = nicknamePinyin;
    }

    @Override
    public String getPortrait() {
        return this.portrait;
    }

    public void setPortrait(String portrait) {
        this.portrait = portrait;
        if (!TextUtils.isEmpty((CharSequence)portrait)) {
            this.setPortraitResource(new Resource(portrait));
        }
    }

    @Override
    public int compareTo(Friend another) {
        return this.getNicknamePinyin().compareTo(another.getNicknamePinyin());
    }

    @Override
    public String getFilterKey() {
        return this.getNickname() + this.getNicknamePinyin();
    }

    @Override
    public char getSearchKey() {
        return this.searchKey;
    }

    public void setSearchKey(char searchKey) {
        this.searchKey = searchKey;
    }

    public Resource getPortraitResource() {
        return this.portraitResource;
    }

    public void setPortraitResource(Resource portraitResource) {
        this.portraitResource = portraitResource;
    }

    public boolean isAdd() {
        return this.isAdd;
    }

    public void setAdd(boolean isAdd) {
        this.isAdd = isAdd;
    }

    public boolean isSub() {
        return this.isSub;
    }

    public void setSub(boolean isSub) {
        this.isSub = isSub;
    }

    public boolean isDel() {
        return this.isDel;
    }

    public void setDel(boolean isDel) {
        this.isDel = isDel;
    }

    public boolean isCall() {
        return this.isCall;
    }

    public void setCall(boolean isCall) {
        this.isCall = isCall;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setSelected(boolean isSelected) {
        this.isSelected = isSelected;
    }
}

