/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.model;

import android.util.Log;

public enum ErrorCode {
    NOT_CONNECTED(404, "Not Connected"),
    ARGUMENT_EXCEPTION(403, "Argument Exception."),
    UNKNOWN(-1, "Unknown error."),
    PACKAGE_BROKEN(2002, "Package is broken."),
    SERVER_UNAVAILABLE(2003, "Server is unavailable."),
    TOKEN_INCORRECT(2004, "Token is incorrect."),
    APP_KEY_UNAVAILABLE(2005, "App key is unavailable."),
    DATABASE_ERROR(2006, "Database is error"),
    HANDLER_EXP(-2, "Handler exp."),
    TIMEOUT(3001, "Server is timed out.");

    private int code;
    private String msg;

    private ErrorCode(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public int getValue() {
        return this.code;
    }

    public String getMessage() {
        return this.msg;
    }

    public void setMessage(String msg) {
        this.msg = msg;
    }

    public static ErrorCode setValue(int code) {
        if (code == 3002) {
            code = 2004;
        }
        for (ErrorCode c : ErrorCode.values()) {
            if (code != c.getValue()) continue;
            return c;
        }
        Log.d((String)"RongIMClient", (String)("ConnectCallback---ErrorCode---code:" + code));
        return UNKNOWN;
    }
}

