/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.logic;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.Parcelable;
import android.util.Log;
import io.rong.imkit.RCloudContext;
import io.rong.imkit.RongIM;
import io.rong.imkit.common.RongConst;
import io.rong.imkit.logic.BaseLogic;
import io.rong.imkit.model.ErrorCode;
import io.rong.imkit.model.UIDiscussion;
import io.rong.imkit.model.UIMessage;
import io.rong.imkit.service.RongIMService;
import io.rong.imlib.MessageTag;
import io.rong.imlib.RongIMClient;
import io.rong.message.ImageMessage;
import io.rong.message.InformationNotificationMessage;
import io.rong.message.LocationMessage;
import io.rong.message.RichContentMessage;
import io.rong.message.TextMessage;
import io.rong.message.VoiceMessage;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class MessageLogic
extends BaseLogic
implements Handler.Callback {
    private static final String TAG = "MessageLogic";
    public static final String TARGET_ID = "target_id";
    public static final String LEFT_MESSAGE_COUNT = "left_message_count";
    public static final String MESSAGE_COUNT = "message_count";
    public static final String DISCUSSION_NAME = "multi_talk_name";
    public static final String DISCUSSION_MEMBER_ID = "multi_talk_id_array";
    public static final String DISCUSSION_ID = "multi_talk_id";
    public static final String DISCUSSION_IS_OPEN_INVITE_STATUS = "discussion_is_open_invite_status";
    public static final String DISCUSSION_OBJECT = "discussion_object";
    public static final String INTENT_API_OPERATION_STATUS = "intent_api_operation_status";
    public static final String INTENT_STATUE_VALUE = "intent_statue_value";
    public static final String SEND_MESSAGE_STATE = "send_message_state";
    public static final String MESSAGE_ID_SEND_MESSAGE_RETURN = "message_id_send_message_return";
    public static final String MESSAGE_OBJ_SEND_MESSAGE_RETURN = "message_OBJ_send_message_return";
    public static final String SEND_MESSAGE_RETURN_ERROR = "send_message_return_error";
    public static final String INTENT_MESSAGE_FILE_DOWN_TYPE = "intent_message_file_download_type";
    public static final String INTENT_MESSAGE_FILE_DOWN_RES = "intent_message_file_download_res";
    public static final String INTENT_MESSAGE_FILE_DOWN_RES_PATH = "intent_message_file_download_res_path";
    public static final String INTENT_MESSAGE_FILE_DOWN_PROGRESS = "intent_message_file_download_progress";
    public static final String INTENT_CONVERSATION_TYPE = "intent_conversation_type";
    public static final String INTENT_NEW_MESSAGE_BLOCK = "intent_new_message_block";
    public static final String INTENT_IS_COMPLETE = "intent_is_complete";
    private RongIMService mRongIMService;
    private Handler mHandle;
    private Looper mLooper;
    private Handler mWorkHander;
    private int mConnectStatus = 0;
    private static MessageLogic sS;
    private Integer obj = new Integer(1);
    private String peerUserPhoteUri = "";
    private boolean isStartVoip = false;
    Handler mVoipHandler = new Handler(){

        public void handleMessage(Message msg) {
            try {
                Thread.sleep(600L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (!MessageLogic.this.isStartVoip) {
                return;
            }
            Intent videoChatInt = null;
            try {
                videoChatInt = new Intent((Context)MessageLogic.this.mRongIMService, Class.forName("io.rong.voipkit.activity.CalledSideActivity"));
                videoChatInt.putExtra("VoIPCallMessage", (Parcelable)msg.obj);
                videoChatInt.putExtra("appId", RCloudContext.getInstance().getAppKey());
                videoChatInt.putExtra("peerUserPhoteUri", MessageLogic.this.peerUserPhoteUri);
                videoChatInt.setFlags(0x10000000);
                MessageLogic.this.mRongIMService.startActivity(videoChatInt);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    };
    private int mCount = -1;
    private RongIMClient.OnReceiveMessageListener onReceiveMessageListener = new RongIMClient.OnReceiveMessageListener(){

        @Override
        public void onReceived(final RongIMClient.Message message, int leftCount) {
            if (message != null && message.getConversationType() != null) {
                if (message.getContent().getClass().getName().equals("io.rong.voipkit.message.VoIPCallMessage")) {
                    long normalTime = System.currentTimeMillis() - RCloudContext.getInstance().getRongIMClient().getDeltaTime();
                    if (normalTime - message.getSentTime() > 20000L) {
                        return;
                    }
                    if (!Build.CPU_ABI.contains("arm")) {
                        return;
                    }
                    MessageLogic.this.isStartVoip = true;
                    String formId = null;
                    try {
                        Class<?> cls = Class.forName("io.rong.voipkit.message.VoIPCallMessage");
                        Method method = cls.getMethod("getFromId", new Class[0]);
                        formId = (String)method.invoke((Object)message.getContent(), new Object[0]);
                        final Method setFromUserNameMethod = cls.getMethod("setFromUserName", String.class);
                        MessageLogic.getUserInfo(formId, new GetUserInfoCallback(){

                            @Override
                            public void onSuccess(RongIMClient.UserInfo user) {
                                Message msg = MessageLogic.this.mVoipHandler.obtainMessage();
                                String uname = user.getName();
                                MessageLogic.this.peerUserPhoteUri = user.getPortraitUri();
                                if (uname == null || "".equals(uname)) {
                                    uname = "\u672a\u77e5\u8054\u7cfb\u4eba";
                                }
                                try {
                                    setFromUserNameMethod.invoke((Object)message.getContent(), uname);
                                    msg.obj = message.getContent();
                                }
                                catch (IllegalAccessException e) {
                                    e.printStackTrace();
                                }
                                catch (InvocationTargetException e) {
                                    e.printStackTrace();
                                }
                                MessageLogic.this.mVoipHandler.sendMessage(msg);
                            }

                            @Override
                            public void onError() {
                                Message msg = MessageLogic.this.mVoipHandler.obtainMessage();
                                try {
                                    setFromUserNameMethod.invoke((Object)message.getObjectName(), "\u672a\u77e5\u8054\u7cfb\u4eba");
                                    msg.obj = message.getContent();
                                }
                                catch (IllegalAccessException e) {
                                    e.printStackTrace();
                                }
                                catch (InvocationTargetException e) {
                                    e.printStackTrace();
                                }
                                MessageLogic.this.mVoipHandler.sendMessage(msg);
                            }
                        });
                    }
                    catch (NoSuchMethodException e) {
                        e.printStackTrace();
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    return;
                }
                if (message.getContent().getClass().getName().equals("io.rong.voipkit.message.VoIPAcceptMessage")) {
                    Intent i = new Intent();
                    i.putExtra("messageContent", (Parcelable)message.getContent());
                    i.setAction(MessageLogic.this.mRongIMService.getPackageName() + "com.ccrc.avtest.action.reciveMsg");
                    MessageLogic.this.mRongIMService.sendBroadcast(i);
                    return;
                }
                if (message.getContent().getClass().getName().equals("io.rong.voipkit.message.VoIPFinishMessage")) {
                    MessageLogic.this.isStartVoip = false;
                    Intent i = new Intent();
                    i.putExtra("messageContent", (Parcelable)message.getContent());
                    i.setAction(MessageLogic.this.mRongIMService.getPackageName() + "com.ccrc.avtest.action.reciveMsg");
                    MessageLogic.this.mRongIMService.sendBroadcast(i);
                    return;
                }
            }
            if (RCloudContext.getInstance().getOnReceiveMessageListener() != null) {
                RCloudContext.getInstance().getOnReceiveMessageListener().onReceived(message, leftCount);
            }
            if (message != null) {
                if (message.getContent() instanceof RongIMClient.UnknowMessage) {
                    return;
                }
                if (message.getContent() != null) {
                    MessageTag msgTag = message.getContent().getClass().getAnnotation(MessageTag.class);
                    if (msgTag != null) {
                        RCloudContext.getInstance();
                        if (!RCloudContext.isExitMessageType(msgTag.value())) {
                            return;
                        }
                    }
                } else {
                    return;
                }
            }
            if (message != null && message.getConversationType() != null) {
                if (MessageLogic.this.mCount == -1) {
                    MessageLogic.this.mCount = leftCount;
                    MessageLogic.this.mWorkHander.post((Runnable)new NoticeFilterRunnable(message, MessageLogic.this.mCount, leftCount));
                } else {
                    if (leftCount > 50) {
                        return;
                    }
                    if (MessageLogic.this.mCount > 50 && leftCount == 50) {
                        MessageLogic.this.mCount = 50;
                    }
                    MessageLogic.this.mWorkHander.post((Runnable)new NoticeFilterRunnable(message, MessageLogic.this.mCount, leftCount));
                }
                if (leftCount == 0) {
                    MessageLogic.this.mCount = -1;
                }
            }
        }
    };

    private MessageLogic(RongIMService rongIMService) {
        super(rongIMService);
        this.mRongIMService = rongIMService;
        ArrayList<String> actions = new ArrayList<String>();
        actions.add(RongConst.BROADCAST.ACTION_P2P_MESSAGE_SEND);
        actions.add(RongConst.BROADCAST.ACTION_CHATROOM_MESSAGE_RECEIVE);
        actions.add(RongConst.BROADCAST.ACTION_DISCUSSION_CREATE);
        actions.add(RongConst.BROADCAST.ACTION_DISCUSSION_MESSAGE_SEND);
        actions.add(RongConst.BROADCAST.ACTION_DISCUSSION_QUIT);
        actions.add(RongConst.BROADCAST.ACTION_MESSAGE_IMAGE_DOWNLOAD);
        actions.add(RongConst.BROADCAST.ACTION_DISCUSSION_INFO_GET);
        actions.add(RongConst.BROADCAST.ACTION_DISCUSSION_INVITE_MEMBER);
        actions.add(RongConst.BROADCAST.ACTION_DISCUSSION_UPDATE_NAME);
        actions.add(RongConst.BROADCAST.ACTION_SET_DISCUSSION_INVITE_STATUS);
        actions.add(RongConst.BROADCAST.ACTION_SET_BLOCK_PUSH_STATUS);
        actions.add(RongConst.BROADCAST.ACTION_GET_BLOCK_PUSH_STATUS);
        this.mRongIMService.registerAction(this, actions);
        this.registerReceviceMessage();
        Log.d((String)TAG, (String)"MessageLogic----MessageLogic---init--");
        if (Looper.myLooper() == Looper.getMainLooper()) {
            Log.d((String)TAG, (String)"*************Looper.myLooper() ==Looper.getMainLooper()*******getGroupInfo***");
        }
        this.mHandle = new Handler((Handler.Callback)this);
        HandlerThread mThead = new HandlerThread(TAG);
        mThead.start();
        this.mLooper = mThead.getLooper();
        this.mWorkHander = new Handler(this.mLooper);
        this.mConnectStatus = 0;
    }

    public static void init(RongIMService rongIMService) {
        sS = new MessageLogic(rongIMService);
    }

    public static MessageLogic getInstance() {
        return sS;
    }

    @Override
    public void onHandleAction(Intent intent) {
        if (intent == null) {
            return;
        }
        String action = intent.getAction();
        Log.d((String)TAG, (String)("onHandleAction----->:" + action));
        if (RongConst.BROADCAST.ACTION_P2P_MESSAGE_SEND.equals(action)) {
            this.sendMessage(intent);
        } else if (RongConst.BROADCAST.ACTION_MESSAGE_IMAGE_DOWNLOAD.equals(action)) {
            this.downloadFile(intent);
        } else if (RongConst.BROADCAST.ACTION_DISCUSSION_CREATE.equals(action)) {
            this.createDiscussion(intent);
        } else if (RongConst.BROADCAST.ACTION_DISCUSSION_INFO_GET.equals(action)) {
            this.getDiscussion(intent);
        } else if (RongConst.BROADCAST.ACTION_DISCUSSION_QUIT.equals(action)) {
            this.quitDiscussion(intent);
        } else if (RongConst.BROADCAST.ACTION_DISCUSSION_UPDATE_NAME.equals(action)) {
            this.updateDiscussionName(intent);
        } else if (RongConst.BROADCAST.ACTION_SET_DISCUSSION_INVITE_STATUS.equals(action)) {
            this.setDiscussionInviteStatus(intent);
        } else if (RongConst.BROADCAST.ACTION_SET_BLOCK_PUSH_STATUS.equals(action)) {
            this.setBlockPushStatus(intent);
        } else if (RongConst.BROADCAST.ACTION_GET_BLOCK_PUSH_STATUS.equals(action)) {
            this.getBlockPushStatus(intent);
        }
    }

    private final void sendMessage(Intent intent) {
        String action = intent.getAction();
        Log.d((String)TAG, (String)action);
        UIMessage msg = (UIMessage)intent.getParcelableExtra("message_obj");
        if (msg != null && msg.getContent() != null) {
            MessageTag msgTag = msg.getContent().getClass().getAnnotation(MessageTag.class);
            msg.setObjectName(msgTag.value());
        }
        this.mWorkHander.post((Runnable)new SendMessageRunnable(intent, msg));
    }

    public static void getUserInfo(String userId, final GetUserInfoCallback getUserInfoCallback) {
        if (RCloudContext.getInstance().getGetUserInfoProvider() != null) {
            RongIMClient.UserInfo userInfo = RCloudContext.getInstance().getGetUserInfoProvider().getUserInfo(userId);
            if (userInfo != null) {
                if (getUserInfoCallback != null) {
                    getUserInfoCallback.onSuccess(userInfo);
                }
            } else {
                RCloudContext.getInstance().getRongIMClient().getUserInfo(userId, new RongIMClient.GetUserInfoCallback(){

                    @Override
                    public void onSuccess(RongIMClient.UserInfo user) {
                        getUserInfoCallback.onSuccess(user);
                    }

                    @Override
                    public void onError(RongIMClient.GetUserInfoCallback.ErrorCode errorCode) {
                        getUserInfoCallback.onError();
                    }
                });
            }
        } else {
            RCloudContext.getInstance().getRongIMClient().getUserInfo(userId, new RongIMClient.GetUserInfoCallback(){

                @Override
                public void onSuccess(RongIMClient.UserInfo user) {
                    getUserInfoCallback.onSuccess(user);
                }

                @Override
                public void onError(RongIMClient.GetUserInfoCallback.ErrorCode errorCode) {
                    getUserInfoCallback.onError();
                }
            });
        }
    }

    private final void registerReceviceMessage() {
        Log.d((String)TAG, (String)"--registerReceviceMessage----p2p-----");
        try {
            if (RCloudContext.getInstance() != null && RCloudContext.getInstance().getRongIMClient() != null) {
                RCloudContext.getInstance().getRongIMClient().setOnReceiveMessageListener(this.onReceiveMessageListener);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.d((String)TAG, (String)"--registerReceviceMessage----error-----");
        }
    }

    private final void downloadFile(final Intent intentArg) {
        if (intentArg == null) {
            return;
        }
        String targetId = intentArg.getStringExtra(TARGET_ID);
        int code = intentArg.getIntExtra(INTENT_MESSAGE_FILE_DOWN_TYPE, 1);
        RongIMClient.ConversationType conversationType = RongIMClient.ConversationType.setValue(code);
        Uri uri = (Uri)intentArg.getParcelableExtra(INTENT_MESSAGE_FILE_DOWN_RES);
        if (uri == null) {
            Intent intent = intentArg;
            intent.putExtra(INTENT_IS_COMPLETE, true);
            intent.putExtra(INTENT_API_OPERATION_STATUS, false);
            this.mHandle.obtainMessage(0, (Object)intent).sendToTarget();
        }
        RCloudContext.getInstance().getRongIMClient().downloadMedia(conversationType, targetId, RongIMClient.MediaType.IMAGE, uri.toString(), new RongIMClient.DownloadMediaCallback(){

            @Override
            public void onProgress(int progress) {
                Intent intent = intentArg;
                intent.putExtra(MessageLogic.INTENT_MESSAGE_FILE_DOWN_PROGRESS, progress);
                intent.putExtra(MessageLogic.INTENT_IS_COMPLETE, false);
                MessageLogic.this.mHandle.obtainMessage(0, (Object)intent).sendToTarget();
            }

            @Override
            public void onSuccess(String localMediaPath) {
                Log.d((String)MessageLogic.TAG, (String)("downloadFile---onSuccess--" + localMediaPath));
                Intent intent = intentArg;
                intent.putExtra(MessageLogic.INTENT_MESSAGE_FILE_DOWN_RES_PATH, localMediaPath);
                intent.putExtra(MessageLogic.INTENT_IS_COMPLETE, true);
                intent.putExtra(MessageLogic.INTENT_API_OPERATION_STATUS, true);
                MessageLogic.this.mHandle.obtainMessage(0, (Object)intent).sendToTarget();
            }

            @Override
            public void onError(RongIMClient.DownloadMediaCallback.ErrorCode errorCode) {
                Log.d((String)MessageLogic.TAG, (String)"downloadFile---errorCode--");
                Intent intent = intentArg;
                intent.putExtra(MessageLogic.INTENT_IS_COMPLETE, true);
                intent.putExtra(MessageLogic.INTENT_API_OPERATION_STATUS, false);
                MessageLogic.this.mHandle.obtainMessage(0, (Object)intent).sendToTarget();
            }
        });
    }

    public void inviteMemberToDiscussion(String discussionId, List<String> userIdList, final RongIM.OperationCallback callback) {
        final EventInviteDiscussion event = new EventInviteDiscussion();
        event.setDiscussionId(discussionId);
        event.setUserIdList(userIdList);
        RCloudContext.getInstance().getRongIMClient().addMemberToDiscussion(discussionId, userIdList, new RongIMClient.OperationCallback(){

            @Override
            public void onSuccess() {
                event.setSuccess(true);
                RCloudContext.getInstance().getEventBus().post(event);
                if (callback == null) {
                    return;
                }
                MessageLogic.this.mHandle.post(new Runnable(){

                    @Override
                    public void run() {
                        callback.onSuccess();
                    }
                });
            }

            @Override
            public void onError(final RongIMClient.OperationCallback.ErrorCode errorCode) {
                event.setSuccess(false);
                event.setErrorCode(errorCode.getValue());
                RCloudContext.getInstance().getEventBus().post(event);
                if (callback == null) {
                    return;
                }
                MessageLogic.this.mHandle.post(new Runnable(){

                    @Override
                    public void run() {
                        callback.onError(RongIM.OperationCallback.ErrorCode.setValue(errorCode.getValue()));
                    }
                });
            }
        });
    }

    private final void createDiscussion(final Intent intent) {
        String name = intent.getStringExtra(DISCUSSION_NAME);
        ArrayList userIdList = intent.getStringArrayListExtra(DISCUSSION_MEMBER_ID);
        RCloudContext.getInstance().getRongIMClient().createDiscussion(name, userIdList, new RongIMClient.CreateDiscussionCallback(){

            @Override
            public void onSuccess(String discussionId) {
                Log.d((String)MessageLogic.TAG, (String)"entenr createDiscussion---->onSuccess");
                intent.putExtra(MessageLogic.INTENT_API_OPERATION_STATUS, true);
                intent.putExtra(MessageLogic.DISCUSSION_ID, discussionId);
                MessageLogic.this.mHandle.obtainMessage(0, (Object)intent).sendToTarget();
            }

            @Override
            public void onError(RongIMClient.CreateDiscussionCallback.ErrorCode errorCode) {
                Log.d((String)MessageLogic.TAG, (String)("entenr createDiscussion---->onError" + errorCode.getValue()));
                intent.putExtra(MessageLogic.INTENT_API_OPERATION_STATUS, false);
                MessageLogic.this.mHandle.obtainMessage(0, (Object)intent).sendToTarget();
            }
        });
    }

    public void removeMemberFromDiscussion(String discussionId, String userId, final RongIM.OperationCallback callback) {
        final EventRemoveDiscussion event = new EventRemoveDiscussion();
        event.setDiscussionId(discussionId);
        event.setUserId(userId);
        RCloudContext.getInstance().getRongIMClient().removeMemberFromDiscussion(discussionId, userId, new RongIMClient.OperationCallback(){

            @Override
            public void onSuccess() {
                Log.d((String)MessageLogic.TAG, (String)"enter removeMemberFromDiscussion----onSuccess--->");
                event.setSuccess(true);
                RCloudContext.getInstance().getEventBus().post(event);
                if (callback == null) {
                    return;
                }
                MessageLogic.this.mHandle.post(new Runnable(){

                    @Override
                    public void run() {
                        callback.onSuccess();
                    }
                });
            }

            @Override
            public void onError(final RongIMClient.OperationCallback.ErrorCode errorCode) {
                Log.d((String)MessageLogic.TAG, (String)"enter removeMemberFromDiscussion----onError--->");
                event.setSuccess(false);
                event.setErrorCode(errorCode.getValue());
                RCloudContext.getInstance().getEventBus().post(event);
                if (callback == null) {
                    return;
                }
                MessageLogic.this.mHandle.post(new Runnable(){

                    @Override
                    public void run() {
                        callback.onError(RongIM.OperationCallback.ErrorCode.setValue(errorCode.getValue()));
                    }
                });
            }
        });
    }

    public void getDiscussion(final Intent intent) {
        String discussionId = intent.getStringExtra(DISCUSSION_ID);
        RCloudContext.getInstance().getRongIMClient().getDiscussion(discussionId, new RongIMClient.GetDiscussionCallback(){

            @Override
            public void onSuccess(RongIMClient.Discussion discussion) {
                Log.d((String)MessageLogic.TAG, (String)"enter getDiscussion---onSuccess->");
                intent.putExtra(MessageLogic.INTENT_API_OPERATION_STATUS, true);
                intent.putExtra(MessageLogic.INTENT_IS_COMPLETE, true);
                intent.putExtra(MessageLogic.DISCUSSION_OBJECT, (Parcelable)new UIDiscussion(discussion));
                MessageLogic.this.mHandle.obtainMessage(0, (Object)intent).sendToTarget();
            }

            @Override
            public void onError(RongIMClient.GetDiscussionCallback.ErrorCode errorCode) {
                Log.d((String)MessageLogic.TAG, (String)("enter getDiscussion---onError->" + errorCode.getValue()));
                intent.putExtra(MessageLogic.INTENT_API_OPERATION_STATUS, false);
                intent.putExtra(MessageLogic.INTENT_IS_COMPLETE, true);
                MessageLogic.this.mHandle.obtainMessage(0, (Object)intent).sendToTarget();
            }
        });
    }

    public void quitDiscussion(final Intent intent) {
        String discussionId = intent.getStringExtra(DISCUSSION_ID);
        RCloudContext.getInstance().getRongIMClient().quitDiscussion(discussionId, new RongIMClient.OperationCallback(){

            @Override
            public void onSuccess() {
                Log.d((String)MessageLogic.TAG, (String)"quitDiscussion------onSuccess");
                intent.putExtra(MessageLogic.INTENT_API_OPERATION_STATUS, true);
                MessageLogic.this.mHandle.obtainMessage(0, (Object)intent).sendToTarget();
            }

            @Override
            public void onError(RongIMClient.OperationCallback.ErrorCode errorCode) {
                Log.d((String)MessageLogic.TAG, (String)"quitDiscussion------onError");
                intent.putExtra(MessageLogic.INTENT_API_OPERATION_STATUS, false);
                MessageLogic.this.mHandle.obtainMessage(0, (Object)intent).sendToTarget();
            }
        });
    }

    public void updateDiscussionName(final Intent intent) {
        String discussionId = intent.getStringExtra(DISCUSSION_ID);
        String name = intent.getStringExtra(DISCUSSION_NAME);
        RCloudContext.getInstance().getRongIMClient().setDiscussionName(discussionId, name, new RongIMClient.OperationCallback(){

            @Override
            public void onSuccess() {
                Log.d((String)MessageLogic.TAG, (String)"updateDiscussionName------onSuccess");
                intent.putExtra(MessageLogic.INTENT_API_OPERATION_STATUS, true);
                MessageLogic.this.mHandle.obtainMessage(0, (Object)intent).sendToTarget();
            }

            @Override
            public void onError(RongIMClient.OperationCallback.ErrorCode errorCode) {
                Log.d((String)MessageLogic.TAG, (String)"updateDiscussionName------onError");
                intent.putExtra(MessageLogic.INTENT_API_OPERATION_STATUS, false);
                MessageLogic.this.mHandle.obtainMessage(0, (Object)intent).sendToTarget();
            }
        });
    }

    public void setDiscussionInviteStatus(final Intent intent) {
        String discussionId = intent.getStringExtra(DISCUSSION_ID);
        final boolean isOpen = intent.getBooleanExtra(DISCUSSION_IS_OPEN_INVITE_STATUS, true);
        RCloudContext.getInstance().getRongIMClient().setDiscussionInviteStatus(discussionId, isOpen ? RongIMClient.DiscussionInviteStatus.OPENED : RongIMClient.DiscussionInviteStatus.CLOSED, new RongIMClient.SetDiscussionInviteStatusCallback(){

            @Override
            public void onSuccess() {
                Log.d((String)MessageLogic.TAG, (String)"setDiscussionInviteStatus------status:0");
                intent.putExtra(MessageLogic.INTENT_API_OPERATION_STATUS, true);
                intent.putExtra(MessageLogic.INTENT_STATUE_VALUE, isOpen ? RongIMClient.DiscussionInviteStatus.OPENED.getValue() : RongIMClient.DiscussionInviteStatus.CLOSED.getValue());
                MessageLogic.this.mHandle.obtainMessage(0, (Object)intent).sendToTarget();
            }

            @Override
            public void onError(RongIMClient.SetDiscussionInviteStatusCallback.ErrorCode errorCode) {
                intent.putExtra(MessageLogic.INTENT_API_OPERATION_STATUS, false);
                MessageLogic.this.mHandle.obtainMessage(0, (Object)intent).sendToTarget();
            }
        });
    }

    public void setBlockPushStatus(final Intent intent) {
        String targetId = intent.getStringExtra(TARGET_ID);
        boolean isBlock = intent.getBooleanExtra(INTENT_NEW_MESSAGE_BLOCK, false);
        int conversationTypeValue = intent.getIntExtra(INTENT_CONVERSATION_TYPE, 0);
        RongIMClient.ConversationType conversationType = RongIMClient.ConversationType.setValue(conversationTypeValue);
        RCloudContext.getInstance().getRongIMClient().setConversationNotificationStatus(conversationType, targetId, isBlock ? RongIMClient.ConversationNotificationStatus.DO_NOT_DISTURB : RongIMClient.ConversationNotificationStatus.NOTIFY, new RongIMClient.SetConversationNotificationStatusCallback(){

            @Override
            public void onSuccess(RongIMClient.ConversationNotificationStatus status) {
                Log.d((String)MessageLogic.TAG, (String)("setBlockPushStatus------onSuccess--status:" + (Object)((Object)status)));
                intent.putExtra(MessageLogic.INTENT_API_OPERATION_STATUS, true);
                intent.putExtra(MessageLogic.INTENT_STATUE_VALUE, status.getValue());
                MessageLogic.this.mHandle.obtainMessage(0, (Object)intent).sendToTarget();
            }

            @Override
            public void onError(RongIMClient.SetConversationNotificationStatusCallback.ErrorCode errorCode) {
                Log.d((String)MessageLogic.TAG, (String)("setBlockPushStatus------onError:" + errorCode.getValue()));
                intent.putExtra(MessageLogic.INTENT_API_OPERATION_STATUS, false);
                MessageLogic.this.mHandle.obtainMessage(0, (Object)intent).sendToTarget();
            }
        });
    }

    public void getBlockPushStatus(final Intent intent) {
        String targetId = intent.getStringExtra(TARGET_ID);
        int conversationTypeValue = intent.getIntExtra(INTENT_CONVERSATION_TYPE, 0);
        RongIMClient.ConversationType conversationType = RongIMClient.ConversationType.setValue(conversationTypeValue);
        RCloudContext.getInstance().getRongIMClient().getConversationNotificationStatus(conversationType, targetId, new RongIMClient.GetConversationNotificationStatusCallback(){

            @Override
            public void onSuccess(RongIMClient.ConversationNotificationStatus status) {
                Log.d((String)MessageLogic.TAG, (String)("getBlockPushStatus------onSuccess--status:" + (Object)((Object)status)));
                intent.putExtra(MessageLogic.INTENT_API_OPERATION_STATUS, true);
                intent.putExtra(MessageLogic.INTENT_STATUE_VALUE, status.getValue());
                MessageLogic.this.mHandle.obtainMessage(0, (Object)intent).sendToTarget();
            }

            @Override
            public void onError(RongIMClient.GetConversationNotificationStatusCallback.ErrorCode errorCode) {
                Log.d((String)MessageLogic.TAG, (String)("getBlockPushStatus------onError:" + errorCode.getValue()));
                intent.putExtra(MessageLogic.INTENT_API_OPERATION_STATUS, false);
                MessageLogic.this.mHandle.obtainMessage(0, (Object)intent).sendToTarget();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleMessage(Message msg) {
        Integer n = this.obj;
        synchronized (n) {
            Intent intent = (Intent)msg.obj;
            this.mRongIMService.sendBroadcast(intent);
            return true;
        }
    }

    @Override
    public void destroy() {
        this.mLooper.quit();
        super.destroy();
    }

    public static class EventRemoveDiscussion
    extends EventResult {
        String userId;
        String discussionId;

        public String getDiscussionId() {
            return this.discussionId;
        }

        public void setDiscussionId(String discussionId) {
            this.discussionId = discussionId;
        }

        public String getUserId() {
            return this.userId;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }
    }

    public static class EventResult {
        boolean isSuccess;
        ErrorCode errorCode;

        public ErrorCode getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(ErrorCode errorCode) {
            this.errorCode = errorCode;
        }

        public void setErrorCode(int code) {
            this.errorCode = ErrorCode.setValue(code);
        }

        public boolean isSuccess() {
            return this.isSuccess;
        }

        public void setSuccess(boolean isSuccess) {
            this.isSuccess = isSuccess;
        }
    }

    public static class EventInviteDiscussion
    extends EventResult {
        String discussionId;
        List<String> userIdList;

        public String getDiscussionId() {
            return this.discussionId;
        }

        public void setDiscussionId(String discussionId) {
            this.discussionId = discussionId;
        }

        public List<String> getUserIdList() {
            return this.userIdList;
        }

        public void setUserIdList(List<String> userIdList) {
            this.userIdList = userIdList;
        }
    }

    class NoticeFilterRunnable
    implements Runnable {
        RongIMClient.Message message;
        int leftMessageCount;
        int count;

        NoticeFilterRunnable(RongIMClient.Message message, int count, int leftCount) {
            this.message = message;
            this.leftMessageCount = leftCount;
            this.count = count;
        }

        @Override
        public void run() {
            Intent intent = null;
            intent = this.message.getConversationType() == RongIMClient.ConversationType.PRIVATE ? new Intent(RongConst.BROADCAST.ACTION_P2P_MESSAGE_RECEIVE) : (this.message.getConversationType() == RongIMClient.ConversationType.DISCUSSION ? new Intent(RongConst.BROADCAST.ACTION_DISCUSSION_MESSAGE_RECEIVE) : (this.message.getConversationType() == RongIMClient.ConversationType.CHATROOM ? new Intent(RongConst.BROADCAST.ACTION_CHATROOM_MESSAGE_RECEIVE) : (this.message.getConversationType() == RongIMClient.ConversationType.GROUP ? new Intent(RongConst.BROADCAST.ACTION_GROUP_MESSAGE_RECEIVE) : (this.message.getConversationType() == RongIMClient.ConversationType.CUSTOMER_SERVICE ? new Intent(RongConst.BROADCAST.ACTION_CUSTOMER_SERVICE_MESSAGE_RECEIVE) : (this.message.getConversationType() == RongIMClient.ConversationType.SYSTEM ? new Intent(RongConst.BROADCAST.ACTION_SYSTEM_MESSAGE_RECEIVE) : new Intent())))));
            final UIMessage uiMessage = new UIMessage(this.message);
            intent.putExtra("message_obj", (Parcelable)uiMessage);
            intent.putExtra(MessageLogic.TARGET_ID, uiMessage.getTargetId());
            intent.putExtra(MessageLogic.LEFT_MESSAGE_COUNT, this.leftMessageCount);
            intent.putExtra(MessageLogic.MESSAGE_COUNT, this.count);
            final Intent finalIntent = intent;
            if (this.message.getConversationType() == RongIMClient.ConversationType.CUSTOMER_SERVICE) {
                finalIntent.putExtra("notice_status", 1);
                uiMessage.setNotify(true);
                MessageLogic.this.mHandle.obtainMessage(0, (Object)finalIntent).sendToTarget();
                this.newMessageNotifycation(uiMessage, this.count, this.leftMessageCount);
                return;
            }
            if (this.message.getConversationType() == RongIMClient.ConversationType.DISCUSSION && this.message.getContent() instanceof RongIMClient.DiscussionNotificationMessage) {
                finalIntent.putExtra("notice_status", 1);
                uiMessage.setNotify(true);
                MessageLogic.this.mHandle.obtainMessage(0, (Object)finalIntent).sendToTarget();
                return;
            }
            if (this.message.getContent() instanceof InformationNotificationMessage) {
                finalIntent.putExtra("notice_status", 1);
                uiMessage.setNotify(true);
                MessageLogic.this.mHandle.obtainMessage(0, (Object)finalIntent).sendToTarget();
            } else if (this.message.getConversationType() == RongIMClient.ConversationType.SYSTEM) {
                finalIntent.putExtra("notice_status", 1);
                uiMessage.setNotify(true);
                MessageLogic.this.mHandle.obtainMessage(0, (Object)finalIntent).sendToTarget();
                this.newMessageNotifycation(uiMessage, this.count, this.leftMessageCount);
                return;
            }
            RCloudContext.getInstance().getRongIMClient().getConversationNotificationStatus(this.message.getConversationType(), this.message.getTargetId(), new RongIMClient.GetConversationNotificationStatusCallback(){

                @Override
                public void onSuccess(RongIMClient.ConversationNotificationStatus status) {
                    finalIntent.putExtra("notice_status", status == RongIMClient.ConversationNotificationStatus.NOTIFY ? 1 : 0);
                    uiMessage.setNotify(status == RongIMClient.ConversationNotificationStatus.NOTIFY);
                    MessageLogic.this.mHandle.obtainMessage(0, (Object)finalIntent).sendToTarget();
                    NoticeFilterRunnable.this.newMessageNotifycation(uiMessage, NoticeFilterRunnable.this.count, NoticeFilterRunnable.this.leftMessageCount);
                }

                @Override
                public void onError(RongIMClient.GetConversationNotificationStatusCallback.ErrorCode errorCode) {
                    MessageLogic.this.mHandle.obtainMessage(0, (Object)finalIntent).sendToTarget();
                    NoticeFilterRunnable.this.newMessageNotifycation(uiMessage, NoticeFilterRunnable.this.count, NoticeFilterRunnable.this.leftMessageCount);
                }
            });
        }

        private final void newMessageNotifycation(UIMessage uiMessage, int count, int leftMessageCount) {
            if (!(uiMessage.getContent() instanceof TextMessage || uiMessage.getContent() instanceof ImageMessage || uiMessage.getContent() instanceof VoiceMessage || uiMessage.getContent() instanceof RichContentMessage || uiMessage.getContent() instanceof LocationMessage)) {
                return;
            }
            MessageLogic.this.mRongIMService.newMessageNotifycation(uiMessage, count, leftMessageCount);
        }
    }

    public static interface GetUserInfoCallback {
        public void onSuccess(RongIMClient.UserInfo var1);

        public void onError();
    }

    class SendMessageRunnable
    implements Runnable {
        UIMessage message;
        RongIMClient.Message oriMessage;
        Intent intent;

        SendMessageRunnable(Intent intent, UIMessage message) {
            this.intent = intent;
            this.message = message;
        }

        @Override
        public void run() {
            try {
                if (RCloudContext.getInstance() != null && RCloudContext.getInstance().getRongIMClient() != null) {
                    RongIMClient.Message tmp;
                    if (RCloudContext.getInstance() != null && RCloudContext.getInstance().getOnSendMessageListener() != null && (tmp = RCloudContext.getInstance().getOnSendMessageListener().onSent(this.message)) != null && tmp != this.message) {
                        this.message.setContent(tmp.getContent());
                        this.message.setSenderUserId(tmp.getSenderUserId());
                        this.message.setConversationType(tmp.getConversationType());
                        this.message.setExtra(tmp.getExtra());
                        this.message.setTargetId(tmp.getTargetId());
                    }
                    this.oriMessage = RCloudContext.getInstance().getRongIMClient().sendMessage(this.message.getConversationType(), this.message.getTargetId(), this.message.getContent(), new RongIMClient.SendMessageCallback(){

                        @Override
                        public void onSuccess(int messageId) {
                            Log.d((String)"MessageLogic---onHandleAction--sendMessage", (String)"onSuccess:---two--");
                            if (SendMessageRunnable.this.intent == null) {
                                return;
                            }
                            Intent intentArg = SendMessageRunnable.this.intent;
                            intentArg.putExtra(MessageLogic.SEND_MESSAGE_STATE, true);
                            intentArg.putExtra(MessageLogic.INTENT_IS_COMPLETE, true);
                            intentArg.putExtra(MessageLogic.MESSAGE_ID_SEND_MESSAGE_RETURN, SendMessageRunnable.this.oriMessage.getMessageId());
                            MessageLogic.this.mRongIMService.sendBroadcast(intentArg);
                            MessageLogic.this.mRongIMService.sendBroadcast(new Intent(RongConst.BROADCAST.ACTION_RESET_DATA_FOR_CONVERSION_LIST));
                            MessageLogic.this.mRongIMService.sendBroadcast(new Intent(RongConst.BROADCAST.ACTION_RESET_DATA_FOR_CONVERSION));
                            SendMessageRunnable.this.message.setSentStatus(RongIMClient.SentStatus.SENT);
                        }

                        @Override
                        public void onProgress(int messageId, int percent) {
                            Log.d((String)"UploadMediaCallback", (String)(":" + percent));
                            Intent intentArg = SendMessageRunnable.this.intent;
                            intentArg.putExtra(MessageLogic.MESSAGE_ID_SEND_MESSAGE_RETURN, SendMessageRunnable.this.message.getMessageId());
                            intentArg.putExtra(MessageLogic.INTENT_MESSAGE_FILE_DOWN_PROGRESS, percent);
                            intentArg.putExtra(MessageLogic.INTENT_IS_COMPLETE, false);
                            MessageLogic.this.mRongIMService.sendBroadcast(intentArg);
                        }

                        @Override
                        public void onError(int messageId, final RongIMClient.SendMessageCallback.ErrorCode errorCode) {
                            MessageLogic.this.mHandle.postDelayed(new Runnable(){

                                @Override
                                public void run() {
                                    Log.d((String)"MessageLogic---onHandleAction--sendMessage", (String)("onError:---two--" + errorCode.getValue()));
                                    Intent intentArg = SendMessageRunnable.this.intent;
                                    intentArg.putExtra(MessageLogic.SEND_MESSAGE_STATE, false);
                                    intentArg.putExtra(MessageLogic.INTENT_IS_COMPLETE, true);
                                    intentArg.putExtra(MessageLogic.SEND_MESSAGE_RETURN_ERROR, errorCode.getValue());
                                    intentArg.putExtra(MessageLogic.MESSAGE_ID_SEND_MESSAGE_RETURN, SendMessageRunnable.this.oriMessage.getMessageId());
                                    MessageLogic.this.mRongIMService.sendBroadcast(intentArg);
                                    MessageLogic.this.mRongIMService.sendBroadcast(new Intent(RongConst.BROADCAST.ACTION_RESET_DATA_FOR_CONVERSION_LIST));
                                    MessageLogic.this.mRongIMService.sendBroadcast(new Intent(RongConst.BROADCAST.ACTION_RESET_DATA_FOR_CONVERSION));
                                    SendMessageRunnable.this.message.setSentStatus(RongIMClient.SentStatus.FAILED);
                                }
                            }, 200L);
                        }
                    });
                    Log.d((String)"MessageLogic---onHandleAction--sendMessage", (String)"----one---");
                    this.message.setMessageId(this.oriMessage.getMessageId());
                    UIMessage uimessage = new UIMessage(this.oriMessage);
                    Intent intentArg = this.intent;
                    intentArg.putExtra(MessageLogic.MESSAGE_ID_SEND_MESSAGE_RETURN, this.oriMessage.getMessageId());
                    intentArg.putExtra(MessageLogic.MESSAGE_OBJ_SEND_MESSAGE_RETURN, (Parcelable)uimessage);
                    intentArg.putExtra(MessageLogic.INTENT_IS_COMPLETE, false);
                    MessageLogic.this.mRongIMService.sendBroadcast(intentArg);
                }
            }
            catch (Exception e) {
                Log.d((String)"MessageLogic---onHandleAction--sendMessage", (String)"message send is fail");
                e.printStackTrace();
                Intent intentError = new Intent(this.intent.getAction());
                intentError.putExtra(MessageLogic.SEND_MESSAGE_STATE, false);
                this.intent.putExtra(MessageLogic.INTENT_IS_COMPLETE, false);
                intentError.putExtra(MessageLogic.MESSAGE_ID_SEND_MESSAGE_RETURN, this.message.getMessageId());
                MessageLogic.this.mRongIMService.sendBroadcast(intentError);
            }
        }
    }
}

