/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.libs.pinyin;

import io.rong.imkit.RCloudContext;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class PinyinHelper {
    public static final char First_HANZI = '\u4e00';
    public static final char LAST_HANZI = '\u9fa5';
    private static PinyinHelper mInstance;
    private static String[] PINYINS;
    private static final String NONE = "none";
    private static final String FILE_PATH = "unicode_to_hanyu_pinyin.dat";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PinyinHelper getInstance() {
        Class<PinyinHelper> clazz = PinyinHelper.class;
        synchronized (PinyinHelper.class) {
            if (mInstance == null) {
                mInstance = new PinyinHelper();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PinyinHelper() {
        BufferedReader br = null;
        try {
            InputStream inputStream = RCloudContext.getInstance().getResources().getAssets().open(FILE_PATH);
            br = new BufferedReader(new InputStreamReader(inputStream));
        }
        catch (IOException e) {
            throw new RuntimeException("no find pinyin assets file");
        }
        try {
            String line;
            PINYINS = new String[20902];
            for (int i = 0; (line = br.readLine()) != null && i < PINYINS.length; ++i) {
                PinyinHelper.PINYINS[i] = line;
            }
            line = null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public List<String> getPinyins(String input) {
        ArrayList<String> pinyins = null;
        if (PINYINS != null && input != null) {
            char[] chars = input.toCharArray();
            pinyins = new ArrayList<String>();
            String pinyin = null;
            int len = chars.length;
            for (int i = 0; i < len; ++i) {
                if (PinyinHelper.isHanzi(chars[i])) {
                    pinyin = PINYINS[chars[i] - 19968];
                    pinyins.add(NONE.equals(pinyin) ? String.valueOf(chars[i]) : pinyin);
                } else {
                    if (i < len - 1 && !PinyinHelper.isHanzi(chars[i + 1])) {
                        pinyin = new String(new char[]{chars[i], chars[i + 1]});
                        ++i;
                    } else {
                        pinyin = String.valueOf(chars[i]);
                    }
                    pinyins.add(pinyin);
                }
                pinyin = null;
            }
        }
        return pinyins;
    }

    public String getPinyins(String input, String separator) {
        String result = null;
        if (PINYINS != null && input != null) {
            char[] chars = input.toCharArray();
            StringBuffer pinyins = new StringBuffer(chars.length);
            String pinyin = null;
            int len = chars.length;
            for (int i = 0; i < len; ++i) {
                if (PinyinHelper.isHanzi(chars[i])) {
                    pinyin = PINYINS[chars[i] - 19968];
                    pinyins.append(NONE.equals(pinyin) ? String.valueOf(chars[i]) : pinyin);
                } else {
                    pinyins.append(String.valueOf(chars[i]));
                }
                if (i < len - 1 && (PinyinHelper.isHanzi(chars[i]) || PinyinHelper.isHanzi(chars[i + 1]))) {
                    pinyins.append(separator);
                }
                pinyin = null;
            }
            result = pinyins.toString();
            pinyins.setLength(0);
        }
        return result;
    }

    public String getFirstPinyins(String input) {
        String result = null;
        if (PINYINS != null && input != null) {
            char[] chars = input.toCharArray();
            StringBuffer pinyins = new StringBuffer(chars.length);
            String pinyin = null;
            int len = chars.length;
            for (int i = 0; i < len; ++i) {
                if (PinyinHelper.isHanzi(chars[i])) {
                    pinyin = PINYINS[chars[i] - 19968];
                    pinyins.append(NONE.equals(pinyin) ? String.valueOf(chars[i]) : Character.valueOf(pinyin.charAt(0)));
                } else {
                    pinyins.append(String.valueOf(chars[i]));
                }
                pinyin = null;
            }
            result = pinyins.toString();
            pinyins.setLength(0);
        }
        return result;
    }

    public static boolean isHanzi(char c) {
        return c >= '\u4e00' && c <= '\u9fa5';
    }

    public static boolean isHanzi(String input) {
        if (input != null && input.length() > 0) {
            for (int i = input.length() - 1; i >= 0; --i) {
                if (!PinyinHelper.isHanzi(input.charAt(i))) {
                    return false;
                }
                if (i != 0) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isContainsHanzi(String input) {
        if (input != null && input.length() > 0) {
            for (int i = input.length() - 1; i >= 0; --i) {
                if (!PinyinHelper.isHanzi(input.charAt(i))) continue;
                return true;
            }
        }
        return false;
    }
}

