/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.fragment;

import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import io.rong.imkit.Res;
import io.rong.imkit.common.RongConst;
import io.rong.imkit.fragment.ActionBaseFragment;
import io.rong.imkit.utils.BitmapUtils;
import io.rong.imkit.utils.RongToast;
import io.rong.imkit.view.LoadingDialog;
import io.rong.imlib.RongIMClient;
import java.io.File;
import java.io.IOException;

public class ShowDownloadImageFragment
extends ActionBaseFragment
implements Handler.Callback,
View.OnClickListener {
    public static final String MESSAGE_IMAGE_KEY = "message_image_key";
    private ImageView mImageView;
    private Uri mImageUri;
    private Handler mHandler;
    private LoadingDialog mDialog;
    private TextView mSaveTextView;
    private File mFile;
    private String mTargetId;
    private final int HANDLE_DOWNLOAD_SUCCESS = 10009;
    private final int HANDLE_DOWNLOAD_FAILURE = 10010;
    private final int HANDLER_LOCAL_PATH = 10011;
    private final String IMAGE_DESCRIPTION = "RongCloud_Download";

    @Override
    public void onCreate(Bundle savedInstanceState) {
        this.mHandler = new Handler((Handler.Callback)this);
        super.onCreate(savedInstanceState);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(Res.getInstance((Context)this.getActivity()).layout("rc_fragment_show_dowload_image"), null);
        this.mImageView = (ImageView)this.getViewById(view, 16908294);
        return view;
    }

    @Override
    public void onViewCreated(View view, Bundle savedInstanceState) {
        if (this.getActionBar() != null) {
            View saveView = LayoutInflater.from((Context)this.getActivity()).inflate(Res.getInstance((Context)this.getActivity()).layout("rc_action_bar_save_image"), (ViewGroup)this.getActionBar(), false);
            this.mSaveTextView = (TextView)this.getViewById(saveView, "rc_actionbar_save_image_btn");
            this.mSaveTextView.setOnClickListener((View.OnClickListener)this);
            this.getActionBar().addView((View)this.mSaveTextView);
            this.getActionBar().setOnBackClick(new View.OnClickListener(){

                public void onClick(View v) {
                    ShowDownloadImageFragment.this.getActivity().finish();
                }
            });
            this.getActionBar().getTitleTextView().setText(Res.getInstance((Context)this.getActivity()).string("show_download_image_title"));
        }
        Intent intentArg = this.getActivity().getIntent();
        this.mImageUri = (Uri)intentArg.getParcelableExtra(MESSAGE_IMAGE_KEY);
        this.mTargetId = intentArg.getStringExtra("target_id");
        Intent intent = new Intent(RongConst.BROADCAST.ACTION_MESSAGE_IMAGE_DOWNLOAD);
        intent.putExtra("intent_message_file_download_res", (Parcelable)this.mImageUri);
        intent.putExtra("intent_message_file_download_type", RongIMClient.ConversationType.PRIVATE.getValue());
        intent.putExtra("target_id", this.mTargetId);
        this.mDialog = new LoadingDialog((Context)this.getActivity());
        this.mDialog.setOnKeyListener(new DialogInterface.OnKeyListener(){

            public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
                if (4 == keyCode) {
                    ShowDownloadImageFragment.this.getActivity().finish();
                }
                return false;
            }
        });
        this.mDialog.setText(Res.getInstance((Context)this.getActivity()).string("show_download_image_loading"));
        this.mDialog.show();
        if (this.mImageUri != null) {
            if (this.mImageUri.getScheme().equals("file")) {
                this.mHandler.obtainMessage(10011, (Object)this.mImageUri).sendToTarget();
            } else {
                this.sendAction(intent, new ActionBaseFragment.ActionCallback(){

                    @Override
                    public void callback(Intent intent) {
                        String path = intent.getStringExtra("intent_message_file_download_res_path");
                        boolean isOperation = intent.getBooleanExtra("intent_api_operation_status", false);
                        boolean isComplete = intent.getBooleanExtra("intent_is_complete", false);
                        if (isComplete) {
                            if (isOperation) {
                                if (!TextUtils.isEmpty((CharSequence)path)) {
                                    ShowDownloadImageFragment.this.mHandler.obtainMessage(10009, (Object)path).sendToTarget();
                                }
                            } else {
                                ShowDownloadImageFragment.this.mHandler.obtainMessage(10010).sendToTarget();
                            }
                        }
                    }
                });
            }
        }
        super.onViewCreated(view, savedInstanceState);
    }

    public boolean handleMessage(Message msg) {
        if (msg.what == 10009) {
            String path = (String)msg.obj;
            this.setImage(path);
            if (this.mDialog != null) {
                this.mDialog.dismiss();
            }
        } else if (msg.what == 10010) {
            if (this.mDialog != null) {
                this.mDialog.dismiss();
            }
            this.mImageView.setImageResource(Res.getInstance((Context)this.getActivity()).drawable("rc_image_download_failure"));
            this.mImageView.setScaleType(ImageView.ScaleType.CENTER);
            RongToast.toast((Context)this.getActivity(), Res.getInstance((Context)this.getActivity()).string("show_image_download_failure"));
        } else if (msg.what == 10011) {
            Uri uri = (Uri)msg.obj;
            this.mFile = new File(uri.getPath());
            new ImageProcess().execute(new Uri[]{uri});
        }
        return false;
    }

    private final void setImage(String path) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inPreferredConfig = Bitmap.Config.RGB_565;
        this.mFile = new File(path);
        this.mImageView.setImageBitmap(BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options));
        this.mDialog.dismiss();
    }

    public void onClick(View v) {
        if (v == this.mSaveTextView) {
            new AsyncTask<Void, Void, Boolean>(){

                protected void onPreExecute() {
                    super.onPreExecute();
                }

                protected Boolean doInBackground(Void ... params) {
                    if (ShowDownloadImageFragment.this.getActivity() == null) {
                        return false;
                    }
                    if (ShowDownloadImageFragment.this.getActivity() != null) {
                        ContentResolver resolver = ShowDownloadImageFragment.this.getActivity().getContentResolver();
                        try {
                            MediaStore.Images.Media.insertImage((ContentResolver)resolver, (String)ShowDownloadImageFragment.this.mFile.getPath(), (String)ShowDownloadImageFragment.this.mFile.getName(), (String)"RongCloud_Download");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            return false;
                        }
                    }
                    if (ShowDownloadImageFragment.this.getActivity() != null) {
                        ShowDownloadImageFragment.this.getActivity().sendBroadcast(new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE", Uri.parse((String)ShowDownloadImageFragment.this.mFile.getPath())));
                    }
                    return true;
                }

                protected void onPostExecute(Boolean result) {
                    if (result.booleanValue()) {
                        if (ShowDownloadImageFragment.this.getActivity() != null) {
                            RongToast.toast((Context)ShowDownloadImageFragment.this.getActivity(), Res.getInstance((Context)ShowDownloadImageFragment.this.getActivity()).string("show_image_save_success"));
                        }
                    } else if (ShowDownloadImageFragment.this.getActivity() != null) {
                        RongToast.toast((Context)ShowDownloadImageFragment.this.getActivity(), Res.getInstance((Context)ShowDownloadImageFragment.this.getActivity()).string("show_image_save_failure"));
                    }
                    super.onPostExecute((Object)result);
                }
            }.execute((Object[])new Void[0]);
        }
    }

    @Override
    public boolean onBackPressed() {
        return false;
    }

    class ImageProcess
    extends AsyncTask<Uri, Void, Bitmap> {
        ImageProcess() {
        }

        protected void onPreExecute() {
            super.onPreExecute();
        }

        protected Bitmap doInBackground(Uri ... params) {
            try {
                Bitmap bitmap = BitmapUtils.getResizedBitmap((Context)ShowDownloadImageFragment.this.getActivity(), params[0], 960, 960);
                return bitmap;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }

        protected void onPostExecute(Bitmap result) {
            ShowDownloadImageFragment.this.mImageView.setImageBitmap(result);
            ShowDownloadImageFragment.this.mDialog.dismiss();
        }
    }
}

