/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.fragment;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.Toast;
import io.rong.imkit.Res;
import io.rong.imkit.fragment.BaseFragment;
import io.rong.imkit.utils.BitmapUtils;
import io.rong.imkit.utils.RongToast;
import io.rong.imkit.view.LoadingDialog;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import uk.co.senab.photoview.PhotoView;

public class PublishShowImageFragment
extends BaseFragment
implements View.OnClickListener {
    private static final String TAG = PublishShowImageFragment.class.getSimpleName();
    private PhotoView mImageView;
    private Button mBtnDel;
    private Button mBtnConfirm;
    private LoadingDialog mDialog;
    private Uri mUri;
    private File mFile;

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(Res.getInstance((Context)this.getActivity()).layout("rc_fragment_show_image"), null);
        this.mImageView = (PhotoView)this.getViewById(view, 16908294);
        this.mBtnDel = (Button)this.getViewById(view, 16908313);
        this.mBtnConfirm = (Button)this.getViewById(view, 16908314);
        if (this.getActionBar() != null) {
            this.getActionBar().setOnBackClick(new View.OnClickListener(){

                public void onClick(View v) {
                    PublishShowImageFragment.this.getActivity().finish();
                }
            });
        }
        return view;
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        this.mBtnDel.setOnClickListener((View.OnClickListener)this);
        this.mBtnConfirm.setOnClickListener((View.OnClickListener)this);
        this.mDialog = new LoadingDialog((Context)this.getActivity());
        this.mDialog.setText(Res.getInstance((Context)this.getActivity()).string("show_download_image_loading"));
        this.mDialog.show();
        if (this.getActivity().getIntent().getData() == null) {
            Toast.makeText((Context)this.getActivity(), (int)Res.getInstance((Context)this.getActivity()).string("rc_image_load_fail"), (int)0).show();
            return;
        }
        this.mUri = this.getActivity().getIntent().getData();
        if (this.mUri != null) {
            Log.d((String)TAG, (String)this.mUri.toString());
        } else {
            Log.d((String)TAG, (String)"mUri is null");
        }
        this.mFile = new File(this.getActivity().getCacheDir(), String.valueOf(new Random().nextInt()));
        Log.d((String)TAG, (String)this.mFile.getPath());
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                new ImageProcess().execute(new Uri[]{PublishShowImageFragment.this.mUri});
            }
        }, 500L);
        super.onViewCreated(view, savedInstanceState);
    }

    public void onResume() {
        super.onResume();
        new ImageProcess().execute(new Uri[]{this.mUri});
    }

    public void onClick(View v) {
        if (this.mBtnConfirm == v) {
            Intent intent = new Intent();
            if (this.mImageView.getDrawable() != null) {
                intent.setData(Uri.fromFile((File)this.mFile));
                this.getActivity().setResult(-1, intent);
            }
            this.getActivity().finish();
        } else if (v == this.mBtnDel) {
            this.getActivity().finish();
        }
    }

    @Override
    public boolean onBackPressed() {
        this.getActivity().setResult(0);
        return false;
    }

    class ImageProcess
    extends AsyncTask<Uri, Void, Bitmap> {
        ImageProcess() {
        }

        protected void onPreExecute() {
            super.onPreExecute();
        }

        protected Bitmap doInBackground(Uri ... params) {
            try {
                Bitmap bitmap = null;
                if (params != null) {
                    Log.d((String)TAG, (String)params[0].toString());
                } else {
                    Log.d((String)TAG, (String)"params is null");
                }
                bitmap = BitmapUtils.getResizedBitmap((Context)PublishShowImageFragment.this.getActivity(), params[0], 960, 960);
                if (bitmap != null) {
                    bitmap.compress(Bitmap.CompressFormat.JPEG, 60, (OutputStream)new FileOutputStream(PublishShowImageFragment.this.mFile));
                } else {
                    Log.e((String)TAG, (String)"bitmap is null");
                }
                return bitmap;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }

        protected void onPostExecute(Bitmap result) {
            if (result != null) {
                PublishShowImageFragment.this.mImageView.setImageBitmap(result);
            } else {
                RongToast.toast((Context)PublishShowImageFragment.this.getActivity(), "\u65e0\u6548\u56fe\u7247");
            }
            PublishShowImageFragment.this.mDialog.dismiss();
        }
    }
}

