/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.fragment;

import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.TextView;
import io.rong.imkit.Res;
import io.rong.imkit.RongIM;
import io.rong.imkit.adapter.FriendMultiChoiceAdapter;
import io.rong.imkit.fragment.FriendListFragment;
import io.rong.imkit.utils.RongToast;
import io.rong.imkit.view.LoadingDialog;
import io.rong.imlib.RongIMClient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class FriendMultiChoiceFragment
extends FriendListFragment
implements Handler.Callback {
    private static final String TAG = FriendMultiChoiceFragment.class.getSimpleName();
    private static final int HANDLE_UPDATE_CONFIRM_BUTTON = 10001;
    private FriendMultiChoiceAdapter.MutilChoiceCallback mCallback;
    private TextView mConfirmTextView;
    private String mConfirmFromatString;
    private ArrayList<String> mMemberIds;
    private RongIMClient.ConversationType mConversationType;
    private String mDiscussionId;
    private Handler mHandle;
    private LoadingDialog mLoadingDialog = null;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        this.mMemberIds = new ArrayList();
        if (this.getActivity().getIntent() == null || this.getActivity().getIntent().getData() == null || !this.getActivity().getIntent().getData().getScheme().equals("rong")) {
            this.mConversationType = RongIMClient.ConversationType.PRIVATE;
        } else {
            Uri uri = this.getActivity().getIntent().getData();
            this.mDiscussionId = uri.getQueryParameter("discussionId");
            String targetIds = uri.getQueryParameter("userIds");
            String delimiter = uri.getQueryParameter("delimiter");
            if (TextUtils.isEmpty((CharSequence)delimiter)) {
                delimiter = ",";
            }
            this.mConversationType = RongIMClient.ConversationType.valueOf(uri.getLastPathSegment().toUpperCase());
            if (!TextUtils.isEmpty((CharSequence)targetIds)) {
                String[] ids = targetIds.split(delimiter);
                for (String item : Arrays.asList(ids)) {
                    this.mMemberIds.add(item);
                }
            }
        }
        super.onCreate(savedInstanceState);
    }

    @Override
    public void onViewCreated(View view, Bundle savedInstanceState) {
        this.setMultiChoice(true, new ArrayList<String>(this.mMemberIds));
        super.onViewCreated(view, savedInstanceState);
        LayoutInflater inflater = LayoutInflater.from((Context)this.getActivity());
        this.mConfirmTextView = (TextView)inflater.inflate(Res.getInstance((Context)this.getActivity()).layout("rc_wi_btn_selector"), (ViewGroup)this.getActionBar(), false);
        this.mConfirmTextView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FriendMultiChoiceFragment.this.selectPeopleComplete();
            }
        });
        this.selectButtonShowStyle(0);
        this.mHandle = new Handler((Handler.Callback)this);
        if (this.getActionBar() != null) {
            this.getActionBar().addView((View)this.mConfirmTextView);
            this.getActionBar().getTitleTextView().setText(Res.getInstance((Context)this.getActivity()).string("friend_list_multi_choice_title"));
        }
    }

    private void selectButtonShowStyle(int selectedCount) {
        if (selectedCount > 0) {
            this.mConfirmTextView.setEnabled(true);
            this.mConfirmFromatString = this.getResources().getString(Res.getInstance((Context)this.getActivity()).string("friend_list_multi_choice_comfirt_btn"));
            this.mConfirmTextView.setTextColor(this.getResources().getColor(Res.getInstance((Context)this.getActivity()).color("rc_text_color_secondary_inverse")));
            this.mConfirmTextView.setText((CharSequence)String.format(this.mConfirmFromatString, selectedCount));
        } else {
            this.mConfirmTextView.setEnabled(false);
            this.mConfirmFromatString = this.getResources().getString(Res.getInstance((Context)this.getActivity()).string("friend_list_multi_choice_comfirt_btn"));
            this.mConfirmTextView.setText((CharSequence)String.format(this.mConfirmFromatString, 0));
        }
    }

    private final void selectPeopleComplete() {
        if (this.mAdapter == null) {
            return;
        }
        ArrayList<RongIMClient.UserInfo> userInfos = ((FriendMultiChoiceAdapter)this.mAdapter).getChoiceUserInfos();
        int selected = 0;
        if (this.mMemberIds != null) {
            selected = this.mMemberIds.size();
        }
        if (!this.outOfMaxPrompt(userInfos.size() + selected)) {
            return;
        }
        ArrayList<String> ids = new ArrayList<String>();
        if (userInfos.size() == 0) {
            this.getActivity().finish();
            return;
        }
        if (this.mConversationType == RongIMClient.ConversationType.DISCUSSION || userInfos.size() + this.mMemberIds.size() > 1) {
            StringBuilder sb = new StringBuilder();
            RongIMClient.UserInfo userInfo = this.getCurrentUserInfo();
            for (RongIMClient.UserInfo item : userInfos) {
                ids.add(item.getUserId());
                if (sb.length() > 20) continue;
                if (sb.length() > 0 && !TextUtils.isEmpty((CharSequence)item.getName())) {
                    sb.append(",");
                }
                sb.append(item.getName());
            }
            if (sb.length() <= 20 && userInfo != null) {
                sb.append(",");
                sb.append(userInfo.getName());
            }
            if (this.mMemberIds.size() == 0) {
                RongIM.getInstance().createDiscussionChat((Context)this.getActivity(), ids, sb.toString());
                this.getActivity().finish();
            } else {
                this.mLoadingDialog = new LoadingDialog((Context)this.getActivity());
                this.mLoadingDialog.setText(Res.getInstance((Context)this.getActivity()).string("rc_public_data_process"));
                this.mLoadingDialog.show();
                if (!TextUtils.isEmpty((CharSequence)this.mDiscussionId)) {
                    RongIM.getInstance().addMemberToDiscussion(this.mDiscussionId, ids, new RongIM.OperationCallback(){

                        @Override
                        public void onSuccess() {
                            if (FriendMultiChoiceFragment.this.mLoadingDialog != null) {
                                FriendMultiChoiceFragment.this.mLoadingDialog.dismiss();
                            }
                            FriendMultiChoiceFragment.this.getActivity().finish();
                        }

                        @Override
                        public void onError(RongIM.OperationCallback.ErrorCode errorCode) {
                            if (FriendMultiChoiceFragment.this.mLoadingDialog != null) {
                                FriendMultiChoiceFragment.this.mLoadingDialog.dismiss();
                            }
                            RongToast.toast((Context)FriendMultiChoiceFragment.this.getActivity(), Res.getInstance((Context)FriendMultiChoiceFragment.this.getActivity()).string("rc_conversation_setting_add_discussion_member_failure"));
                        }
                    });
                } else {
                    ids.addAll(this.mMemberIds);
                    RongIM.getInstance().createDiscussionChat((Context)this.getActivity(), ids, sb.toString());
                }
            }
        } else if (this.mConversationType == RongIMClient.ConversationType.PRIVATE) {
            RongIM.getInstance().startPrivateChat((Context)this.getActivity(), userInfos.get(0).getUserId(), userInfos.get(0).getName());
            this.getActivity().finish();
            return;
        }
    }

    private boolean outOfMaxPrompt(int count) {
        int setMaxCount = this.getActivity().getResources().getInteger(Res.getInstance((Context)this.getActivity()).integer("discussion_member_max_count"));
        String countFormat = this.getActivity().getResources().getString(Res.getInstance((Context)this.getActivity()).string("friend_multi_choice_people_max_prompt"));
        if (count >= setMaxCount) {
            RongToast.toast((Context)this.getActivity(), String.format(countFormat, setMaxCount));
            return false;
        }
        if (count >= 500) {
            RongToast.toast((Context)this.getActivity(), String.format(countFormat, 500));
            return false;
        }
        return true;
    }

    @Override
    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        if (this.mCallback == null) {
            this.mCallback = new FriendMultiChoiceAdapter.MutilChoiceCallback(){

                @Override
                public void callback(int count) {
                    boolean isShow = FriendMultiChoiceFragment.this.outOfMaxPrompt(count);
                    if (!isShow) {
                        return;
                    }
                    FriendMultiChoiceFragment.this.mHandle.obtainMessage(10001, (Object)(count - FriendMultiChoiceFragment.this.mMemberIds.size())).sendToTarget();
                }
            };
        }
        FriendMultiChoiceAdapter adapter = (FriendMultiChoiceAdapter)this.mAdapter;
        adapter.setCallback(this.mCallback);
        super.onItemClick(parent, view, position, id2);
    }

    @Override
    public void onPause() {
        super.onPause();
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
    }

    @Override
    public void registerActions(List<String> actions) {
        actions.add("client_connected_to_sdk");
        actions.add("client_disconnect_to_sdk");
        super.registerActions(actions);
    }

    public boolean handleMessage(Message msg) {
        if (msg.what == 10001) {
            this.selectButtonShowStyle((Integer)msg.obj);
        }
        return false;
    }
}

