/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.fragment;

import android.content.Context;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.EditText;
import android.widget.ListAdapter;
import io.rong.imkit.RCloudContext;
import io.rong.imkit.Res;
import io.rong.imkit.adapter.FriendListAdapter;
import io.rong.imkit.adapter.FriendMultiChoiceAdapter;
import io.rong.imkit.fragment.ActionBaseFragment;
import io.rong.imkit.model.Friend;
import io.rong.imkit.view.PinnedHeaderListView;
import io.rong.imkit.view.SearchHeaderView;
import io.rong.imkit.view.SwitchGroup;
import io.rong.imkit.view.SwitchItemView;
import io.rong.imlib.RongIMClient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class FriendListFragment
extends ActionBaseFragment
implements SwitchGroup.ItemHander,
View.OnClickListener,
TextWatcher,
FriendListAdapter.OnFilterFinished,
AdapterView.OnItemClickListener {
    protected FriendListAdapter mAdapter;
    private PinnedHeaderListView mListView;
    private SwitchGroup mSwitchGroup;
    private SearchHeaderView mSearchHeader;
    private EditText mEditText;
    protected List<Friend> mFriendsList;
    private boolean isMultiChoice = false;
    private ArrayList<String> mSelectedItemIds;

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(Res.getInstance((Context)this.getActivity()).layout("rc_fragment_friend_list"), null);
        this.mListView = (PinnedHeaderListView)((Object)this.getViewById(view, 16908298));
        this.mSwitchGroup = (SwitchGroup)((Object)this.getViewById(view, 16908299));
        this.mSearchHeader = new SearchHeaderView((Context)this.getActivity());
        this.mEditText = this.mSearchHeader.getEditText();
        this.mListView.addHeaderView((View)this.mSearchHeader);
        this.mListView.setPinnedHeaderView(this.getInflateView("rc_item_friend_index", (ViewGroup)this.mListView, false));
        this.mListView.setFastScrollEnabled(false);
        this.mListView.setOnItemClickListener(this);
        this.mSwitchGroup.setItemHander(this);
        this.mEditText.addTextChangedListener((TextWatcher)this);
        this.mListView.setHeaderDividersEnabled(false);
        this.mListView.setFooterDividersEnabled(false);
        return view;
    }

    public void onResume() {
        super.onResume();
    }

    @Override
    public void onViewCreated(View view, Bundle savedInstanceState) {
        if (this.getActionBar() != null) {
            this.getActionBar().setOnBackClick(new View.OnClickListener(){

                public void onClick(View v) {
                    FriendListFragment.this.getActivity().finish();
                }
            });
        }
        ArrayList userInfos = null;
        if (RCloudContext.getInstance() != null && RCloudContext.getInstance().getGetFriendsProvider() != null) {
            userInfos = (ArrayList)RCloudContext.getInstance().getGetFriendsProvider().getFriends();
        }
        this.mFriendsList = new ArrayList<Friend>();
        if (userInfos != null) {
            for (RongIMClient.UserInfo userInfo : userInfos) {
                Friend friend = new Friend();
                friend.setNickname(userInfo.getName());
                friend.setPortrait(userInfo.getPortraitUri());
                friend.setUserId(userInfo.getUserId());
                this.mFriendsList.add(friend);
            }
        }
        this.mFriendsList = this.sortFriends(this.mFriendsList);
        if (this.mSelectedItemIds != null && this.isMultiChoice) {
            block1: for (String id2 : this.mSelectedItemIds) {
                for (Friend friend : this.mFriendsList) {
                    if (!id2.equals(friend.getUserId())) continue;
                    friend.setSelected(true);
                    continue block1;
                }
            }
        }
        this.mAdapter = this.isMultiChoice ? new FriendMultiChoiceAdapter((Context)this.getActivity(), this.mFriendsList, this.mSelectedItemIds) : new FriendListAdapter((Context)this.getActivity(), this.mFriendsList);
        this.mListView.setAdapter((ListAdapter)this.mAdapter);
        this.fillData();
        super.onViewCreated(view, savedInstanceState);
    }

    @Override
    public boolean onBackPressed() {
        return false;
    }

    private final void fillData() {
        this.mAdapter.removeAll();
        this.mAdapter.setAdapterData(this.mFriendsList);
        this.mAdapter.notifyDataSetChanged();
    }

    @Override
    public void onFilterFinished() {
        if (this.mFriendsList != null && this.mFriendsList.size() == 0) {
            return;
        }
        if (this.mAdapter == null || this.mAdapter.isEmpty()) {
            // empty if block
        }
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
        if (this.mAdapter != null) {
            this.mAdapter.getFilter().filter(s);
        }
    }

    public void afterTextChanged(Editable s) {
    }

    public void onClick(View v) {
        if (v instanceof SwitchItemView) {
            CharSequence tag = ((SwitchItemView)v).getText();
            if (this.mAdapter != null && this.mAdapter.getSectionIndexer() != null) {
                Object[] sections = this.mAdapter.getSectionIndexer().getSections();
                int size = sections.length;
                for (int i = 0; i < size; ++i) {
                    if (!tag.equals(sections[i])) continue;
                    int index = this.mAdapter.getPositionForSection(i);
                    this.mListView.setSelection(index + this.mListView.getHeaderViewsCount());
                    break;
                }
            }
        }
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        Object tagObj = view.getTag();
        if (tagObj != null && tagObj instanceof FriendListAdapter.ViewHolder) {
            FriendListAdapter.ViewHolder viewHolder = (FriendListAdapter.ViewHolder)tagObj;
            this.mAdapter.onItemClick(viewHolder.friend.getUserId(), viewHolder.choice);
            return;
        }
    }

    public void onDestroyView() {
        if (this.mAdapter != null) {
            this.mAdapter.destroy();
            this.mAdapter = null;
        }
        super.onDestroyView();
    }

    public boolean isMultiChoice() {
        return this.isMultiChoice;
    }

    public void setMultiChoice(boolean isMultiChoice, ArrayList<String> selectedItemIds) {
        this.isMultiChoice = isMultiChoice;
        this.mSelectedItemIds = selectedItemIds;
    }

    private ArrayList<Friend> sortFriends(List<Friend> friends) {
        String[] searchLetters = this.getResources().getStringArray(Res.getInstance((Context)this.getActivity()).array("rc_search_letters"));
        HashMap<String, ArrayList> userMap = new HashMap<String, ArrayList>();
        ArrayList<Friend> friendsArrayList = new ArrayList<Friend>();
        for (Friend friend : friends) {
            ArrayList friendList;
            String letter = new String(new char[]{friend.getSearchKey()});
            if (userMap.containsKey(letter)) {
                friendList = (ArrayList)userMap.get(letter);
                friendList.add(friend);
                continue;
            }
            friendList = new ArrayList();
            friendList.add(friend);
            userMap.put(letter, friendList);
        }
        for (int i = 0; i < searchLetters.length; ++i) {
            String letter = searchLetters[i];
            ArrayList fArrayList = (ArrayList)userMap.get(letter);
            if (fArrayList == null) continue;
            friendsArrayList.addAll(fArrayList);
        }
        return friendsArrayList;
    }
}

