/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.fragment;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.ListAdapter;
import android.widget.RelativeLayout;
import android.widget.TextView;
import de.greenrobot.event.EventBus;
import io.rong.imkit.Res;
import io.rong.imkit.RongActivity;
import io.rong.imkit.RongIM;
import io.rong.imkit.adapter.ConversationListAdapter;
import io.rong.imkit.adapter.ConversationMemberGridViewAdapter;
import io.rong.imkit.common.RongConst;
import io.rong.imkit.data.DBHelper;
import io.rong.imkit.fragment.ActionBaseFragment;
import io.rong.imkit.fragment.ConversationFragment;
import io.rong.imkit.logic.MessageLogic;
import io.rong.imkit.model.Friend;
import io.rong.imkit.model.UIConversation;
import io.rong.imkit.model.UIDiscussion;
import io.rong.imkit.model.UIMessage;
import io.rong.imkit.model.UIUserInfo;
import io.rong.imkit.utils.RongToast;
import io.rong.imkit.view.AlterDialog;
import io.rong.imkit.view.EditTextRongDialog;
import io.rong.imkit.view.LoadingDialog;
import io.rong.imkit.view.RongGridView;
import io.rong.imlib.RongIMClient;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ConversationSettingFragment
extends ActionBaseFragment
implements View.OnClickListener,
AdapterView.OnItemClickListener,
ConversationListAdapter.OnGetDataListener,
ConversationMemberGridViewAdapter.OnGridViewImageListener {
    private static final String TAG = ConversationSettingFragment.class.getSimpleName();
    private static final int HANDLE_GET_DISCUSSION_INFO_SUCCESS = 10001;
    private static final int HANDLE_GET_DISCUSSION_INFO_FAILURE = 10002;
    private static final int HANDLE_REMOVE_MEMBER_SUCCESS = 10003;
    private static final int HANDLE_REMOVE_MEMBER_FAILURE = 10004;
    private static final int HANDLE_QUIT_DISCUSSION_FAILURE = 10005;
    private static final int HANDLE_QUIT_DISCUSSION_SUCCESS = 10006;
    private static final int HANDLE_UPDATE_DISCUSSION_NAME_SUCCESS = 10010;
    private static final int HANDLE_UPDATE_DISCUSSION_NAME_FAILURE = 10011;
    private static final int HANDLE_CREATE_DISCUSSION_SUCCESS = 10012;
    private static final int HANDLE_CREATE_DISCUSSION_FAILURE = 10013;
    private static final int HANDLE_GET_BLOCK_PUSH_STATUS_SUCCESS = 10014;
    private static final int HANDLE_GET_BLOCK_PUSH_STATUS_FAILURE = 10015;
    private static final int HANDLE_SET_DISCUSSION_INVITE_STATUS_SUCCESS = 10016;
    private static final int HANDLE_SET_DISCUSSION_INVITE_STATUS_FAILURE = 10017;
    private static final int HANDLE_SET_BLOCK_PUSH_STATUS_SUCCESS = 10018;
    private static final int HANDLE_SET_BLOCK_PUSH_STATUS_FAILURE = 10019;
    private static final int HANDLE_GET_DISCUSSION_MESSAGE = 20019;
    private static final int HANDLE_CLOSE_DIALOG = 10020;
    private static final int HANDLE_CLEAR_MESSAGE = 10022;
    public static final String INTENT_QUIT_DISCUSSION_CLOSE_PAGE = "intent_quit_discussion_close_page";
    public static final String INTENT_CLEAR_MESSSAGE_SUCCESS = "intent_clear_message_success";
    public static final String INTENT_SET_TOP_CONVERSATION_SUCCESS = "intent_set_top_conversation_success";
    public static final String INTENT_UPDATE_NAME_DISCUSSION = "intent_update_name_discussion";
    public static final String INTENT_CREATE_DISCUSSION_SUCCESS = "intent_create_discussion_success";
    private RongGridView mGridView;
    private CheckBox mSetTopConversationCheckBox;
    private CheckBox mNewMessageNotifySetCheckBox;
    private Button mExitButton;
    private RelativeLayout mClearMessagesLayout;
    private RelativeLayout setTopLayout;
    private RelativeLayout mDiscussionNameLayout;
    private RelativeLayout mOpenMemberInviteLayout;
    private TextView mDiscussionNameTextView;
    private CheckBox mOpenMemberInviteCheckBox;
    private ConversationMemberGridViewAdapter mMemberGridViewAdapter;
    private RongIMClient.ConversationType mConversationType;
    private String mTargetId;
    private ArrayList<Friend> mMembers;
    private LoadingDialog mLoadingDialog = null;
    private AlterDialog mAlterDialog;
    private UIConversation mConversation;
    private String mTempDiscussionName = null;
    private int mDelPosition = -1;
    private EditTextRongDialog editTextRongDialog;
    private Handler mWorkHandler;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        EventBus.getDefault().register(this);
        HandlerThread thread = new HandlerThread("BACK_THREAD");
        thread.start();
        this.mWorkHandler = new Handler(thread.getLooper());
        if (this.getActivity().getIntent() != null) {
            Uri uri = this.getActivity().getIntent().getData();
            this.mTargetId = uri.getQueryParameter("targetId");
            this.mConversationType = RongIMClient.ConversationType.valueOf(uri.getLastPathSegment().toUpperCase());
            this.mConversation = new UIConversation();
            this.mConversation.setTargetId(this.mTargetId);
            this.mConversation.setConversationType(this.mConversationType);
            if (!TextUtils.isEmpty((CharSequence)this.mTargetId)) {
                this.setCurrentConversationTargetId(this.mTargetId);
            }
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(Res.getInstance((Context)this.getActivity()).layout("rc_fragment_conversation_setting"), null);
        this.mLoadingDialog = new LoadingDialog((Context)this.getActivity());
        this.mGridView = (RongGridView)((Object)this.getViewById(view, 16908298));
        this.mGridView.setOnItemClickListener(this);
        this.mSetTopConversationCheckBox = (CheckBox)this.getViewById(view, 16908313);
        this.mNewMessageNotifySetCheckBox = (CheckBox)this.getViewById(view, 16908314);
        this.mSetTopConversationCheckBox.setOnClickListener((View.OnClickListener)this);
        this.mNewMessageNotifySetCheckBox.setOnClickListener((View.OnClickListener)this);
        this.mNewMessageNotifySetCheckBox.setChecked(true);
        this.mExitButton = (Button)this.getViewById(view, 16908315);
        this.mExitButton.setOnClickListener((View.OnClickListener)this);
        this.mClearMessagesLayout = (RelativeLayout)this.getViewById(view, "rc_clear_messages");
        this.mClearMessagesLayout.setTag((Object)false);
        this.mClearMessagesLayout.setOnClickListener((View.OnClickListener)this);
        this.setTopLayout = (RelativeLayout)this.getViewById(view, "rc_set_top");
        this.setTopLayout.setTag((Object)false);
        this.setTopLayout.setOnClickListener((View.OnClickListener)this);
        this.mDiscussionNameLayout = (RelativeLayout)this.getViewById(view, "rc_discussion_name_layout");
        this.mDiscussionNameLayout.setOnClickListener((View.OnClickListener)this);
        this.mDiscussionNameTextView = (TextView)this.getViewById(view, 16908308);
        this.mOpenMemberInviteLayout = (RelativeLayout)this.getViewById(view, "rc_open_member_invite_layout");
        this.mOpenMemberInviteCheckBox = (CheckBox)this.getViewById(view, "rc_open_member_invite");
        this.mOpenMemberInviteCheckBox.setOnClickListener((View.OnClickListener)this);
        this.mOpenMemberInviteCheckBox.setChecked(true);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                UIConversation conversation = DBHelper.getInstance().getConversation(ConversationSettingFragment.this.mConversationType, ConversationSettingFragment.this.mTargetId);
                if (conversation != null) {
                    ConversationSettingFragment.this.mConversation = conversation;
                }
                ConversationSettingFragment.this.getHandler().post(new Runnable(){

                    @Override
                    public void run() {
                        if (ConversationSettingFragment.this.mConversation.isTop()) {
                            ConversationSettingFragment.this.mSetTopConversationCheckBox.setChecked(true);
                        } else {
                            ConversationSettingFragment.this.mSetTopConversationCheckBox.setChecked(false);
                        }
                        if (ConversationSettingFragment.this.mConversation.getConversationTitle() != null) {
                            ConversationSettingFragment.this.mDiscussionNameTextView.setText((CharSequence)ConversationSettingFragment.this.mConversation.getConversationTitle());
                        }
                    }
                });
            }
        });
        if (this.mConversationType != null) {
            if (RongIMClient.ConversationType.DISCUSSION == this.mConversationType) {
                this.mExitButton.setVisibility(0);
                this.mDiscussionNameLayout.setVisibility(0);
                this.mGridView.setVisibility(0);
                this.setTopLayout.setVisibility(0);
            } else if (RongIMClient.ConversationType.PRIVATE == this.mConversationType) {
                this.mExitButton.setVisibility(8);
                this.mDiscussionNameLayout.setVisibility(8);
                this.mGridView.setVisibility(0);
                this.setTopLayout.setVisibility(0);
            } else if (RongIMClient.ConversationType.GROUP == this.mConversationType) {
                this.mExitButton.setVisibility(8);
                this.mDiscussionNameLayout.setVisibility(8);
                this.mGridView.setVisibility(8);
                this.setTopLayout.setVisibility(8);
            }
        }
        if (this.getActionBar() != null) {
            this.getActionBar().getTitleTextView().setText(Res.getInstance((Context)this.getActivity()).string("conversation_setting_title"));
            this.getActionBar().setOnBackClick(new View.OnClickListener(){

                public void onClick(View v) {
                    ConversationSettingFragment.this.getActivity().finish();
                }
            });
        }
        return view;
    }

    public void onResume() {
        if (this.mConversation != null && !TextUtils.isEmpty((CharSequence)this.mConversation.getTargetId())) {
            this.setCurrentConversationTargetId(this.mConversation.getTargetId());
        }
        super.onResume();
    }

    @Override
    public void onViewCreated(View view, Bundle savedInstanceState) {
        this.mMembers = new ArrayList();
        if (this.mConversationType == RongIMClient.ConversationType.PRIVATE) {
            Friend friend = new Friend();
            friend.setUserId(this.mTargetId);
            this.mMembers.add(friend);
        } else if (this.mConversationType == RongIMClient.ConversationType.DISCUSSION) {
            Intent intent = new Intent(RongConst.BROADCAST.ACTION_DISCUSSION_INFO_GET);
            intent.putExtra("multi_talk_id", this.mTargetId);
            this.getDiscussionInfo(this.mTargetId, new ActionBaseFragment.GetDiscussionInfoCallback(){

                @Override
                public void onSuccess(UIDiscussion discussion) {
                    ConversationSettingFragment.this.getHandler().obtainMessage(10001, (Object)discussion).sendToTarget();
                }

                @Override
                public void onError() {
                    ConversationSettingFragment.this.getHandler().obtainMessage(10002).sendToTarget();
                }
            });
        }
        this.mMemberGridViewAdapter = new ConversationMemberGridViewAdapter((Context)this.getActivity());
        this.mMemberGridViewAdapter.setGridViewImageListener(this);
        this.mMemberGridViewAdapter.setOnGetDataListener(this);
        this.mMemberGridViewAdapter.addData(this.mMembers);
        if (this.mConversationType == RongIMClient.ConversationType.PRIVATE) {
            this.mMemberGridViewAdapter.addAddButtonItem();
            this.mGridView.setAdapter((ListAdapter)this.mMemberGridViewAdapter);
            this.mMemberGridViewAdapter.notifyDataSetChanged();
        } else {
            this.mGridView.setAdapter((ListAdapter)this.mMemberGridViewAdapter);
        }
        this.getBlockPushStatus(this.mConversationType, this.mTargetId);
        this.mGridView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (1 == event.getAction() && ConversationSettingFragment.this.mMemberGridViewAdapter.isDeleteState()) {
                    ConversationSettingFragment.this.cancelDeleteStatus();
                    return true;
                }
                return false;
            }
        });
        super.onViewCreated(view, savedInstanceState);
    }

    private final void cancelDeleteStatus() {
        if (this.mMemberGridViewAdapter.isDeleteState() && RongIMClient.ConversationType.DISCUSSION == this.mConversation.getConversationType()) {
            String userId;
            UIDiscussion uiDiscussion = this.mConversation.getUiDiscussion();
            String string2 = userId = this.getCurrentUserInfo() != null ? this.getCurrentUserInfo().getUserId() : "";
            if (uiDiscussion != null && !TextUtils.isEmpty((CharSequence)uiDiscussion.getAdminId()) && userId.equals(uiDiscussion.getAdminId())) {
                this.mMemberGridViewAdapter.deleteToggle(false);
                this.mMemberGridViewAdapter.addAddButtonItem();
                this.mMemberGridViewAdapter.addSubButtonItem();
                this.mMemberGridViewAdapter.notifyDataSetChanged();
            }
        }
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        Friend friend = (Friend)view.getTag(Res.getInstance((Context)this.getActivity()).drawable("rc_default_portrait"));
        if (friend.isAdd()) {
            ArrayList<String> ids = new ArrayList<String>();
            if (this.mConversationType.equals((Object)RongIMClient.ConversationType.DISCUSSION)) {
                for (Friend item : this.mMembers) {
                    ids.add(item.getUserId());
                }
                RongIM.getInstance().startDiscussionMemberSelect((Context)this.getActivity(), this.mConversation.getTargetId(), ids);
            } else {
                ids.add(this.mConversation.getTargetId());
                RongIM.getInstance().startDiscussionMemberSelect((Context)this.getActivity(), null, ids);
            }
        } else if (friend.isSub()) {
            this.mMemberGridViewAdapter.deleteToggle(true);
            if (this.mMemberGridViewAdapter.isAdd() && this.mMemberGridViewAdapter.isSub()) {
                Friend friend1;
                int count = this.mMemberGridViewAdapter.getCount();
                for (int i = count - 1; i > 0 && ((friend1 = (Friend)this.mMemberGridViewAdapter.getItem(i)).isSub() || friend1.isAdd()); --i) {
                    this.mMemberGridViewAdapter.remove(i);
                }
            }
            this.mMemberGridViewAdapter.notifyDataSetChanged();
        }
    }

    @Override
    public void onGridViewImageClick(View view, int position) {
        String userId = (String)view.getTag();
        this.mDelPosition = position;
        this.removeMemberForDiscussion(this.mConversation.getTargetId(), userId);
    }

    public void onEvent(MessageLogic.EventInviteDiscussion eventInviteDiscussion) {
        if (eventInviteDiscussion.isSuccess()) {
            this.getDiscussionInfo(this.mTargetId, new ActionBaseFragment.GetDiscussionInfoCallback(){

                @Override
                public void onSuccess(UIDiscussion discussion) {
                    ConversationSettingFragment.this.getHandler().obtainMessage(10001, (Object)discussion).sendToTarget();
                }

                @Override
                public void onError() {
                    ConversationSettingFragment.this.getHandler().obtainMessage(10002).sendToTarget();
                }
            });
        }
    }

    @Override
    public void onDestroy() {
        EventBus.getDefault().unregister(this);
        super.onDestroy();
    }

    @Override
    protected void rongHandleMessage(Message msg) {
        super.rongHandleMessage(msg);
        if (msg.what == 10001) {
            String userId;
            UIDiscussion discussion = (UIDiscussion)msg.obj;
            if (this.mConversation != null) {
                this.mConversation.setUiDiscussion(discussion);
            }
            List<String> userIds = discussion.getUserIds();
            this.mMembers = new ArrayList();
            if (userIds != null) {
                for (String userId2 : userIds) {
                    Log.d((String)TAG, (String)userId2);
                    Friend friend = new Friend();
                    friend.setNickname("");
                    friend.setUserId(userId2);
                    this.mMembers.add(friend);
                }
            }
            this.mMemberGridViewAdapter.removeAll();
            this.mMemberGridViewAdapter.addData(this.mMembers);
            String string2 = userId = this.getCurrentUserInfo() != null ? this.getCurrentUserInfo().getUserId() : "";
            if (discussion != null) {
                if (!TextUtils.isEmpty((CharSequence)discussion.getAdminId()) && userId.equals(discussion.getAdminId())) {
                    this.mMemberGridViewAdapter.addAddButtonItem();
                    if (discussion.isOpen()) {
                        this.mOpenMemberInviteCheckBox.setChecked(true);
                    } else {
                        this.mOpenMemberInviteCheckBox.setChecked(false);
                    }
                    this.mOpenMemberInviteLayout.setVisibility(0);
                    this.mMemberGridViewAdapter.addSubButtonItem();
                } else if (discussion.isOpen()) {
                    this.mMemberGridViewAdapter.addAddButtonItem();
                    this.mOpenMemberInviteCheckBox.setChecked(true);
                } else {
                    this.mOpenMemberInviteLayout.setVisibility(8);
                }
                this.mDiscussionNameTextView.setText((CharSequence)discussion.getName());
            }
            this.mMemberGridViewAdapter.notifyDataSetChanged();
        } else if (msg.what == 10002) {
            RongToast.toast((Context)this.getActivity(), Res.getInstance((Context)this.getActivity()).string("conversation_setting_get_info_failure"));
        } else if (msg.what == 10004) {
            RongToast.toast((Context)this.getActivity(), Res.getInstance((Context)this.getActivity()).string("discussion_remove_member_failure"));
        } else if (msg.what == 10005) {
            RongToast.toast((Context)this.getActivity(), Res.getInstance((Context)this.getActivity()).string("conversation_setting_discussion_exit_failure"));
            if (this.mLoadingDialog != null) {
                this.mLoadingDialog.dismiss();
            }
            RongToast.toast((Context)this.getActivity(), Res.getInstance((Context)this.getActivity()).string("rc_conversation_setting_exit_discussion_failure"));
        } else if (msg.what == 10006) {
            DBHelper.getInstance().removeConversation(this.mConversation.getConversationType(), this.mConversation.getTargetId());
            DBHelper.getInstance().clearMessages(this.mConversation.getConversationType(), this.mConversation.getTargetId());
            if (this.mLoadingDialog != null) {
                this.mLoadingDialog.dismiss();
            }
            Intent intent = new Intent(RongConst.BROADCAST.ACTION_BUNDLE_IO_RONG_IMKIT_CONVERSATION_SETTING);
            intent.putExtra(INTENT_QUIT_DISCUSSION_CLOSE_PAGE, true);
            intent.putExtra("target_id", this.mConversation.getTargetId());
            this.getActivity().sendBroadcast(intent);
            this.getActivity().finish();
        } else if (msg.what == 10020) {
            if (this.mLoadingDialog != null) {
                this.mLoadingDialog.dismiss();
            }
        } else if (msg.what == 10004) {
            RongToast.toast((Context)this.getActivity(), Res.getInstance((Context)this.getActivity()).string("rc_conversation_setting_remove_discussion_member_failure"));
            if (this.mLoadingDialog != null) {
                this.mLoadingDialog.dismiss();
            }
            this.mDelPosition = -1;
        } else if (msg.what == 10003) {
            if (this.mDelPosition != -1) {
                this.mMemberGridViewAdapter.remove(this.mDelPosition);
                this.mMemberGridViewAdapter.notifyDataSetChanged();
                this.mDelPosition = -1;
            }
        } else if (msg.what == 10010) {
            this.mDiscussionNameTextView.setText((CharSequence)this.mTempDiscussionName);
            if (this.mConversation != null) {
                this.mConversation.setConversationTitle(this.mTempDiscussionName);
                if (this.mConversation.getUiDiscussion() != null) {
                    this.mConversation.getUiDiscussion().setName(this.mTempDiscussionName);
                }
            }
            if (this.mLoadingDialog != null) {
                this.mLoadingDialog.dismiss();
            }
        } else if (msg.what == 10011) {
            RongToast.toast((Context)this.getActivity(), Res.getInstance((Context)this.getActivity()).string("rc_conversation_setting_update_discussion_name_failure"));
            if (this.mLoadingDialog != null) {
                this.mLoadingDialog.dismiss();
            }
        } else if (msg.what == 10012) {
            UIConversation conversation = (UIConversation)msg.obj;
            Intent intent1 = new Intent(RongConst.BROADCAST.ACTION_BUNDLE_IO_RONG_IMKIT_CONVERSATION_SETTING);
            intent1.putExtra(INTENT_CREATE_DISCUSSION_SUCCESS, INTENT_CREATE_DISCUSSION_SUCCESS);
            intent1.putExtra("extra_conversation", (Parcelable)this.mConversation);
            this.getActivity().sendBroadcast(intent1);
            Intent intent = new Intent((Context)this.getActivity(), RongActivity.class);
            intent.putExtra("extra_fragment_content", ConversationFragment.class.getCanonicalName());
            intent.putExtra("extra_conversation", (Parcelable)conversation);
            this.startActivity(intent);
            this.getActivity().finish();
        } else if (msg.what == 10013) {
            RongToast.toast((Context)this.getActivity(), Res.getInstance((Context)this.getActivity()).string("discussion_create_failure"));
        } else if (msg.what == 10016) {
            int status = (Integer)msg.obj;
            RongIMClient.DiscussionInviteStatus discussionInviteStatus = RongIMClient.DiscussionInviteStatus.setValue(status);
            if (RongIMClient.DiscussionInviteStatus.OPENED == discussionInviteStatus) {
                this.mOpenMemberInviteCheckBox.setChecked(true);
            } else if (RongIMClient.DiscussionInviteStatus.CLOSED == discussionInviteStatus) {
                this.mOpenMemberInviteCheckBox.setChecked(false);
            }
        } else if (msg.what == 10017) {
            this.mOpenMemberInviteCheckBox.setChecked(!this.mOpenMemberInviteCheckBox.isChecked());
        } else if (msg.what == 10018) {
            int status = (Integer)msg.obj;
            RongIMClient.ConversationNotificationStatus conversationNotificationStatus = RongIMClient.ConversationNotificationStatus.setValue(status);
            if (RongIMClient.ConversationNotificationStatus.DO_NOT_DISTURB == conversationNotificationStatus) {
                this.mNewMessageNotifySetCheckBox.setChecked(false);
            } else if (RongIMClient.ConversationNotificationStatus.NOTIFY == conversationNotificationStatus) {
                this.mNewMessageNotifySetCheckBox.setChecked(true);
            }
        } else if (msg.what == 10019) {
            this.mNewMessageNotifySetCheckBox.setChecked(!this.mNewMessageNotifySetCheckBox.isChecked());
        } else if (msg.what == 10014) {
            int status = (Integer)msg.obj;
            RongIMClient.ConversationNotificationStatus conversationNotificationStatus = RongIMClient.ConversationNotificationStatus.setValue(status);
            if (RongIMClient.ConversationNotificationStatus.DO_NOT_DISTURB == conversationNotificationStatus) {
                this.mNewMessageNotifySetCheckBox.setChecked(false);
            } else if (RongIMClient.ConversationNotificationStatus.NOTIFY == conversationNotificationStatus) {
                this.mNewMessageNotifySetCheckBox.setChecked(true);
            }
        } else if (msg.what == 10015) {
            this.mNewMessageNotifySetCheckBox.setChecked(true);
        } else if (msg.what == 990001) {
            int position = msg.arg1;
            UIUserInfo uiUserInfo = (UIUserInfo)msg.obj;
            Friend friend = (Friend)this.mMemberGridViewAdapter.getItem(position);
            friend.setNickname(uiUserInfo.getName());
            friend.setPortrait(uiUserInfo.getPortraitUri());
            this.mMemberGridViewAdapter.notifyDataSetChanged();
        } else if (msg.what == 20019) {
            if (msg.obj == null) {
                return;
            }
            RongIMClient.DiscussionNotificationMessage discussionNotificationMessage = null;
            if (msg.obj instanceof RongIMClient.DiscussionNotificationMessage) {
                discussionNotificationMessage = (RongIMClient.DiscussionNotificationMessage)msg.obj;
            }
            switch (discussionNotificationMessage.getType()) {
                case 1: {
                    if (discussionNotificationMessage.getOperator().equals(this.getCurrentUserInfo() != null ? this.getCurrentUserInfo().getUserId() : "")) break;
                    String[] userIds = null;
                    userIds = discussionNotificationMessage.getExtension().indexOf(",") != -1 ? discussionNotificationMessage.getExtension().split(",") : new String[]{discussionNotificationMessage.getExtension()};
                    int count = this.mMemberGridViewAdapter.getCount();
                    ArrayList<Friend> friends = new ArrayList<Friend>();
                    for (String userId : userIds) {
                        Friend friend = new Friend();
                        friend.setUserId(userId);
                        friends.add(friend);
                    }
                    int position = -1;
                    if (this.mMemberGridViewAdapter.isAdd() && this.mMemberGridViewAdapter.isSub()) {
                        position = count - 2;
                    } else if (this.mMemberGridViewAdapter.isAdd() || this.mMemberGridViewAdapter.isSub()) {
                        position = count - 1;
                    }
                    if (position >= 0) {
                        this.mMemberGridViewAdapter.addData(position, friends);
                    }
                    this.mMemberGridViewAdapter.notifyDataSetChanged();
                    break;
                }
                case 2: {
                    if (discussionNotificationMessage.getOperator().equals(this.getCurrentUserInfo() != null ? this.getCurrentUserInfo().getUserId() : "")) break;
                    String userId = discussionNotificationMessage.getExtension();
                    this.removeGridViewFriend(userId);
                    break;
                }
                case 3: {
                    if (discussionNotificationMessage.getOperator().equals(this.getCurrentUserInfo() != null ? this.getCurrentUserInfo().getUserId() : "") || this.mDiscussionNameTextView == null) break;
                    this.mDiscussionNameTextView.setText((CharSequence)discussionNotificationMessage.getExtension());
                    break;
                }
                case 4: {
                    if (discussionNotificationMessage.getOperator().equals(this.getCurrentUserInfo() != null ? this.getCurrentUserInfo().getUserId() : "")) break;
                    String userId = discussionNotificationMessage.getExtension();
                    this.removeGridViewFriend(userId);
                    break;
                }
                case 5: {
                    break;
                }
            }
        } else if (msg.what == 10022) {
            if (this.mLoadingDialog != null) {
                this.mLoadingDialog.dismiss();
            }
            Intent intent = new Intent(RongConst.BROADCAST.ACTION_BUNDLE_IO_RONG_IMKIT_CONVERSATION_SETTING);
            intent.putExtra(INTENT_CLEAR_MESSSAGE_SUCCESS, (Serializable)((Boolean)this.mClearMessagesLayout.getTag()));
            this.getActivity().sendBroadcast(intent);
        }
    }

    private final void removeGridViewFriend(String userId) {
        int count = this.mMemberGridViewAdapter.getCount();
        for (int i = 0; i < count; ++i) {
            Friend friend = (Friend)this.mMemberGridViewAdapter.getItem(i);
            if (friend == null || !friend.getUserId().equals(userId)) continue;
            this.mMemberGridViewAdapter.remove(friend);
            this.mMemberGridViewAdapter.notifyDataSetChanged();
            break;
        }
    }

    public void onClick(View v) {
        if (v == this.mExitButton) {
            final Intent intent = new Intent(RongConst.BROADCAST.ACTION_DISCUSSION_QUIT);
            intent.putExtra("multi_talk_id", this.mTargetId);
            this.mLoadingDialog = new LoadingDialog((Context)this.getActivity());
            this.mLoadingDialog.setText(Res.getInstance((Context)this.getActivity()).string("rc_public_data_process"));
            this.mAlterDialog = new AlterDialog((Context)this.getActivity());
            this.mAlterDialog.setTitle(this.getString(Res.getInstance((Context)this.getActivity()).string("conversation_setting_exit_prompt")), false);
            this.mAlterDialog.setButton1(Res.getInstance((Context)this.getActivity()).string("alter_dialog_confirm"), new View.OnClickListener(){

                public void onClick(View v) {
                    ConversationSettingFragment.this.mAlterDialog.dismiss();
                    ConversationSettingFragment.this.sendAction(intent, new ActionBaseFragment.ActionCallback(){

                        @Override
                        public void callback(Intent intent) {
                            boolean isSuccess = intent.getBooleanExtra("intent_api_operation_status", false);
                            if (isSuccess) {
                                ConversationSettingFragment.this.getHandler().obtainMessage(10006).sendToTarget();
                            } else {
                                ConversationSettingFragment.this.getHandler().obtainMessage(10005).sendToTarget();
                            }
                        }
                    });
                }
            });
            this.mAlterDialog.setButton2(Res.getInstance((Context)this.getActivity()).string("alter_dialog_cancel"), new View.OnClickListener(){

                public void onClick(View v) {
                    ConversationSettingFragment.this.mAlterDialog.dismiss();
                }
            });
            this.mAlterDialog.show();
        } else if (v == this.mClearMessagesLayout) {
            this.mLoadingDialog = new LoadingDialog((Context)this.getActivity());
            this.mLoadingDialog.setText(Res.getInstance((Context)this.getActivity()).string("rc_public_data_process"));
            this.mAlterDialog = new AlterDialog((Context)this.getActivity());
            this.mAlterDialog.setTitle(Res.getInstance((Context)this.getActivity()).string("rc_conversation_setting_clear_messages_prompt"));
            this.mAlterDialog.setButton1(Res.getInstance((Context)this.getActivity()).string("alter_dialog_confirm"), new View.OnClickListener(){

                public void onClick(View v) {
                    ConversationSettingFragment.this.mAlterDialog.dismiss();
                    ConversationSettingFragment.this.mLoadingDialog.show();
                    DBHelper.getInstance().clearMessages(ConversationSettingFragment.this.mConversation.getConversationType(), ConversationSettingFragment.this.mConversation.getTargetId());
                    ConversationSettingFragment.this.mClearMessagesLayout.setTag((Object)true);
                    ConversationSettingFragment.this.getHandler().obtainMessage(10022).sendToTarget();
                }
            });
            this.mAlterDialog.setButton2(Res.getInstance((Context)this.getActivity()).string("alter_dialog_cancel"), new View.OnClickListener(){

                public void onClick(View v) {
                    ConversationSettingFragment.this.mAlterDialog.dismiss();
                }
            });
            this.mAlterDialog.show();
        } else if (v == this.mSetTopConversationCheckBox) {
            this.getHandler().post(new Runnable(){

                @Override
                public void run() {
                    boolean isSetTop = ConversationSettingFragment.this.mSetTopConversationCheckBox.isChecked();
                    DBHelper.getInstance().setTop(ConversationSettingFragment.this.mConversation.getConversationType(), ConversationSettingFragment.this.mConversation.getTargetId(), isSetTop);
                    Intent intent = new Intent(RongConst.BROADCAST.ACTION_BUNDLE_IO_RONG_IMKIT_CONVERSATION_SETTING);
                    if (isSetTop != ConversationSettingFragment.this.mConversation.isTop()) {
                        intent.putExtra(ConversationSettingFragment.INTENT_SET_TOP_CONVERSATION_SUCCESS, ConversationSettingFragment.this.mSetTopConversationCheckBox.isChecked() ? 1 : 0);
                    }
                    ConversationSettingFragment.this.getActivity().sendBroadcast(intent);
                }
            });
        } else if (v == this.mNewMessageNotifySetCheckBox) {
            this.setBlockPushStatus(this.mConversationType, this.mTargetId, !this.mNewMessageNotifySetCheckBox.isChecked());
        } else if (v == this.mDiscussionNameLayout) {
            this.mLoadingDialog = new LoadingDialog((Context)this.getActivity());
            this.mLoadingDialog.setText(Res.getInstance((Context)this.getActivity()).string("rc_public_data_process"));
            DisplayMetrics dm = new DisplayMetrics();
            this.getActivity().getWindowManager().getDefaultDisplay().getMetrics(dm);
            this.editTextRongDialog = new EditTextRongDialog((Context)this.getActivity(), dm.widthPixels - dm.widthPixels / 3);
            this.editTextRongDialog.setTitle(Res.getInstance((Context)this.getActivity()).string("rc_conversation_setting_update_discussion_name"));
            if (this.mConversation != null) {
                if (!TextUtils.isEmpty((CharSequence)this.mConversation.getConversationTitle())) {
                    this.editTextRongDialog.setEditText(this.mConversation.getConversationTitle());
                } else if (this.mConversation.getUiDiscussion() != null && !TextUtils.isEmpty((CharSequence)this.mConversation.getUiDiscussion().getName())) {
                    this.editTextRongDialog.setEditText(this.mConversation.getUiDiscussion().getName());
                }
            }
            this.editTextRongDialog.setButton1(this.getString(Res.getInstance((Context)this.getActivity()).string("alter_dialog_confirm")), new View.OnClickListener(){

                public void onClick(View v) {
                    ConversationSettingFragment.this.mTempDiscussionName = ConversationSettingFragment.this.editTextRongDialog.getText();
                    if (!TextUtils.isEmpty((CharSequence)ConversationSettingFragment.this.mTempDiscussionName)) {
                        ConversationSettingFragment.this.updateDiscussionName(ConversationSettingFragment.this.mConversation.getTargetId(), ConversationSettingFragment.this.mTempDiscussionName);
                        ConversationSettingFragment.this.mLoadingDialog.show();
                    }
                    ConversationSettingFragment.this.editTextRongDialog.dismiss();
                }
            });
            this.editTextRongDialog.setButton2(this.getString(Res.getInstance((Context)this.getActivity()).string("alter_dialog_cancel")), new View.OnClickListener(){

                public void onClick(View v) {
                    ConversationSettingFragment.this.editTextRongDialog.dismiss();
                }
            });
            this.editTextRongDialog.show();
        } else if (v == this.mOpenMemberInviteCheckBox) {
            this.setDiscussionInviteStatus(this.mTargetId, this.mOpenMemberInviteCheckBox.isChecked());
        }
    }

    @Override
    public void onPause() {
        super.onPause();
    }

    private void updateDiscussionName(String discussionId, String newDiscussionName) {
        Intent intent = new Intent(RongConst.BROADCAST.ACTION_DISCUSSION_UPDATE_NAME);
        intent.putExtra("multi_talk_id", discussionId);
        intent.putExtra("multi_talk_name", newDiscussionName);
        this.sendAction(intent, new ActionBaseFragment.ActionCallback(){

            @Override
            public void callback(Intent intent) {
                boolean isSuccess = intent.getBooleanExtra("intent_api_operation_status", false);
                if (isSuccess) {
                    ConversationSettingFragment.this.getHandler().obtainMessage(10010).sendToTarget();
                } else {
                    ConversationSettingFragment.this.getHandler().obtainMessage(10011).sendToTarget();
                }
            }
        });
    }

    private void removeMemberForDiscussion(String discussionId, String memberId) {
        RongIM.getInstance().removeMemberFromDiscussion(discussionId, memberId, new RongIM.OperationCallback(){

            @Override
            public void onSuccess() {
                ConversationSettingFragment.this.getHandler().obtainMessage(10003).sendToTarget();
            }

            @Override
            public void onError(RongIM.OperationCallback.ErrorCode errorCode) {
                ConversationSettingFragment.this.getHandler().obtainMessage(10003).sendToTarget();
            }
        });
    }

    private final void setDiscussionInviteStatus(String targetId, boolean isOpen) {
        if (TextUtils.isEmpty((CharSequence)targetId)) {
            return;
        }
        Intent intent = new Intent(RongConst.BROADCAST.ACTION_SET_DISCUSSION_INVITE_STATUS);
        intent.putExtra("multi_talk_id", targetId);
        intent.putExtra("discussion_is_open_invite_status", isOpen);
        this.sendAction(intent, new ActionBaseFragment.ActionCallback(){

            @Override
            public void callback(Intent intentArg) {
                boolean opStatus = intentArg.getBooleanExtra("intent_api_operation_status", false);
                int status = intentArg.getIntExtra("intent_statue_value", 1);
                Log.d((String)TAG, (String)("setDiscussionInviteStatus--opStatus:" + opStatus));
                if (opStatus) {
                    ConversationSettingFragment.this.getHandler().obtainMessage(10016, (Object)status).sendToTarget();
                } else {
                    ConversationSettingFragment.this.getHandler().obtainMessage(10017).sendToTarget();
                }
            }
        });
    }

    private final void setBlockPushStatus(RongIMClient.ConversationType conversationType, String targetId, boolean isBlock) {
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId)) {
            return;
        }
        Intent intent = new Intent(RongConst.BROADCAST.ACTION_SET_BLOCK_PUSH_STATUS);
        intent.putExtra("intent_conversation_type", conversationType.getValue());
        intent.putExtra("target_id", targetId);
        intent.putExtra("intent_new_message_block", isBlock);
        this.sendAction(intent, new ActionBaseFragment.ActionCallback(){

            @Override
            public void callback(Intent intentArg) {
                boolean isSuccess = intentArg.getBooleanExtra("intent_api_operation_status", false);
                int status = intentArg.getIntExtra("intent_statue_value", 0);
                Log.d((String)TAG, (String)("setBlockPushStatus--status:" + status));
                if (isSuccess) {
                    ConversationSettingFragment.this.getHandler().obtainMessage(10018, (Object)status).sendToTarget();
                } else {
                    ConversationSettingFragment.this.getHandler().obtainMessage(10019).sendToTarget();
                }
            }
        });
    }

    private final void getBlockPushStatus(RongIMClient.ConversationType conversationType, String targetId) {
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId)) {
            return;
        }
        Intent intent = new Intent(RongConst.BROADCAST.ACTION_GET_BLOCK_PUSH_STATUS);
        intent.putExtra("target_id", targetId);
        intent.putExtra("intent_conversation_type", conversationType.getValue());
        this.sendAction(intent, new ActionBaseFragment.ActionCallback(){

            @Override
            public void callback(Intent intentArg) {
                int status = intentArg.getIntExtra("intent_statue_value", 1);
                ConversationSettingFragment.this.getHandler().obtainMessage(10014, (Object)status).sendToTarget();
            }
        });
    }

    @Override
    public void registerBundleActions(List<String> actions) {
        super.registerBundleActions(actions);
    }

    @Override
    public boolean onBackPressed() {
        return false;
    }

    @Override
    public void getDiscussionInfo(int position, String discusstionId) {
    }

    @Override
    public void registerActions(List<String> actions) {
        actions.add(RongConst.BROADCAST.ACTION_DISCUSSION_MESSAGE_RECEIVE);
        super.registerActions(actions);
    }

    @Override
    public void receiveData(Intent intent) {
        String action = intent.getAction();
        if (RongConst.BROADCAST.ACTION_DISCUSSION_MESSAGE_RECEIVE.equals(action)) {
            UIMessage message = (UIMessage)intent.getParcelableExtra("message_obj");
            if (message != null && !message.getTargetId().equals(this.mTargetId)) {
                return;
            }
            if (message.getContent() instanceof RongIMClient.DiscussionNotificationMessage) {
                RongIMClient.DiscussionNotificationMessage discussionNotificationMessage = (RongIMClient.DiscussionNotificationMessage)message.getContent();
                this.getHandler().obtainMessage(20019, (Object)discussionNotificationMessage).sendToTarget();
            }
        }
    }

    public void onEventMainThread(RongIMClient.UserInfo userInfo) {
        if (this.mMemberGridViewAdapter != null) {
            this.mMemberGridViewAdapter.notifyDataSetChanged();
        }
    }
}

