/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.fragment;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Message;
import android.view.View;
import android.widget.AdapterView;
import io.rong.imkit.Res;
import io.rong.imkit.adapter.ConversationListAdapter;
import io.rong.imkit.common.RongConst;
import io.rong.imkit.data.DBHelper;
import io.rong.imkit.fragment.ConversationListFragment;
import io.rong.imkit.model.UIConversation;
import io.rong.imkit.model.UIGroup;
import io.rong.imkit.model.UIMessage;
import io.rong.imkit.view.ActionBar;
import io.rong.imlib.RongIMClient;
import java.util.ArrayList;
import java.util.List;

public class ConversationGroupListFragment
extends ConversationListFragment {
    @Override
    public void onResume() {
        super.onResume();
        this.setCurrentConversationTargetId(null);
    }

    @Override
    protected void setGroupUnReadMessageCount() {
    }

    @Override
    protected void initAdapter() {
        this.mConversationListAdapter = new ConversationListAdapter((Context)this.getActivity(), true);
    }

    @Override
    protected void setActionBar(ActionBar actionBar) {
        if (actionBar == null) {
            return;
        }
        actionBar.getTitleTextView().setText(Res.getInstance((Context)this.getActivity()).string("conversation_list_action_bar_title"));
        actionBar.setOnBackClick(new View.OnClickListener(){

            public void onClick(View v) {
                ConversationGroupListFragment.this.getActivity().finish();
            }
        });
    }

    @Override
    protected void resetData() {
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                final ArrayList<UIConversation> list = DBHelper.getInstance().getConversationGroupList();
                ConversationGroupListFragment.this.getHandler().post(new Runnable(){

                    @Override
                    public void run() {
                        ConversationGroupListFragment.this.clearListCache();
                        ConversationGroupListFragment.this.mConversationListAdapter.removeAll();
                        if (list == null || list.size() == 0) {
                            return;
                        }
                        ConversationGroupListFragment.this.mConversationListAdapter.addData(list);
                        ConversationGroupListFragment.this.mConversationListAdapter.notifyDataSetChanged();
                    }
                });
            }
        });
    }

    @Override
    public void registerActions(List<String> actions) {
        super.registerActions(actions);
    }

    @Override
    public void registerBundleActions(List<String> actions) {
        super.registerBundleActions(actions);
        actions.add(RongConst.BROADCAST.ACTION_RESET_DATA_FOR_CONVERSION_GROUP_LIST);
    }

    @Override
    public void receiveData(Intent intent) {
        super.receiveData(intent);
    }

    @Override
    public void receivePageIntent(Intent intent) {
        String action = intent.getAction();
        if (RongConst.BROADCAST.ACTION_RESET_DATA_FOR_CONVERSION_GROUP_LIST.equals(action)) {
            this.resetData();
            return;
        }
        if (RongConst.BROADCAST.ACTION_BUNDLE_IO_RONG_IMKIT_CONVERSATION.equals(action)) {
            this.getHandler().obtainMessage(1104, (Object)intent).sendToTarget();
            this.mConversationType = null;
            this.setCurrentConversationTargetId(null);
        } else if (RongConst.BROADCAST.ACTION_BUNDLE_IO_RONG_IMKIT_CONVERSATION_SETTING.equals(action)) {
            this.getHandler().obtainMessage(1106, (Object)intent).sendToTarget();
        }
    }

    @Override
    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        UIConversation conversation = (UIConversation)this.mConversationListAdapter.getItem(position);
        this.setCurrentConversationTargetId(conversation.getTargetId());
        this.mConversationType = conversation.getConversationType();
        Uri uri = Uri.parse((String)("rong://" + this.getActivity().getApplicationInfo().packageName)).buildUpon().appendPath("conversation").appendPath(RongIMClient.ConversationType.GROUP.getName().toLowerCase()).appendQueryParameter("targetId", conversation.getTargetId()).appendQueryParameter("title", conversation.getConversationTitle()).build();
        this.getActivity().startActivity(new Intent("android.intent.action.VIEW", uri));
    }

    @Override
    protected void rongHandleMessage(Message msg) {
        UIConversation conversation;
        RongIMClient.Group group;
        super.rongHandleMessage(msg);
        if (msg.what == 990003 && msg.obj instanceof RongIMClient.Group && (group = (RongIMClient.Group)msg.obj) != null && (conversation = this.getUIConversation(group.getId())) != null) {
            conversation.setUiGroup(new UIGroup(group));
            conversation.setConversationTitle(group.getName());
            this.mConversationListAdapter.notifyDataSetChanged();
        }
    }

    @Override
    protected void hasNewMessage(UIMessage message, boolean isNewMessage, boolean isGroup) {
        super.hasNewMessage(message, isNewMessage, true);
    }

    @Override
    protected boolean wrapGroupCoversation(UIMessage message) {
        return super.wrapGroupCoversation(message);
    }

    @Override
    public void onEventMainThread(RongIMClient.UserInfo userInfo) {
        if (this.mConversationListAdapter != null) {
            this.mConversationListAdapter.notifyDataSetChanged();
        }
    }

    @Override
    public void onEventMainThread(RongIMClient.Group group) {
        if (this.mConversationListAdapter != null) {
            this.mConversationListAdapter.notifyDataSetChanged();
        }
    }
}

